/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.ColumnPruneVisitor;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public abstract class TypeCastInserter
extends Rule {
    public TypeCastInserter(String n) {
        super(n, true);
    }

    protected abstract LogicalSchema determineSchema(LogicalRelationalOperator var1) throws FrontendException;

    @Override
    public Transformer getNewTransformer() {
        return new TypeCastInserterTransformer();
    }

    protected abstract void markCastInserted(LogicalRelationalOperator var1);

    protected abstract void markCastNoNeed(LogicalRelationalOperator var1);

    protected abstract boolean isCastAdjusted(LogicalRelationalOperator var1);

    public class TypeCastInserterTransformer
    extends Transformer {
        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LogicalRelationalOperator op = (LogicalRelationalOperator)matched.getSources().get(0);
            LogicalSchema s = op.getSchema();
            if (s == null) {
                return false;
            }
            if (TypeCastInserter.this.isCastAdjusted(op)) {
                return false;
            }
            if (op instanceof LOLoad ? ((LOLoad)op).getScriptSchema() == null : ((LOStream)op).getScriptSchema() == null) {
                return false;
            }
            LogicalSchema determinedSchema = TypeCastInserter.this.determineSchema(op);
            if (this.atLeastOneCastNeeded(determinedSchema, s)) {
                return true;
            }
            return determinedSchema == null || determinedSchema.size() != s.size();
        }

        private boolean atLeastOneCastNeeded(LogicalSchema determinedSchema, LogicalSchema s) {
            for (int i = 0; i < s.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = s.getField(i);
                if (fs.type == 50 || determinedSchema != null && fs.isEqual(determinedSchema.getField(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            LogicalRelationalOperator op = (LogicalRelationalOperator)matched.getSources().get(0);
            LogicalSchema s = op.getSchema();
            LogicalSchema determinedSchema = TypeCastInserter.this.determineSchema(op);
            if (TypeCastInserter.this.currentPlan.getSuccessors(op) == null) {
                return;
            }
            if (!this.atLeastOneCastNeeded(determinedSchema, s) && op instanceof LOLoad) {
                TreeSet<Integer> required = new TreeSet<Integer>();
                for (int i = 0; i < s.size(); ++i) {
                    int index;
                    int n = index = determinedSchema == null ? i : determinedSchema.findField(s.getField((int)i).uid);
                    if (index < 0) continue;
                    required.add(index);
                }
                HashMap<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>> requiredMap = new HashMap<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>>(1);
                Pair pair = new Pair(null, required);
                requiredMap.put((LOLoad)op, pair);
                new ColumnPruneVisitor(TypeCastInserter.this.currentPlan, requiredMap, true).visit((LOLoad)op);
                TypeCastInserter.this.markCastNoNeed(op);
                return;
            }
            LogicalPlan innerPlan = new LogicalPlan();
            LOForEach foreach = new LOForEach(TypeCastInserter.this.currentPlan);
            foreach.setInnerPlan(innerPlan);
            foreach.setAlias(op.getAlias());
            Operator next = TypeCastInserter.this.currentPlan.getSuccessors(op).get(0);
            TypeCastInserter.this.currentPlan.insertBetween(op, foreach, next);
            ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
            LOGenerate gen = new LOGenerate(innerPlan, exps, new boolean[s.size()]);
            innerPlan.add(gen);
            for (int i = 0; i < s.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = s.getField(i);
                LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, i);
                innerPlan.add(innerLoad);
                innerPlan.connect(innerLoad, gen);
                LogicalExpressionPlan exp = new LogicalExpressionPlan();
                ProjectExpression prj = new ProjectExpression(exp, i, -1, gen);
                exp.add(prj);
                if (!(fs.type == 50 || determinedSchema != null && fs.isEqual(determinedSchema.getField(i)))) {
                    CastExpression cast = new CastExpression(exp, prj, new LogicalSchema.LogicalFieldSchema(fs));
                    exp.add(cast);
                    FuncSpec loadFuncSpec = null;
                    if (op instanceof LOLoad) {
                        loadFuncSpec = ((LOLoad)op).getFileSpec().getFuncSpec();
                    } else if (op instanceof LOStream) {
                        StreamingCommand command = ((LOStream)op).getStreamingCommand();
                        StreamingCommand.HandleSpec streamOutputSpec = command.getOutputSpec();
                        loadFuncSpec = new FuncSpec(streamOutputSpec.getSpec());
                    } else {
                        String msg = "TypeCastInserter invoked with an invalid operator class name: " + innerPlan.getClass().getSimpleName();
                        throw new FrontendException(msg, 2242);
                    }
                    cast.setFuncSpec(loadFuncSpec);
                }
                exps.add(exp);
            }
            TypeCastInserter.this.markCastInserted(op);
        }

        @Override
        public OperatorPlan reportChanges() {
            return TypeCastInserter.this.currentPlan;
        }
    }
}

