/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;
import org.osgi.framework.Bundle;
import org.pentaho.js.require.RequireJsConfiguration;
import org.pentaho.js.require.RequireJsDependencyResolver;
import org.pentaho.js.require.RequireJsMerger;

public class RebuildCacheCallable
implements Callable<String> {
    private final String baseUrl;
    private final Map<Long, Map<String, Object>> configMap;
    private final List<RequireJsConfiguration> requireJsConfigurations;

    public RebuildCacheCallable(String baseUrl, Map<Long, Map<String, Object>> configMap, List<RequireJsConfiguration> requireJsConfigurations) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.configMap = configMap;
        this.requireJsConfigurations = new ArrayList<RequireJsConfiguration>(requireJsConfigurations);
        Collections.sort(this.requireJsConfigurations, (o1, o2) -> {
            long longResult = o1.getBundle().getBundleId() - o2.getBundle().getBundleId();
            if (longResult < 0L) {
                return -1;
            }
            if (longResult > 0L) {
                return 1;
            }
            return 0;
        });
    }

    private static void makePathsAbsolute(Map<String, Object> result, String baseUrl) {
        HashMap paths = (HashMap)result.get("paths");
        paths.forEach((moduleId, location) -> {
            if (RebuildCacheCallable.checkNeedsBaseUrl(location)) {
                paths.put(moduleId, baseUrl + location);
            }
        });
        ArrayList packages = (ArrayList)result.get("packages");
        ArrayList convertedPackages = packages.stream().filter(Objects::nonNull).map(packageDefinition -> {
            String location;
            HashMap complexPackageDefinition;
            if (packageDefinition instanceof HashMap && (complexPackageDefinition = (HashMap)packageDefinition).containsKey("location") && RebuildCacheCallable.checkNeedsBaseUrl(location = (String)complexPackageDefinition.get("location"))) {
                complexPackageDefinition.put("location", baseUrl + location);
                return complexPackageDefinition;
            }
            return packageDefinition;
        }).collect(Collectors.toCollection(ArrayList::new));
        result.put("packages", convertedPackages);
    }

    private static boolean checkNeedsBaseUrl(String value) {
        return value.charAt(0) != '/' && !value.matches("/^[\\w\\+\\.\\-]+:/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        RequireJsMerger merger = new RequireJsMerger();
        for (Long bundleId : this.configMap.keySet()) {
            merger.merge(this.configMap.get(bundleId));
        }
        Map<String, Object> result = merger.getRequireConfig();
        RequireJsDependencyResolver.processMetaInformation(result);
        RebuildCacheCallable.makePathsAbsolute(result, this.baseUrl);
        StringBuilder sb = new StringBuilder(JSONObject.toJSONString(result));
        sb.append(";");
        for (RequireJsConfiguration requireJsConfiguration : this.requireJsConfigurations) {
            sb.append("\n\n/* Following configurations are from bundle ");
            Bundle bundle = requireJsConfiguration.getBundle();
            String bundleName = "[" + bundle.getBundleId() + "] - " + bundle.getSymbolicName() + ":" + bundle.getVersion();
            sb.append(bundleName);
            sb.append("*/\n");
            for (String config : requireJsConfiguration.getRequireConfigurations()) {
                URL configURL = bundle.getResource(config);
                InputStream inputStream = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                try {
                    String input;
                    URLConnection urlConnection = configURL.openConnection();
                    inputStream = urlConnection.getInputStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((input = bufferedReader.readLine()) != null) {
                        sb.append(input);
                        sb.append("\n");
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            sb.append("/* End of bundle ");
            sb.append(bundleName);
            sb.append("*/\n");
        }
        return sb.toString();
    }
}

