/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.js.require.RequireJsConfigManager;

public class RequireJsConfigServlet
extends HttpServlet {
    private String contextRoot;
    private RequireJsConfigManager manager;
    private String requireJs;

    public void setContextRoot(String contextRoot) {
        contextRoot = !contextRoot.startsWith("/") ? "/" + contextRoot : contextRoot;
        this.contextRoot = contextRoot = !contextRoot.endsWith("/") ? contextRoot + "/" : contextRoot;
    }

    public void setManager(RequireJsConfigManager manager) {
        this.manager = manager;
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.manager.getLastModified();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/javascript");
        resp.setHeader("Cache-Control", "must-revalidate");
        try (PrintWriter printWriter = new PrintWriter((OutputStream)resp.getOutputStream());){
            RequestContext requestContext = new RequestContext(req);
            if (requestContext.shouldOutputRequireJs()) {
                printWriter.write(this.getRequireJsScript());
            }
            printWriter.write("\n(function(w) {");
            printWriter.write("\n  if(typeof CONTEXT_PATH == 'undefined'){");
            printWriter.write("\n    w.CONTEXT_PATH = '" + this.getContextRoot(requestContext) + "';");
            printWriter.write("\n  }");
            printWriter.write("\n");
            printWriter.write("\n  var legacyConfig = null;");
            printWriter.write("\n  if(typeof requireCfg !== 'undefined' && requireCfg != null && requireCfg.config != null) {");
            printWriter.write("\n    legacyConfig = requireCfg.config;");
            printWriter.write("\n  }");
            printWriter.write("\n");
            printWriter.write("\n  var requireCfg = " + this.manager.getRequireJsConfig(this.getContextRoot(requestContext)) + "\n");
            printWriter.write("\n  requireCfg.skipDataMain = true;");
            printWriter.write("\n");
            printWriter.write("\n  if(legacyConfig != null) {");
            printWriter.write("\n    for (var key in legacyConfig) {");
            printWriter.write("\n      if (Object.prototype.hasOwnProperty.call(legacyConfig, key)) {");
            printWriter.write("\n        if(!requireCfg.config[key]) {;");
            printWriter.write("\n          requireCfg.config[key] = {};");
            printWriter.write("\n        }");
            printWriter.write("\n");
            printWriter.write("\n        for (var moduleId in legacyConfig[key]) {");
            printWriter.write("\n          if (Object.prototype.hasOwnProperty.call(legacyConfig[key], moduleId)) {");
            printWriter.write("\n            requireCfg.config[key][moduleId] = legacyConfig[key][moduleId];");
            printWriter.write("\n          }");
            printWriter.write("\n        }");
            printWriter.write("\n      }");
            printWriter.write("\n    }");
            printWriter.write("\n  }");
            printWriter.write("\n");
            printWriter.write("\n  require.config(requireCfg);");
            printWriter.write("\n}(window));\n");
        }
    }

    private String getContextRoot(RequestContext requestContext) {
        return (requestContext.shouldUseFullyQualifiedUrl() ? requestContext.getServerAddress() : "") + this.contextRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequireJsScript() throws IOException {
        if (this.requireJs == null) {
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            try {
                String line;
                inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("js/require.js");
                inputStreamReader = new InputStreamReader(inputStream);
                reader = new BufferedReader(inputStreamReader);
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                this.requireJs = sb.toString();
            }
            finally {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.requireJs;
    }

    private class RequestContext {
        private final boolean outputRequireJs;
        private final boolean useFullyQualifiedUrl;
        private final String serverAddress;

        RequestContext(HttpServletRequest req) {
            this.outputRequireJs = this.getBooleanValue(req.getParameter("requirejs"), true);
            String referer = req.getHeader("referer");
            this.serverAddress = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
            this.useFullyQualifiedUrl = this.getBooleanValue(req.getParameter("fullyQualifiedUrl"), referer != null && !referer.startsWith(this.serverAddress));
        }

        boolean shouldOutputRequireJs() {
            return this.outputRequireJs;
        }

        boolean shouldUseFullyQualifiedUrl() {
            return this.useFullyQualifiedUrl;
        }

        String getServerAddress() {
            return this.serverAddress;
        }

        private boolean getBooleanValue(String parameter, boolean defaultValue) {
            if (parameter == null) {
                return defaultValue;
            }
            return Boolean.valueOf(parameter);
        }
    }
}

