/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.SslConfiguration;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServer
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
VariableSpace,
RepositoryElementInterface,
XMLInterface {
    private static Class<?> PKG = SlaveServer.class;
    public static final String STRING_SLAVESERVER = "Slave Server";
    private static final Random RANDOM = new Random();
    public static final String XML_TAG = "slaveserver";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.SLAVE_SERVER;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL_MODE_TAG = "sslMode";
    private static final int NOT_FOUND_ERROR = 404;
    public static final int KETTLE_CARTE_RETRIES = SlaveServer.getNumberOfSlaveServerRetries();
    public static final int KETTLE_CARTE_RETRY_BACKOFF_INCREMENTS = SlaveServer.getBackoffIncrements();
    private LogChannelInterface log;
    private String name;
    private String hostname;
    private String port;
    private String webAppName;
    private String username;
    private String password;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String propertiesMasterName;
    private boolean overrideExistingProperties;
    private boolean master;
    private boolean shared;
    private ObjectId id;
    private VariableSpace variables = new Variables();
    private ObjectRevision objectRevision;
    private Date changedDate;
    private boolean sslMode;
    private SslConfiguration sslConfig;
    private ReadWriteLock lock;

    private static int getNumberOfSlaveServerRetries() {
        try {
            return Integer.parseInt(Const.NVL((String)System.getProperty("KETTLE_CARTE_RETRIES"), (String)"0"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getBackoffIncrements() {
        try {
            return Integer.parseInt(Const.NVL((String)System.getProperty("KETTLE_CARTE_RETRY_BACKOFF_INCREMENTS"), (String)"1000"));
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public SlaveServer() {
        this.initializeVariablesFrom(null);
        this.id = null;
        this.log = new LogChannel((Object)STRING_SLAVESERVER);
        this.changedDate = new Date();
        this.lock = new ReentrantReadWriteLock();
    }

    public SlaveServer(String name, String hostname, String port, String username, String password) {
        this(name, hostname, port, username, password, null, null, null, false, false);
    }

    public SlaveServer(String name, String hostname, String port, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean master) {
        this(name, hostname, port, username, password, proxyHostname, proxyPort, nonProxyHosts, master, false);
    }

    public SlaveServer(String name, String hostname, String port, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean master, boolean ssl) {
        this();
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.nonProxyHosts = nonProxyHosts;
        this.master = master;
        this.initializeVariablesFrom(null);
        this.log = new LogChannel((Object)this);
    }

    public SlaveServer(Node slaveNode) {
        this();
        this.name = XMLHandler.getTagValue((Node)slaveNode, (String)"name");
        this.hostname = XMLHandler.getTagValue((Node)slaveNode, (String)"hostname");
        this.port = XMLHandler.getTagValue((Node)slaveNode, (String)"port");
        this.webAppName = XMLHandler.getTagValue((Node)slaveNode, (String)"webAppName");
        this.username = XMLHandler.getTagValue((Node)slaveNode, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)slaveNode, (String)"password"));
        this.proxyHostname = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_hostname");
        this.proxyPort = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_port");
        this.nonProxyHosts = XMLHandler.getTagValue((Node)slaveNode, (String)"non_proxy_hosts");
        this.propertiesMasterName = XMLHandler.getTagValue((Node)slaveNode, (String)"get_properties_from_master");
        this.overrideExistingProperties = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)slaveNode, (String)"override_existing_properties"));
        this.master = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)slaveNode, (String)"master"));
        this.initializeVariablesFrom(null);
        this.log = new LogChannel((Object)this);
        this.setSslMode("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)slaveNode, (String)SSL_MODE_TAG)));
        Node sslConfig = XMLHandler.getSubNode((Node)slaveNode, (String)"sslConfig");
        if (sslConfig != null) {
            this.setSslMode(true);
            this.sslConfig = new SslConfiguration(sslConfig);
        }
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        this.lock.readLock().lock();
        try {
            xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
            xml.append("        ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
            xml.append("        ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
            xml.append("        ").append(XMLHandler.addTagValue((String)"webAppName", (String)this.webAppName));
            xml.append("        ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
            xml.append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"proxy_hostname", (String)this.proxyHostname));
            xml.append("        ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
            xml.append("        ").append(XMLHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts));
            xml.append("        ").append(XMLHandler.addTagValue((String)"master", (boolean)this.master));
            xml.append("        ").append(XMLHandler.addTagValue((String)SSL_MODE_TAG, (boolean)this.isSslMode(), (boolean)false));
            if (this.sslConfig != null) {
                xml.append(this.sslConfig.getXML());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        xml.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public Object clone() {
        SlaveServer slaveServer = new SlaveServer();
        this.lock.readLock().lock();
        try {
            slaveServer.replaceMeta(this);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return slaveServer;
    }

    public void replaceMeta(SlaveServer slaveServer) {
        this.lock.writeLock().lock();
        try {
            this.name = slaveServer.name;
            this.hostname = slaveServer.hostname;
            this.port = slaveServer.port;
            this.webAppName = slaveServer.webAppName;
            this.username = slaveServer.username;
            this.password = slaveServer.password;
            this.proxyHostname = slaveServer.proxyHostname;
            this.proxyPort = slaveServer.proxyPort;
            this.nonProxyHosts = slaveServer.nonProxyHosts;
            this.master = slaveServer.master;
            this.id = slaveServer.id;
            this.shared = slaveServer.shared;
            this.sslMode = slaveServer.sslMode;
            this.setChanged(true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getServerAndPort() {
        String realHostname;
        this.lock.readLock().lock();
        try {
            realHostname = this.environmentSubstitute(this.hostname);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!Utils.isEmpty((CharSequence)realHostname)) {
            return realHostname + this.getPortSpecification();
        }
        return STRING_SLAVESERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof SlaveServer)) {
            return false;
        }
        SlaveServer slave = (SlaveServer)obj;
        this.lock.readLock().lock();
        try {
            boolean bl = this.name.equalsIgnoreCase(slave.getName());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public String getHostname() {
        this.lock.readLock().lock();
        try {
            String string = this.hostname;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setHostname(String urlString) {
        this.lock.writeLock().lock();
        this.hostname = urlString;
        this.lock.writeLock().unlock();
    }

    public String getPassword() {
        this.lock.readLock().lock();
        try {
            String string = this.password;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setPassword(String password) {
        this.lock.writeLock().lock();
        this.password = password;
        this.lock.writeLock().unlock();
    }

    public String getUsername() {
        this.lock.readLock().lock();
        try {
            String string = this.username;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setUsername(String username) {
        this.lock.writeLock().lock();
        this.username = username;
        this.lock.writeLock().unlock();
    }

    public String getWebAppName() {
        this.lock.readLock().lock();
        try {
            String string = this.webAppName;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setWebAppName(String webAppName) {
        this.lock.writeLock().lock();
        this.webAppName = webAppName;
        this.lock.writeLock().unlock();
    }

    public String getNonProxyHosts() {
        this.lock.readLock().lock();
        try {
            String string = this.nonProxyHosts;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.lock.writeLock().lock();
        this.nonProxyHosts = nonProxyHosts;
        this.lock.writeLock().unlock();
    }

    public String getProxyHostname() {
        this.lock.readLock().lock();
        try {
            String string = this.proxyHostname;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setProxyHostname(String proxyHostname) {
        this.lock.writeLock().lock();
        this.proxyHostname = proxyHostname;
        this.lock.writeLock().unlock();
    }

    public String getProxyPort() {
        this.lock.readLock().lock();
        try {
            String string = this.proxyPort;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setProxyPort(String proxyPort) {
        this.lock.writeLock().lock();
        this.proxyPort = proxyPort;
        this.lock.writeLock().unlock();
    }

    public String getPropertiesMasterName() {
        this.lock.readLock().lock();
        try {
            String string = this.propertiesMasterName;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isOverrideExistingProperties() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.overrideExistingProperties;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getPort() {
        this.lock.readLock().lock();
        try {
            String string = this.port;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setPort(String port) {
        this.lock.writeLock().lock();
        this.port = port;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPortSpecification() {
        this.lock.readLock().lock();
        try {
            String realPort = this.environmentSubstitute(this.port);
            String portSpec = ":" + realPort;
            if (Utils.isEmpty((CharSequence)realPort) || this.port.equals("80")) {
                portSpec = "";
            }
            String string = portSpec;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String constructUrl(String serviceAndArguments) throws UnsupportedEncodingException {
        this.lock.readLock().lock();
        try {
            String realHostname = this.environmentSubstitute(this.hostname);
            if (!StringUtils.isBlank((String)this.webAppName)) {
                serviceAndArguments = "/" + this.environmentSubstitute(this.getWebAppName()) + serviceAndArguments;
            }
            String result = (this.isSslMode() ? HTTPS : HTTP) + "://" + realHostname + this.getPortSpecification() + serviceAndArguments;
            String string = result = Const.replace((String)result, (String)" ", (String)"%20");
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    PostMethod buildSendXMLMethod(byte[] content, String service) throws Exception {
        String urlString = this.constructUrl(service);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        PostMethod postMethod = new PostMethod(urlString);
        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(content);
        postMethod.setRequestEntity((RequestEntity)entity);
        postMethod.setDoAuthentication(true);
        postMethod.addRequestHeader(new Header("Content-Type", "text/xml;charset=UTF-8"));
        return postMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendXML(String xml, String service) throws Exception {
        String string;
        PostMethod method = this.buildSendXMLMethod(xml.getBytes("UTF-8"), service);
        try {
            int result = this.getHttpClient().executeMethod((HttpMethod)method);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
            }
            String responseBody = this.getResponseBodyAsString(method.getResponseBodyAsStream());
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
            }
            if (result >= 400) {
                String message = result == 404 ? String.format("%s%s%s%s", BaseMessages.getString(PKG, (String)"SlaveServer.Error.404.Title", (String[])new String[0]), Const.CR, Const.CR, BaseMessages.getString(PKG, (String)"SlaveServer.Error.404.Message", (String[])new String[0])) : String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText());
                throw new KettleException(message);
            }
            string = responseBody;
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentXmlToService", (String[])new String[]{service, this.environmentSubstitute(this.hostname)}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentXmlToService", (String[])new String[]{service, this.environmentSubstitute(this.hostname)}));
        }
        return string;
    }

    PostMethod buildSendExportMethod(String type, String load, InputStream is) throws UnsupportedEncodingException {
        String serviceUrl = "/kettle/registerPackage";
        if (type != null && load != null) {
            serviceUrl = serviceUrl + "/?type=" + type + "&" + "load" + "=" + URLEncoder.encode(load, "UTF-8");
        }
        String urlString = this.constructUrl(serviceUrl);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        PostMethod method = new PostMethod(urlString);
        method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(is));
        method.setDoAuthentication(true);
        method.addRequestHeader(new Header("Content-Type", "binary/zip"));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendExport(String filename, String type, String load) throws Exception {
        InputStream is = null;
        try {
            String string;
            is = KettleVFS.getInputStream((FileObject)KettleVFS.getFileObject((String)filename));
            PostMethod method = this.buildSendExportMethod(type, load, is);
            try {
                int result = this.getHttpClient().executeMethod((HttpMethod)method);
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
                }
                String responseBody = this.getResponseBodyAsString(method.getResponseBodyAsStream());
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
                }
                if (result >= 400) {
                    throw new KettleException(String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText()));
                }
                string = responseBody;
            }
            catch (Throwable throwable) {
                method.releaseConnection();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentExportToService", (String[])new String[]{"/kettle/registerPackage", this.environmentSubstitute(this.hostname)}));
                }
                throw throwable;
            }
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentExportToService", (String[])new String[]{"/kettle/registerPackage", this.environmentSubstitute(this.hostname)}));
            }
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxy(HttpClient client) {
        String nonProxyHosts;
        String proxyPort;
        String proxyHost;
        String hostName;
        this.lock.readLock().lock();
        try {
            hostName = this.environmentSubstitute(this.hostname);
            proxyHost = this.environmentSubstitute(this.proxyHostname);
            proxyPort = this.environmentSubstitute(this.proxyPort);
            nonProxyHosts = this.environmentSubstitute(this.nonProxyHosts);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!Utils.isEmpty((CharSequence)proxyHost) && !Utils.isEmpty((CharSequence)proxyPort)) {
            if (!Utils.isEmpty((CharSequence)nonProxyHosts) && !Utils.isEmpty((CharSequence)hostName) && hostName.matches(nonProxyHosts)) {
                return;
            }
            client.getHostConfiguration().setProxy(proxyHost, Integer.parseInt(proxyPort));
        }
    }

    public void addCredentials(HttpClient client) {
        HttpState state = client.getState();
        this.lock.readLock().lock();
        try {
            state.setCredentials(new AuthScope(this.environmentSubstitute(this.hostname), Const.toInt((String)this.environmentSubstitute(this.port), (int)80)), (Credentials)new UsernamePasswordCredentials(this.environmentSubstitute(this.username), Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password))));
        }
        finally {
            this.lock.readLock().unlock();
        }
        client.getParams().setAuthenticationPreemptive(true);
    }

    public boolean isMaster() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.master;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setMaster(boolean master) {
        this.lock.writeLock().lock();
        this.master = master;
        this.lock.writeLock().unlock();
    }

    public String execService(String service, boolean retry) throws Exception {
        int tries = 0;
        int maxRetries = 0;
        if (retry) {
            maxRetries = KETTLE_CARTE_RETRIES;
        }
        while (true) {
            try {
                return this.execService(service);
            }
            catch (Exception e) {
                if (tries >= maxRetries) {
                    throw e;
                }
                try {
                    Thread.sleep(SlaveServer.getDelay(tries));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++tries;
                continue;
            }
            break;
        }
    }

    public static long getDelay(int trial) {
        long current = KETTLE_CARTE_RETRY_BACKOFF_INCREMENTS;
        long previous = 0L;
        for (int i = 0; i < trial; ++i) {
            long tmp = current;
            current += previous;
            previous = tmp;
        }
        return current + (long)RANDOM.nextInt((int)Math.min(Integer.MAX_VALUE, current / 4L));
    }

    public String execService(String service) throws Exception {
        return this.execService(service, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getResponseBodyAsString(InputStream is) throws IOException {
        StringBuilder bodyBuffer = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                bodyBuffer.append(line);
            }
        }
        return bodyBuffer.toString();
    }

    GetMethod buildExecuteServiceMethod(String service, Map<String, String> headerValues) throws UnsupportedEncodingException {
        GetMethod method = new GetMethod(this.constructUrl(service));
        for (String key : headerValues.keySet()) {
            method.setRequestHeader(key, headerValues.get(key));
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execService(String service, Map<String, String> headerValues) throws Exception {
        String string;
        GetMethod method = this.buildExecuteServiceMethod(service, headerValues);
        try {
            int result = this.getHttpClient().executeMethod((HttpMethod)method);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
            }
            String responseBody = method.getResponseBodyAsString();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_FinishedReading", (String[])new String[]{Integer.toString(responseBody.getBytes().length)}));
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
            }
            if (result >= 400) {
                throw new KettleException(String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText()));
            }
            string = responseBody;
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
        }
        return string;
    }

    HttpClient getHttpClient() {
        HttpClient client = SlaveConnectionManager.getInstance().createHttpClient();
        this.addCredentials(client);
        this.addProxy(client);
        return client;
    }

    public SlaveServerStatus getStatus() throws Exception {
        String xml = this.execService("/kettle/status/?xml=Y");
        return SlaveServerStatus.fromXML(xml);
    }

    public List<SlaveServerDetection> getSlaveServerDetections() throws Exception {
        String xml = this.execService("/kettle/getSlaves/");
        Document document = XMLHandler.loadXMLString((String)xml);
        Node detectionsNode = XMLHandler.getSubNode((Node)document, (String)"SlaveServerDetections");
        int nrDetections = XMLHandler.countNodes((Node)detectionsNode, (String)"SlaveServerDetection");
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        for (int i = 0; i < nrDetections; ++i) {
            Node detectionNode = XMLHandler.getSubNodeByNr((Node)detectionsNode, (String)"SlaveServerDetection", (int)i);
            SlaveServerDetection detection = new SlaveServerDetection(detectionNode);
            detections.add(detection);
        }
        return detections;
    }

    public SlaveServerTransStatus getTransStatus(String transName, String carteObjectId, int startLogLineNr) throws Exception {
        String xml = this.execService("/kettle/transStatus/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr, true);
        return SlaveServerTransStatus.fromXML(xml);
    }

    public SlaveServerJobStatus getJobStatus(String jobName, String carteObjectId, int startLogLineNr) throws Exception {
        String xml = this.execService("/kettle/jobStatus/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr, true);
        return SlaveServerJobStatus.fromXML(xml);
    }

    public WebResult stopTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/stopTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult pauseResumeTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/pauseTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult removeTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/removeTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult removeJob(String jobName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/removeJob/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult stopJob(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/stopJob/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)carteObjectId, (String)""));
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult startTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/startTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult startJob(String jobName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/startJob/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)carteObjectId, (String)""));
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult cleanupTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult deAllocateServerSockets(String transName, String clusteredRunId) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)clusteredRunId, (String)"") + "&xml=Y&sockets=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public Properties getKettleProperties() throws Exception {
        String xml = this.execService("/kettle/properties/?xml=Y");
        String decryptedXml = Encr.decryptPassword((String)xml);
        ByteArrayInputStream in = new ByteArrayInputStream(decryptedXml.getBytes());
        Properties properties = new Properties();
        properties.loadFromXML(in);
        return properties;
    }

    public static SlaveServer findSlaveServer(List<SlaveServer> slaveServers, String name) {
        for (SlaveServer slaveServer : slaveServers) {
            if (slaveServer.getName() == null || !slaveServer.getName().equalsIgnoreCase(name)) continue;
            return slaveServer;
        }
        return null;
    }

    public static SlaveServer findSlaveServer(List<SlaveServer> slaveServers, ObjectId id) {
        for (SlaveServer slaveServer : slaveServers) {
            if (slaveServer.getObjectId() == null || !slaveServer.getObjectId().equals(id)) continue;
            return slaveServer;
        }
        return null;
    }

    public static String[] getSlaveServerNames(List<SlaveServer> slaveServers) {
        String[] names = new String[slaveServers.size()];
        for (int i = 0; i < slaveServers.size(); ++i) {
            SlaveServer slaveServer = slaveServers.get(i);
            names[i] = slaveServer.getName();
        }
        return names;
    }

    public int allocateServerSocket(String runId, int portRangeStart, String hostname, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(hostname);
        String address = inetAddress.getHostAddress();
        String service = "/kettle/allocateSocket/?";
        service = service + "rangeStart=" + Integer.toString(portRangeStart);
        service = service + "&id=" + URLEncoder.encode(runId, "UTF-8");
        service = service + "&host=" + address;
        service = service + "&trans=" + URLEncoder.encode(transformationName, "UTF-8");
        service = service + "&sourceSlave=" + URLEncoder.encode(sourceSlaveName, "UTF-8");
        service = service + "&sourceStep=" + URLEncoder.encode(sourceStepName, "UTF-8");
        service = service + "&sourceCopy=" + URLEncoder.encode(sourceStepCopy, "UTF-8");
        service = service + "&targetSlave=" + URLEncoder.encode(targetSlaveName, "UTF-8");
        service = service + "&targetStep=" + URLEncoder.encode(targetStepName, "UTF-8");
        service = service + "&targetCopy=" + URLEncoder.encode(targetStepCopy, "UTF-8");
        String xml = this.execService(service = service + "&xml=Y");
        Document doc = XMLHandler.loadXMLString((String)xml);
        String portString = XMLHandler.getTagValue((Node)doc, (String)"port");
        int port = Const.toInt((String)portString, (int)-1);
        if (port < 0) {
            throw new Exception("Unable to retrieve port from service : " + service + ", received : \n" + xml);
        }
        return port;
    }

    public String getName() {
        this.lock.readLock().lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setName(String name) {
        this.lock.writeLock().lock();
        this.name = name;
        this.lock.writeLock().unlock();
    }

    public boolean isShared() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.shared;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setShared(boolean shared) {
        this.lock.writeLock().lock();
        this.shared = shared;
        this.lock.writeLock().unlock();
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.environmentSubstitute(variableName)))) {
            return ValueMetaString.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public ObjectId getObjectId() {
        this.lock.readLock().lock();
        try {
            ObjectId objectId = this.id;
            return objectId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setObjectId(ObjectId id) {
        this.lock.writeLock().lock();
        this.id = id;
        this.lock.writeLock().unlock();
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return new RepositoryDirectory();
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
        throw new RuntimeException("Setting a directory on a database connection is not supported");
    }

    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    public ObjectRevision getObjectRevision() {
        this.lock.readLock().lock();
        try {
            ObjectRevision objectRevision = this.objectRevision;
            return objectRevision;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.lock.writeLock().lock();
        this.objectRevision = objectRevision;
        this.lock.writeLock().unlock();
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String description) {
    }

    public String verifyAndModifySlaveServerName(List<SlaveServer> slaveServers, String oldname) {
        String name = this.getName();
        if (name.equalsIgnoreCase(oldname)) {
            return name;
        }
        int nr = 2;
        while (SlaveServer.findSlaveServer(slaveServers, this.getName()) != null) {
            this.setName(name + " " + nr);
            ++nr;
        }
        return this.getName();
    }

    public String sniffStep(String transName, String stepName, String copyNr, int lines, String type) throws Exception {
        return this.execService("/kettle/sniffStep/?trans=" + URLEncoder.encode(transName, "UTF-8") + "&step=" + URLEncoder.encode(stepName, "UTF-8") + "&copynr=" + copyNr + "&type=" + type + "&lines=" + lines + "&xml=Y");
    }

    public long getNextSlaveSequenceValue(String slaveSequenceName, long incrementValue) throws KettleException {
        try {
            String xml = this.execService("/kettle/nextSequence/?name=" + URLEncoder.encode(slaveSequenceName, "UTF-8") + "&" + "increment" + "=" + Long.toString(incrementValue));
            Document doc = XMLHandler.loadXMLString((String)xml);
            Node seqNode = XMLHandler.getSubNode((Node)doc, (String)"seq");
            String nextValueString = XMLHandler.getTagValue((Node)seqNode, (String)"value");
            String errorString = XMLHandler.getTagValue((Node)seqNode, (String)"error");
            if (!Utils.isEmpty((CharSequence)errorString)) {
                throw new KettleException(errorString);
            }
            if (Utils.isEmpty((CharSequence)nextValueString)) {
                throw new KettleException("No value retrieved from slave sequence '" + slaveSequenceName + "' on slave " + this.toString());
            }
            long nextValue = Const.toLong((String)nextValueString, (long)Long.MIN_VALUE);
            if (nextValue == Long.MIN_VALUE) {
                throw new KettleException("Incorrect value '" + nextValueString + "' retrieved from slave sequence '" + slaveSequenceName + "' on slave " + this.toString());
            }
            return nextValue;
        }
        catch (Exception e) {
            throw new KettleException("There was a problem retrieving a next sequence value from slave sequence '" + slaveSequenceName + "' on slave " + this.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlaveServer getClient() {
        this.lock.readLock().lock();
        try {
            String pHostName = this.getHostname();
            String pPort = this.getPort();
            String name = MessageFormat.format("Dynamic slave [{0}:{1}]", pHostName, pPort);
            SlaveServer client = new SlaveServer(name, pHostName, pPort, this.getUsername(), this.getPassword());
            client.setSslMode(this.isSslMode());
            SlaveServer slaveServer = client;
            return slaveServer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Date getChangedDate() {
        this.lock.readLock().lock();
        try {
            Date date = this.changedDate;
            return date;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setSslMode(boolean sslMode) {
        this.lock.writeLock().lock();
        this.sslMode = sslMode;
        this.lock.writeLock().unlock();
    }

    public boolean isSslMode() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.sslMode;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public SslConfiguration getSslConfig() {
        this.lock.readLock().lock();
        try {
            SslConfiguration sslConfiguration = this.sslConfig;
            return sslConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

