/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.List;
import org.pentaho.di.base.BaseHopMeta;
import org.pentaho.di.base.BaseMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;

public abstract class BasePainter<Hop extends BaseHopMeta, Part extends BaseMeta> {
    public final double theta = Math.toRadians(11.0);
    public static final int MINI_ICON_SIZE = 16;
    public static final int MINI_ICON_MARGIN = 5;
    public static final int MINI_ICON_TRIANGLE_BASE = 20;
    public static final int MINI_ICON_DISTANCE = 4;
    public static final int MINI_ICON_SKEW = 0;
    public static final int CONTENT_MENU_INDENT = 4;
    public static final int CORNER_RADIUS_5 = 10;
    public static final int CORNER_RADIUS_4 = 8;
    public static final int CORNER_RADIUS_3 = 6;
    public static final int CORNER_RADIUS_2 = 4;
    public static final float FACTOR_1_TO_1 = 1.0f;
    protected Point area;
    protected ScrollBarInterface hori;
    protected ScrollBarInterface vert;
    protected List<AreaOwner> areaOwners;
    protected Point offset;
    protected Point drop_candidate;
    protected int iconsize;
    protected int gridSize;
    protected Rectangle selrect;
    protected int linewidth;
    protected float magnification;
    protected float translationX;
    protected float translationY;
    protected boolean shadow;
    protected Object subject;
    protected GCInterface gc;
    protected int shadowSize;
    private String noteFontName;
    private int noteFontHeight;
    protected Hop candidate;

    public BasePainter(GCInterface gc, Object subject, Point area, ScrollBarInterface hori, ScrollBarInterface vert, Point drop_candidate, Rectangle selrect, List<AreaOwner> areaOwners, int iconsize, int linewidth, int gridsize, int shadowSize, boolean antiAliasing, String noteFontName, int noteFontHeight) {
        this.gc = gc;
        this.subject = subject;
        this.area = area;
        this.hori = hori;
        this.vert = vert;
        this.selrect = selrect;
        this.drop_candidate = drop_candidate;
        this.areaOwners = areaOwners;
        areaOwners.clear();
        this.iconsize = iconsize;
        this.linewidth = linewidth;
        this.gridSize = gridsize;
        this.shadowSize = shadowSize;
        this.shadow = shadowSize > 0;
        this.magnification = 1.0f;
        gc.setAntialias(antiAliasing);
        this.noteFontName = noteFontName;
        this.noteFontHeight = noteFontHeight;
    }

    public static PrimitiveGCInterface.EImage getStreamIconImage(StreamIcon streamIcon) {
        switch (streamIcon) {
            case TRUE: {
                return PrimitiveGCInterface.EImage.TRUE;
            }
            case FALSE: {
                return PrimitiveGCInterface.EImage.FALSE;
            }
            case ERROR: {
                return PrimitiveGCInterface.EImage.ERROR;
            }
            case INFO: {
                return PrimitiveGCInterface.EImage.INFO;
            }
            case TARGET: {
                return PrimitiveGCInterface.EImage.TARGET;
            }
            case INPUT: {
                return PrimitiveGCInterface.EImage.INPUT;
            }
            case OUTPUT: {
                return PrimitiveGCInterface.EImage.OUTPUT;
            }
        }
        return PrimitiveGCInterface.EImage.ARROW;
    }

    protected void drawNote(NotePadMeta notePadMeta) {
        Point ext;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(2);
        } else {
            this.gc.setLineWidth(1);
        }
        if (Utils.isEmpty((CharSequence)notePadMeta.getNote())) {
            ext = new Point(10, 10);
        } else {
            this.gc.setFont(Const.NVL((String)notePadMeta.getFontName(), (String)this.noteFontName), notePadMeta.getFontSize() == -1 ? this.noteFontHeight : notePadMeta.getFontSize(), notePadMeta.isFontBold(), notePadMeta.isFontItalic());
            ext = this.gc.textExtent(notePadMeta.getNote());
        }
        Point p = new Point(ext.x, ext.y);
        Point loc = notePadMeta.getLocation();
        Point note = this.real2screen(loc.x, loc.y);
        int margin = 5;
        p.x += 2 * margin;
        p.y += 2 * margin;
        int width = notePadMeta.width;
        int height = notePadMeta.height;
        if (p.x > width) {
            width = p.x;
        }
        if (p.y > height) {
            height = p.y;
        }
        int[] noteshape = new int[]{note.x, note.y, note.x + width + 2 * margin, note.y, note.x + width + 2 * margin, note.y + height, note.x + width, note.y + height + 2 * margin, note.x + width, note.y + height, note.x + width + 2 * margin, note.y + height, note.x + width, note.y + height + 2 * margin, note.x, note.y + height + 2 * margin};
        if (notePadMeta.isDrawShadow()) {
            int s = this.shadowSize;
            int[] shadowa = new int[]{note.x + s, note.y + s, note.x + width + 2 * margin + s, note.y + s, note.x + width + 2 * margin + s, note.y + height + s, note.x + width + s, note.y + height + 2 * margin + s, note.x + s, note.y + height + 2 * margin + s};
            this.gc.setBackground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.gc.fillPolygon(shadowa);
        }
        this.gc.setBackground(notePadMeta.getBackGroundColorRed(), notePadMeta.getBackGroundColorGreen(), notePadMeta.getBackGroundColorBlue());
        this.gc.setForeground(notePadMeta.getBorderColorRed(), notePadMeta.getBorderColorGreen(), notePadMeta.getBorderColorBlue());
        this.gc.fillPolygon(noteshape);
        this.gc.drawPolygon(noteshape);
        if (!Utils.isEmpty((CharSequence)notePadMeta.getNote())) {
            this.gc.setForeground(notePadMeta.getFontColorRed(), notePadMeta.getFontColorGreen(), notePadMeta.getFontColorBlue());
            this.gc.drawText(notePadMeta.getNote(), note.x + margin, note.y + margin, true);
        }
        notePadMeta.width = width;
        notePadMeta.height = height;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(1);
        } else {
            this.gc.setLineWidth(2);
        }
        if (!this.shadow) {
            this.areaOwners.add(new AreaOwner(AreaOwner.AreaType.NOTE, note.x, note.y, width, height, this.offset, this.subject, (Object)notePadMeta));
        }
    }

    protected int translateTo1To1(int value) {
        return Math.round((float)value / this.magnification);
    }

    protected int translateToCurrentScale(int value) {
        return Math.round((float)value * this.magnification);
    }

    protected Point real2screen(int x, int y) {
        Point screen = new Point(x + this.offset.x, y + this.offset.y);
        return screen;
    }

    protected Point getThumb(Point area, Point transMax) {
        Point resizedMax = this.magnifyPoint(transMax);
        Point thumb = new Point(0, 0);
        thumb.x = resizedMax.x <= area.x ? 100 : (int)Math.floor(100.0 * (double)area.x / (double)resizedMax.x);
        thumb.y = resizedMax.y <= area.y ? 100 : (int)Math.floor(100.0 * (double)area.y / (double)resizedMax.y);
        return thumb;
    }

    protected Point magnifyPoint(Point p) {
        return new Point(Math.round((float)p.x * this.magnification), Math.round((float)p.y * this.magnification));
    }

    protected Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        if (this.hori == null || this.vert == null) {
            return p;
        }
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round((float)(-sel.x * area.x / thumb.x) / this.magnification);
        p.y = Math.round((float)(-sel.y * area.y / thumb.y) / this.magnification);
        return p;
    }

    protected void drawRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.DASHDOT);
        this.gc.setLineWidth(this.linewidth);
        this.gc.setForeground(PrimitiveGCInterface.EColor.GRAY);
        Point s = this.real2screen(rect.x, rect.y);
        if (rect.width < 0) {
            s.x += rect.width;
        }
        if (rect.height < 0) {
            s.y += rect.height;
        }
        this.gc.drawRectangle(s.x, s.y, Math.abs(rect.width), Math.abs(rect.height));
        this.gc.setLineStyle(PrimitiveGCInterface.ELineStyle.SOLID);
    }

    protected void drawGrid() {
        Point bounds = this.gc.getDeviceBounds();
        for (int x = 0; x < bounds.x; x += this.gridSize) {
            for (int y = 0; y < bounds.y; y += this.gridSize) {
                this.gc.drawPoint(x + this.offset.x % this.gridSize, y + this.offset.y % this.gridSize);
            }
        }
    }

    protected int calcArrowLength() {
        return 19 + (this.linewidth - 1) * 5;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Point getArea() {
        return this.area;
    }

    public void setArea(Point area) {
        this.area = area;
    }

    public ScrollBarInterface getHori() {
        return this.hori;
    }

    public void setHori(ScrollBarInterface hori) {
        this.hori = hori;
    }

    public ScrollBarInterface getVert() {
        return this.vert;
    }

    public void setVert(ScrollBarInterface vert) {
        this.vert = vert;
    }

    public List<AreaOwner> getAreaOwners() {
        return this.areaOwners;
    }

    public void setAreaOwners(List<AreaOwner> areaOwners) {
        this.areaOwners = areaOwners;
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }

    public Point getDrop_candidate() {
        return this.drop_candidate;
    }

    public void setDrop_candidate(Point drop_candidate) {
        this.drop_candidate = drop_candidate;
    }

    public int getIconsize() {
        return this.iconsize;
    }

    public void setIconsize(int iconsize) {
        this.iconsize = iconsize;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public Rectangle getSelrect() {
        return this.selrect;
    }

    public void setSelrect(Rectangle selrect) {
        this.selrect = selrect;
    }

    public int getLinewidth() {
        return this.linewidth;
    }

    public void setLinewidth(int linewidth) {
        this.linewidth = linewidth;
    }

    public float getTranslationX() {
        return this.translationX;
    }

    public void setTranslationX(float translationX) {
        this.translationX = translationX;
    }

    public float getTranslationY() {
        return this.translationY;
    }

    public void setTranslationY(float translationY) {
        this.translationY = translationY;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }

    public GCInterface getGc() {
        return this.gc;
    }

    public void setGc(GCInterface gc) {
        this.gc = gc;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    public String getNoteFontName() {
        return this.noteFontName;
    }

    public void setNoteFontName(String noteFontName) {
        this.noteFontName = noteFontName;
    }

    public int getNoteFontHeight() {
        return this.noteFontHeight;
    }

    public void setNoteFontHeight(int noteFontHeight) {
        this.noteFontHeight = noteFontHeight;
    }

    public double getTheta() {
        return this.theta;
    }

    public Hop getCandidate() {
        return this.candidate;
    }

    public void setCandidate(Hop candidate) {
        this.candidate = candidate;
    }

    protected int[] getLine(Part fs, Part ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconsize / 2;
        int y1 = from.y + this.iconsize / 2;
        int x2 = to.x + this.iconsize / 2;
        int y2 = to.y + this.iconsize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    protected void drawArrow(PrimitiveGCInterface.EImage arrow, int[] line, Hop hop, Object startObject, Object endObject) {
        Point screen_from = this.real2screen(line[0], line[1]);
        Point screen_to = this.real2screen(line[2], line[3]);
        this.drawArrow(arrow, screen_from.x, screen_from.y, screen_to.x, screen_to.y, this.theta, this.calcArrowLength(), -1.0, hop, startObject, endObject);
    }

    protected abstract void drawArrow(PrimitiveGCInterface.EImage var1, int var2, int var3, int var4, int var5, double var6, int var8, double var9, Hop var11, Object var12, Object var13);
}

