/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.w3c.dom.Node;

public class StepLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = StepLogTable.class;
    public static final String XML_TAG = "step-log-table";

    private StepLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            StepLogTable table = (StepLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("        ").append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databases, List<StepMeta> steps) {
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof StepLogTable)) {
            return;
        }
        StepLogTable logTable = (StepLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    public static StepLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        StepLogTable table = new StepLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.IdBatch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.IdBatch", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.CHANNEL_ID.id, true, false, "CHANNEL_ID", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.ChannelId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.ChannelId", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.LOG_DATE.id, true, false, "LOG_DATE", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.TRANSNAME.id, true, false, "TRANSNAME", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.TransName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.TransName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STEPNAME.id, true, false, "STEPNAME", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.StepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.StepName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STEP_COPY.id, true, false, "STEP_COPY", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.StepCopy", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.StepCopy", (String[])new String[0]), 5, 3));
        table.fields.add(new LogTableField(ID.LINES_READ.id, true, false, "LINES_READ", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesRead", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesRead", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_WRITTEN.id, true, false, "LINES_WRITTEN", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesWritten", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesWritten", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_UPDATED.id, true, false, "LINES_UPDATED", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesUpdated", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_INPUT.id, true, false, "LINES_INPUT", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesInput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_OUTPUT.id, true, false, "LINES_OUTPUT", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesOutput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_REJECTED.id, true, false, "LINES_REJECTED", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LinesRejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LinesRejected", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.ERRORS.id, true, false, "ERRORS", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.Errors", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LOG_FIELD.id, false, false, "LOG_FIELD", BaseMessages.getString(PKG, (String)"StepLogTable.FieldName.LogField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepLogTable.FieldDescription.LogField", (String[])new String[0]), 2, 9999999));
        table.findField(ID.TRANSNAME.id).setNameField(true);
        table.findField(ID.LOG_DATE.id).setLogDateField(true);
        table.findField(ID.ID_BATCH.id).setKey(true);
        table.findField(ID.CHANNEL_ID.id).setVisible(false);
        table.findField(ID.LOG_FIELD.id).setLogField(true);
        table.findField(ID.ERRORS.id).setErrorsField(true);
        return table;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof StepMetaDataCombi) {
            StepMetaDataCombi combi = (StepMetaDataCombi)subject;
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (subject != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(combi.step.getTrans().getBatchId());
                            break;
                        }
                        case CHANNEL_ID: {
                            value = combi.step.getLogChannel().getLogChannelId();
                            break;
                        }
                        case LOG_DATE: {
                            value = new Date();
                            break;
                        }
                        case TRANSNAME: {
                            value = combi.step.getTrans().getName();
                            break;
                        }
                        case STEPNAME: {
                            value = combi.stepname;
                            break;
                        }
                        case STEP_COPY: {
                            value = new Long(combi.copy);
                            break;
                        }
                        case LINES_READ: {
                            value = new Long(combi.step.getLinesRead());
                            break;
                        }
                        case LINES_WRITTEN: {
                            value = new Long(combi.step.getLinesWritten());
                            break;
                        }
                        case LINES_UPDATED: {
                            value = new Long(combi.step.getLinesUpdated());
                            break;
                        }
                        case LINES_INPUT: {
                            value = new Long(combi.step.getLinesInput());
                            break;
                        }
                        case LINES_OUTPUT: {
                            value = new Long(combi.step.getLinesOutput());
                            break;
                        }
                        case LINES_REJECTED: {
                            value = new Long(combi.step.getLinesRejected());
                            break;
                        }
                        case ERRORS: {
                            value = new Long(combi.step.getErrors());
                            break;
                        }
                        case LOG_FIELD: {
                            value = this.getLogBuffer(combi.step, combi.step.getLogChannel().getLogChannelId(), status, null);
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "STEP";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"StepLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_STEP_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_STEP_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_STEP_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        return indexes;
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        CHANNEL_ID("CHANNEL_ID"),
        LOG_DATE("LOG_DATE"),
        TRANSNAME("TRANSNAME"),
        STEPNAME("STEPNAME"),
        STEP_COPY("STEP_COPY"),
        LINES_READ("LINES_READ"),
        LINES_WRITTEN("LINES_WRITTEN"),
        LINES_UPDATED("LINES_UPDATED"),
        LINES_INPUT("LINES_INPUT"),
        LINES_OUTPUT("LINES_OUTPUT"),
        LINES_REJECTED("LINES_REJECTED"),
        ERRORS("ERRORS"),
        LOG_FIELD("LOG_FIELD");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

