/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.util.HashMap;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;

public class CommandLineOption {
    private String option;
    private String description;
    private boolean yesNo;
    private boolean array;
    private StringBuilder argument;
    private boolean hiddenOption;
    private NamedParams arrayParams;
    private boolean extraParameter;

    public StringBuilder getArgument() {
        return this.argument;
    }

    public void setArgument(StringBuilder argument) {
        this.argument = argument;
    }

    public CommandLineOption(String option, String description, StringBuilder argument, boolean yesNo, boolean hiddenOption) {
        this(option, description, argument, yesNo, hiddenOption, false);
    }

    public CommandLineOption(String option, String description, StringBuilder argument, boolean yesNo, boolean hiddenOption, boolean extraParameter) {
        this.option = option;
        this.description = description;
        this.arrayParams = null;
        this.argument = argument;
        this.yesNo = yesNo;
        this.array = false;
        this.hiddenOption = hiddenOption;
        this.extraParameter = extraParameter;
    }

    public CommandLineOption(String option, String description, NamedParams argument, boolean hiddenOption) {
        this.option = option;
        this.description = description;
        this.arrayParams = argument;
        this.argument = null;
        this.yesNo = false;
        this.array = true;
        this.hiddenOption = hiddenOption;
    }

    public CommandLineOption(String option, String description, StringBuilder argument) {
        this(option, description, argument, false, false);
    }

    public CommandLineOption(String option) {
        this(option, null, new StringBuilder(), false, false);
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public boolean isYesNo() {
        return this.yesNo;
    }

    public void setYesNo(boolean yesNo) {
        this.yesNo = yesNo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsageDescription() {
        String optionStart = "  -";
        String optionDelim = " = ";
        if (Const.isWindows()) {
            optionStart = "  /";
            optionDelim = " : ";
        }
        return optionStart + Const.rightPad((String)this.option, (int)14) + optionDelim + this.description;
    }

    public String extractAndSetArgument(String arg) {
        String[] optionStart = new String[]{"-", "/"};
        String[] optionDelim = new String[]{"=", ":"};
        for (int s = 0; s < optionStart.length; ++s) {
            int osLength = optionStart[s].length();
            for (int d = 0; d < optionDelim.length; ++d) {
                int optLength = optionDelim[d].length();
                if (arg == null || arg.length() <= osLength || !arg.toUpperCase().substring(osLength).equals(this.option.toUpperCase())) continue;
                String value = null;
                int valueStart = osLength + this.option.length() + optLength;
                if (arg.length() >= valueStart) {
                    value = arg.substring(valueStart);
                }
                if ((value == null || value.length() == 0) && this.yesNo) {
                    value = "Y";
                }
                this.argument.append(value);
                return value;
            }
        }
        return null;
    }

    public boolean isHiddenOption() {
        return this.hiddenOption;
    }

    public void setHiddenOption(boolean hiddenOption) {
        this.hiddenOption = hiddenOption;
    }

    public static boolean parseArguments(List<String> args, CommandLineOption[] options, LogChannelInterface log) {
        HashMap<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
        for (int i = 0; i < options.length; ++i) {
            optionMap.put(options[i].option, options[i]);
        }
        int idx = 0;
        while (args.size() > 0 && idx < args.size()) {
            String arg = args.get(idx).trim();
            if (arg != null && arg.length() > 0 && (arg.charAt(0) == '-' || arg.charAt(0) == '/')) {
                String optionName = arg.substring(1);
                CommandLineOption option = (CommandLineOption)optionMap.get(optionName);
                String value = null;
                if (option == null) {
                    String tmp;
                    int pos = optionName.indexOf(61);
                    if (pos != -1 && (option = (CommandLineOption)optionMap.get(tmp = optionName.substring(0, pos))) != null) {
                        value = optionName.substring(pos + 1);
                    }
                    if (option == null && (pos = optionName.indexOf(58)) != -1 && (option = (CommandLineOption)optionMap.get(tmp = optionName.substring(0, pos))) != null) {
                        value = optionName.substring(pos + 1);
                    }
                }
                if (option != null) {
                    args.remove(idx);
                    if (option.yesNo) {
                        if (value != null) {
                            option.argument.append(value);
                            continue;
                        }
                        option.argument.append("Y");
                        continue;
                    }
                    if (option.array) {
                        String parameterString = null;
                        if (idx < args.size()) {
                            if (value == null) {
                                parameterString = args.get(idx);
                                args.remove(idx);
                            } else {
                                parameterString = value;
                            }
                        } else if (value != null) {
                            parameterString = value;
                        } else {
                            if (log != null) {
                                log.logError("Command Line Options", new Object[]{"Option " + optionName + " expects an argument", new Object[]{optionName}});
                            }
                            return false;
                        }
                        String key = null;
                        String val = null;
                        int pos = parameterString.indexOf(61);
                        if (pos > 0) {
                            key = parameterString.substring(0, pos);
                            val = parameterString.substring(pos + 1);
                            key = key.trim();
                            try {
                                option.arrayParams.addParameterDefinition(key, "", "runtime");
                                try {
                                    option.arrayParams.setParameterValue(key, val);
                                }
                                catch (UnknownParamException unknownParamException) {
                                }
                            }
                            catch (DuplicateParamException e) {
                                if (log == null) continue;
                                log.logError("Command Line Options", new Object[]{"Parameter '" + key + "' is specified multiple times, first occurrence is used.", new Object[]{optionName}});
                            }
                            continue;
                        }
                        if (log != null) {
                            log.logError("Command Line Options", new Object[]{"Option " + optionName + " expects an argument of the format KEY=VALUE (missing '=')", new Object[]{optionName}});
                        }
                        return false;
                    }
                    if (idx < args.size()) {
                        if (value == null) {
                            value = args.get(idx);
                            args.remove(idx);
                        }
                        option.argument.append(value);
                        continue;
                    }
                    if (value != null) {
                        option.argument.append(value);
                        continue;
                    }
                    if (log != null) {
                        log.logError("Command Line Options", new Object[]{"Option " + optionName + " expects an argument", new Object[]{optionName}});
                    }
                    return false;
                }
                ++idx;
                continue;
            }
            if ("".equals(arg)) {
                args.remove(0);
                continue;
            }
            ++idx;
        }
        return true;
    }

    public boolean isExtraParameter() {
        return this.extraParameter;
    }

    public void setExtraParameter(boolean extraParameter) {
        this.extraParameter = extraParameter;
    }

    public static void printUsage(CommandLineOption[] options) {
        System.out.println("Options:");
        for (int i = 0; i < options.length; ++i) {
            CommandLineOption option = options[i];
            if (!option.isHiddenOption()) {
                System.out.println(option.getUsageDescription());
                continue;
            }
            if (!option.isExtraParameter()) continue;
            System.out.println("[" + option.getDescription() + "]");
        }
        System.out.println("");
    }
}

