/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutput;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ExcelOutput.Injection.", groups={"FIELDS", "CUSTOM", "CONTENT"})
public class ExcelOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExcelOutputMeta.class;
    public static final int FONT_NAME_ARIAL = 0;
    public static final int FONT_NAME_COURIER = 1;
    public static final int FONT_NAME_TAHOMA = 2;
    public static final int FONT_NAME_TIMES = 3;
    public static final String[] font_name_code = new String[]{"arial", "courier", "tahoma", "times"};
    public static final String[] font_name_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_name.Arial", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_name.Courier", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_name.Tahoma", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_name.Times", (String[])new String[0])};
    public static final int FONT_UNDERLINE_NO = 0;
    public static final int FONT_UNDERLINE_SINGLE = 1;
    public static final int FONT_UNDERLINE_SINGLE_ACCOUNTING = 2;
    public static final int FONT_UNDERLINE_DOUBLE = 3;
    public static final int FONT_UNDERLINE_DOUBLE_ACCOUNTING = 4;
    public static final String[] font_underline_code = new String[]{"no", "single", "single_accounting", "double", "double_accounting"};
    public static final String[] font_underline_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_underline.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_underline.Single", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_underline.SingleAccounting", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_underline.Double", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_underline.DoubleAccounting", (String[])new String[0])};
    public static final int FONT_ORIENTATION_HORIZONTAL = 0;
    public static final int FONT_ORIENTATION_MINUS_45 = 1;
    public static final int FONT_ORIENTATION_MINUS_90 = 2;
    public static final int FONT_ORIENTATION_PLUS_45 = 3;
    public static final int FONT_ORIENTATION_PLUS_90 = 4;
    public static final int FONT_ORIENTATION_STACKED = 5;
    public static final int FONT_ORIENTATION_VERTICAL = 6;
    public static final String[] font_orientation_code = new String[]{"horizontal", "minus_45", "minus_90", "plus_45", "plus_90", "stacked", "vertical"};
    public static final String[] font_orientation_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Horizontal", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Minus_45", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Minus_90", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Plus_45", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Plus_90", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Stacked", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_orientation.Vertical", (String[])new String[0])};
    public static final int FONT_COLOR_NONE = 0;
    public static final int FONT_COLOR_BLACK = 1;
    public static final int FONT_COLOR_WHITE = 2;
    public static final int FONT_COLOR_RED = 3;
    public static final int FONT_COLOR_BRIGHT_GREEN = 4;
    public static final int FONT_COLOR_BLUE = 5;
    public static final int FONT_COLOR_YELLOW = 6;
    public static final int FONT_COLOR_PINK = 7;
    public static final int FONT_COLOR_TURQUOISE = 8;
    public static final int FONT_COLOR_DARK_RED = 9;
    public static final int FONT_COLOR_GREEN = 10;
    public static final int FONT_COLOR_DARK_BLUE = 11;
    public static final int FONT_COLOR_DARK_YELLOW = 12;
    public static final int FONT_COLOR_VIOLET = 13;
    public static final int FONT_COLOR_TEAL = 14;
    public static final int FONT_COLOR_GREY_25pct = 15;
    public static final int FONT_COLOR_GREY_50pct = 16;
    public static final int FONT_COLOR_PERIWINKLEpct = 17;
    public static final int FONT_COLOR_PLUM = 18;
    public static final int FONT_COLOR_IVORY = 19;
    public static final int FONT_COLOR_LIGHT_TURQUOISE = 20;
    public static final int FONT_COLOR_DARK_PURPLE = 21;
    public static final int FONT_COLOR_CORAL = 22;
    public static final int FONT_COLOR_OCEAN_BLUE = 23;
    public static final int FONT_COLOR_ICE_BLUE = 24;
    public static final int FONT_COLOR_TURQOISE = 25;
    public static final int FONT_COLOR_SKY_BLUE = 26;
    public static final int FONT_COLOR_LIGHT_GREEN = 27;
    public static final int FONT_COLOR_VERY_LIGHT_YELLOW = 28;
    public static final int FONT_COLOR_PALE_BLUE = 29;
    public static final int FONT_COLOR_ROSE = 30;
    public static final int FONT_COLOR_LAVENDER = 31;
    public static final int FONT_COLOR_TAN = 32;
    public static final int FONT_COLOR_LIGHT_BLUE = 33;
    public static final int FONT_COLOR_AQUA = 34;
    public static final int FONT_COLOR_LIME = 35;
    public static final int FONT_COLOR_GOLD = 36;
    public static final int FONT_COLOR_LIGHT_ORANGE = 37;
    public static final int FONT_COLOR_ORANGE = 38;
    public static final int FONT_COLOR_BLUE_GREY = 39;
    public static final int FONT_COLOR_GREY_40pct = 40;
    public static final int FONT_COLOR_DARK_TEAL = 41;
    public static final int FONT_COLOR_SEA_GREEN = 42;
    public static final int FONT_COLOR_DARK_GREEN = 43;
    public static final int FONT_COLOR_OLIVE_GREEN = 44;
    public static final int FONT_COLOR_BROWN = 45;
    public static final int FONT_COLOR_GREY_80pct = 46;
    public static final String[] font_color_code = new String[]{"none", "black", "white", "red", "bright_green", "blue", "yellow", "pink", "turquoise", "dark_red", "green", "dark_blue", "dark_yellow", "violet", "teal", "grey_25pct", "grey_50pct", "periwinklepct", "plum", "ivory", "light_turquoise", "dark_purple", "coral", "ocean_blue", "ice_blue", "turqoise", "sky_blue", "light_green", "very_light_yellow", "pale_blue", "rose", "lavender", "tan", "light_blue", "aqua", "lime", "gold", "light_orange", "orange", "blue_grey", "grey_40pct", "dark_teal", "sea_green", "dark_green", "olive_green", "brown", "grey_80pct"};
    public static final String[] font_color_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.BLACK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.WHITE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.RED", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.BRIGHT_GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.YELLOW", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.PINK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.TURQUOISE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_RED", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_YELLOW", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.VIOLET", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.TEAL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GREY_25pct", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GREY_50pct", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.PERIWINKLEpct", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.PLUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.IVORY", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LIGHT_TURQUOISE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_PURPLE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.CORAL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.OCEAN_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.ICE_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.TURQOISE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.SKY_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LIGHT_GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.VERY_LIGHT_YELLOW", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.PALE_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.ROSE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LAVENDER", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.TAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LIGHT_BLUE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.AQUA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LIME", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GOLD", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.LIGHT_ORANGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.ORANGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.BLUE_GREY", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GREY_40pct", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_TEAL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.SEA_GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.DARK_GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.OLIVE_GREEN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.BROWN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_color.GREY_80pct", (String[])new String[0])};
    public static final int FONT_ALIGNMENT_LEFT = 0;
    public static final int FONT_ALIGNMENT_RIGHT = 1;
    public static final int FONT_ALIGNMENT_CENTER = 2;
    public static final int FONT_ALIGNMENT_FILL = 3;
    public static final int FONT_ALIGNMENT_GENERAL = 4;
    public static final int FONT_ALIGNMENT_JUSTIFY = 5;
    public static final String[] font_alignment_code = new String[]{"left", "right", "center", "fill", "general", "justify"};
    public static final String[] font_alignment_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.Center", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.Fill", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.General", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelOutputMeta.font_alignment.Justify", (String[])new String[0])};
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final int DEFAULT_ROW_HEIGHT = 255;
    public static final int DEFAULT_ROW_WIDTH = 255;
    private int header_font_name;
    @Injection(name="HEADER_FONT_SIZE", group="CUSTOM")
    private String header_font_size;
    @Injection(name="HEADER_FONT_BOLD", group="CUSTOM")
    private boolean header_font_bold;
    @Injection(name="HEADER_FONT_ITALIC", group="CUSTOM")
    private boolean header_font_italic;
    private int header_font_underline;
    private int header_font_orientation;
    @Injection(name="HEADER_FONT_COLOR", group="CUSTOM")
    private int header_font_color;
    @Injection(name="HEADER_BACKGROUND_COLOR", group="CUSTOM")
    private int header_background_color;
    @Injection(name="HEADER_ROW_HEIGHT", group="CUSTOM")
    private String header_row_height;
    private int header_alignment;
    @Injection(name="HEADER_IMAGE", group="CUSTOM")
    private String header_image;
    private int row_font_name;
    @Injection(name="ROW_FONT_SIZE", group="CUSTOM")
    private String row_font_size;
    @Injection(name="ROW_FONT_COLOR", group="CUSTOM")
    private int row_font_color;
    @Injection(name="ROW_BACKGROUND_COLOR", group="CUSTOM")
    private int row_background_color;
    @Injection(name="FILENAME")
    private String fileName;
    @Injection(name="EXTENSION")
    private String extension;
    @Injection(name="PASSWORD", group="CONTENT")
    private String password;
    @Injection(name="HEADER_ENABLED", group="CONTENT")
    private boolean headerEnabled;
    @Injection(name="FOOTER_ENABLED", group="CONTENT")
    private boolean footerEnabled;
    @Injection(name="SPLIT_EVERY", group="CONTENT")
    private int splitEvery;
    @Injection(name="STEP_NR_IN_FILENAME")
    private boolean stepNrInFilename;
    @Injection(name="DATE_IN_FILENAME")
    private boolean dateInFilename;
    @Injection(name="FILENAME_TO_RESULT")
    private boolean addToResultFilenames;
    @Injection(name="PROTECT", group="CONTENT")
    private boolean protectsheet;
    @Injection(name="TIME_IN_FILENAME")
    private boolean timeInFilename;
    @Injection(name="TEMPLATE", group="CONTENT")
    private boolean templateEnabled;
    @Injection(name="TEMPLATE_FILENAME", group="CONTENT")
    private String templateFileName;
    @Injection(name="TEMPLATE_APPEND", group="CONTENT")
    private boolean templateAppend;
    @Injection(name="SHEET_NAME", group="CONTENT")
    private String sheetname;
    @Injection(name="USE_TEMPFILES", group="CONTENT")
    private boolean usetempfiles;
    @Injection(name="TEMPDIR", group="CONTENT")
    private String tempdirectory;
    @InjectionDeep
    private ExcelField[] outputFields;
    @Injection(name="ENCODING", group="CONTENT")
    private String encoding;
    @Injection(name="NEWLINE", group="CONTENT")
    private String newline;
    @Injection(name="APPEND", group="CONTENT")
    private boolean append;
    @Injection(name="DONT_OPEN_NEW_FILE")
    private boolean doNotOpenNewFileInit;
    @Injection(name="CREATE_PARENT_FOLDER")
    private boolean createparentfolder;
    @Injection(name="DATE_FORMAT_SPECIFIED")
    private boolean SpecifyFormat;
    @Injection(name="DATE_FORMAT")
    private String date_time_format;
    @Injection(name="AUTOSIZE_COLUMNS", group="CONTENT")
    private boolean autoSizeColumns;
    @Injection(name="NULL_AS_BLANK", group="CONTENT")
    private boolean nullIsBlank;

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSheetname() {
        return this.sheetname;
    }

    public void setSheetname(String sheetname) {
        this.sheetname = sheetname;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isAutoSizeColumns() {
        return this.autoSizeColumns;
    }

    public void setAutoSizeColumns(boolean autosizecolums) {
        this.autoSizeColumns = autosizecolums;
    }

    @Deprecated
    public boolean isAutoSizeColums() {
        return this.autoSizeColumns;
    }

    @Deprecated
    public void setAutoSizeColums(boolean autosizecolums) {
        this.autoSizeColumns = autosizecolums;
    }

    public void setTempDirectory(String directory) {
        this.tempdirectory = directory;
    }

    public String getTempDirectory() {
        return this.tempdirectory;
    }

    public boolean isNullBlank() {
        return this.nullIsBlank;
    }

    public void setNullIsBlank(boolean nullIsBlank) {
        this.nullIsBlank = nullIsBlank;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isSheetProtected() {
        return this.protectsheet;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setProtectSheet(boolean protectsheet) {
        this.protectsheet = protectsheet;
    }

    public boolean isUseTempFiles() {
        return this.usetempfiles;
    }

    public void setUseTempFiles(boolean usetempfiles) {
        this.usetempfiles = usetempfiles;
    }

    public ExcelField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(ExcelField[] outputFields) {
        this.outputFields = outputFields;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isTemplateEnabled() {
        return this.templateEnabled;
    }

    public void setTemplateEnabled(boolean template) {
        this.templateEnabled = template;
    }

    public boolean isTemplateAppend() {
        return this.templateAppend;
    }

    public void setTemplateAppend(boolean templateAppend) {
        this.templateAppend = templateAppend;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new ExcelField[nrfields];
    }

    @Override
    public Object clone() {
        ExcelOutputMeta retval = (ExcelOutputMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (ExcelField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.append = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"append"));
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResult) ? true : "Y".equalsIgnoreCase(addToResult);
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"do_not_open_newfile_init"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"date_time_format");
            this.usetempfiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"usetempfiles"));
            this.tempdirectory = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"tempdirectory");
            this.autoSizeColumns = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"autosizecolums"));
            this.nullIsBlank = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"nullisblank"));
            this.protectsheet = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"protect_sheet"));
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"password"));
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            this.templateEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"enabled"));
            this.templateAppend = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"append"));
            this.templateFileName = XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"filename");
            this.sheetname = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"sheetname");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new ExcelField();
                this.outputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
            }
            Node customnode = XMLHandler.getSubNode((Node)stepnode, (String)"custom");
            this.header_font_name = ExcelOutputMeta.getFontNameByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_font_name"), (String)""));
            this.header_font_size = Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_font_size"), (String)"10");
            this.header_font_bold = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)customnode, (String)"header_font_bold"));
            this.header_font_italic = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)customnode, (String)"header_font_italic"));
            this.header_font_underline = ExcelOutputMeta.getFontUnderlineByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_font_underline"), (String)""));
            this.header_font_orientation = ExcelOutputMeta.getFontOrientationByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_font_orientation"), (String)""));
            this.header_font_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_font_color"), (String)"1"));
            this.header_background_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_background_color"), (String)"0"));
            this.header_row_height = XMLHandler.getTagValue((Node)customnode, (String)"header_row_height");
            this.header_alignment = ExcelOutputMeta.getFontAlignmentByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"header_alignment"), (String)""));
            this.header_image = XMLHandler.getTagValue((Node)customnode, (String)"header_image");
            this.row_font_name = ExcelOutputMeta.getFontNameByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"row_font_name"), (String)""));
            this.row_font_size = Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"row_font_size"), (String)"10");
            this.row_font_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"row_font_color"), (String)"1"));
            this.row_background_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)XMLHandler.getTagValue((Node)customnode, (String)"row_background_color"), (String)"0"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.usetempfiles = false;
        this.tempdirectory = null;
        this.header_font_name = 0;
        this.header_font_size = "10";
        this.header_font_bold = false;
        this.header_font_italic = false;
        this.header_font_underline = 0;
        this.header_font_orientation = 0;
        this.header_font_color = 1;
        this.header_background_color = 0;
        this.header_row_height = "255";
        this.header_alignment = 0;
        this.header_image = null;
        this.row_font_name = 0;
        this.row_font_size = "10";
        this.row_font_color = 1;
        this.row_background_color = 0;
        this.autoSizeColumns = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileName = "file";
        this.extension = "xls";
        this.doNotOpenNewFileInit = false;
        this.createparentfolder = false;
        this.stepNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.date_time_format = null;
        this.SpecifyFormat = false;
        this.addToResultFilenames = true;
        this.protectsheet = false;
        this.splitEvery = 0;
        this.templateEnabled = false;
        this.templateAppend = false;
        this.templateFileName = "template.xls";
        this.sheetname = "Sheet1";
        this.append = false;
        this.nullIsBlank = false;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new ExcelField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
        }
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(space, copy, split);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(this.fileName);
        String realextension = space.environmentSubstitute(this.extension);
        Date now = new Date();
        if (this.SpecifyFormat && !Utils.isEmpty((CharSequence)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.dateInFilename) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.timeInFilename) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + splitnr;
        }
        if (realextension != null && realextension.length() != 0) {
            retval = retval + "." + realextension;
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"append", (boolean)this.append));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sheetname", (String)this.sheetname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"autosizecolums", (boolean)this.autoSizeColumns));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nullisblank", (boolean)this.nullIsBlank));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protect_sheet", (boolean)this.protectsheet));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usetempfiles", (boolean)this.usetempfiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tempdirectory", (String)this.tempdirectory));
        retval.append("      </file>").append(Const.CR);
        retval.append("    <template>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.templateEnabled));
        retval.append("      ").append(XMLHandler.addTagValue((String)"append", (boolean)this.templateAppend));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.templateFileName));
        retval.append("    </template>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            ExcelField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <custom>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_name", (String)ExcelOutputMeta.getFontNameCode(this.header_font_name)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_size", (String)this.header_font_size));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_bold", (boolean)this.header_font_bold));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_italic", (boolean)this.header_font_italic));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_underline", (String)ExcelOutputMeta.getFontUnderlineCode(this.header_font_underline)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_orientation", (String)ExcelOutputMeta.getFontOrientationCode(this.header_font_orientation)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_font_color", (String)ExcelOutputMeta.getFontColorCode(this.header_font_color)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_background_color", (String)ExcelOutputMeta.getFontColorCode(this.header_background_color)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_row_height", (String)this.header_row_height));
        retval.append("    " + XMLHandler.addTagValue((String)"header_alignment", (String)ExcelOutputMeta.getFontAlignmentCode(this.header_alignment)));
        retval.append("    " + XMLHandler.addTagValue((String)"header_image", (String)this.header_image));
        retval.append("    " + XMLHandler.addTagValue((String)"row_font_name", (String)ExcelOutputMeta.getFontNameCode(this.row_font_name)));
        retval.append("    " + XMLHandler.addTagValue((String)"row_font_size", (String)this.row_font_size));
        retval.append("    " + XMLHandler.addTagValue((String)"row_font_color", (String)ExcelOutputMeta.getFontColorCode(this.row_font_color)));
        retval.append("    " + XMLHandler.addTagValue((String)"row_background_color", (String)ExcelOutputMeta.getFontColorCode(this.row_background_color)));
        retval.append("      </custom>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, "header");
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, "footer");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.append = rep.getStepAttributeBoolean(id_step, "append");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.usetempfiles = rep.getStepAttributeBoolean(id_step, "usetempfiles");
            this.tempdirectory = rep.getStepAttributeString(id_step, "tempdirectory");
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_newfile_init");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.SpecifyFormat = rep.getStepAttributeBoolean(id_step, "SpecifyFormat");
            this.date_time_format = rep.getStepAttributeString(id_step, "date_time_format");
            this.autoSizeColumns = rep.getStepAttributeBoolean(id_step, "autosizecolums");
            this.nullIsBlank = rep.getStepAttributeBoolean(id_step, "nullisblank");
            this.protectsheet = rep.getStepAttributeBoolean(id_step, "protect_sheet");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.templateEnabled = rep.getStepAttributeBoolean(id_step, "template_enabled");
            this.templateAppend = rep.getStepAttributeBoolean(id_step, "template_append");
            this.templateFileName = rep.getStepAttributeString(id_step, "template_filename");
            this.sheetname = rep.getStepAttributeString(id_step, "sheetname");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new ExcelField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
            }
            this.header_font_name = ExcelOutputMeta.getFontNameByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_font_name"), (String)""));
            this.header_font_size = Const.NVL((String)rep.getStepAttributeString(id_step, "header_font_size"), (String)"10");
            this.header_font_bold = rep.getStepAttributeBoolean(id_step, "header_font_bold");
            this.header_font_italic = rep.getStepAttributeBoolean(id_step, "header_font_italic");
            this.header_font_underline = ExcelOutputMeta.getFontUnderlineByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_font_underline"), (String)""));
            this.header_font_orientation = ExcelOutputMeta.getFontOrientationByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_font_orientation"), (String)""));
            this.header_font_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_font_color"), (String)"1"));
            this.header_background_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_background_color"), (String)"0"));
            this.header_row_height = rep.getStepAttributeString(id_step, "header_row_height");
            this.header_alignment = ExcelOutputMeta.getFontAlignmentByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "header_alignment"), (String)""));
            this.header_image = rep.getStepAttributeString(id_step, "header_image");
            this.row_font_name = ExcelOutputMeta.getFontNameByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "row_font_name"), (String)""));
            this.row_font_size = Const.NVL((String)rep.getStepAttributeString(id_step, "row_font_size"), (String)"10");
            this.row_font_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "row_font_color"), (String)"1"));
            this.row_background_color = ExcelOutputMeta.getFontColorByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "row_background_color"), (String)"0"));
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    private static String getFontNameCode(int i) {
        if (i < 0 || i >= font_name_code.length) {
            return font_name_code[0];
        }
        return font_name_code[i];
    }

    private static String getFontUnderlineCode(int i) {
        if (i < 0 || i >= font_underline_code.length) {
            return font_underline_code[0];
        }
        return font_underline_code[i];
    }

    private static String getFontAlignmentCode(int i) {
        if (i < 0 || i >= font_alignment_code.length) {
            return font_alignment_code[0];
        }
        return font_alignment_code[i];
    }

    private static String getFontOrientationCode(int i) {
        if (i < 0 || i >= font_orientation_code.length) {
            return font_orientation_code[0];
        }
        return font_orientation_code[i];
    }

    private static String getFontColorCode(int i) {
        if (i < 0 || i >= font_color_code.length) {
            return font_color_code[0];
        }
        return font_color_code[i];
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "append", this.append);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_newfile_init", this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "SpecifyFormat", this.SpecifyFormat);
            rep.saveStepAttribute(id_transformation, id_step, "date_time_format", this.date_time_format);
            rep.saveStepAttribute(id_transformation, id_step, "tempdirectory", this.tempdirectory);
            rep.saveStepAttribute(id_transformation, id_step, "usetempfiles", this.usetempfiles);
            rep.saveStepAttribute(id_transformation, id_step, "autosizecolums", this.autoSizeColumns);
            rep.saveStepAttribute(id_transformation, id_step, "nullisblank", this.nullIsBlank);
            rep.saveStepAttribute(id_transformation, id_step, "protect_sheet", this.protectsheet);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "template_enabled", this.templateEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "template_append", this.templateAppend);
            rep.saveStepAttribute(id_transformation, id_step, "template_filename", this.templateFileName);
            rep.saveStepAttribute(id_transformation, id_step, "sheetname", this.sheetname);
            for (int i = 0; i < this.outputFields.length; ++i) {
                ExcelField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
            }
            rep.saveStepAttribute(id_transformation, id_step, "header_font_name", ExcelOutputMeta.getFontNameCode(this.header_font_name));
            rep.saveStepAttribute(id_transformation, id_step, "header_font_size", this.header_font_size);
            rep.saveStepAttribute(id_transformation, id_step, "header_font_bold", this.header_font_bold);
            rep.saveStepAttribute(id_transformation, id_step, "header_font_italic", this.header_font_italic);
            rep.saveStepAttribute(id_transformation, id_step, "header_font_underline", ExcelOutputMeta.getFontUnderlineCode(this.header_font_underline));
            rep.saveStepAttribute(id_transformation, id_step, "header_font_orientation", ExcelOutputMeta.getFontOrientationCode(this.header_font_orientation));
            rep.saveStepAttribute(id_transformation, id_step, "header_font_color", ExcelOutputMeta.getFontColorCode(this.header_font_color));
            rep.saveStepAttribute(id_transformation, id_step, "header_background_color", ExcelOutputMeta.getFontColorCode(this.header_background_color));
            rep.saveStepAttribute(id_transformation, id_step, "header_row_height", this.header_row_height);
            rep.saveStepAttribute(id_transformation, id_step, "header_alignment", ExcelOutputMeta.getFontAlignmentCode(this.header_alignment));
            rep.saveStepAttribute(id_transformation, id_step, "header_image", this.header_image);
            rep.saveStepAttribute(id_transformation, id_step, "row_font_name", ExcelOutputMeta.getFontNameCode(this.row_font_name));
            rep.saveStepAttribute(id_transformation, id_step, "row_font_size", this.row_font_size);
            rep.saveStepAttribute(id_transformation, id_step, "row_font_color", ExcelOutputMeta.getFontColorCode(this.row_font_color));
            rep.saveStepAttribute(id_transformation, id_step, "row_background_color", ExcelOutputMeta.getFontColorCode(this.row_background_color));
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"ExcelOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space);
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExcelOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExcelOutputData();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jxl.jar"};
    }

    public static String getFontNameDesc(int i) {
        if (i < 0 || i >= font_name_desc.length) {
            return font_name_desc[0];
        }
        return font_name_desc[i];
    }

    public static String getFontUnderlineDesc(int i) {
        if (i < 0 || i >= font_underline_desc.length) {
            return font_underline_desc[0];
        }
        return font_underline_desc[i];
    }

    public static String getFontOrientationDesc(int i) {
        if (i < 0 || i >= font_orientation_desc.length) {
            return font_orientation_desc[0];
        }
        return font_orientation_desc[i];
    }

    public static String getFontColorDesc(int i) {
        if (i < 0 || i >= font_color_desc.length) {
            return font_color_desc[0];
        }
        return font_color_desc[i];
    }

    public static String getFontAlignmentDesc(int i) {
        if (i < 0 || i >= font_alignment_desc.length) {
            return font_alignment_desc[0];
        }
        return font_alignment_desc[i];
    }

    public int getHeaderFontName() {
        return this.header_font_name;
    }

    public int getRowFontName() {
        return this.row_font_name;
    }

    public int getHeaderFontUnderline() {
        return this.header_font_underline;
    }

    public int getHeaderFontOrientation() {
        return this.header_font_orientation;
    }

    public int getHeaderAlignment() {
        return this.header_alignment;
    }

    public int getHeaderFontColor() {
        return this.header_font_color;
    }

    public int getRowFontColor() {
        return this.row_font_color;
    }

    public int getHeaderBackGroundColor() {
        return this.header_background_color;
    }

    public int getRowBackGroundColor() {
        return this.row_background_color;
    }

    public static int getFontNameByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_name_desc.length; ++i) {
            if (!font_name_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ExcelOutputMeta.getFontNameByCode(tt);
    }

    private static int getFontNameByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_name_code.length; ++i) {
            if (!font_name_code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getFontUnderlineByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_underline_desc.length; ++i) {
            if (!font_underline_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ExcelOutputMeta.getFontUnderlineByCode(tt);
    }

    public static int getFontOrientationByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_orientation_desc.length; ++i) {
            if (!font_orientation_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ExcelOutputMeta.getFontOrientationByCode(tt);
    }

    private static int getFontUnderlineByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_underline_code.length; ++i) {
            if (!font_underline_code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getFontOrientationByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_orientation_code.length; ++i) {
            if (!font_orientation_code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getFontColorByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_color_desc.length; ++i) {
            if (!font_color_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ExcelOutputMeta.getFontColorByCode(tt);
    }

    public static int getFontAlignmentByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_alignment_desc.length; ++i) {
            if (!font_alignment_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ExcelOutputMeta.getFontAlignmentByCode(tt);
    }

    private static int getFontAlignmentByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_alignment_code.length; ++i) {
            if (!font_alignment_code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getFontColorByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < font_color_code.length; ++i) {
            if (!font_color_code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setHeaderFontName(int fontname) {
        this.header_font_name = fontname;
    }

    @Injection(name="HEADER_FONT_NAME", group="CUSTOM")
    public void setHeaderFontName(String fontname) {
        this.header_font_name = ExcelOutputMeta.getFontNameByCode(fontname);
    }

    public void setRowFontName(int fontname) {
        this.row_font_name = fontname;
    }

    @Injection(name="ROW_FONT_NAME", group="CUSTOM")
    public void setRowFontName(String fontname) {
        this.row_font_name = ExcelOutputMeta.getFontNameByCode(fontname);
    }

    public void setHeaderFontUnderline(int fontunderline) {
        this.header_font_underline = fontunderline;
    }

    @Injection(name="HEADER_FONT_UNDERLINE", group="CUSTOM")
    public void setHeaderFontUnderline(String fontunderline) {
        this.header_font_underline = ExcelOutputMeta.getFontUnderlineByCode(fontunderline);
    }

    public void setHeaderFontOrientation(int fontorientation) {
        this.header_font_orientation = fontorientation;
    }

    @Injection(name="HEADER_FONT_ORIENTATION", group="CUSTOM")
    public void setHeaderFontOrientation(String fontorientation) {
        this.header_font_orientation = ExcelOutputMeta.getFontOrientationByCode(fontorientation);
    }

    public void setHeaderFontColor(int fontcolor) {
        this.header_font_color = fontcolor;
    }

    public void setRowFontColor(int fontcolor) {
        this.row_font_color = fontcolor;
    }

    public void setHeaderBackGroundColor(int fontcolor) {
        this.header_background_color = fontcolor;
    }

    public void setRowBackGroundColor(int fontcolor) {
        this.row_background_color = fontcolor;
    }

    public void setHeaderAlignment(int alignment) {
        this.header_alignment = alignment;
    }

    @Injection(name="HEADER_ALIGNMENT", group="CUSTOM")
    public void setHeaderAlignment(String alignment) {
        this.header_alignment = ExcelOutputMeta.getFontAlignmentByCode(alignment);
    }

    public void setHeaderFontSize(String fontsize) {
        this.header_font_size = fontsize;
    }

    public void setRowFontSize(String fontsize) {
        this.row_font_size = fontsize;
    }

    public String getHeaderFontSize() {
        return this.header_font_size;
    }

    public String getRowFontSize() {
        return this.row_font_size;
    }

    public void setHeaderImage(String image) {
        this.header_image = image;
    }

    public String getHeaderImage() {
        return this.header_image;
    }

    public void setHeaderRowHeight(String height) {
        this.header_row_height = height;
    }

    public String getHeaderRowHeight() {
        return this.header_row_height;
    }

    public boolean isHeaderFontBold() {
        return this.header_font_bold;
    }

    public void setHeaderFontItalic(boolean fontitalic) {
        this.header_font_italic = fontitalic;
    }

    public boolean isHeaderFontItalic() {
        return this.header_font_italic;
    }

    public void setHeaderFontBold(boolean font_bold) {
        this.header_font_bold = font_bold;
    }
}

