/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jobexecutor;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorData;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorParameters;

public class JobExecutor
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JobExecutorMeta.class;
    private JobExecutorMeta meta;
    private JobExecutorData data;

    public JobExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (JobExecutorMeta)smi;
            this.data = (JobExecutorData)sdi;
            Object[] row = this.getRow();
            if (row == null) {
                if (!this.data.groupBuffer.isEmpty()) {
                    this.executeJob();
                }
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.executionResultsOutputRowMeta = this.data.inputRowMeta.clone();
                this.data.resultRowsOutputRowMeta = this.data.inputRowMeta.clone();
                this.data.resultFilesOutputRowMeta = this.data.inputRowMeta.clone();
                if (this.meta.getExecutionResultTargetStepMeta() != null) {
                    this.meta.getFields(this.data.executionResultsOutputRowMeta, this.getStepname(), null, this.meta.getExecutionResultTargetStepMeta(), this, this.repository, this.metaStore);
                    this.data.executionResultRowSet = this.findOutputRowSet(this.meta.getExecutionResultTargetStepMeta().getName());
                }
                if (this.meta.getResultRowsTargetStepMeta() != null) {
                    this.meta.getFields(this.data.resultRowsOutputRowMeta, this.getStepname(), null, this.meta.getResultRowsTargetStepMeta(), this, this.repository, this.metaStore);
                    this.data.resultRowsRowSet = this.findOutputRowSet(this.meta.getResultRowsTargetStepMeta().getName());
                }
                if (this.meta.getResultFilesTargetStepMeta() != null) {
                    this.meta.getFields(this.data.resultFilesOutputRowMeta, this.getStepname(), null, this.meta.getResultFilesTargetStepMeta(), this, this.repository, this.metaStore);
                    this.data.resultFilesRowSet = this.findOutputRowSet(this.meta.getResultFilesTargetStepMeta().getName());
                }
                this.data.groupFieldIndex = -1;
                if (!Utils.isEmpty((CharSequence)this.data.groupField)) {
                    this.data.groupFieldIndex = this.getInputRowMeta().indexOfValue(this.data.groupField);
                    if (this.data.groupFieldIndex < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutor.Exception.GroupFieldNotFound", (String[])new String[]{this.data.groupField}));
                    }
                    this.data.groupFieldMeta = this.getInputRowMeta().getValueMeta(this.data.groupFieldIndex);
                }
            }
            if (this.data.groupSize < 0) {
                long now;
                if (this.data.groupFieldIndex >= 0) {
                    Object groupFieldData = row[this.data.groupFieldIndex];
                    if (this.data.prevGroupFieldData != null && this.data.groupFieldMeta.compare(this.data.prevGroupFieldData, groupFieldData) != 0) {
                        this.executeJob();
                    }
                    this.data.prevGroupFieldData = groupFieldData;
                } else if (this.data.groupTime > 0 && (now = System.currentTimeMillis()) - this.data.groupTimeStart >= (long)this.data.groupTime) {
                    this.executeJob();
                }
            }
            this.data.groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            if (this.data.groupSize > 0 && this.data.groupBuffer.size() >= this.data.groupSize) {
                this.executeJob();
            }
            return true;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void executeJob() throws KettleException {
        Object[] targetRow;
        Result result;
        block35: {
            if (this.data.groupBuffer.isEmpty()) {
                return;
            }
            this.data.groupTimeStart = System.currentTimeMillis();
            if (this.first) {
                this.discardLogLines(this.data);
            }
            this.data.executorJob = this.createJob(this.meta.getRepository(), this.data.executorJobMeta, this);
            this.data.executorJob.setParentTrans(this.getTrans());
            this.data.executorJob.setLogLevel(this.getLogLevel());
            if (this.meta.getParameters().isInheritingAllVariables()) {
                this.data.executorJob.shareVariablesWith(this);
            }
            this.data.executorJob.setInternalKettleVariables(this);
            this.data.executorJob.copyParametersFrom(this.data.executorJobMeta);
            this.data.executorJob.setArguments(this.getTrans().getArguments());
            this.data.executorJob.setSourceRows(this.data.groupBuffer);
            this.passParametersToJob();
            this.getTrans().getActiveSubjobs().put(this.getStepname(), this.data.executorJob);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobStart.id, (Object)this.data.executorJob);
            this.data.executorJob.beginProcessing();
            result = new Result();
            for (DelegationListener delegationListener : this.getTrans().getDelegationListeners()) {
                delegationListener.jobDelegationStarted(this.data.executorJob, new JobExecutionConfiguration());
            }
            result = this.data.executorJob.execute(0, result);
            try {
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.data.executorJob);
                this.data.executorJob.fireJobFinishListeners();
            }
            catch (KettleException e) {
                result.setNrErrors(1L);
                result.setResult(false);
                this.log.logError(BaseMessages.getString(PKG, (String)"JobExecutor.Log.ErrorExecJob", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            break block35;
            catch (KettleException e) {
                try {
                    this.log.logError("An error occurred executing the job: ", (Throwable)e);
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
                catch (Throwable throwable) {
                    try {
                        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.data.executorJob);
                        this.data.executorJob.fireJobFinishListeners();
                    }
                    catch (KettleException e2) {
                        result.setNrErrors(1L);
                        result.setResult(false);
                        this.log.logError(BaseMessages.getString(PKG, (String)"JobExecutor.Log.ErrorExecJob", (String[])new String[]{e2.getMessage()}), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobFinish.id, (Object)this.data.executorJob);
                    this.data.executorJob.fireJobFinishListeners();
                }
                catch (KettleException e3) {
                    result.setNrErrors(1L);
                    result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"JobExecutor.Log.ErrorExecJob", (String[])new String[]{e3.getMessage()}), (Throwable)e3);
                }
            }
        }
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.executionResultsOutputRowMeta.size());
            int idx = 0;
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - this.data.groupTimeStart;
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionResultField())) {
                outputRow[idx++] = result.getResult();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLogTextField())) {
                String channelId = this.data.executorJob.getLogChannelId();
                String logText = KettleLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLogChannelIdField())) {
                outputRow[idx++] = this.data.executorJob.getLogChannelId();
            }
            this.putRowTo(this.data.executionResultsOutputRowMeta, outputRow, this.data.executionResultRowSet);
        }
        if (this.meta.getResultRowsTargetStepMeta() != null && result.getRows() != null) {
            for (RowMetaAndData row : result.getRows()) {
                targetRow = RowDataUtil.allocateRowData((int)this.data.resultRowsOutputRowMeta.size());
                for (int i = 0; i < this.meta.getResultRowsField().length; ++i) {
                    ValueMetaInterface valueMeta = row.getRowMeta().getValueMeta(i);
                    if (valueMeta.getType() != this.meta.getResultRowsType()[i]) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutor.IncorrectDataTypePassed", (String[])new String[]{valueMeta.getTypeDesc(), ValueMetaFactory.getValueMetaName((int)this.meta.getResultRowsType()[i])}));
                    }
                    targetRow[i] = row.getData()[i];
                }
                this.putRowTo(this.data.resultRowsOutputRowMeta, targetRow, this.data.resultRowsRowSet);
            }
        }
        if (this.meta.getResultFilesTargetStepMeta() != null && result.getResultFilesList() != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                targetRow = RowDataUtil.allocateRowData((int)this.data.resultFilesOutputRowMeta.size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(this.data.resultFilesOutputRowMeta, targetRow, this.data.resultFilesRowSet);
            }
        }
        this.data.groupBuffer.clear();
    }

    @VisibleForTesting
    Job createJob(Repository repository, JobMeta jobMeta, LoggingObjectInterface parentLogging) {
        return new Job(repository, jobMeta, parentLogging);
    }

    @VisibleForTesting
    void discardLogLines(JobExecutorData data) {
        if (data.executorJob != null) {
            KettleLogStore.discardLines((String)data.executorJob.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(data.executorJob.getLogChannelId());
        }
    }

    private void passParametersToJob() throws KettleException {
        JobExecutorParameters parameters = this.meta.getParameters();
        this.data.executorJob.clearParameters();
        String[] parameterNames = this.data.executorJob.listParameters();
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            String value;
            String variable = parameters.getVariable()[i];
            String fieldName = parameters.getField()[i];
            String inputValue = parameters.getInput()[i];
            if (!Utils.isEmpty((CharSequence)fieldName)) {
                int idx = this.getInputRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = this.data.groupBuffer.get(0).getString(idx, "");
            } else {
                value = this.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                this.data.executorJob.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            this.data.executorJob.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        this.data.executorJob.activateParameters();
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JobExecutorMeta)smi;
        this.data = (JobExecutorData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.executorJobMeta = JobExecutorMeta.loadJobMeta(this.meta, this.meta.getRepository(), this);
                if (this.data.executorJobMeta != null) {
                    this.data.groupBuffer = new ArrayList<RowMetaAndData>();
                    this.data.groupSize = -1;
                    if (!Utils.isEmpty((CharSequence)this.meta.getGroupSize())) {
                        this.data.groupSize = Const.toInt((String)this.environmentSubstitute(this.meta.getGroupSize()), (int)-1);
                    }
                    this.data.groupTime = -1;
                    if (!Utils.isEmpty((CharSequence)this.meta.getGroupTime())) {
                        this.data.groupTime = Const.toInt((String)this.environmentSubstitute(this.meta.getGroupTime()), (int)-1);
                    }
                    this.data.groupTimeStart = System.currentTimeMillis();
                    this.data.groupField = null;
                    if (!Utils.isEmpty((CharSequence)this.meta.getGroupField())) {
                        this.data.groupField = this.environmentSubstitute(this.meta.getGroupField());
                    }
                    return true;
                }
                this.logError("No valid job was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the executor job because of an error : ", e);
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.groupBuffer = null;
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.executorJob != null) {
            this.data.executorJob.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.data.executorJob != null) {
            this.data.executorJob.stopAll();
        }
        super.stopAll();
    }

    public Job getExecutorJob() {
        return this.data.executorJob;
    }
}

