/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServerTransStatus {
    public static final String XML_TAG = "transstatus";
    private String id;
    private String transName;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private int firstLoggingLineNr;
    private int lastLoggingLineNr;
    private Date logDate;
    private List<StepStatus> stepStatusList = new ArrayList<StepStatus>();
    private Result result;
    private boolean paused;

    public SlaveServerTransStatus() {
    }

    public SlaveServerTransStatus(String transName, String id, String statusDescription) {
        this();
        this.transName = transName;
        this.id = id;
        this.statusDescription = statusDescription;
    }

    public String getXML() throws KettleException {
        boolean sendResultXmlWithStatus = EnvUtil.getSystemProperty((String)"KETTLE_COMPATIBILITY_SEND_RESULT_XML_WITH_FULL_STATUS", (String)"N").equalsIgnoreCase("Y");
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XMLHandler.addTagValue((String)"transname", (String)this.transName));
        xml.append("  ").append(XMLHandler.addTagValue((String)"id", (String)this.id));
        xml.append("  ").append(XMLHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append("  ").append(XMLHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append("  ").append(XMLHandler.addTagValue((String)"log_date", (String)XMLHandler.date2string((Date)this.logDate)));
        xml.append("  ").append(XMLHandler.addTagValue((String)"paused", (boolean)this.paused));
        xml.append("  ").append(XMLHandler.openTag((String)"stepstatuslist")).append(Const.CR);
        for (int i = 0; i < this.stepStatusList.size(); ++i) {
            StepStatus stepStatus = this.stepStatusList.get(i);
            xml.append("    ").append(stepStatus.getXML()).append(Const.CR);
        }
        xml.append("  ").append(XMLHandler.closeTag((String)"stepstatuslist")).append(Const.CR);
        xml.append("  ").append(XMLHandler.addTagValue((String)"first_log_line_nr", (int)this.firstLoggingLineNr));
        xml.append("  ").append(XMLHandler.addTagValue((String)"last_log_line_nr", (int)this.lastLoggingLineNr));
        if (this.result != null) {
            String resultXML = sendResultXmlWithStatus ? this.result.getXML() : this.result.getBasicXml();
            xml.append(resultXML);
        }
        xml.append("  ").append(XMLHandler.addTagValue((String)"logging_string", (String)XMLHandler.buildCDATA((String)this.loggingString)));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public SlaveServerTransStatus(Node transStatusNode) throws KettleException {
        this();
        Node resultNode;
        this.id = XMLHandler.getTagValue((Node)transStatusNode, (String)"id");
        this.transName = XMLHandler.getTagValue((Node)transStatusNode, (String)"transname");
        this.statusDescription = XMLHandler.getTagValue((Node)transStatusNode, (String)"status_desc");
        this.errorDescription = XMLHandler.getTagValue((Node)transStatusNode, (String)"error_desc");
        this.logDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)transStatusNode, (String)"log_date"));
        this.paused = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)transStatusNode, (String)"paused"));
        Node statusListNode = XMLHandler.getSubNode((Node)transStatusNode, (String)"stepstatuslist");
        int nr = XMLHandler.countNodes((Node)statusListNode, (String)"stepstatus");
        for (int i = 0; i < nr; ++i) {
            Node stepStatusNode = XMLHandler.getSubNodeByNr((Node)statusListNode, (String)"stepstatus", (int)i);
            StepStatus stepStatus = new StepStatus(stepStatusNode);
            this.stepStatusList.add(stepStatus);
        }
        this.firstLoggingLineNr = Const.toInt((String)XMLHandler.getTagValue((Node)transStatusNode, (String)"first_log_line_nr"), (int)0);
        this.lastLoggingLineNr = Const.toInt((String)XMLHandler.getTagValue((Node)transStatusNode, (String)"last_log_line_nr"), (int)0);
        String loggingString64 = XMLHandler.getTagValue((Node)transStatusNode, (String)"logging_string");
        if (!Utils.isEmpty((CharSequence)loggingString64)) {
            String dataString64 = loggingString64.substring("<![CDATA[".length(), loggingString64.length() - "]]>".length());
            try {
                this.loggingString = HttpUtil.decodeBase64ZippedString((String)dataString64);
            }
            catch (IOException e) {
                this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getStackTracker((Throwable)e);
            }
        } else {
            this.loggingString = "";
        }
        if ((resultNode = XMLHandler.getSubNode((Node)transStatusNode, (String)"result")) != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (KettleException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
            this.result.setLogText(this.loggingString);
        }
    }

    public static SlaveServerTransStatus fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        SlaveServerTransStatus status = new SlaveServerTransStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public List<StepStatus> getStepStatusList() {
        return this.stepStatusList;
    }

    public void setStepStatusList(List<StepStatus> stepStatusList) {
        this.stepStatusList = stepStatusList;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public boolean isStopped() {
        return this.getStatusDescription().equalsIgnoreCase("Stopped");
    }

    public boolean isWaiting() {
        return this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public long getNrStepErrors() {
        long errors = 0L;
        for (int i = 0; i < this.stepStatusList.size(); ++i) {
            StepStatus stepStatus = this.stepStatusList.get(i);
            errors += stepStatus.getErrors();
        }
        return errors;
    }

    public Result getResult(TransMeta transMeta) {
        Result result = new Result();
        for (StepStatus stepStatus : this.stepStatusList) {
            result.setNrErrors(result.getNrErrors() + stepStatus.getErrors() + (long)(result.isStopped() ? 1 : 0));
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameRead())) {
                result.increaseLinesRead(stepStatus.getLinesRead());
            }
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameInput())) {
                result.increaseLinesInput(stepStatus.getLinesInput());
            }
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameWritten())) {
                result.increaseLinesWritten(stepStatus.getLinesWritten());
            }
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameOutput())) {
                result.increaseLinesOutput(stepStatus.getLinesOutput());
            }
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameUpdated())) {
                result.increaseLinesUpdated(stepStatus.getLinesUpdated());
            }
            if (stepStatus.getStepname().equals(transMeta.getTransLogTable().getStepnameRejected())) {
                result.increaseLinesRejected(stepStatus.getLinesRejected());
            }
            if (!stepStatus.isStopped()) continue;
            result.setStopped(true);
            result.setResult(false);
        }
        return result;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getLastLoggingLineNr() {
        return this.lastLoggingLineNr;
    }

    public void setLastLoggingLineNr(int lastLoggingLineNr) {
        this.lastLoggingLineNr = lastLoggingLineNr;
    }

    public int getFirstLoggingLineNr() {
        return this.firstLoggingLineNr;
    }

    public void setFirstLoggingLineNr(int firstLoggingLineNr) {
        this.firstLoggingLineNr = firstLoggingLineNr;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

