/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;

public class Wss10
extends AbstractSecurityAssertion
implements PolicyContainingAssertion {
    private Policy nestedPolicy;
    private boolean mustSupportRefKeyIdentifier;
    private boolean mustSupportRefIssuerSerial;
    private boolean mustSupportRefExternalURI;
    private boolean mustSupportRefEmbeddedToken;

    public Wss10(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version);
        this.nestedPolicy = nestedPolicy;
        this.parseNestedWss10Policy(nestedPolicy, this);
    }

    public Policy getPolicy() {
        return this.nestedPolicy;
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getWss10();
    }

    @Override
    public PolicyComponent normalize() {
        return super.normalize(this.getPolicy());
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        super.serialize(writer, this.getPolicy());
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new Wss10(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedWss10Policy(Policy nestedPolicy, Wss10 wss10) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (this.getVersion().getSPConstants().getMustSupportRefKeyIdentifier().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportRefKeyIdentifier().getNamespaceURI().equals(assertionNamespace)) {
                    if (wss10.isMustSupportRefKeyIdentifier()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    wss10.setMustSupportRefKeyIdentifier(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getMustSupportRefIssuerSerial().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportRefIssuerSerial().getNamespaceURI().equals(assertionNamespace)) {
                    if (wss10.isMustSupportRefIssuerSerial()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    wss10.setMustSupportRefIssuerSerial(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getMustSupportRefExternalUri().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportRefExternalUri().getNamespaceURI().equals(assertionNamespace)) {
                    if (wss10.isMustSupportRefExternalURI()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    wss10.setMustSupportRefExternalURI(true);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getMustSupportRefEmbeddedToken().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getMustSupportRefEmbeddedToken().getNamespaceURI().equals(assertionNamespace)) continue;
                if (wss10.isMustSupportRefEmbeddedToken()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                wss10.setMustSupportRefEmbeddedToken(true);
            }
        }
    }

    public boolean isMustSupportRefKeyIdentifier() {
        return this.mustSupportRefKeyIdentifier;
    }

    protected void setMustSupportRefKeyIdentifier(boolean mustSupportRefKeyIdentifier) {
        this.mustSupportRefKeyIdentifier = mustSupportRefKeyIdentifier;
    }

    public boolean isMustSupportRefIssuerSerial() {
        return this.mustSupportRefIssuerSerial;
    }

    protected void setMustSupportRefIssuerSerial(boolean mustSupportRefIssuerSerial) {
        this.mustSupportRefIssuerSerial = mustSupportRefIssuerSerial;
    }

    public boolean isMustSupportRefExternalURI() {
        return this.mustSupportRefExternalURI;
    }

    protected void setMustSupportRefExternalURI(boolean mustSupportRefExternalURI) {
        this.mustSupportRefExternalURI = mustSupportRefExternalURI;
    }

    public boolean isMustSupportRefEmbeddedToken() {
        return this.mustSupportRefEmbeddedToken;
    }

    protected void setMustSupportRefEmbeddedToken(boolean mustSupportRefEmbeddedToken) {
        this.mustSupportRefEmbeddedToken = mustSupportRefEmbeddedToken;
    }
}

