/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.table.TableModel;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.TableProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.WrappingFormulaContext;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractKettleTransformationProducer
implements KettleTransformationProducer {
    private static final long serialVersionUID = -2287953597208384424L;
    private String stepName;
    private String username;
    private String password;
    private String repositoryName;
    private FormulaArgument[] arguments;
    private FormulaParameter[] parameter;
    private transient Trans currentlyRunningTransformation;
    private boolean stopOnError;

    @Deprecated
    public AbstractKettleTransformationProducer(String repositoryName, String stepName, String username, String password, String[] definedArgumentNames, ParameterMapping[] definedVariableNames) {
        this(repositoryName, stepName, username, password, FormulaArgument.convert(definedArgumentNames), FormulaParameter.convert(definedVariableNames));
    }

    protected AbstractKettleTransformationProducer(String repositoryName, String stepName, String username, String password, FormulaArgument[] definedArgumentNames, FormulaParameter[] definedVariableNames) {
        if (repositoryName == null) {
            throw new NullPointerException();
        }
        if (definedArgumentNames == null) {
            throw new NullPointerException();
        }
        if (definedVariableNames == null) {
            throw new NullPointerException();
        }
        this.stopOnError = true;
        this.repositoryName = repositoryName;
        this.stepName = stepName;
        this.username = username;
        this.password = password;
        this.arguments = (FormulaArgument[])definedArgumentNames.clone();
        this.parameter = (FormulaParameter[])definedVariableNames.clone();
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String[] getDefinedArgumentNames() {
        return FormulaArgument.convert(this.arguments);
    }

    public ParameterMapping[] getDefinedVariableNames() {
        return FormulaParameter.convert(this.parameter);
    }

    public FormulaArgument[] getArguments() {
        return (FormulaArgument[])this.arguments.clone();
    }

    public FormulaParameter[] getParameter() {
        return (FormulaParameter[])this.parameter.clone();
    }

    @Override
    public Object clone() {
        try {
            AbstractKettleTransformationProducer prod = (AbstractKettleTransformationProducer)super.clone();
            prod.arguments = (FormulaArgument[])this.arguments.clone();
            prod.parameter = (FormulaParameter[])this.parameter.clone();
            prod.currentlyRunningTransformation = null;
            return prod;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransMeta loadTransformation(DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        Repository repository = this.connectToRepository();
        try {
            TransMeta transMeta = this.loadTransformation(repository, context.getResourceManager(), context.getContextKey());
            return transMeta;
        }
        finally {
            this.currentlyRunningTransformation = null;
            if (repository != null) {
                repository.disconnect();
            }
        }
    }

    @Override
    public TableModel queryDesignTimeStructure(DataRow parameter, DataFactoryContext context) throws ReportDataFactoryException, KettleException {
        String stepName = this.getStepName();
        if (stepName == null) {
            throw new ReportDataFactoryException("No step name defined.");
        }
        Repository repository = this.connectToRepository();
        try {
            ResourceManager resourceManager = context.getResourceManager();
            TransMeta transMeta = this.loadTransformation(repository, resourceManager, context.getContextKey());
            if (this.isDynamicTransformation(transMeta)) {
                TableModel tableModel = this.performQueryOnTransformation(parameter, 1, context, transMeta);
                return tableModel;
            }
            StepMeta step = transMeta.findStep(stepName);
            if (step == null) {
                throw new ReportDataFactoryException("Cannot find the specified transformation step " + stepName);
            }
            RowMetaInterface row = transMeta.getStepFields(this.getStepName());
            TableProducer tableProducer = new TableProducer(row, 1, true);
            TableModel tableModel = tableProducer.getTableModel();
            return tableModel;
        }
        catch (EvaluationException e) {
            throw new ReportDataFactoryException("Failed to evaluate parameter", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ReportDataFactoryException("Failed to evaluate parameter", (Throwable)e);
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
        }
    }

    private boolean isDynamicTransformation(TransMeta transMeta) {
        List steps = transMeta.getSteps();
        for (StepMeta step : steps) {
            if (!step.isEtlMetaInject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableModel performQuery(DataRow parameters, int queryLimit, DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        ArgumentNullException.validate((String)"context", (Object)context);
        ArgumentNullException.validate((String)"parameters", (Object)parameters);
        String targetStepName = this.getStepName();
        if (targetStepName == null) {
            throw new ReportDataFactoryException("No step name defined.");
        }
        Repository repository = this.connectToRepository();
        try {
            TransMeta transMeta = this.loadTransformation(repository, context.getResourceManager(), context.getContextKey());
            TableModel tableModel = this.performQueryOnTransformation(parameters, queryLimit, context, transMeta);
            return tableModel;
        }
        catch (EvaluationException e) {
            throw new ReportDataFactoryException("Failed to evaluate parameter", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ReportDataFactoryException("Failed to evaluate parameter", (Throwable)e);
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableModel performQueryOnTransformation(DataRow parameters, int queryLimit, DataFactoryContext context, TransMeta transMeta) throws EvaluationException, ParseException, KettleException, ReportDataFactoryException {
        Trans trans = this.prepareTransformation(parameters, context, transMeta);
        StepInterface targetStep = this.findTargetStep(trans);
        RowMetaInterface row = transMeta.getStepFields(this.getStepName());
        TableProducer tableProducer = new TableProducer(row, queryLimit, this.isStopOnError());
        targetStep.addRowListener((RowListener)tableProducer);
        this.currentlyRunningTransformation = trans;
        try {
            trans.startThreads();
            trans.waitUntilFinished();
        }
        finally {
            trans.cleanup();
            this.currentlyRunningTransformation = null;
        }
        if (trans.getErrors() != 0 && this.isStopOnError()) {
            throw new ReportDataFactoryException(String.format("Transformation reported %d records with errors and stop-on-error is true. Aborting.", trans.getErrors()));
        }
        return tableProducer.getTableModel();
    }

    private Trans prepareTransformation(DataRow parameters, DataFactoryContext context, TransMeta transMeta) throws EvaluationException, ParseException, KettleException {
        WrappingFormulaContext formulaContext = new WrappingFormulaContext(context.getFormulaContext(), parameters);
        String[] params = this.fillArguments(formulaContext);
        Trans trans = new Trans(transMeta);
        trans.setArguments(params);
        this.updateTransformationParameter(formulaContext, trans);
        transMeta.setInternalKettleVariables();
        trans.prepareExecution(params);
        return trans;
    }

    private StepInterface findTargetStep(Trans trans) throws ReportDataFactoryException {
        String stepName = this.getStepName();
        List stepList = trans.getSteps();
        for (int i = 0; i < stepList.size(); ++i) {
            StepMetaDataCombi metaDataCombi = (StepMetaDataCombi)stepList.get(i);
            if (!stepName.equals(metaDataCombi.stepname)) continue;
            return metaDataCombi.step;
        }
        throw new ReportDataFactoryException("Cannot find the specified transformation step " + stepName);
    }

    private void updateTransformationParameter(FormulaContext formulaContext, Trans trans) throws UnknownParamException, EvaluationException, ParseException {
        for (int i = 0; i < this.parameter.length; ++i) {
            FormulaParameter mapping = this.parameter[i];
            String sourceName = mapping.getName();
            Object value = mapping.compute(formulaContext);
            if (value != null) {
                trans.setParameterValue(sourceName, String.valueOf(value));
                continue;
            }
            trans.setParameterValue(sourceName, null);
        }
    }

    private String[] fillArguments(FormulaContext context) throws EvaluationException, ParseException {
        String[] params = new String[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            FormulaArgument arg = this.arguments[i];
            Object compute = arg.compute(context);
            params[i] = compute == null ? null : String.valueOf(compute);
        }
        return params;
    }

    private Repository connectToRepository() throws ReportDataFactoryException, KettleException {
        if (this.repositoryName == null) {
            throw new NullPointerException();
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        try {
            repositoriesMeta.readData();
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(this.repositoryName);
        if (repositoryMeta == null) {
            return null;
        }
        Repository repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
        repository.init(repositoryMeta);
        repository.connect(this.username, this.password);
        return repository;
    }

    protected abstract TransMeta loadTransformation(Repository var1, ResourceManager var2, ResourceKey var3) throws ReportDataFactoryException, KettleException;

    @Override
    public void cancelQuery() {
        Trans currentlyRunningTransformation = this.currentlyRunningTransformation;
        if (currentlyRunningTransformation != null) {
            currentlyRunningTransformation.stopAll();
            this.currentlyRunningTransformation = null;
        }
    }

    @Override
    public String[] getReferencedFields() throws ParseException {
        LinkedHashSet retval = new LinkedHashSet();
        HashSet<String> args = new HashSet<String>();
        for (FormulaArgument formulaArgument : this.arguments) {
            args.addAll(Arrays.asList(formulaArgument.getReferencedFields()));
        }
        for (Serializable serializable : this.parameter) {
            args.addAll(Arrays.asList(((FormulaParameter)serializable).getReferencedFields()));
        }
        retval.addAll(args);
        retval.add("::org.pentaho.reporting::query-limit");
        return retval.toArray(new String[retval.size()]);
    }

    protected ArrayList<Object> internalGetQueryHash() {
        ArrayList<Object> retval = new ArrayList<Object>();
        retval.add(this.getClass().getName());
        retval.add(this.getUsername());
        retval.add(this.getPassword());
        retval.add(this.getStepName());
        retval.add(this.isStopOnError());
        retval.add(this.getRepositoryName());
        retval.add(new ArrayList<FormulaArgument>(Arrays.asList(this.getArguments())));
        retval.add(new ArrayList<FormulaParameter>(Arrays.asList(this.getParameter())));
        return retval;
    }

    protected String computeFullFilename(ResourceKey key) {
        while (key != null) {
            Object identifier = key.getIdentifier();
            if (identifier instanceof File) {
                File file = (File)identifier;
                return file.getAbsolutePath();
            }
            key = key.getParent();
        }
        return null;
    }
}

