/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromRepositoryProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.EmdeddedTransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.FileTransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.RepositoryTransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandler;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class KettleDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/kettle-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.extensions.datasources.kettle.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        KettleDataFactory kettleDataFactory = (KettleDataFactory)dataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/kettle");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "kettle-datasource", rootAttrs, false);
        String[] queryNames = kettleDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            KettleTransformationProducer prod = kettleDataFactory.getQuery(queryName);
            TransformationProducerWriteHandler handler = this.lookupWriteHandler(prod);
            handler.writeKettleRepositoryProducer(bundle, fileName, xmlWriter, queryName, prod);
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }

    protected TransformationProducerWriteHandler lookupWriteHandler(KettleTransformationProducer prod) throws BundleWriterException {
        if (prod instanceof KettleTransFromFileProducer) {
            return new FileTransformationProducerWriteHandler();
        }
        if (prod instanceof KettleTransFromRepositoryProducer) {
            return new RepositoryTransformationProducerWriteHandler();
        }
        if (prod instanceof EmbeddedKettleTransformationProducer) {
            return new EmdeddedTransformationProducerWriteHandler();
        }
        throw new BundleWriterException("Failed to write Kettle-Producer: Unknown implementation.");
    }
}

