/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.common.base.Stopwatch;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaTableLocator {
    private static final Log LOG = LogFactory.getLog(MetaTableLocator.class);
    private volatile boolean stopped = false;

    public boolean isLocationAvailable(ZooKeeperWatcher zkw) {
        return this.getMetaRegionLocation(zkw) != null;
    }

    public List<Pair<HRegionInfo, ServerName>> getMetaRegionsAndLocations(ZooKeeperWatcher zkw) {
        return this.getMetaRegionsAndLocations(zkw, 0);
    }

    public List<Pair<HRegionInfo, ServerName>> getMetaRegionsAndLocations(ZooKeeperWatcher zkw, int replicaId) {
        ServerName serverName = this.getMetaRegionLocation(zkw, replicaId);
        ArrayList<Pair<HRegionInfo, ServerName>> list = new ArrayList<Pair<HRegionInfo, ServerName>>();
        list.add(new Pair((Object)RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, replicaId), (Object)serverName));
        return list;
    }

    public List<HRegionInfo> getMetaRegions(ZooKeeperWatcher zkw) {
        return this.getMetaRegions(zkw, 0);
    }

    public List<HRegionInfo> getMetaRegions(ZooKeeperWatcher zkw, int replicaId) {
        List<Pair<HRegionInfo, ServerName>> result = this.getMetaRegionsAndLocations(zkw, replicaId);
        return this.getListOfHRegionInfos(result);
    }

    private List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add((HRegionInfo)pair.getFirst());
        }
        return result;
    }

    public ServerName getMetaRegionLocation(ZooKeeperWatcher zkw) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public ServerName getMetaRegionLocation(ZooKeeperWatcher zkw, int replicaId) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw, replicaId);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public ServerName waitMetaRegionLocation(ZooKeeperWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        return this.waitMetaRegionLocation(zkw, 0, timeout);
    }

    public ServerName waitMetaRegionLocation(ZooKeeperWatcher zkw, int replicaId, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error((Object)errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("KeeperException while trying to check baseZNode:", e);
        }
        ServerName sn = this.blockUntilAvailable(zkw, replicaId, timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public void waitMetaRegionLocation(ZooKeeperWatcher zkw) throws InterruptedException {
        Stopwatch stopwatch = new Stopwatch().start();
        while (!this.stopped) {
            try {
                if (this.waitMetaRegionLocation(zkw, 100L) != null) break;
                long sleepTime = stopwatch.elapsedMillis();
                if ((sleepTime + 1L) % 10000L != 0L) continue;
                LOG.warn((Object)("Have been waiting for meta to be assigned for " + sleepTime + "ms"));
            }
            catch (NotAllMetaRegionsOnlineException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("hbase:meta still not available, sleeping and retrying. Reason: " + e.getMessage()));
            }
        }
    }

    public boolean verifyMetaRegionLocation(HConnection hConnection, ZooKeeperWatcher zkw, long timeout) throws InterruptedException, IOException {
        return this.verifyMetaRegionLocation(hConnection, zkw, timeout, 0);
    }

    public boolean verifyMetaRegionLocation(HConnection hConnection, ZooKeeperWatcher zkw, long timeout, int replicaId) throws InterruptedException, IOException {
        AdminProtos.AdminService.BlockingInterface service = null;
        try {
            service = this.getMetaServerConnection(hConnection, zkw, timeout, replicaId);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningYetException e) {
        }
        catch (UnknownHostException e) {
        }
        catch (RegionServerStoppedException e) {
            // empty catch block
        }
        return service != null && this.verifyRegionLocation(hConnection, service, this.getMetaRegionLocation(zkw, replicaId), RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, replicaId).getRegionName());
    }

    private boolean verifyRegionLocation(Connection connection, AdminProtos.AdminService.BlockingInterface hostingServer, ServerName address, byte[] regionName) throws IOException {
        Throwable t;
        if (hostingServer == null) {
            LOG.info((Object)"Passed hostingServer is null");
            return false;
        }
        PayloadCarryingRpcController controller = null;
        if (connection instanceof ClusterConnection) {
            controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        }
        try {
            return ProtobufUtil.getRegionInfo(controller, hostingServer, regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RetriesExhaustedException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info((Object)("Failed verification of " + Bytes.toStringBinary((byte[])regionName) + " at address=" + address + ", exception=" + t.getMessage()));
        return false;
    }

    private AdminProtos.AdminService.BlockingInterface getMetaServerConnection(HConnection hConnection, ZooKeeperWatcher zkw, long timeout, int replicaId) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return MetaTableLocator.getCachedConnection(hConnection, this.waitMetaRegionLocation(zkw, replicaId, timeout));
    }

    private static AdminProtos.AdminService.BlockingInterface getCachedConnection(HConnection hConnection, ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface service;
        block11: {
            if (sn == null) {
                return null;
            }
            service = null;
            try {
                service = hConnection.getAdmin(sn);
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug((Object)("Timed out connecting to " + sn));
            }
            catch (NoRouteToHostException e) {
                LOG.debug((Object)("Connecting to " + sn), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)("Exception connecting to " + sn));
            }
            catch (UnknownHostException e) {
                LOG.debug((Object)("Unknown host exception connecting to  " + sn));
            }
            catch (FailedServerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Server " + sn + " is in failed server list."));
                }
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (ioe instanceof ConnectException || cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase().contains("connection reset")) break block11;
                throw ioe;
            }
        }
        return service;
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName serverName, RegionState.State state) throws KeeperException {
        MetaTableLocator.setMetaLocation(zookeeper, serverName, 0, state);
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName serverName, int replicaId, RegionState.State state) throws KeeperException {
        LOG.info((Object)("Setting hbase:meta region location in ZooKeeper as " + serverName));
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName(serverName)).setRpcVersion(0).setState(state.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic(pbrsr.toByteArray());
        try {
            ZKUtil.setData(zookeeper, zookeeper.getZNodeForReplica(replicaId), data);
        }
        catch (KeeperException.NoNodeException nne) {
            if (replicaId == 0) {
                LOG.debug((Object)"META region location doesn't exist, create it");
            } else {
                LOG.debug((Object)("META region location doesn't exist for replicaId " + replicaId + ", create it"));
            }
            ZKUtil.createAndWatch(zookeeper, zookeeper.getZNodeForReplica(replicaId), data);
        }
    }

    public static RegionState getMetaRegionState(ZooKeeperWatcher zkw) throws KeeperException {
        return MetaTableLocator.getMetaRegionState(zkw, 0);
    }

    public static RegionState getMetaRegionState(ZooKeeperWatcher zkw, int replicaId) throws KeeperException {
        ServerName serverName;
        RegionState.State state;
        block8: {
            state = RegionState.State.OPEN;
            serverName = null;
            try {
                byte[] data = ZKUtil.getData(zkw, zkw.getZNodeForReplica(replicaId));
                if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix(data)) {
                    try {
                        int prefixLen = ProtobufUtil.lengthOfPBMagic();
                        ZooKeeperProtos.MetaRegionServer rl = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                        if (rl.hasState()) {
                            state = RegionState.State.convert(rl.getState());
                        }
                        HBaseProtos.ServerName sn = rl.getServer();
                        serverName = ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
                        break block8;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new DeserializationException("Unable to parse meta region location");
                    }
                }
                serverName = ServerName.parseFrom(data);
            }
            catch (DeserializationException e) {
                throw ZKUtil.convert(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, replicaId), state, serverName);
    }

    public void deleteMetaLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        this.deleteMetaLocation(zookeeper, 0);
    }

    public void deleteMetaLocation(ZooKeeperWatcher zookeeper, int replicaId) throws KeeperException {
        if (replicaId == 0) {
            LOG.info((Object)"Deleting hbase:meta region location in ZooKeeper");
        } else {
            LOG.info((Object)("Deleting hbase:meta for " + replicaId + " region location in ZooKeeper"));
        }
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.getZNodeForReplica(replicaId));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public List<ServerName> blockUntilAvailable(ZooKeeperWatcher zkw, long timeout, Configuration conf) throws InterruptedException {
        int numReplicasConfigured = 1;
        try {
            List<String> metaReplicaNodes = zkw.getMetaReplicaNodes();
            numReplicasConfigured = metaReplicaNodes.size();
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Got ZK exception " + (Object)((Object)e)));
        }
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numReplicasConfigured);
        ServerName server = this.blockUntilAvailable(zkw, timeout);
        if (server == null) {
            return null;
        }
        servers.add(server);
        for (int replicaId = 1; replicaId < numReplicasConfigured; ++replicaId) {
            servers.add(this.getMetaRegionLocation(zkw, replicaId));
        }
        return servers;
    }

    public ServerName blockUntilAvailable(ZooKeeperWatcher zkw, long timeout) throws InterruptedException {
        return this.blockUntilAvailable(zkw, 0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName blockUntilAvailable(ZooKeeperWatcher zkw, int replicaId, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        Stopwatch sw = new Stopwatch().start();
        ServerName sn = null;
        try {
            while ((sn = this.getMetaRegionLocation(zkw, replicaId)) == null) {
                if (sw.elapsedMillis() > timeout - 200L) {
                    break;
                }
                Thread.sleep(200L);
            }
        }
        finally {
            sw.stop();
        }
        return sn;
    }

    public void stop() {
        if (!this.stopped) {
            LOG.debug((Object)"Stopping MetaTableLocator");
            this.stopped = true;
        }
    }
}

