/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDBDelegate;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.HelpUtils;

public class EnterSelectionDialog
extends Dialog {
    private static Class<?> PKG = EnterSelectionDialog.class;
    private Label wlSelection;
    private List wSelection;
    private FormData fdlSelection;
    private FormData fdSelection;
    private TextVar wConstantValue;
    private Button wbUseConstant;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private SelectionAdapter lsDef;
    private String[] choices;
    private String selection;
    private int selectionNr;
    private String shellText;
    private String lineText;
    private PropsUI props;
    private String constant;
    private VariableSpace variableSpace;
    private boolean viewOnly;
    private boolean modal;
    private int[] selectedNrs;
    private boolean multi;
    private int[] indices;
    private boolean fixed;
    private boolean quickSearch;
    private ToolItem goSearch;
    private ToolItem wfilter;
    private ToolItem addConnection;
    private ToolItem wbRegex;
    private String filterString = null;
    private Pattern pattern = null;
    private Text searchText = null;
    private HasDatabasesInterface databasesInterface;

    public Shell getShell() {
        return this.shell;
    }

    @Deprecated
    public EnterSelectionDialog(Shell parent, PropsUI props, String[] choices, String shellText, String lineText) {
        this(parent, choices, shellText, lineText);
        this.props = props;
    }

    public EnterSelectionDialog(Shell parent, String[] choices, String shellText, String message) {
        super(parent, 0);
        this.choices = choices;
        this.shellText = shellText;
        this.lineText = message;
        this.props = PropsUI.getInstance();
        this.selection = null;
        this.viewOnly = false;
        this.modal = true;
        this.selectedNrs = new int[0];
        this.multi = false;
        this.fixed = false;
        this.quickSearch = true;
    }

    public EnterSelectionDialog(Shell parent, String[] choices, String shellText, String message, HasDatabasesInterface databasesInterface) {
        this(parent, choices, shellText, message);
        this.databasesInterface = databasesInterface;
    }

    public EnterSelectionDialog(Shell parent, String[] choices, String shellText, String message, String constant, VariableSpace variableSpace) {
        this(parent, choices, shellText, message);
        this.constant = constant;
        this.variableSpace = variableSpace;
    }

    public void setViewOnly() {
        this.viewOnly = true;
    }

    public void setAvoidQuickSearch() {
        this.quickSearch = false;
    }

    public void clearModal() {
        this.modal = false;
    }

    public String open(int nr) {
        this.selectedNrs = new int[]{nr};
        return this.open();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 0x860 | (this.modal ? 0x10010000 : 0) | 0x10 | 0x80 | 0x400);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        int margin = 4;
        if (this.quickSearch) {
            ToolBar treeTb = new ToolBar((Composite)this.shell, 0x800100);
            this.props.setLook((Control)treeTb);
            this.wfilter = new ToolItem(treeTb, 2);
            this.searchText = new Text((Composite)treeTb, 384);
            this.props.setLook((Control)this.searchText);
            this.searchText.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.FilterString.ToolTip", (String[])new String[0]));
            this.wfilter.setControl((Control)this.searchText);
            this.wfilter.setWidth(120);
            this.wbRegex = new ToolItem(treeTb, 32);
            this.wbRegex.setImage(GUIResource.getInstance().getImageRegexSmall());
            this.wbRegex.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.useRegEx.Tooltip", (String[])new String[0]));
            this.goSearch = new ToolItem(treeTb, 8);
            this.goSearch.setImage(GUIResource.getInstance().getImageSearchSmall());
            this.goSearch.setToolTipText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.refresh.Label", (String[])new String[0]));
            this.goSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    EnterSelectionDialog.this.updateFilter();
                }
            });
            if (this.databasesInterface != null) {
                this.addConnection = new ToolItem(treeTb, 8);
                this.addConnection.setImage(GUIResource.getInstance().getImageAdd());
                this.addConnection.setToolTipText(BaseMessages.getString(PKG, (String)"Add.Datasource.Label", (String[])new String[0]));
                this.addConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        EnterSelectionDialog.this.addDataSource();
                    }
                });
            }
            FormData fd = new FormData();
            fd.right = new FormAttachment(100);
            fd.top = new FormAttachment(0, 0);
            treeTb.setLayoutData((Object)fd);
            Label wlFilter = new Label((Composite)this.shell, 131072);
            this.props.setLook((Control)wlFilter);
            wlFilter.setText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.FilterString.Label", (String[])new String[0]));
            FormData fdlFilter = new FormData();
            fdlFilter.top = new FormAttachment(0, 5);
            fdlFilter.right = new FormAttachment((Control)treeTb, -5);
            wlFilter.setLayoutData((Object)fdlFilter);
            this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    EnterSelectionDialog.this.updateFilter();
                }
            });
            this.wlSelection = new Label((Composite)this.shell, 0);
            this.wlSelection.setText(this.lineText);
            this.props.setLook((Control)this.wlSelection);
            this.fdlSelection = new FormData();
            this.fdlSelection.left = new FormAttachment(0, 0);
            this.fdlSelection.top = new FormAttachment((Control)treeTb, 10);
            this.wlSelection.setLayoutData((Object)this.fdlSelection);
        } else {
            this.wlSelection = new Label((Composite)this.shell, 0);
            this.wlSelection.setText(this.lineText);
            this.props.setLook((Control)this.wlSelection);
            this.fdlSelection = new FormData();
            this.fdlSelection.left = new FormAttachment(0, 0);
            this.wlSelection.setLayoutData((Object)this.fdlSelection);
        }
        int options = 19200;
        options = this.multi ? (options |= 2) : (options |= 4);
        this.wSelection = new List((Composite)this.shell, options);
        for (int i = 0; i < this.choices.length; ++i) {
            this.wSelection.add(this.choices[i]);
        }
        if (this.selectedNrs != null) {
            this.wSelection.select(this.selectedNrs);
            this.wSelection.showSelection();
        }
        if (this.fixed) {
            this.props.setLook((Control)this.wSelection, 1);
        } else {
            this.props.setLook((Control)this.wSelection);
        }
        this.wOK = new Button((Composite)this.shell, 8);
        if (this.viewOnly) {
            this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        } else {
            this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        }
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterSelectionDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        Button[] buttons = new Button[]{this.wOK};
        if (!this.viewOnly) {
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            this.lsCancel = new Listener(){

                public void handleEvent(Event e) {
                    EnterSelectionDialog.this.cancel();
                }
            };
            this.wCancel.addListener(13, this.lsCancel);
            buttons = new Button[]{this.wOK, this.wCancel};
        }
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, buttons, margin, null);
        Button nextControl = this.wOK;
        if (this.constant != null) {
            this.wConstantValue = new TextVar(this.variableSpace, (Composite)this.shell, 18436);
            if (!Utils.isEmpty((CharSequence)this.constant)) {
                this.wConstantValue.setText(this.constant);
            }
            this.props.setLook((Control)this.wConstantValue);
            FormData fdConstantValue = new FormData();
            fdConstantValue.left = new FormAttachment(0, 0);
            fdConstantValue.bottom = new FormAttachment((Control)this.wOK, -10);
            fdConstantValue.right = new FormAttachment(100, 0);
            this.wConstantValue.setLayoutData(fdConstantValue);
            this.wbUseConstant = new Button((Composite)this.shell, 32);
            this.props.setLook((Control)this.wbUseConstant);
            this.wbUseConstant.setText(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.UseConstant.Label", (String[])new String[0]));
            this.wbUseConstant.setSelection(!Utils.isEmpty((CharSequence)this.constant));
            nextControl = this.wbUseConstant;
            FormData fdUseConstant = new FormData();
            fdUseConstant.left = new FormAttachment(0, 0);
            fdUseConstant.bottom = new FormAttachment((Control)this.wConstantValue, -5);
            this.wbUseConstant.setLayoutData((Object)fdUseConstant);
            this.wbUseConstant.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    EnterSelectionDialog.this.setActive();
                }
            });
            this.setActive();
        }
        this.fdSelection = new FormData();
        this.fdSelection.left = new FormAttachment(0, 0);
        this.fdSelection.right = new FormAttachment(100, 0);
        this.fdSelection.top = new FormAttachment((Control)this.wlSelection, 5);
        this.fdSelection.bottom = new FormAttachment((Control)nextControl, -10);
        this.wSelection.setLayoutData((Object)this.fdSelection);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterSelectionDialog.this.ok();
            }
        };
        this.wSelection.addSelectionListener((SelectionListener)this.lsDef);
        this.wSelection.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterSelectionDialog.this.ok();
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterSelectionDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.wOK.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    private void setActive() {
        this.wSelection.setEnabled(!this.wbUseConstant.getSelection());
        this.wConstantValue.setEnabled(this.wbUseConstant.getSelection());
    }

    public String openRepoDialog() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 0x860 | (this.modal ? 0x10010000 : 0) | 0x80 | 0x400);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.wlSelection = new Label((Composite)this.shell, 0);
        this.wlSelection.setText(this.lineText);
        this.props.setLook((Control)this.wlSelection);
        this.fdlSelection = new FormData();
        this.fdlSelection.left = new FormAttachment(0, 10);
        this.fdlSelection.top = new FormAttachment(0, 10);
        this.wlSelection.setLayoutData((Object)this.fdlSelection);
        int options = 19200;
        this.wSelection = new List((Composite)this.shell, options);
        String pentRepo = "";
        boolean found = false;
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i] != null && this.choices[i].startsWith(BaseMessages.getString(PKG, (String)"EnterSelectionDialog.PentahoRepo", (String[])new String[0]))) {
                pentRepo = this.choices[i];
                found = true;
                continue;
            }
            this.wSelection.add(this.choices[i]);
        }
        if (found) {
            this.wSelection.add(pentRepo, 0);
            this.wSelection.select(0);
        }
        int width = Const.isOSX() ? 75 : 70;
        Label separator = new Label((Composite)this.shell, 258);
        FormData fd_separator = new FormData();
        fd_separator.top = new FormAttachment((Control)this.wSelection, 35);
        fd_separator.right = new FormAttachment(100, -10);
        fd_separator.left = new FormAttachment(0, 10);
        separator.setLayoutData((Object)fd_separator);
        Button btnHelp = new Button((Composite)this.shell, 8);
        btnHelp.setImage(GUIResource.getInstance().getImageHelpWeb());
        FormData fd_btnHelp = new FormData();
        fd_btnHelp.top = new FormAttachment((Control)separator, 12);
        fd_btnHelp.left = new FormAttachment(0, 10);
        fd_btnHelp.bottom = new FormAttachment(100, -10);
        fd_btnHelp.width = Const.isOSX() ? 85 : 75;
        btnHelp.setLayoutData((Object)fd_btnHelp);
        btnHelp.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HelpUtils.openHelpDialog(EnterSelectionDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"EnterSelectionDialog.Help.Title", (String[])new String[0]), Const.getDocUrl((String)BaseMessages.getString((Class)PKG, (String)"EnterSelectionDialog.Help", (String[])new String[0])), BaseMessages.getString((Class)PKG, (String)"EnterSelectionDialog.Help.Header", (String[])new String[0]));
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        FormData fd_wCancel = new FormData();
        fd_wCancel.top = new FormAttachment((Control)separator, 12);
        fd_wCancel.right = new FormAttachment(100, -10);
        fd_wCancel.bottom = new FormAttachment(100, -10);
        fd_wCancel.width = width;
        this.wCancel.setLayoutData((Object)fd_wCancel);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]).trim());
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterSelectionDialog.this.cancel();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd_wOK = new FormData();
        fd_wOK.top = new FormAttachment((Control)separator, 12);
        fd_wOK.right = new FormAttachment((Control)this.wCancel, -5);
        fd_wOK.bottom = new FormAttachment(100, -10);
        fd_wOK.width = width;
        this.wOK.setLayoutData((Object)fd_wOK);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterSelectionDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.fdSelection = new FormData();
        this.fdSelection.left = new FormAttachment(0, 10);
        this.fdSelection.right = new FormAttachment(100, -10);
        this.fdSelection.top = new FormAttachment((Control)this.wlSelection, 10);
        this.fdSelection.bottom = new FormAttachment((Control)separator, -12);
        this.wSelection.setLayoutData((Object)this.fdSelection);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterSelectionDialog.this.ok();
            }
        };
        this.wSelection.addSelectionListener((SelectionListener)this.lsDef);
        this.wSelection.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    EnterSelectionDialog.this.ok();
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterSelectionDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.wOK.setFocus();
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
    }

    private void cancel() {
        this.selection = null;
        this.dispose();
    }

    private void ok() {
        if (this.constant != null && this.wbUseConstant.getSelection()) {
            this.selection = this.wConstantValue.getText();
        } else if (this.wSelection.getSelectionCount() > 0) {
            this.selection = this.wSelection.getSelection()[0];
            this.selectionNr = this.wSelection.getSelectionIndices()[0];
            if (this.quickSearch) {
                for (int i = 0; i < this.choices.length; ++i) {
                    if (!this.choices[i].equals(this.selection)) continue;
                    this.selectionNr = i;
                }
            }
            String[] selections = this.wSelection.getSelection();
            boolean found = false;
            this.indices = new int[selections.length];
            block1: for (int i = 0; i < selections.length; ++i) {
                found = false;
                for (int j = 0; j < this.choices.length; ++j) {
                    if (!selections[i].equals(this.choices[j])) continue;
                    this.indices[i] = j;
                    found = true;
                    continue block1;
                }
            }
            if (!found) {
                this.indices = this.wSelection.getSelectionIndices();
            }
        } else {
            this.selection = null;
            this.selectionNr = -1;
            this.indices = new int[0];
        }
        this.dispose();
    }

    public int getSelectionNr(String str) {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    public int getSelectionNr() {
        return this.selectionNr;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public int[] getSelectionIndeces() {
        return this.indices;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int[] getSelectedNrs() {
        return this.selectedNrs;
    }

    public void setSelectedNrs(int[] selectedNrs) {
        this.selectedNrs = selectedNrs;
    }

    protected void updateFilter() {
        this.pattern = null;
        this.filterString = null;
        if (this.searchText != null && !this.searchText.isDisposed() && !Utils.isEmpty((CharSequence)this.searchText.getText())) {
            if (this.wbRegex.getSelection()) {
                this.pattern = Pattern.compile(this.searchText.getText());
            } else {
                this.filterString = this.searchText.getText().toUpperCase();
            }
        }
        this.refresh();
    }

    protected void addDataSource() {
        Spoon theSpoon = Spoon.getInstance();
        SpoonDBDelegate theDelegate = new SpoonDBDelegate(theSpoon);
        theDelegate.newConnection(this.databasesInterface);
        ArrayList theDatabases = new ArrayList();
        theDatabases.addAll(this.databasesInterface.getDatabases());
        String[] theNames = new String[theDatabases.size()];
        for (int i = 0; i < theDatabases.size(); ++i) {
            theNames[i] = ((DatabaseMeta)theDatabases.get(i)).getName();
        }
        this.choices = theNames;
        this.refresh();
    }

    private void refresh() {
        this.wSelection.removeAll();
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.quickSearch) {
                if (this.wbRegex.getSelection()) {
                    if (this.pattern != null) {
                        Matcher matcher = this.pattern.matcher(this.choices[i]);
                        if (!matcher.matches()) continue;
                        this.wSelection.add(this.choices[i]);
                        continue;
                    }
                    this.wSelection.add(this.choices[i]);
                    continue;
                }
                if (this.filterString != null) {
                    if (!this.choices[i].toUpperCase().contains(this.filterString)) continue;
                    this.wSelection.add(this.choices[i]);
                    continue;
                }
                this.wSelection.add(this.choices[i]);
                continue;
            }
            this.wSelection.add(this.choices[i]);
        }
        this.wSelection.redraw();
    }
}

