/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ConfigurationDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;

public class TransExecutionConfigurationDialog
extends ConfigurationDialog {
    private static Class<?> PKG = TransExecutionConfigurationDialog.class;
    private CCombo wRunConfiguration;

    public TransExecutionConfigurationDialog(Shell parent, TransExecutionConfiguration configuration, TransMeta transMeta) {
        super(parent, (ExecutionConfiguration)configuration, (AbstractMeta)transMeta);
    }

    @Override
    protected void serverOptionsComposite(Class<?> PKG, String prefix) {
    }

    @Override
    protected void optionsSectionControls() {
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.top = new FormAttachment(0, 10);
        fdClearLog.left = new FormAttachment(0, 10);
        this.wClearLog.setLayoutData((Object)fdClearLog);
        this.wSafeMode = new Button((Composite)this.gDetails, 32);
        this.wSafeMode.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.SafeMode.Label", (String[])new String[0]));
        this.wSafeMode.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.SafeMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSafeMode);
        FormData fdSafeMode = new FormData();
        fdSafeMode.top = new FormAttachment((Control)this.wClearLog, 7);
        fdSafeMode.left = new FormAttachment(0, 10);
        this.wSafeMode.setLayoutData((Object)fdSafeMode);
        this.wGatherMetrics = new Button((Composite)this.gDetails, 32);
        this.wGatherMetrics.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.GatherMetrics.Label", (String[])new String[0]));
        this.wGatherMetrics.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.GatherMetrics.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGatherMetrics);
        FormData fdGatherMetrics = new FormData();
        fdGatherMetrics.top = new FormAttachment((Control)this.wSafeMode, 7);
        fdGatherMetrics.left = new FormAttachment(0, 10);
        fdGatherMetrics.bottom = new FormAttachment(100, -10);
        this.wGatherMetrics.setLayoutData((Object)fdGatherMetrics);
        this.wlLogLevel = new Label((Composite)this.gDetails, 0);
        this.props.setLook((Control)this.wlLogLevel);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.top = new FormAttachment(0, 10);
        fdlLogLevel.left = new FormAttachment(45, 0);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.top = new FormAttachment((Control)this.wlLogLevel, -2, 128);
        fdLogLevel.width = 180;
        fdLogLevel.left = new FormAttachment((Control)this.wlLogLevel, 6);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
    }

    public boolean open() {
        this.mainLayout(PKG, "TransExecutionConfigurationDialog", GUIResource.getInstance().getImageTransGraph());
        Composite cRunConfiguration = new Composite((Composite)this.shell, 0);
        cRunConfiguration.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)cRunConfiguration);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0, 15);
        fdLocal.right = new FormAttachment(100, -15);
        fdLocal.left = new FormAttachment(0, 15);
        cRunConfiguration.setBackground(this.shell.getBackground());
        cRunConfiguration.setLayoutData((Object)fdLocal);
        Label wlRunConfiguration = new Label(cRunConfiguration, 16384);
        this.props.setLook((Control)wlRunConfiguration);
        wlRunConfiguration.setText("Run configuration:");
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.top = new FormAttachment(0);
        fdlRunConfiguration.left = new FormAttachment(0);
        wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new CCombo(cRunConfiguration, 2048);
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.width = 200;
        fdRunConfiguration.top = new FormAttachment((Control)wlRunConfiguration, 5);
        fdRunConfiguration.left = new FormAttachment(0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        this.optionsSectionLayout(PKG, "TransExecutionConfigurationDialog");
        this.parametersSectionLayout(PKG, "TransExecutionConfigurationDialog");
        this.fdDetails.top = new FormAttachment((Control)cRunConfiguration, 15);
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(Spoon.class, (String)"Spoon.TransExecutionConfigurationDialog.Help", (String[])new String[0]));
        String docTitle = BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.docTitle", (String[])new String[0]);
        String docHeader = BaseMessages.getString(PKG, (String)"TransExecutionConfigurationDialog.docHeader", (String[])new String[0]);
        this.buttonsSectionLayout(PKG, "TransExecutionConfigurationDialog", docTitle, docUrl, docHeader);
        this.getData();
        this.openDialog();
        return this.retval;
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariables().keySet());
        Collections.sort(variableNames);
        for (int i = 0; i < variableNames.size(); ++i) {
            String variableName = (String)variableNames.get(i);
            String variableValue = (String)this.configuration.getVariables().get(variableName);
            if (Const.indexOfString((String)variableName, (String[])this.abstractMeta.listParameters()) >= 0) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    public void getData() {
        this.wSafeMode.setSelection(this.configuration.isSafeModeEnabled());
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        this.wGatherMetrics.setSelection(this.configuration.isGatheringMetrics());
        ArrayList runConfigurations = new ArrayList();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)Spoon.getInstance().getLog(), (String)KettleExtensionPoint.SpoonRunConfiguration.id, runConfigurations);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
        if (!runConfigurations.contains(this.getConfiguration().getRunConfiguration())) {
            this.getConfiguration().setRunConfiguration(null);
        }
        if (Utils.isEmpty((CharSequence)this.getConfiguration().getRunConfiguration())) {
            this.wRunConfiguration.select(0);
        } else {
            this.wRunConfiguration.setText(this.getConfiguration().getRunConfiguration());
        }
        this.wLogLevel.select(this.configuration.getLogLevel().getLevel());
        this.getParamsData();
        this.getVariablesData();
    }

    @Override
    public void getInfo() {
        try {
            this.configuration.setReplayDate(null);
            this.getConfiguration().setRunConfiguration(this.wRunConfiguration.getText());
            this.configuration.setSafeModeEnabled(this.wSafeMode.getSelection());
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            this.configuration.setGatheringMetrics(this.wGatherMetrics.getSelection());
            this.getInfoParameters();
            this.getInfoVariables();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error in settings", "There is an error in the dialog settings", e);
        }
    }

    public TransExecutionConfiguration getConfiguration() {
        return (TransExecutionConfiguration)this.configuration;
    }
}

