/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.osgi.objecttunnel.TunnelSerializer;

abstract class BaseSerializer<T extends PDIEvent>
implements TunnelSerializer<T> {
    ObjectMapper mapper = new ObjectMapper();
    private Class<T> tClass;

    public BaseSerializer(Class<T> tClass) {
        this.tClass = tClass;
    }

    public List<Class> getSupportedClasses() {
        return Collections.singletonList(this.tClass);
    }

    public String serialize(Object object) {
        try {
            return this.mapper.writer().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public T deserialize(String serializedString) {
        try {
            return (T)((PDIEvent)this.mapper.readValue(serializedString, this.tClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

