/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.logging.Logger;
import mondrian.olap.MondrianDef;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.w3c.dom.Document;

@MetaStoreElementType(name="UpdateCalculatedMember", description="UpdateCalculatedMember Annotation")
public class UpdateCalculatedMember
extends AnnotationType {
    private static final long serialVersionUID = 5169827225345800226L;
    private static transient Logger logger = Logger.getLogger(AnnotationType.class.getName());
    private static final String NAME_ID = "name";
    private static final String NAME_NAME = "Name";
    private static final int NAME_ORDER = 0;
    private static final String CAPTION_ID = "caption";
    private static final String CAPTION_NAME = "Caption";
    private static final int CAPTION_ORDER = 0;
    private static final String DESCRIPTION_ID = "description";
    private static final String DESCRIPTION_NAME = "Description";
    private static final int DESCRIPTION_ORDER = 0;
    private static final String FORMULA_ID = "formula";
    private static final String FORMULA_NAME = "Formula";
    private static final int FORMULA_ORDER = 0;
    private static final String DIMENSION_ID = "dimension";
    private static final String DIMENSION_NAME = "Dimension";
    private static final int DIMENSION_ORDER = 0;
    private static final String HIDDEN_ID = "hidden";
    private static final String HIDDEN_NAME = "Hidden";
    private static final int HIDDEN_ORDER = 0;
    private static final String INLINE_ID = "inline";
    private static final String INLINE_NAME = "Inline";
    private static final int INLINE_ORDER = 0;
    public static final String FORMAT_STRING_ID = "formatString";
    public static final String FORMAT_STRING_NAME = "Format String";
    public static final int FORMAT_STRING_ORDER = 1;
    public static final String FORMAT_CATEGORY_ID = "formatCategory";
    public static final String FORMAT_CATEGORY_NAME = "Format Category";
    public static final int FORMAT_CATEGORY_ORDER = 2;
    public static final String DECIMAL_PLACES_ID = "decimalPlaces";
    public static final String DECIMAL_PLACES_NAME = "Decimal Places";
    public static final int DECIMAL_PLACES_ORDER = 3;
    public static final String MEASURE_CONTENT_ID = "measureContent";
    public static final String MEASURE_CONTENT_NAME = "Measure Content";
    public static final int MEASURE_CONTENT_ORDER = 4;
    public static final String CALCULATE_SUBTOTALS_ID = "calculateSubtotals";
    public static final String CALCULATE_SUBTOTALS_NAME = "Calculate Subtotals";
    public static final int CALCULATE_SUBTOTALS_ORDER = 5;
    public static final String CATALOG_NAME_ID = "catalogName";
    public static final String CATALOG_NAME_NAME = "Catalog Name";
    public static final int CATALOG_NAME_ORDER = 6;
    private static final String CUBE_ID = "cube";
    private static final String CUBE_NAME = "Cube";
    private static final int CUBE_ORDER = 7;
    private static final String CALCULATED_MEASURE_ID = "calculatedMeasure";
    private static final String CALCULATED_MEASURE_NAME = "CalculatedMeasure";
    private static final int CALCULATED_MEASURE_ORDER = 8;
    public static final String CALCULATED_MEMBER_NODE_NAME = "CalculatedMember";
    public static final String CALCULATED_MEMBER_NAME_ATTRIB = "name";
    public static final String CALCULATED_MEMBER_COLUMN_ATTRIB = "column";
    public static final String CALCULATED_MEMBER_AGGREGATOR_ATTRIB = "aggregator";
    public static final String CUBE_XPATH_EXPR = "/Schema/Cube";
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Name", order=0)
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="caption", name="Caption", order=0)
    private String caption;
    @MetaStoreAttribute
    @ModelProperty(id="description", name="Description", order=0)
    private String description;
    @MetaStoreAttribute
    @ModelProperty(id="formula", name="Formula", order=0)
    private String formula;
    @MetaStoreAttribute
    @ModelProperty(id="dimension", name="Dimension", order=0)
    private String dimension;
    @MetaStoreAttribute
    @ModelProperty(id="hidden", name="Hidden", order=0)
    private boolean hidden = false;
    @MetaStoreAttribute
    @ModelProperty(id="inline", name="Inline", order=0)
    private boolean inline;
    @MetaStoreAttribute
    @ModelProperty(id="formatString", name="Format String", order=1)
    private String formatString;
    @MetaStoreAttribute
    @ModelProperty(id="formatCategory", name="Format Category", order=2)
    private String formatCategory;
    @MetaStoreAttribute
    @ModelProperty(id="decimalPlaces", name="Decimal Places", order=3)
    private int decimalPlaces;
    @MetaStoreAttribute
    @ModelProperty(id="measureContent", name="Measure Content", order=4)
    private String measureContent;
    @MetaStoreAttribute
    @ModelProperty(id="calculateSubtotals", name="Calculate Subtotals", order=5)
    private boolean calculateSubtotals;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube", order=7)
    private String cube;
    @MetaStoreAttribute
    @ModelProperty(id="calculatedMeasure", name="CalculatedMeasure", order=8)
    private String sourceCalculatedMeasure;
    private transient boolean pdiContext;

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        if (schema == null) {
            return false;
        }
        MondrianSchemaHandler mondrianSchemaHandler = new MondrianSchemaHandler(schema);
        MondrianDef.CalculatedMember calculatedMember = new MondrianDef.CalculatedMember();
        calculatedMember.name = this.getName();
        calculatedMember.caption = this.getCaption();
        calculatedMember.description = this.getDescription();
        calculatedMember.dimension = this.getDimension();
        calculatedMember.formula = this.getFormula();
        calculatedMember.visible = !this.isHidden();
        MondrianDef.CalculatedMemberProperty solveOrder = new MondrianDef.CalculatedMemberProperty();
        solveOrder.name = "SOLVE_ORDER";
        solveOrder.value = this.isCalculateSubtotals() ? "200" : "0";
        calculatedMember.memberProperties = new MondrianDef.CalculatedMemberProperty[]{solveOrder};
        MondrianDef.Annotation inline = new MondrianDef.Annotation();
        inline.name = "InlineCreatedInline";
        inline.cdata = this.isInline() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        MondrianDef.Annotation formatScaleAnnotation = new MondrianDef.Annotation();
        formatScaleAnnotation.name = "InlineFormatScale";
        formatScaleAnnotation.cdata = String.valueOf(this.getDecimalPlaces());
        MondrianDef.Annotation formatCategoryAnnotation = new MondrianDef.Annotation();
        formatCategoryAnnotation.name = "InlineFormatCategory";
        formatCategoryAnnotation.cdata = this.getFormatCategory();
        MondrianDef.Annotation formulaExpressionAnnotation = new MondrianDef.Annotation();
        formulaExpressionAnnotation.name = "InlineFormulaExpression";
        formulaExpressionAnnotation.cdata = this.getFormula();
        MondrianDef.Annotation calcSubtotalsAnnotation = new MondrianDef.Annotation();
        calcSubtotalsAnnotation.name = "InlineCalcSubtotals";
        calcSubtotalsAnnotation.cdata = this.isCalculateSubtotals() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        MondrianDef.Annotations annot = new MondrianDef.Annotations();
        annot.array = new MondrianDef.Annotation[]{inline, formatScaleAnnotation, formatCategoryAnnotation, formulaExpressionAnnotation, calcSubtotalsAnnotation};
        calculatedMember.annotations = annot;
        calculatedMember.formatString = this.getFormatString();
        mondrianSchemaHandler.updateCalculatedMember(this.cube, this.sourceCalculatedMeasure, calculatedMember);
        return true;
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getName())) {
            if (this.pdiContext) {
                throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.MEASURE_NAME_REQUIRED", (String[])new String[0]));
            }
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.CATALOG_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getFormula())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.FORMULA_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getCube())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.CUBE_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getSourceCalculatedMeasure())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.SOURCE_CALC_MEASURE_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getFormatString())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.UpdateCalculatedMember.validation.FORMAT_STRING_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.UPDATE_CALCULATED_MEMBER;
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.UpdateCalculatedMember.Summary", (String[])new String[]{this.getName(), this.getFormula()});
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public void setMeasureContent(String measureContent) {
        this.measureContent = measureContent;
    }

    public String getMeasureContent() {
        return this.measureContent;
    }

    public boolean isCalculateSubtotals() {
        return this.calculateSubtotals;
    }

    public void setCalculateSubtotals(boolean calculateSubtotals) {
        this.calculateSubtotals = calculateSubtotals;
    }

    @Override
    public String getField() {
        return null;
    }

    public boolean isPdiContext() {
        return this.pdiContext;
    }

    public void setPdiContext(boolean pdiContext) {
        this.pdiContext = pdiContext;
    }

    public String getFormatCategory() {
        return this.formatCategory;
    }

    public void setFormatCategory(String formatCategory) {
        this.formatCategory = formatCategory;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public String getSourceCalculatedMeasure() {
        return this.sourceCalculatedMeasure;
    }

    public void setSourceCalculatedMeasure(String sourceCalculatedMeasure) {
        this.sourceCalculatedMeasure = sourceCalculatedMeasure;
    }
}

