/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.agilebi.modeler.nodes.AbstractAvailableItem;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;

public class AvailableTable
extends AbstractAvailableItem<AvailableField>
implements IAvailableItem {
    private static final String FACT_TABLE_IMAGE = "images/table_fact.png";
    private static final String DIM_TABLE_IMAGE = "images/table.png";
    private static final String FACT_TABLE_CLASSNAME = "icon-fact-table";
    private static final String DIM_TABLE_CLASSNAME = "icon-table";
    private static final long serialVersionUID = -6428366981250876565L;
    private List<AvailableField> availableFields;
    protected transient IPhysicalTable physicalTable;
    private boolean factTable = false;
    private Comparator<IAvailableItem> itemComparator = new Comparator<IAvailableItem>(){

        @Override
        public int compare(IAvailableItem arg0, IAvailableItem arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    };

    public AvailableTable() {
        this.availableFields = new ArrayList<AvailableField>();
        this.setImage(DIM_TABLE_IMAGE);
        this.setClassname(DIM_TABLE_CLASSNAME);
    }

    public AvailableTable(IPhysicalTable physicalTable) {
        this(physicalTable, false);
    }

    public AvailableTable(IPhysicalTable physicalTable, boolean isFactTable) {
        this.setPhysicalTable(physicalTable);
        this.setFactTable(isFactTable);
        this.setImage(isFactTable ? FACT_TABLE_IMAGE : DIM_TABLE_IMAGE);
        this.setClassname(isFactTable ? FACT_TABLE_CLASSNAME : DIM_TABLE_CLASSNAME);
    }

    protected void populateAvailableFields() {
        if (this.physicalTable != null) {
            for (IPhysicalColumn column : this.physicalTable.getPhysicalColumns()) {
                AvailableField field = new AvailableField(column);
                this.availableFields.add(field);
            }
        }
        Collections.sort(this.availableFields, this.itemComparator);
    }

    public List<AvailableField> getAvailableFields() {
        return this.availableFields;
    }

    public void setAvailableFields(List<AvailableField> availableFields) {
        this.availableFields = availableFields;
        Collections.sort(this.availableFields, this.itemComparator);
    }

    public IPhysicalTable getPhysicalTable() {
        return this.physicalTable;
    }

    public void setPhysicalTable(IPhysicalTable physicalTable) {
        this.physicalTable = physicalTable;
        this.setName(physicalTable.getName("en_US"));
        this.availableFields = new ArrayList<AvailableField>();
        this.populateAvailableFields();
    }

    public boolean isSameUnderlyingPhysicalTable(IPhysicalTable table) {
        return this.getPhysicalTable().getId().equals(table.getId());
    }

    public boolean containsUnderlyingPhysicalColumn(IPhysicalColumn column) {
        for (AvailableField field : this.availableFields) {
            if (!field.isSameUnderlyingPhysicalColumn(column)) continue;
            return true;
        }
        return false;
    }

    public AvailableField findFieldByPhysicalColumn(IPhysicalColumn column) {
        for (AvailableField field : this.availableFields) {
            if (!field.isSameUnderlyingPhysicalColumn(column)) continue;
            return field;
        }
        return null;
    }

    public boolean isFactTable() {
        return this.factTable;
    }

    public void setFactTable(boolean factTable) {
        this.factTable = factTable;
    }

    @Bindable
    public List<AvailableField> getChildren() {
        return this.getAvailableFields();
    }
}

