/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.DownloadManagers;
import org.apache.karaf.features.internal.region.DigraphHelper;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.EventAdminListener;
import org.apache.karaf.features.internal.service.FeatureConfigInstaller;
import org.apache.karaf.features.internal.service.FeatureFinder;
import org.apache.karaf.features.internal.service.Overrides;
import org.apache.karaf.features.internal.service.RepositoryImpl;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.service.StateStorage;
import org.apache.karaf.features.internal.util.JsonReader;
import org.apache.karaf.features.internal.util.JsonWriter;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.util.bundles.BundleUtils;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesServiceImpl
implements FeaturesService,
Deployer.DeployCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final String FEATURE_OSGI_REQUIREMENT_PREFIX = "feature:";
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private final BundleContext systemBundleContext;
    private final StateStorage storage;
    private final FeatureFinder featureFinder;
    private final EventAdminListener eventAdminListener;
    private final ConfigurationAdmin configurationAdmin;
    private final Resolver resolver;
    private final FeatureConfigInstaller configInstaller;
    private final RegionDigraph digraph;
    private final String overrides;
    private final String featureResolutionRange;
    private final String bundleUpdateRange;
    private final String updateSnaphots;
    private final String serviceRequirements;
    private final int downloadThreads;
    private final long scheduleDelay;
    private final int scheduleMaxRun;
    private final String blacklisted;
    private final boolean configCfgStore;
    private final ThreadLocal<String> outputFile = new ThreadLocal();
    private final org.osgi.service.repository.Repository globalRepository;
    private final List<FeaturesListener> listeners = new CopyOnWriteArrayIdentityList<FeaturesListener>();
    private final Object lock = new Object();
    private final State state = new State();
    private final Map<String, Repository> repositoryCache = new HashMap<String, Repository>();
    private final ExecutorService executor;
    private Map<String, Map<String, Feature>> featureCache;

    public FeaturesServiceImpl(Bundle bundle, BundleContext bundleContext, BundleContext systemBundleContext, StateStorage storage, FeatureFinder featureFinder, EventAdminListener eventAdminListener, ConfigurationAdmin configurationAdmin, Resolver resolver, RegionDigraph digraph, String overrides, String featureResolutionRange, String bundleUpdateRange, String updateSnaphots, String serviceRequirements, org.osgi.service.repository.Repository globalRepository, int downloadThreads, long scheduleDelay, int scheduleMaxRun, String blacklisted) {
        this.bundle = bundle;
        this.bundleContext = bundleContext;
        this.systemBundleContext = systemBundleContext;
        this.storage = storage;
        this.featureFinder = featureFinder;
        this.eventAdminListener = eventAdminListener;
        this.configurationAdmin = configurationAdmin;
        this.resolver = resolver;
        this.configInstaller = configurationAdmin != null ? new FeatureConfigInstaller(configurationAdmin, true) : null;
        this.digraph = digraph;
        this.overrides = overrides;
        this.featureResolutionRange = featureResolutionRange;
        this.bundleUpdateRange = bundleUpdateRange;
        this.updateSnaphots = updateSnaphots;
        this.serviceRequirements = serviceRequirements;
        this.globalRepository = globalRepository;
        this.downloadThreads = downloadThreads > 0 ? downloadThreads : 1;
        this.scheduleDelay = scheduleDelay;
        this.scheduleMaxRun = scheduleMaxRun;
        this.blacklisted = blacklisted;
        this.configCfgStore = true;
        this.executor = Executors.newSingleThreadExecutor();
        this.loadState();
        this.checkResolve();
    }

    public FeaturesServiceImpl(Bundle bundle, BundleContext bundleContext, BundleContext systemBundleContext, StateStorage storage, FeatureFinder featureFinder, EventAdminListener eventAdminListener, ConfigurationAdmin configurationAdmin, Resolver resolver, RegionDigraph digraph, String overrides, String featureResolutionRange, String bundleUpdateRange, String updateSnaphots, String serviceRequirements, org.osgi.service.repository.Repository globalRepository, int downloadThreads, long scheduleDelay, int scheduleMaxRun, String blacklisted, boolean configCfgStore) {
        this.bundle = bundle;
        this.bundleContext = bundleContext;
        this.systemBundleContext = systemBundleContext;
        this.storage = storage;
        this.featureFinder = featureFinder;
        this.eventAdminListener = eventAdminListener;
        this.configurationAdmin = configurationAdmin;
        this.resolver = resolver;
        this.configInstaller = configurationAdmin != null ? new FeatureConfigInstaller(configurationAdmin, configCfgStore) : null;
        this.digraph = digraph;
        this.overrides = overrides;
        this.featureResolutionRange = featureResolutionRange;
        this.bundleUpdateRange = bundleUpdateRange;
        this.updateSnaphots = updateSnaphots;
        this.serviceRequirements = serviceRequirements;
        this.globalRepository = globalRepository;
        this.downloadThreads = downloadThreads > 0 ? downloadThreads : 1;
        this.scheduleDelay = scheduleDelay;
        this.scheduleMaxRun = scheduleMaxRun;
        this.blacklisted = blacklisted;
        this.configCfgStore = configCfgStore;
        this.executor = Executors.newSingleThreadExecutor();
        this.loadState();
        this.checkResolve();
    }

    public void stop() {
        this.executor.shutdown();
    }

    private void checkResolve() {
        Map request;
        if (this.bundleContext == null) {
            return;
        }
        File resolveFile = this.bundleContext.getDataFile("resolve");
        if (!resolveFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(resolveFile);){
            request = (Map)JsonReader.read(fis);
        }
        catch (IOException e) {
            LOGGER.warn("Error reading resolution request", (Throwable)e);
            return;
        }
        Map<String, Set<String>> requestedFeatures = StateStorage.toStringStringSetMap((Map)request.get("features"));
        Collection opts = (Collection)request.get("options");
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        for (String opt : opts) {
            options.add(FeaturesService.Option.valueOf(opt));
        }
        try {
            Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
            this.doProvisionInThread(requestedFeatures, stateChanges, this.copyState(), options);
        }
        catch (Exception e) {
            LOGGER.warn("Error updating state", (Throwable)e);
        }
    }

    private void writeResolve(Map<String, Set<String>> requestedFeatures, EnumSet<FeaturesService.Option> options) throws IOException {
        File resolveFile = this.bundleContext.getDataFile("resolve");
        HashMap<String, Object> request = new HashMap<String, Object>();
        ArrayList<String> opts = new ArrayList<String>();
        for (FeaturesService.Option opt : options) {
            opts.add(opt.toString());
        }
        request.put("features", requestedFeatures);
        request.put("options", opts);
        try (FileOutputStream fos = new FileOutputStream(resolveFile);){
            JsonWriter.write(fos, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.storage.load(this.state);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error loading FeaturesService state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!"crc".equalsIgnoreCase(this.updateSnaphots)) {
                    this.state.bundleChecksums.clear();
                }
                this.storage.save(this.state);
                if (this.bundleContext != null) {
                    DigraphHelper.saveDigraph(this.bundleContext, this.digraph);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error saving FeaturesService state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBootDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.bootDone.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bootDone() {
        Object object = this.lock;
        synchronized (object) {
            this.state.bootDone.set(true);
            this.saveState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(FeaturesListener listener) {
        this.listeners.add(listener);
        try {
            TreeSet<String> repositories = new TreeSet<String>();
            TreeMap<String, Set<String>> installedFeatures = new TreeMap<String, Set<String>>();
            Iterator<Object> iterator = this.lock;
            synchronized (iterator) {
                repositories.addAll(this.state.repositories);
                installedFeatures.putAll(MapUtils.copy(this.state.installedFeatures));
            }
            for (String string : repositories) {
                RepositoryImpl repository = new RepositoryImpl(URI.create(string), this.blacklisted);
                listener.repositoryEvent(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, true));
            }
            for (Map.Entry entry : installedFeatures.entrySet()) {
                for (String id : (Set)entry.getValue()) {
                    Feature feature = org.apache.karaf.features.internal.model.Feature.valueOf(id);
                    listener.featureEvent(new FeatureEvent(FeatureEvent.EventType.FeatureInstalled, feature, (String)entry.getKey(), true));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error notifying listener about the current state", (Throwable)e);
        }
    }

    @Override
    public void unregisterListener(FeaturesListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void callListeners(FeatureEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.featureEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.featureEvent(event);
        }
    }

    protected void callListeners(RepositoryEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.repositoryEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.repositoryEvent(event);
        }
    }

    @Override
    public URI getRepositoryUriFor(String name, String version) {
        return this.featureFinder.getUriFor(name, version);
    }

    @Override
    public String[] getRepositoryNames() {
        return this.featureFinder.getNames();
    }

    public Repository loadRepository(URI uri) throws Exception {
        RepositoryImpl repo = new RepositoryImpl(uri, this.blacklisted);
        repo.load(true);
        return repo;
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.addRepository(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(URI uri, boolean install) throws Exception {
        Repository repository = this.loadRepository(uri);
        Object object = this.lock;
        synchronized (object) {
            this.repositoryCache.put(uri.toString(), repository);
            this.featureCache = null;
            if (!this.state.repositories.add(uri.toString())) {
                return;
            }
            this.saveState();
        }
        this.callListeners(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, false));
        if (install) {
            HashSet<String> features = new HashSet<String>();
            for (Feature feature : repository.getFeatures()) {
                features.add(feature.getName() + "/" + feature.getVersion());
            }
            this.installFeatures(features, EnumSet.noneOf(FeaturesService.Option.class));
        }
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.removeRepository(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRepository(URI uri, boolean uninstall) throws Exception {
        Repository repo;
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.repositories.remove(uri.toString())) {
                return;
            }
            this.featureCache = null;
            repo = this.repositoryCache.get(uri.toString());
            ArrayList<String> toRemove = new ArrayList<String>();
            toRemove.add(uri.toString());
            while (!toRemove.isEmpty()) {
                Repository rep = this.repositoryCache.remove(toRemove.remove(0));
                if (rep == null) continue;
                for (URI u : rep.getRepositories()) {
                    toRemove.add(u.toString());
                }
            }
            this.saveState();
        }
        if (repo == null) {
            repo = new RepositoryImpl(uri, this.blacklisted);
        }
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryRemoved, false));
        if (uninstall) {
            HashSet<String> features = new HashSet<String>();
            for (Feature feature : repo.getFeatures()) {
                features.add(feature.getName() + "/" + feature.getVersion());
            }
            this.uninstallFeatures(features, EnumSet.noneOf(FeaturesService.Option.class));
        }
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRepository(URI uri) throws Exception {
        this.removeRepository(uri, false);
        this.addRepository(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository[] listRepositories() throws Exception {
        this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            return this.repositoryCache.values().toArray(new Repository[this.repositoryCache.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository[] listRequiredRepositories() throws Exception {
        this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Repository> repos = new ArrayList<Repository>();
            for (Map.Entry<String, Repository> entry : this.repositoryCache.entrySet()) {
                if (!this.state.repositories.contains(entry.getKey())) continue;
                repos.add(entry.getValue());
            }
            return repos.toArray(new Repository[repos.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(String name) throws Exception {
        this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            for (Repository repo : this.repositoryCache.values()) {
                if (!name.equals(repo.getName())) continue;
                return repo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(URI uri) throws Exception {
        this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            for (Repository repo : this.repositoryCache.values()) {
                if (!repo.getURI().equals(uri)) continue;
                return repo;
            }
            return null;
        }
    }

    @Override
    public String getRepositoryName(URI uri) throws Exception {
        Repository repo = this.getRepository(uri);
        return repo != null ? repo.getName() : null;
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        Feature[] features = this.getFeatures(name);
        if (features.length < 1) {
            return null;
        }
        return features[0];
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature[] features = this.getFeatures(name, version);
        if (features.length < 1) {
            return null;
        }
        return features[0];
    }

    @Override
    public Feature[] getFeatures(String nameOrId) throws Exception {
        String[] parts = nameOrId.split("/");
        String name = parts.length > 0 ? parts[0] : nameOrId;
        String version = parts.length > 1 ? parts[1] : null;
        return this.getFeatures(name, version);
    }

    @Override
    public Feature[] getFeatures(String name, String version) throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Pattern pattern = Pattern.compile(name);
        for (String featureName : this.getFeatures().keySet()) {
            Map<String, Feature> versions;
            Feature matchingFeature;
            Matcher matcher = pattern.matcher(featureName);
            if (!matcher.matches() || (matchingFeature = this.getFeatureMatching(versions = this.getFeatures().get(featureName), version)) == null) continue;
            features.add(matchingFeature);
        }
        return features.toArray(new Feature[features.size()]);
    }

    protected Feature getFeatureMatching(Map<String, Feature> versions, String version) {
        Feature feature;
        if (version != null) {
            if ((version = version.trim()).equals("0.0.0")) {
                version = "";
            }
        } else {
            version = "";
        }
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        Feature feature2 = feature = version.isEmpty() ? null : versions.get(version);
        if (feature == null) {
            VersionRange versionRange = version.isEmpty() ? new VersionRange(Version.emptyVersion) : new VersionRange(version, true, true);
            Version latest = Version.emptyVersion;
            for (String available : versions.keySet()) {
                Version availableVersion = VersionTable.getVersion(available);
                if (availableVersion.compareTo(latest) < 0 || !versionRange.contains(availableVersion)) continue;
                feature = versions.get(available);
                latest = availableVersion;
            }
        }
        return feature;
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Map<String, Feature> featureWithDifferentVersion : this.getFeatures().values()) {
            for (Feature f : featureWithDifferentVersion.values()) {
                features.add(f);
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        ArrayList<Repository> repos;
        ArrayList<String> uris;
        Object object = this.lock;
        synchronized (object) {
            if (this.featureCache != null) {
                return this.featureCache;
            }
            uris = new ArrayList<String>(this.state.repositories);
        }
        HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
        ArrayList<String> toLoad = new ArrayList<String>(uris);
        while (!toLoad.isEmpty()) {
            Object repo;
            String uri = (String)toLoad.remove(0);
            Object object2 = this.lock;
            synchronized (object2) {
                repo = this.repositoryCache.get(uri);
            }
            try {
                if (repo == null) {
                    RepositoryImpl rep = new RepositoryImpl(URI.create(uri), this.blacklisted);
                    rep.load();
                    repo = rep;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.repositoryCache.put(uri, (Repository)repo);
                    }
                }
                for (URI u : repo.getRepositories()) {
                    toLoad.add(u.toString());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't load features repository {}", (Object)uri, (Object)e);
            }
        }
        Object object4 = this.lock;
        synchronized (object4) {
            repos = new ArrayList<Repository>(this.repositoryCache.values());
        }
        for (Repository repo : repos) {
            for (Feature f : repo.getFeatures()) {
                if (map.get(f.getName()) == null) {
                    HashMap<String, Feature> versionMap = new HashMap<String, Feature>();
                    versionMap.put(f.getVersion(), f);
                    map.put(f.getName(), versionMap);
                    continue;
                }
                ((Map)map.get(f.getName())).put(f.getVersion(), f);
            }
        }
        object4 = this.lock;
        synchronized (object4) {
            if (uris.size() == this.state.repositories.size() && this.state.repositories.containsAll(uris)) {
                this.featureCache = map;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] listInstalledFeatures() throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        Map<String, Map<String, Feature>> allFeatures = this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            for (Map<String, Feature> featureWithDifferentVersion : allFeatures.values()) {
                for (Feature f : featureWithDifferentVersion.values()) {
                    if (!this.isInstalled(f)) continue;
                    features.add(f);
                }
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] listRequiredFeatures() throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        Map<String, Map<String, Feature>> allFeatures = this.getFeatures();
        Object object = this.lock;
        synchronized (object) {
            for (Map<String, Feature> featureWithDifferentVersion : allFeatures.values()) {
                for (Feature f : featureWithDifferentVersion.values()) {
                    if (!this.isRequired(f)) continue;
                    features.add(f);
                }
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstalled(Feature f) {
        String id = this.normalize(f.getId());
        Object object = this.lock;
        synchronized (object) {
            Set<String> installed = this.state.installedFeatures.get("root");
            return installed != null && installed.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureState getState(String featureId) {
        String id = this.normalize(featureId);
        Object object = this.lock;
        synchronized (object) {
            Set<String> installed = this.state.installedFeatures.get("root");
            if (!installed.contains(id)) {
                return FeatureState.Uninstalled;
            }
            String stateSt = this.state.stateFeatures.get("root").get(id);
            return FeatureState.valueOf(stateSt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequired(Feature f) {
        String id = FEATURE_OSGI_REQUIREMENT_PREFIX + f.getName() + "/" + new VersionRange(f.getVersion(), true);
        Object object = this.lock;
        synchronized (object) {
            Set<String> features = this.state.requirements.get("root");
            return features != null && features.contains(id);
        }
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.installFeature(version != null ? name + "/" + version : name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(Collections.singleton(name), options);
    }

    @Override
    public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(version != null ? name + "/" + version : name, options);
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(feature.getId(), options);
    }

    @Override
    public void installFeatures(Set<String> features, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(features, "root", options);
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        this.uninstallFeature(version != null ? name + "/" + version : name);
    }

    @Override
    public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeature(version != null ? name + "/" + version : name, options);
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        this.uninstallFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeatures(Collections.singleton(name), options);
    }

    @Override
    public void uninstallFeatures(Set<String> features, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeatures(features, "root", options);
    }

    @Override
    public void setResolutionOutputFile(String outputFile) {
        this.outputFile.set(outputFile);
    }

    @Override
    public void installFeatures(Set<String> features, String region, EnumSet<FeaturesService.Option> options) throws Exception {
        Set<String> fl;
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        if (region == null || region.isEmpty()) {
            region = "root";
        }
        if ((fl = required.get(region)) == null) {
            fl = new HashSet<String>();
            required.put(region, fl);
        }
        ArrayList<String> featuresToAdd = new ArrayList<String>();
        ArrayList<String> featuresToRemove = new ArrayList<String>();
        for (String feature : features) {
            feature = this.normalize(feature);
            String name = feature.substring(0, feature.indexOf("/"));
            String version = feature.substring(feature.indexOf("/") + 1);
            Pattern pattern = Pattern.compile(name);
            boolean matched = false;
            for (String fKey : this.getFeatures().keySet()) {
                Feature f;
                Matcher matcher = pattern.matcher(fKey);
                if (!matcher.matches() || (f = this.getFeatureMatching(this.getFeatures().get(fKey), version)) == null) continue;
                String req = f.getName() + "/" + new VersionRange(f.getVersion(), true);
                featuresToAdd.add(req);
                Feature[] installedFeatures = this.listInstalledFeatures();
                for (int i = 0; i < installedFeatures.length; ++i) {
                    if (!installedFeatures[i].getName().equals(f.getName()) || !installedFeatures[i].getVersion().equals(f.getVersion())) continue;
                    LOGGER.info("The specified feature: '{}' version '{}' {}", new Object[]{f.getName(), f.getVersion(), f.getVersion().endsWith("SNAPSHOT") ? "has been upgraded" : "is already installed"});
                }
                matched = true;
            }
            if (!matched && !options.contains((Object)FeaturesService.Option.NoFailOnFeatureNotFound)) {
                throw new IllegalArgumentException("No matching features for " + feature);
            }
            if (!options.contains((Object)FeaturesService.Option.Upgrade)) continue;
            for (String existentFeatureReq : fl) {
                String existentFeature = existentFeatureReq.substring(FEATURE_OSGI_REQUIREMENT_PREFIX.length());
                if (!existentFeature.startsWith(name + "/") || featuresToAdd.contains(existentFeature)) continue;
                featuresToRemove.add(existentFeature);
            }
        }
        if (!featuresToRemove.isEmpty()) {
            this.print("Removing features: " + this.join(featuresToRemove), options.contains((Object)FeaturesService.Option.Verbose));
            for (String featureReq : featuresToRemove) {
                fl.remove(FEATURE_OSGI_REQUIREMENT_PREFIX + featureReq);
            }
        }
        featuresToAdd = new ArrayList(new LinkedHashSet(featuresToAdd));
        this.print("Adding features: " + this.join(featuresToAdd), options.contains((Object)FeaturesService.Option.Verbose));
        for (String feature : featuresToAdd) {
            fl.add(FEATURE_OSGI_REQUIREMENT_PREFIX + feature);
        }
        Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
        this.doProvisionInThread(required, stateChanges, state, options);
    }

    @Override
    public void uninstallFeatures(Set<String> features, String region, EnumSet<FeaturesService.Option> options) throws Exception {
        Set<String> fl;
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        if (region == null || region.isEmpty()) {
            region = "root";
        }
        if ((fl = required.get(region)) == null) {
            fl = new HashSet<String>();
            required.put(region, fl);
        }
        ArrayList<String> featuresToRemove = new ArrayList<String>();
        for (String feature : new HashSet<String>(features)) {
            ArrayList<String> toRemove = new ArrayList<String>();
            if ((feature = this.normalize(feature)).endsWith("/0.0.0")) {
                String nameSep = FEATURE_OSGI_REQUIREMENT_PREFIX + feature.substring(0, feature.indexOf("/") + 1);
                for (String f : fl) {
                    Pattern pattern = Pattern.compile(nameSep.substring(0, nameSep.length() - 1));
                    Matcher matcher = pattern.matcher(f);
                    if (!matcher.matches() && !this.normalize(f).startsWith(nameSep)) continue;
                    toRemove.add(f);
                }
            } else {
                String name = feature.substring(0, feature.indexOf("/"));
                String version = feature.substring(feature.indexOf("/") + 1);
                Pattern pattern = this.getFeaturePattern(name, version);
                for (String f : fl) {
                    Matcher matcher = pattern.matcher(f);
                    if (!matcher.matches()) continue;
                    toRemove.add(f);
                }
            }
            toRemove.retainAll(fl);
            if (toRemove.isEmpty()) {
                throw new IllegalArgumentException("Feature named '" + feature + "' is not installed");
            }
            featuresToRemove.addAll(toRemove);
        }
        featuresToRemove = new ArrayList(new LinkedHashSet(featuresToRemove));
        this.print("Removing features: " + this.join(featuresToRemove), options.contains((Object)FeaturesService.Option.Verbose));
        fl.removeAll(featuresToRemove);
        if (fl.isEmpty()) {
            required.remove(region);
        }
        Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
        this.doProvisionInThread(required, stateChanges, state, options);
    }

    @Override
    public void updateFeaturesState(Map<String, Map<String, FeatureState>> stateChanges, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        this.doProvisionInThread(MapUtils.copy(state.requirements), stateChanges, state, options);
    }

    @Override
    public void addRequirements(Map<String, Set<String>> requirements, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        MapUtils.add(required, requirements);
        Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
        this.doProvisionInThread(required, stateChanges, state, options);
    }

    @Override
    public void removeRequirements(Map<String, Set<String>> requirements, EnumSet<FeaturesService.Option> options) throws Exception {
        State state = this.copyState();
        Map<String, Set<String>> required = MapUtils.copy(state.requirements);
        MapUtils.remove(required, requirements);
        Map<String, Map<String, FeatureState>> stateChanges = Collections.emptyMap();
        this.doProvisionInThread(required, stateChanges, state, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<String>> listRequirements() {
        Object object = this.lock;
        synchronized (object) {
            return MapUtils.copy(this.state.requirements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State copyState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.copy();
        }
    }

    protected String normalize(String feature) {
        if (!feature.contains("/")) {
            feature = feature + "/0.0.0";
        }
        int idx = feature.indexOf("/");
        String name = feature.substring(0, idx);
        String version = feature.substring(idx + 1);
        return name + "/" + VersionCleaner.clean(version);
    }

    public void doProvisionInThread(final Map<String, Set<String>> requirements, final Map<String, Map<String, FeatureState>> stateChanges, final State state, final EnumSet<FeaturesService.Option> options) throws Exception {
        try {
            final String outputFile = this.outputFile.get();
            this.outputFile.set(null);
            this.executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    FeaturesServiceImpl.this.doProvision(requirements, stateChanges, state, options, outputFile);
                    return null;
                }
            }).get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    protected Deployer.DeploymentState getDeploymentState(State state) throws Exception {
        Deployer.DeploymentState dstate = new Deployer.DeploymentState();
        dstate.state = state;
        dstate.serviceBundle = this.bundle;
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.systemBundleContext.getBundle().adapt(FrameworkStartLevel.class);
        dstate.initialBundleStartLevel = fsl.getInitialBundleStartLevel();
        dstate.currentStartLevel = fsl.getStartLevel();
        dstate.bundles = new HashMap<Long, Bundle>();
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            dstate.bundles.put(bundle.getBundleId(), bundle);
        }
        dstate.features = new HashMap<String, Feature>();
        for (Map map : this.getFeatures().values()) {
            for (Feature feature : map.values()) {
                String id = feature.getId();
                dstate.features.put(id, feature);
            }
        }
        dstate.bundlesPerRegion = new HashMap<String, Set<Long>>();
        dstate.filtersPerRegion = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        RegionDigraph clone = this.digraph.copy();
        for (Region region : clone.getRegions()) {
            dstate.bundlesPerRegion.put(region.getName(), new HashSet<Long>(region.getBundleIds()));
            HashMap edges = new HashMap();
            for (RegionDigraph.FilteredRegion fr : clone.getEdges(region)) {
                HashMap policy = new HashMap();
                Map<String, Collection<String>> current = fr.getFilter().getSharingPolicy();
                for (String ns : current.keySet()) {
                    for (String f : current.get(ns)) {
                        MapUtils.addToMapSet(policy, ns, f);
                    }
                }
                edges.put(fr.getRegion().getName(), policy);
            }
            dstate.filtersPerRegion.put(region.getName(), edges);
        }
        return dstate;
    }

    private Deployer.DeploymentRequest getDeploymentRequest(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, EnumSet<FeaturesService.Option> options, String outputFile) {
        Deployer.DeploymentRequest request = new Deployer.DeploymentRequest();
        request.bundleUpdateRange = this.bundleUpdateRange;
        request.featureResolutionRange = this.featureResolutionRange;
        request.serviceRequirements = this.serviceRequirements;
        request.updateSnaphots = this.updateSnaphots;
        request.globalRepository = this.globalRepository;
        request.overrides = Overrides.loadOverrides(this.overrides);
        request.requirements = requirements;
        request.stateChanges = stateChanges;
        request.options = options;
        request.outputFile = outputFile;
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProvision(Map<String, Set<String>> requirements, Map<String, Map<String, FeatureState>> stateChanges, State state, EnumSet<FeaturesService.Option> options, String outputFile) throws Exception {
        Dictionary<String, String> props = this.getMavenConfig();
        MavenResolver resolver = MavenResolvers.createMavenResolver(props, (String)"org.ops4j.pax.url.mvn");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.downloadThreads);
        executor.setMaximumPoolSize(this.downloadThreads);
        DownloadManager manager = DownloadManagers.createDownloadManager(resolver, executor, this.scheduleDelay, this.scheduleMaxRun);
        try {
            HashSet<String> prereqs = new HashSet<String>();
            while (true) {
                try {
                    Deployer.DeploymentState dstate = this.getDeploymentState(state);
                    Deployer.DeploymentRequest request = this.getDeploymentRequest(requirements, stateChanges, options, outputFile);
                    new Deployer(manager, this.resolver, this).deploy(dstate, request);
                }
                catch (Deployer.PartialDeploymentException e) {
                    if (!prereqs.containsAll(e.getMissing())) {
                        prereqs.addAll(e.getMissing());
                        state = this.copyState();
                        continue;
                    }
                    throw new Exception("Deployment aborted due to loop in missing prerequisites: " + e.getMissing());
                }
                break;
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private Dictionary<String, String> getMavenConfig() throws IOException {
        Dictionary cfg;
        Configuration config;
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.configurationAdmin != null && (config = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn", null)) != null && (cfg = config.getProperties()) != null) {
            Enumeration e = cfg.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = cfg.get(key);
                if (key == null) continue;
                props.put(key, val.toString());
            }
        }
        return props;
    }

    @Override
    public void print(String message, boolean verbose) {
        LOGGER.info(message);
        if (verbose) {
            System.out.println(message);
        }
    }

    @Override
    public void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring fw = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
        fw.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 2) {
                    LOGGER.error("Framework error", event.getThrowable());
                }
                latch.countDown();
            }
        }});
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveState(State state) {
        Object object = this.lock;
        synchronized (object) {
            state.repositories.clear();
            state.repositories.addAll(this.state.repositories);
            state.bootDone.set(this.state.bootDone.get());
            this.state.replace(state);
            this.saveState();
        }
    }

    @Override
    public void persistResolveRequest(Deployer.DeploymentRequest request) throws IOException {
        this.writeResolve(request.requirements, request.options);
    }

    @Override
    public void installFeature(Feature feature) throws IOException, InvalidSyntaxException {
        if (this.configInstaller != null) {
            this.configInstaller.installFeatureConfigs(feature);
        }
    }

    @Override
    public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
        if ("root".equals(region)) {
            return this.digraph.getRegion(region).installBundleAtLocation(uri, is);
        }
        return this.digraph.getRegion(region).installBundle(uri, is);
    }

    @Override
    public void updateBundle(Bundle bundle, String uri, InputStream is) throws BundleException {
        try {
            File file = BundleUtils.fixBundleWithUpdateLocation(is, uri);
            bundle.update((InputStream)new FileInputStream(file));
            file.delete();
        }
        catch (IOException e) {
            throw new BundleException("Unable to update bundle", (Throwable)e);
        }
    }

    @Override
    public void uninstall(Bundle bundle) throws BundleException {
        bundle.uninstall();
    }

    @Override
    public void startBundle(Bundle bundle) throws BundleException {
        bundle.start();
    }

    @Override
    public void stopBundle(Bundle bundle, int options) throws BundleException {
        bundle.stop(options);
    }

    @Override
    public void setBundleStartLevel(Bundle bundle, int startLevel) {
        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveBundles(Set<Bundle> bundles, final Map<Resource, List<Wire>> wiring, Map<Resource, Bundle> resToBnd) {
        final Thread thread = Thread.currentThread();
        final HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
        for (Resource res : resToBnd.keySet()) {
            bndToRes.put(resToBnd.get(res), res);
        }
        final ResolverHook hook = new ResolverHook(){

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                if (Thread.currentThread() == thread) {
                    if ("osgi.ee".equals(requirement.getNamespace())) {
                        return;
                    }
                    Bundle sourceBundle = requirement.getRevision().getBundle();
                    Resource sourceResource = (Resource)bndToRes.get(sourceBundle);
                    HashSet<Resource> wired = new HashSet<Resource>();
                    wired.add(sourceResource);
                    for (Wire wire : (List)wiring.get(sourceResource)) {
                        wired.add(wire.getProvider());
                        if (!"osgi.wiring.host".equals(wire.getRequirement().getNamespace())) continue;
                        for (Wire hostWire : (List)wiring.get(wire.getProvider())) {
                            wired.add(hostWire.getProvider());
                        }
                    }
                    Iterator<BundleCapability> candIter = candidates.iterator();
                    while (candIter.hasNext()) {
                        BundleCapability cand = candIter.next();
                        BundleRevision br = cand.getRevision();
                        if ((br.getTypes() & 1) != 0) {
                            br = ((BundleWire)br.getWiring().getRequiredWires(null).get(0)).getProvider();
                        }
                        Resource res = (Resource)bndToRes.get(br.getBundle());
                        if (wired.contains(br) || wired.contains(res)) continue;
                        candIter.remove();
                    }
                }
            }

            public void end() {
            }
        };
        ResolverHookFactory factory = new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return hook;
            }
        };
        ServiceRegistration registration = this.systemBundleContext.registerService(ResolverHookFactory.class, (Object)factory, null);
        try {
            FrameworkWiring frameworkWiring = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
            frameworkWiring.resolveBundles(bundles);
        }
        finally {
            registration.unregister();
        }
    }

    @Override
    public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> policies, Map<String, Set<Long>> bundles) throws BundleException, InvalidSyntaxException {
        RegionDigraph temp = this.digraph.copy();
        for (Region region : temp.getRegions()) {
            temp.removeRegion(region);
        }
        for (String string : policies.keySet()) {
            temp.createRegion(string);
        }
        for (Map.Entry entry : bundles.entrySet()) {
            Region region = temp.getRegion((String)entry.getKey());
            Iterator<Object> iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                region.addBundle(l);
            }
        }
        for (Map.Entry entry : policies.entrySet()) {
            Region region1 = temp.getRegion((String)entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Region region2 = temp.getRegion((String)entry2.getKey());
                RegionFilterBuilder rfb = temp.createRegionFilterBuilder();
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    for (String flt : (Set)entry3.getValue()) {
                        rfb.allow((String)entry3.getKey(), flt);
                    }
                }
                region1.connectRegion(region2, rfb.build());
            }
        }
        this.digraph.replace(temp);
    }

    private Pattern getFeaturePattern(String name, String version) {
        String req = FEATURE_OSGI_REQUIREMENT_PREFIX + name + "/" + new VersionRange(version, true);
        req = req.replace("[", "\\[");
        req = req.replace("(", "\\(");
        req = req.replace("]", "\\]");
        req = req.replace(")", "\\)");
        Pattern pattern = Pattern.compile(req);
        return pattern;
    }

    private String join(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }
}

