/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.app.command;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.pentaho.pdi.engine.daemon.app.service.HdfsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="pdi", name="uninstall", description="Uninstall PDI Client:  Deletes spark assembly directory on HDFS")
public class UninstallCommand
implements Action {
    private static Logger LOG = LoggerFactory.getLogger(UninstallCommand.class);
    @Argument(index=0, name="location", required=true, multiValued=false, description="Folder on HDFS where the client exists and will be removed. (ie, /org/pentaho/pdi-ee-client-7.1)")
    String folder = null;
    @Reference
    private HdfsService hdfsService;

    public Object execute() throws Exception {
        LOG.trace("execute()");
        LOG.info("PDI Uninstall:");
        LOG.info("  - {}", (Object)this.folder);
        try {
            this.hdfsService.delete(this.folder);
            return "PDI Uninstall Complete";
        }
        catch (Exception e) {
            LOG.info("Unexpected error trying to delete HDFS Folder.", (Throwable)e);
            return "Error occurred trying to delete folder.  Please look at the log for more information.";
        }
    }
}

