/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.command;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.table.ShellTable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

@Component(property={"osgi.command.scope=rsa", "osgi.command.function=endpoints", "osgi.command.function=endpoint", "endpoint.listener.scope=(endpoint.framework.uuid=*)"})
public class EndpointsCommand
implements EndpointListener {
    Set<EndpointDescription> endpoints = new HashSet<EndpointDescription>();
    private String frameworkId;

    @Activate
    public void activate(BundleContext context) {
        this.frameworkId = context.getProperty("org.osgi.framework.uuid");
    }

    public void endpoint(String id) {
        EndpointDescription epd = this.getEndpoint(id);
        ShellTable table = new ShellTable();
        table.column("key");
        table.column("value");
        for (String key : epd.getProperties().keySet()) {
            Object value = epd.getProperties().get(key);
            table.addRow().addContent(key, this.toString(value));
        }
        table.print(System.out);
    }

    private Object toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    private EndpointDescription getEndpoint(String id) {
        for (EndpointDescription epd : this.endpoints) {
            if (!epd.getId().equals(id)) continue;
            return epd;
        }
        throw new IllegalArgumentException("No endpoint found for id " + id);
    }

    public void endpoints() {
        System.out.println("Endpoints for framework " + this.frameworkId);
        ShellTable table = new ShellTable();
        table.column("id");
        table.column("interfaces");
        table.column("framework");
        table.column("comp name");
        for (EndpointDescription epd : this.endpoints) {
            this.print(table, epd);
        }
        table.print(System.out);
    }

    private void print(ShellTable table, EndpointDescription ep) {
        String compName = this.getProp(ep, "component.name");
        table.addRow().addContent(ep.getId(), ep.getInterfaces(), ep.getFrameworkUUID(), compName);
    }

    private String getProp(EndpointDescription ep, String key) {
        Object value = ep.getProperties().get(key);
        return value == null ? "" : value.toString();
    }

    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        this.endpoints.add(endpoint);
    }

    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        this.endpoints.remove(endpoint);
    }
}

