/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints.dtos.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;
import org.pentaho.marketplace.domain.model.factories.interfaces.ICategoryFactory;
import org.pentaho.marketplace.endpoints.dtos.entities.CategoryDTO;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.ICategoryDTOMapper;

public final class CategoryDTOMapper
implements ICategoryDTOMapper {
    private ICategoryFactory categoryFactory;

    public CategoryDTOMapper(ICategoryFactory categoryFactory) {
        this.categoryFactory = categoryFactory;
    }

    @Override
    public ICategory toEntity(CategoryDTO dto) {
        ICategory parent = null;
        if (dto.parentName != null) {
            parent = this.categoryFactory.create(dto.parentName);
        }
        ICategory category = this.categoryFactory.create(dto.name, parent);
        return category;
    }

    @Override
    public CategoryDTO toDTO(ICategory category) {
        if (category == null) {
            return null;
        }
        CategoryDTO dto = new CategoryDTO();
        dto.name = category.getName();
        if (category.getParent() != null) {
            dto.parentName = category.getParent().getName();
        }
        return dto;
    }

    @Override
    public Collection<ICategory> toEntities(List<CategoryDTO> dtos) {
        ArrayList<ICategory> entities = new ArrayList<ICategory>();
        for (CategoryDTO dto : dtos) {
            entities.add(this.toEntity(dto));
        }
        return entities;
    }

    @Override
    public List<CategoryDTO> toDTOs(Collection<ICategory> categories) {
        ArrayList<CategoryDTO> dtos = new ArrayList<CategoryDTO>();
        for (ICategory category : categories) {
            dtos.add(this.toDTO(category));
        }
        return dtos;
    }
}

