/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.PriorityQueue;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DistanceFunction;
import weka.core.Drawable;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class HierarchicalClusterer
extends AbstractClusterer
implements OptionHandler,
CapabilitiesHandler,
Drawable {
    private static final long serialVersionUID = 1L;
    Instances m_instances;
    int m_nNumClusters = 2;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();
    static final int SINGLE = 0;
    static final int COMPLETE = 1;
    static final int AVERAGE = 2;
    static final int MEAN = 3;
    static final int CENTROID = 4;
    static final int WARD = 5;
    static final int ADJCOMLPETE = 6;
    public static final Tag[] TAGS_LINK_TYPE = new Tag[]{new Tag(0, "SINGLE"), new Tag(1, "COMPLETE"), new Tag(2, "AVERAGE"), new Tag(3, "MEAN"), new Tag(4, "CENTROID"), new Tag(5, "WARD"), new Tag(6, "ADJCOMLPETE")};
    int m_nLinkType = 0;
    boolean m_bPrintNewick = true;
    Node[] m_clusters;
    int[] m_nClusterNr;

    public void setNumClusters(int nClusters) {
        this.m_nNumClusters = Math.max(1, nClusters);
    }

    public int getNumClusters() {
        return this.m_nNumClusters;
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.m_DistanceFunction = distanceFunction;
    }

    public boolean getPrintNewick() {
        return this.m_bPrintNewick;
    }

    public void setPrintNewick(boolean bPrintNewick) {
        this.m_bPrintNewick = bPrintNewick;
    }

    public void setLinkType(SelectedTag newLinkType) {
        if (newLinkType.getTags() == TAGS_LINK_TYPE) {
            this.m_nLinkType = newLinkType.getSelectedTag().getID();
        }
    }

    public SelectedTag getLinkType() {
        return new SelectedTag(this.m_nLinkType, TAGS_LINK_TYPE);
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        this.m_instances = data;
        int nInstances = this.m_instances.numInstances();
        if (nInstances == 0) {
            return;
        }
        this.m_DistanceFunction.setInstances(this.m_instances);
        Vector[] nClusterID = new Vector[data.numInstances()];
        for (int i = 0; i < data.numInstances(); ++i) {
            nClusterID[i] = new Vector();
            nClusterID[i].add(i);
        }
        int nClusters = data.numInstances();
        PriorityQueue<Tuple> queue = new PriorityQueue<Tuple>(nClusters * nClusters / 2, new TupleComparator());
        double[][] fDistance0 = new double[nClusters][nClusters];
        for (int i = 0; i < nClusters; ++i) {
            fDistance0[i][i] = 0.0;
            for (int j = i + 1; j < nClusters; ++j) {
                fDistance0[i][j] = this.getDistance0(nClusterID[i], nClusterID[j]);
                fDistance0[j][i] = fDistance0[i][j];
                queue.add(new Tuple(fDistance0[i][j], i, j));
            }
        }
        Node[] clusterNodes = new Node[nInstances];
        while (nClusters > this.m_nNumClusters) {
            Tuple t;
            while ((t = queue.poll()) != null && (nClusterID[t.m_iCluster1] == null || nClusterID[t.m_iCluster2] == null)) {
            }
            int iMin1 = t.m_iCluster1;
            int iMin2 = t.m_iCluster2;
            nClusterID[iMin1].addAll(nClusterID[iMin2]);
            nClusterID[iMin2] = null;
            for (int i = 0; i < nInstances; ++i) {
                if (i == iMin1 || nClusterID[i] == null) continue;
                int i1 = Math.min(iMin1, i);
                int i2 = Math.max(iMin1, i);
                double fDistance = this.getDistance(fDistance0, nClusterID[i1], nClusterID[i2]);
                queue.add(new Tuple(fDistance, i1, i2));
            }
            Node node = new Node();
            if (clusterNodes[iMin1] == null) {
                node.m_iLeftInstance = iMin1;
                node.m_height = 1.0;
            } else {
                node.m_left = clusterNodes[iMin1];
                clusterNodes[iMin1].m_parent = node;
                node.m_height = clusterNodes[iMin1].m_height + 1.0;
            }
            if (clusterNodes[iMin2] == null) {
                node.m_iRightInstance = iMin2;
                node.m_height = Math.max(1.0, node.m_height);
            } else {
                node.m_right = clusterNodes[iMin2];
                clusterNodes[iMin2].m_parent = node;
                node.m_height = Math.max(clusterNodes[iMin2].m_height + 1.0, node.m_height);
            }
            clusterNodes[iMin1] = node;
            --nClusters;
        }
        int iCurrent = 0;
        this.m_clusters = new Node[this.m_nNumClusters];
        this.m_nClusterNr = new int[nInstances];
        for (int i = 0; i < nInstances; ++i) {
            if (nClusterID[i] == null) continue;
            for (int j = 0; j < nClusterID[i].size(); ++j) {
                this.m_nClusterNr[((Integer)nClusterID[i].elementAt((int)j)).intValue()] = iCurrent;
            }
            this.m_clusters[iCurrent] = clusterNodes[i];
            ++iCurrent;
        }
    }

    double getDistance0(Vector<Integer> cluster1, Vector<Integer> cluster2) {
        double fBestDist = Double.MAX_VALUE;
        switch (this.m_nLinkType) {
            case 0: {
                fBestDist = Double.MAX_VALUE;
                for (int i = 0; i < cluster1.size(); ++i) {
                    Instance instance1 = this.m_instances.instance(cluster1.elementAt(i));
                    for (int j = 0; j < cluster2.size(); ++j) {
                        Instance instance2 = this.m_instances.instance(cluster2.elementAt(j));
                        double fDist = this.m_DistanceFunction.distance(instance1, instance2);
                        if (!(fBestDist > fDist)) continue;
                        fBestDist = fDist;
                    }
                }
                break;
            }
            case 1: 
            case 6: {
                double fDist;
                Instance instance2;
                Instance instance1;
                int i;
                fBestDist = 0.0;
                for (int i2 = 0; i2 < cluster1.size(); ++i2) {
                    Instance instance12 = this.m_instances.instance(cluster1.elementAt(i2));
                    for (int j = 0; j < cluster2.size(); ++j) {
                        Instance instance22 = this.m_instances.instance(cluster2.elementAt(j));
                        double fDist2 = this.m_DistanceFunction.distance(instance12, instance22);
                        if (!(fBestDist < fDist2)) continue;
                        fBestDist = fDist2;
                    }
                }
                if (this.m_nLinkType == 1) break;
                double fMaxDist = 0.0;
                for (i = 0; i < cluster1.size(); ++i) {
                    instance1 = this.m_instances.instance(cluster1.elementAt(i));
                    for (int j = i + 1; j < cluster1.size(); ++j) {
                        instance2 = this.m_instances.instance(cluster1.elementAt(j));
                        fDist = this.m_DistanceFunction.distance(instance1, instance2);
                        if (!(fMaxDist < fDist)) continue;
                        fMaxDist = fDist;
                    }
                }
                for (i = 0; i < cluster2.size(); ++i) {
                    instance1 = this.m_instances.instance(cluster2.elementAt(i));
                    for (int j = i + 1; j < cluster2.size(); ++j) {
                        instance2 = this.m_instances.instance(cluster2.elementAt(j));
                        fDist = this.m_DistanceFunction.distance(instance1, instance2);
                        if (!(fMaxDist < fDist)) continue;
                        fMaxDist = fDist;
                    }
                }
                fBestDist -= fMaxDist;
                break;
            }
            case 2: {
                fBestDist = 0.0;
                for (int i = 0; i < cluster1.size(); ++i) {
                    Instance instance1 = this.m_instances.instance(cluster1.elementAt(i));
                    for (int j = 0; j < cluster2.size(); ++j) {
                        Instance instance2 = this.m_instances.instance(cluster2.elementAt(j));
                        fBestDist += this.m_DistanceFunction.distance(instance1, instance2);
                    }
                }
                fBestDist /= (double)(cluster1.size() * cluster2.size());
                break;
            }
            case 3: {
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                fBestDist = 0.0;
                for (int i = 0; i < merged.size(); ++i) {
                    Instance instance1 = this.m_instances.instance((Integer)merged.elementAt(i));
                    for (int j = i + 1; j < merged.size(); ++j) {
                        Instance instance2 = this.m_instances.instance((Integer)merged.elementAt(j));
                        fBestDist += this.m_DistanceFunction.distance(instance1, instance2);
                    }
                }
                int n = merged.size();
                fBestDist /= (double)n * ((double)n - 1.0) / 2.0;
                break;
            }
            case 4: {
                double[] fValues1 = new double[this.m_instances.numAttributes()];
                double[] fValues2 = new double[this.m_instances.numAttributes()];
                for (int i = 0; i < cluster1.size(); ++i) {
                    Instance instance1 = this.m_instances.instance(cluster1.elementAt(i));
                    Instance instance2 = this.m_instances.instance(cluster1.elementAt(i));
                    for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                        int n = j;
                        fValues1[n] = fValues1[n] + instance1.value(j);
                        int n2 = j;
                        fValues2[n2] = fValues2[n2] + instance2.value(j);
                    }
                }
                int j = 0;
                while (j < this.m_instances.numAttributes()) {
                    int n = j;
                    fValues1[n] = fValues1[n] / (double)cluster1.size();
                    int n3 = j++;
                    fValues2[n3] = fValues2[n3] + (double)cluster2.size();
                }
                Instance instance1 = (Instance)this.m_instances.instance(cluster1.elementAt(0)).copy();
                Instance instance2 = (Instance)this.m_instances.instance(cluster1.elementAt(0)).copy();
                for (int j2 = 0; j2 < this.m_instances.numAttributes(); ++j2) {
                    instance1.setValue(j2, fValues1[j2]);
                    instance2.setValue(j2, fValues1[j2]);
                }
                fBestDist = this.m_DistanceFunction.distance(instance1, instance2);
                break;
            }
            case 5: {
                double ESS1 = this.calcESS(cluster1);
                double ESS2 = this.calcESS(cluster2);
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                double ESS = this.calcESS(merged);
                fBestDist = ESS * (double)merged.size() - ESS1 * (double)cluster1.size() - ESS2 * (double)cluster2.size();
            }
        }
        return fBestDist;
    }

    double getDistance(double[][] fDistance, Vector<Integer> cluster1, Vector<Integer> cluster2) {
        double fBestDist = Double.MAX_VALUE;
        switch (this.m_nLinkType) {
            case 0: {
                fBestDist = Double.MAX_VALUE;
                for (int i = 0; i < cluster1.size(); ++i) {
                    int i1 = cluster1.elementAt(i);
                    for (int j = 0; j < cluster2.size(); ++j) {
                        int i2 = cluster2.elementAt(j);
                        double fDist = fDistance[i1][i2];
                        if (!(fBestDist > fDist)) continue;
                        fBestDist = fDist;
                    }
                }
                break;
            }
            case 1: 
            case 6: {
                double fDist;
                int i2;
                int i1;
                int i;
                fBestDist = 0.0;
                for (int i3 = 0; i3 < cluster1.size(); ++i3) {
                    int i12 = cluster1.elementAt(i3);
                    for (int j = 0; j < cluster2.size(); ++j) {
                        int i22 = cluster2.elementAt(j);
                        double fDist2 = fDistance[i12][i22];
                        if (!(fBestDist < fDist2)) continue;
                        fBestDist = fDist2;
                    }
                }
                if (this.m_nLinkType == 1) break;
                double fMaxDist = 0.0;
                for (i = 0; i < cluster1.size(); ++i) {
                    i1 = cluster1.elementAt(i);
                    for (int j = i + 1; j < cluster1.size(); ++j) {
                        i2 = cluster1.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (!(fMaxDist < fDist)) continue;
                        fMaxDist = fDist;
                    }
                }
                for (i = 0; i < cluster2.size(); ++i) {
                    i1 = cluster2.elementAt(i);
                    for (int j = i + 1; j < cluster2.size(); ++j) {
                        i2 = cluster2.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (!(fMaxDist < fDist)) continue;
                        fMaxDist = fDist;
                    }
                }
                fBestDist -= fMaxDist;
                break;
            }
            case 2: {
                fBestDist = 0.0;
                for (int i = 0; i < cluster1.size(); ++i) {
                    int i1 = cluster1.elementAt(i);
                    for (int j = 0; j < cluster2.size(); ++j) {
                        int i2 = cluster2.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                    }
                }
                fBestDist /= (double)(cluster1.size() * cluster2.size());
                break;
            }
            case 3: {
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                fBestDist = 0.0;
                for (int i = 0; i < merged.size(); ++i) {
                    int i1 = (Integer)merged.elementAt(i);
                    for (int j = i + 1; j < merged.size(); ++j) {
                        int i2 = (Integer)merged.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                    }
                }
                int n = merged.size();
                fBestDist /= (double)n * ((double)n - 1.0) / 2.0;
                break;
            }
            case 4: {
                double[] fValues1 = new double[this.m_instances.numAttributes()];
                double[] fValues2 = new double[this.m_instances.numAttributes()];
                for (int i = 0; i < cluster1.size(); ++i) {
                    Instance instance1 = this.m_instances.instance(cluster1.elementAt(i));
                    Instance instance2 = this.m_instances.instance(cluster1.elementAt(i));
                    for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                        int n = j;
                        fValues1[n] = fValues1[n] + instance1.value(j);
                        int n2 = j;
                        fValues2[n2] = fValues2[n2] + instance2.value(j);
                    }
                }
                int j = 0;
                while (j < this.m_instances.numAttributes()) {
                    int n = j;
                    fValues1[n] = fValues1[n] / (double)cluster1.size();
                    int n3 = j++;
                    fValues2[n3] = fValues2[n3] + (double)cluster2.size();
                }
                Instance instance1 = (Instance)this.m_instances.instance(cluster1.elementAt(0)).copy();
                Instance instance2 = (Instance)this.m_instances.instance(cluster1.elementAt(0)).copy();
                for (int j2 = 0; j2 < this.m_instances.numAttributes(); ++j2) {
                    instance1.setValue(j2, fValues1[j2]);
                    instance2.setValue(j2, fValues1[j2]);
                }
                fBestDist = this.m_DistanceFunction.distance(instance1, instance2);
                break;
            }
            case 5: {
                double ESS1 = this.calcESS(cluster1);
                double ESS2 = this.calcESS(cluster2);
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                double ESS = this.calcESS(merged);
                fBestDist = ESS * (double)merged.size() - ESS1 * (double)cluster1.size() - ESS2 * (double)cluster2.size();
            }
        }
        return fBestDist;
    }

    double calcESS(Vector<Integer> cluster) {
        double[] fValues1 = new double[this.m_instances.numAttributes()];
        for (int i = 0; i < cluster.size(); ++i) {
            Instance instance = this.m_instances.instance(cluster.elementAt(i));
            for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                int n = j;
                fValues1[n] = fValues1[n] + instance.value(j);
            }
        }
        int j = 0;
        while (j < this.m_instances.numAttributes()) {
            int n = j++;
            fValues1[n] = fValues1[n] / (double)cluster.size();
        }
        Instance centroid = (Instance)this.m_instances.instance(cluster.elementAt(0)).copy();
        for (int j2 = 0; j2 < this.m_instances.numAttributes(); ++j2) {
            centroid.setValue(j2, fValues1[j2]);
        }
        double fESS = 0.0;
        for (int i = 0; i < cluster.size(); ++i) {
            Instance instance = this.m_instances.instance(cluster.elementAt(i));
            fESS += this.m_DistanceFunction.distance(centroid, instance);
        }
        return fESS / (double)cluster.size();
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        if (this.m_instances.numInstances() == 0) {
            return 0;
        }
        double fBestDist = Double.MAX_VALUE;
        int iBestInstance = -1;
        for (int i = 0; i < this.m_instances.numInstances(); ++i) {
            double fDist = this.m_DistanceFunction.distance(instance, this.m_instances.instance(i));
            if (!(fDist < fBestDist)) continue;
            fBestDist = fDist;
            iBestInstance = i;
        }
        return this.m_nClusterNr[iBestInstance];
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.numberOfClusters() == 0) {
            double[] p = new double[]{1.0};
            return p;
        }
        double[] p = new double[this.numberOfClusters()];
        p[this.clusterInstance((Instance)instance)] = 1.0;
        return p;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public int numberOfClusters() throws Exception {
        return Math.min(this.m_nNumClusters, this.m_instances.numInstances());
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tnumber of clusters", "N", 1, "-N <Nr Of Clusters>"));
        newVector.addElement(new Option("\tFlag to indicate the cluster should be printed in Newick format.", "P", 0, "-P"));
        newVector.addElement(new Option("Link type (Single, Complete, Average, Mean, Centroid, Ward, Adjusted complete)", "L", 1, "-L [SINGLE|COMPLETE|AVERAGE|MEAN|CENTROID|WARD|ADJCOMLPETE]"));
        newVector.add(new Option("\tDistance function to use.\n\t(default: weka.core.EuclideanDistance)", "A", 1, "-A <classname and options>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String nnSearchClass;
        this.m_bPrintNewick = Utils.getFlag('P', options);
        String optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            Integer temp = new Integer(optionString);
            this.setNumClusters(temp);
        } else {
            this.setNumClusters(2);
        }
        String sLinkType = Utils.getOption('L', options);
        if (sLinkType.compareTo("SINGLE") == 0) {
            this.setLinkType(new SelectedTag(0, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("COMPLETE") == 0) {
            this.setLinkType(new SelectedTag(1, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("AVERAGE") == 0) {
            this.setLinkType(new SelectedTag(2, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("MEAN") == 0) {
            this.setLinkType(new SelectedTag(3, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("CENTROID") == 0) {
            this.setLinkType(new SelectedTag(4, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("WARD") == 0) {
            this.setLinkType(new SelectedTag(5, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("ADJCOMLPETE") == 0) {
            this.setLinkType(new SelectedTag(6, TAGS_LINK_TYPE));
        }
        if ((nnSearchClass = Utils.getOption('A', options)).length() != 0) {
            String[] nnSearchClassSpec = Utils.splitOptions(nnSearchClass);
            if (nnSearchClassSpec.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String className = nnSearchClassSpec[0];
            nnSearchClassSpec[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, className, nnSearchClassSpec));
        } else {
            this.setDistanceFunction(new EuclideanDistance());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[12];
        int current = 0;
        options[current++] = "-N";
        options[current++] = "" + this.getNumClusters();
        options[current++] = "-L";
        switch (this.m_nLinkType) {
            case 0: {
                options[current++] = "SINGLE";
                break;
            }
            case 1: {
                options[current++] = "COMPLETE";
                break;
            }
            case 2: {
                options[current++] = "AVERAGE";
                break;
            }
            case 3: {
                options[current++] = "MEAN";
                break;
            }
            case 4: {
                options[current++] = "CENTROID";
                break;
            }
            case 5: {
                options[current++] = "WARD";
                break;
            }
            case 6: {
                options[current++] = "ADJCOMLPETE";
            }
        }
        if (this.m_bPrintNewick) {
            options[current++] = "-P";
        }
        options[current++] = "-A";
        options[current++] = (this.m_DistanceFunction.getClass().getName() + " " + Utils.joinOptions(this.m_DistanceFunction.getOptions())).trim();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int attIndex = this.m_instances.classIndex();
        if (attIndex < 0) {
            for (attIndex = 0; attIndex < this.m_instances.numAttributes() - 1 && !this.m_instances.attribute(attIndex).isString(); ++attIndex) {
            }
        }
        try {
            if (this.m_bPrintNewick && this.numberOfClusters() > 0) {
                for (int i = 0; i < this.m_clusters.length; ++i) {
                    if (this.m_clusters[i] == null) continue;
                    buf.append("Cluster " + i + "\n");
                    buf.append(this.m_clusters[i].toString(attIndex));
                    buf.append("\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public String numClustersTipText() {
        return "Sets the number of clusters. If a single hierarchy is desired, set this to 1.";
    }

    public String printNewickTipText() {
        return "Flag to indicate whether the cluster should be print in Newick format. This can be useful for display in other programs. However, for large datasets a lot of text may be produced, which may not be a nuisance when the Newick format is not required";
    }

    public String distanceFunctionTipText() {
        return "Sets the distance function, which measures the distance between two individual. instances (or possibly the distance between an instance and the centroid of a clusterdepending on the Link type).";
    }

    public String linkTypeTipText() {
        return "Sets the method used to measure the distance between two clusters.\nSINGLE:\n find single link distance aka minimum link, which is the closest distance between any item in cluster1 and any item in cluster2\nCOMPLETE:\n find complete link distance aka maximum link, which is the largest distance between any item in cluster1 and any item in cluster2\nADJCOMLPETE:\n as COMPLETE, but with adjustment, which is the largest within cluster distance\nAVERAGE:\n finds average distance between the elements of the two clusters\nMEAN: \n calculates the mean distance of a merged cluster (akak Group-average agglomerative clustering)\nCENTROID:\n finds the distance of the centroids of the clusters\nWARD:\n finds the distance of the change in caused by merging the cluster. The information of a cluster is calculated as the error sum of squares of the centroids of the cluster and its members.\n";
    }

    public String globalInfo() {
        return "Hierarchical clustering class.\nImplements a number of classic agglomorative (i.e. bottom up) hierarchical clustering methodsbased on .";
    }

    public static void main(String[] argv) {
        HierarchicalClusterer.runClusterer(new HierarchicalClusterer(), argv);
    }

    @Override
    public String graph() throws Exception {
        if (this.numberOfClusters() == 0) {
            return "Newick:(no,clusters)";
        }
        int attIndex = this.m_instances.classIndex();
        if (attIndex < 0) {
            for (attIndex = 0; attIndex < this.m_instances.numAttributes() - 1 && !this.m_instances.attribute(attIndex).isString(); ++attIndex) {
            }
        }
        String sNewick = this.m_clusters[0].toString(attIndex);
        return "Newick:" + sNewick;
    }

    @Override
    public int graphType() {
        return 3;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    class Node
    implements Serializable {
        Node m_left;
        Node m_right;
        Node m_parent;
        int m_iLeftInstance;
        int m_iRightInstance;
        double m_height = 0.0;

        Node() {
        }

        public String toString(int attIndex) {
            if (this.m_left == null) {
                if (this.m_right == null) {
                    double m_fLength = this.m_height;
                    return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).stringValue(attIndex) + ":" + m_fLength + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).stringValue(attIndex) + ":" + m_fLength + ")";
                }
                double m_fLeftLength = this.m_height;
                double m_fRightLength = this.m_height - this.m_right.m_height;
                return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).stringValue(attIndex) + ":" + m_fLeftLength + "," + this.m_right.toString(attIndex) + ":" + m_fRightLength + ")";
            }
            if (this.m_right == null) {
                double m_fLeftLength = this.m_height - this.m_left.m_height;
                double m_fRightLength = this.m_height;
                return "(" + this.m_left.toString(attIndex) + ":" + m_fLeftLength + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).stringValue(attIndex) + ":" + m_fRightLength + ")";
            }
            double m_fLeftLength = this.m_height - this.m_left.m_height;
            double m_fRightLength = this.m_height - this.m_right.m_height;
            return "(" + this.m_left.toString(attIndex) + ":" + m_fLeftLength + "," + this.m_right.toString(attIndex) + ":" + m_fRightLength + ")";
        }
    }

    class TupleComparator
    implements Comparator<Tuple> {
        TupleComparator() {
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            if (o1.m_fDist < o2.m_fDist) {
                return -1;
            }
            if (o1.m_fDist == o2.m_fDist) {
                return 0;
            }
            return 1;
        }
    }

    class Tuple {
        double m_fDist;
        int m_iCluster1;
        int m_iCluster2;

        public Tuple(double d, int i, int j) {
            this.m_fDist = d;
            this.m_iCluster1 = i;
            this.m_iCluster2 = j;
        }
    }
}

