/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.ArrayList;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;

public class BottomUpConstructor
extends BallTreeConstructor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5864250777657707687L;

    public String globalInfo() {
        return "The class that constructs a ball tree bottom up.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        result.setValue(TechnicalInformation.Field.YEAR, "1989");
        result.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        result.setValue(TechnicalInformation.Field.MONTH, "December");
        result.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return result;
    }

    @Override
    public BallNode buildTree() throws Exception {
        ArrayList<TempNode> list = new ArrayList<TempNode>();
        for (int i = 0; i < this.m_InstList.length; ++i) {
            TempNode n = new TempNode();
            n.points = new int[1];
            n.points[0] = this.m_InstList[i];
            n.anchor = this.m_Instances.instance(this.m_InstList[i]);
            n.radius = 0.0;
            list.add(n);
        }
        return this.mergeNodes(list, 0, this.m_InstList.length - 1, this.m_InstList);
    }

    protected BallNode mergeNodes(ArrayList<TempNode> list, int startIdx, int endIdx, int[] instList) throws Exception {
        double tmpRadius;
        double minRadius = Double.POSITIVE_INFINITY;
        Instance minPivot = null;
        int min1 = -1;
        int min2 = -1;
        int[] minInstList = null;
        int merge = 1;
        while (list.size() > 1) {
            System.err.print("merge step: " + merge++ + "               \r");
            minRadius = Double.POSITIVE_INFINITY;
            min1 = -1;
            min2 = -1;
            for (int i = 0; i < list.size(); ++i) {
                TempNode first = list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    TempNode second = list.get(j);
                    Instance pivot = this.calcPivot(first, second, this.m_Instances);
                    tmpRadius = this.calcRadius(first, second);
                    if (!(tmpRadius < minRadius)) continue;
                    minRadius = tmpRadius;
                    min1 = i;
                    min2 = j;
                    minPivot = pivot;
                }
            }
            TempNode parent = new TempNode();
            parent.left = list.get(min1);
            parent.right = list.get(min2);
            minInstList = new int[parent.left.points.length + parent.right.points.length];
            System.arraycopy(parent.left.points, 0, minInstList, 0, parent.left.points.length);
            System.arraycopy(parent.right.points, 0, minInstList, parent.left.points.length, parent.right.points.length);
            parent.points = minInstList;
            parent.anchor = minPivot;
            parent.radius = BallNode.calcRadius(parent.points, this.m_Instances, minPivot, this.m_DistanceFunction);
            list.remove(min1);
            list.remove(min2 - 1);
            list.add(parent);
        }
        System.err.println("");
        TempNode tmpRoot = list.get(0);
        if (this.m_InstList.length != tmpRoot.points.length) {
            throw new Exception("Root nodes instance list is of irregular length. Please check code.");
        }
        System.arraycopy(tmpRoot.points, 0, this.m_InstList, 0, tmpRoot.points.length);
        this.m_NumLeaves = 0;
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        tmpRadius = BallNode.calcRadius(instList, this.m_Instances, tmpRoot.anchor, this.m_DistanceFunction);
        BallNode node = this.makeBallTree(tmpRoot, startIdx, endIdx, instList, 0, tmpRadius);
        return node;
    }

    protected BallNode makeBallTree(TempNode node, int startidx, int endidx, int[] instList, int depth, double rootRadius) throws Exception {
        BallNode ball = null;
        if (this.m_MaxDepth < depth) {
            this.m_MaxDepth = depth;
        }
        if (node.points.length > this.m_MaxInstancesInLeaf && rootRadius != 0.0 && node.radius / rootRadius >= this.m_MaxRelLeafRadius && node.left != null && node.right != null) {
            Instance pivot = BallNode.calcCentroidPivot(startidx, endidx, instList, this.m_Instances);
            ball = new BallNode(startidx, endidx, this.m_NumNodes, pivot, BallNode.calcRadius(startidx, endidx, instList, this.m_Instances, pivot, this.m_DistanceFunction));
            ++this.m_NumNodes;
            ball.m_Left = this.makeBallTree(node.left, startidx, startidx + node.left.points.length - 1, instList, depth + 1, rootRadius);
            ball.m_Right = this.makeBallTree(node.right, startidx + node.left.points.length, endidx, instList, depth + 1, rootRadius);
        } else {
            Instance pivot = BallNode.calcCentroidPivot(startidx, endidx, instList, this.m_Instances);
            ball = new BallNode(startidx, endidx, this.m_NumNodes, pivot, BallNode.calcRadius(startidx, endidx, instList, this.m_Instances, pivot, this.m_DistanceFunction));
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
        }
        return ball;
    }

    @Override
    public int[] addInstance(BallNode node, Instance inst) throws Exception {
        throw new Exception("BottomUpConstruction method does not allow addition of new Instances.");
    }

    public Instance calcPivot(TempNode node1, TempNode node2, Instances insts) throws Exception {
        int k;
        int classIdx = this.m_Instances.classIndex();
        double[] attrVals = new double[insts.numAttributes()];
        double anchr1Ratio = (double)node1.points.length / (double)(node1.points.length + node2.points.length);
        double anchr2Ratio = (double)node2.points.length / (double)(node1.points.length + node2.points.length);
        for (k = 0; k < node1.anchor.numValues(); ++k) {
            if (node1.anchor.index(k) == classIdx) continue;
            int n = k;
            attrVals[n] = attrVals[n] + node1.anchor.valueSparse(k) * anchr1Ratio;
        }
        for (k = 0; k < node2.anchor.numValues(); ++k) {
            if (node2.anchor.index(k) == classIdx) continue;
            int n = k;
            attrVals[n] = attrVals[n] + node2.anchor.valueSparse(k) * anchr2Ratio;
        }
        DenseInstance temp = new DenseInstance(1.0, attrVals);
        return temp;
    }

    public double calcRadius(TempNode n1, TempNode n2) throws Exception {
        Instance a1 = n1.anchor;
        Instance a2 = n2.anchor;
        double radius = n1.radius + this.m_DistanceFunction.distance(a1, a2) + n2.radius;
        return radius / 2.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    protected class TempNode
    implements RevisionHandler {
        Instance anchor;
        double radius;
        int[] points;
        TempNode left = null;
        TempNode right = null;

        protected TempNode() {
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append("p: ");
            for (int i = 0; i < this.points.length; ++i) {
                if (i != 0) {
                    bf.append(", " + this.points[i]);
                    continue;
                }
                bf.append("" + this.points[i]);
            }
            return bf.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8048 $");
        }
    }
}

