/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.ConverterUtils;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.OutputZipper;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class ExplicitTestsetResultProducer
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    private static final long serialVersionUID = 2613585409333652530L;
    public static final String DEFAULT_SUFFIX = "_test.arff";
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected File m_TestsetDir = new File(System.getProperty("user.dir"));
    protected String m_TestsetPrefix = "";
    protected String m_TestsetSuffix = "_test.arff";
    protected String m_RelationFind = "";
    protected String m_RelationReplace = "";
    protected boolean m_randomize = false;
    protected SplitEvaluator m_SplitEvaluator = new ClassifierSplitEvaluator();
    protected String[] m_AdditionalMeasures = null;
    protected boolean m_debugOutput = false;
    protected OutputZipper m_ZipDest = null;
    protected File m_OutputFile = new File(new File(System.getProperty("user.dir")), "splitEvalutorOut.zip");
    public static String DATASET_FIELD_NAME = "Dataset";
    public static String RUN_FIELD_NAME = "Run";
    public static String TIMESTAMP_FIELD_NAME = "Date_time";
    protected transient Environment m_env;

    public String globalInfo() {
        return "Loads the external test set and calls the appropriate SplitEvaluator to generate some results.\nThe filename of the test set is constructed as follows:\n   <dir> + / + <prefix> + <relation-name> + <suffix>\nThe relation-name can be modified by using the regular expression to replace the matching sub-string with a specified replacement string. In order to get rid of the string that the Weka filters add to the end of the relation name, just use '.*-weka' as the regular expression to find.\nThe suffix determines the type of file to load, i.e., one is not restricted to ARFF files. As long as Weka recognizes the extension specified in the suffix, the data will be loaded with one of Weka's converters.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("Save raw split evaluator output.", "D", 0, "-D"));
        result.addElement(new Option("\tThe filename where raw output will be stored.\n\tIf a directory name is specified then then individual\n\toutputs will be gzipped, otherwise all output will be\n\tzipped to the named file. Use in conjuction with -D.\n\t(default: splitEvalutorOut.zip)", "O", 1, "-O <file/directory name/path>"));
        result.addElement(new Option("\tThe full class name of a SplitEvaluator.\n\teg: weka.experiment.ClassifierSplitEvaluator", "W", 1, "-W <class name>"));
        result.addElement(new Option("\tSet when data is to be randomized.", "R", 0, "-R"));
        result.addElement(new Option("\tThe directory containing the test sets.\n\t(default: current directory)", "dir", 1, "-dir <directory>"));
        result.addElement(new Option("\tAn optional prefix for the test sets (before the relation name).\n(default: empty string)", "prefix", 1, "-prefix <string>"));
        result.addElement(new Option("\tThe suffix to append to the test set.\n\t(default: _test.arff)", "suffix", 1, "-suffix <string>"));
        result.addElement(new Option("\tThe regular expression to search the relation name with.\n\tNot used if an empty string.\n\t(default: empty string)", "find", 1, "-find <regular expression>"));
        result.addElement(new Option("\tThe replacement string for the all the matches of '-find'.\n\t(default: empty string)", "replace", 1, "-replace <string>"));
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to split evaluator " + this.m_SplitEvaluator.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_SplitEvaluator)).listOptions();
            while (enu.hasMoreElements()) {
                result.addElement((Option)enu.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setRawOutput(Utils.getFlag('D', options));
        this.setRandomizeData(!Utils.getFlag('R', options));
        String tmpStr = Utils.getOption('O', options);
        if (tmpStr.length() != 0) {
            this.setOutputFile(new File(tmpStr));
        }
        if ((tmpStr = Utils.getOption("dir", options)).length() > 0) {
            this.setTestsetDir(new File(tmpStr));
        } else {
            this.setTestsetDir(new File(System.getProperty("user.dir")));
        }
        tmpStr = Utils.getOption("prefix", options);
        if (tmpStr.length() > 0) {
            this.setTestsetPrefix(tmpStr);
        } else {
            this.setTestsetPrefix("");
        }
        tmpStr = Utils.getOption("suffix", options);
        if (tmpStr.length() > 0) {
            this.setTestsetSuffix(tmpStr);
        } else {
            this.setTestsetSuffix(DEFAULT_SUFFIX);
        }
        tmpStr = Utils.getOption("find", options);
        if (tmpStr.length() > 0) {
            this.setRelationFind(tmpStr);
        } else {
            this.setRelationFind("");
        }
        tmpStr = Utils.getOption("replace", options);
        if (tmpStr.length() > 0 && this.getRelationFind().length() > 0) {
            this.setRelationReplace(tmpStr);
        } else {
            this.setRelationReplace("");
        }
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            throw new Exception("A SplitEvaluator must be specified with the -W option.");
        }
        this.setSplitEvaluator((SplitEvaluator)Utils.forName(SplitEvaluator.class, tmpStr, null));
        if (this.getSplitEvaluator() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getSplitEvaluator())).setOptions(Utils.partitionOptions(options));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] seOptions = new String[]{};
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            seOptions = ((OptionHandler)((Object)this.m_SplitEvaluator)).getOptions();
        }
        if (this.getRawOutput()) {
            result.add("-D");
        }
        if (!this.getRandomizeData()) {
            result.add("-R");
        }
        result.add("-O");
        result.add(this.getOutputFile().getName());
        result.add("-dir");
        result.add(this.getTestsetDir().getPath());
        if (this.getTestsetPrefix().length() > 0) {
            result.add("-prefix");
            result.add(this.getTestsetPrefix());
        }
        result.add("-suffix");
        result.add(this.getTestsetSuffix());
        if (this.getRelationFind().length() > 0) {
            result.add("-find");
            result.add(this.getRelationFind());
            if (this.getRelationReplace().length() > 0) {
                result.add("-replace");
                result.add(this.getRelationReplace());
            }
        }
        if (this.getSplitEvaluator() != null) {
            result.add("-W");
            result.add(this.getSplitEvaluator().getClass().getName());
        }
        if (seOptions.length > 0) {
            result.add("--");
            for (int i = 0; i < seOptions.length; ++i) {
                result.add(seOptions[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_SplitEvaluator != null) {
            System.err.println("ExplicitTestsetResultProducer: setting additional measures for split evaluator");
            this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                result.addElement(mname);
            }
        }
        return result.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("ExplicitTestsetResultProducer: Can't return value for : " + additionalMeasureName + ". " + this.m_SplitEvaluator.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    @Override
    public void setResultListener(ResultListener listener) {
        this.m_ResultListener = listener;
    }

    public static Double getTimestamp() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        double timestamp = (double)(now.get(1) * 10000 + (now.get(2) + 1) * 100 + now.get(5)) + (double)now.get(11) / 100.0 + (double)now.get(12) / 10000.0;
        return new Double(timestamp);
    }

    @Override
    public void preProcess() throws Exception {
        if (this.m_SplitEvaluator == null) {
            throw new Exception("No SplitEvalutor set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    @Override
    public void postProcess() throws Exception {
        this.m_ResultListener.postProcess(this);
        if (this.m_debugOutput && this.m_ZipDest != null) {
            this.m_ZipDest.finished();
            this.m_ZipDest = null;
        }
    }

    @Override
    public void doRunKeys(int run) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 2];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[1] = "" + run;
        System.arraycopy(seKey, 0, key, 2, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            this.m_ResultListener.acceptResult(this, key, null);
        }
    }

    protected String createFilename(Instances inst) {
        String name = inst.relationName();
        if (this.getRelationFind().length() > 0) {
            name = name.replaceAll(this.getRelationFind(), this.getRelationReplace());
        }
        String result = this.getTestsetDir().getPath() + File.separator;
        result = result + this.getTestsetPrefix() + name + this.getTestsetSuffix();
        try {
            result = this.m_env.substitute(result);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void doRun(int run) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 2];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[1] = "" + run;
        System.arraycopy(seKey, 0, key, 2, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            Instances train = new Instances(this.m_Instances);
            if (this.m_randomize) {
                Random rand = new Random(run);
                train.randomize(rand);
            }
            if (this.m_env == null) {
                this.m_env = new Environment();
            }
            this.m_env.addVariable("RUN_NUMBER", "" + run);
            String filename = this.createFilename(train);
            File file = new File(filename);
            if (!file.exists()) {
                throw new WekaException("Test set '" + filename + "' not found!");
            }
            Instances test = ConverterUtils.DataSource.read(filename);
            if (train.numAttributes() != test.numAttributes()) {
                throw new WekaException("Train and test set (= " + filename + ") " + "differ in number of attributes: " + train.numAttributes() + " != " + test.numAttributes());
            }
            test.setClassIndex(train.classIndex());
            if (!train.equalHeaders(test)) {
                throw new WekaException("Train and test set (= " + filename + ") " + "are not compatible:\n" + train.equalHeadersMsg(test));
            }
            Object[] seResults = this.m_SplitEvaluator.getResult(train, test);
            Object[] results = new Object[seResults.length + 1];
            results[0] = ExplicitTestsetResultProducer.getTimestamp();
            System.arraycopy(seResults, 0, results, 1, seResults.length);
            if (this.m_debugOutput) {
                String resultName = ("" + run + "." + Utils.backQuoteChars(train.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                resultName = Utils.removeSubstring(resultName, "weka.classifiers.");
                resultName = Utils.removeSubstring(resultName, "weka.filters.");
                resultName = Utils.removeSubstring(resultName, "weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), resultName);
            }
            this.m_ResultListener.acceptResult(this, key, results);
        }
    }

    @Override
    public String[] getKeyNames() {
        String[] keyNames = this.m_SplitEvaluator.getKeyNames();
        String[] newKeyNames = new String[keyNames.length + 2];
        newKeyNames[0] = DATASET_FIELD_NAME;
        newKeyNames[1] = RUN_FIELD_NAME;
        System.arraycopy(keyNames, 0, newKeyNames, 2, keyNames.length);
        return newKeyNames;
    }

    @Override
    public Object[] getKeyTypes() {
        Object[] keyTypes = this.m_SplitEvaluator.getKeyTypes();
        Object[] newKeyTypes = new String[keyTypes.length + 2];
        newKeyTypes[0] = new String();
        newKeyTypes[1] = new String();
        System.arraycopy(keyTypes, 0, newKeyTypes, 2, keyTypes.length);
        return newKeyTypes;
    }

    @Override
    public String[] getResultNames() {
        String[] resultNames = this.m_SplitEvaluator.getResultNames();
        String[] newResultNames = new String[resultNames.length + 1];
        newResultNames[0] = TIMESTAMP_FIELD_NAME;
        System.arraycopy(resultNames, 0, newResultNames, 1, resultNames.length);
        return newResultNames;
    }

    @Override
    public Object[] getResultTypes() {
        Object[] resultTypes = this.m_SplitEvaluator.getResultTypes();
        Object[] newResultTypes = new Object[resultTypes.length + 1];
        newResultTypes[0] = new Double(0.0);
        System.arraycopy(resultTypes, 0, newResultTypes, 1, resultTypes.length);
        return newResultTypes;
    }

    @Override
    public String getCompatibilityState() {
        String result = "";
        if (this.getRandomizeData()) {
            result = result + " -R";
        }
        result = result + " -dir " + this.getTestsetDir();
        if (this.getTestsetPrefix().length() > 0) {
            result = result + " -prefix " + this.getTestsetPrefix();
        }
        result = result + " -suffix " + this.getTestsetSuffix();
        if (this.getRelationFind().length() > 0) {
            result = result + " -find " + this.getRelationFind();
            if (this.getRelationReplace().length() > 0) {
                result = result + " -replace " + this.getRelationReplace();
            }
        }
        result = this.m_SplitEvaluator == null ? result + " <null SplitEvaluator>" : result + " -W " + this.m_SplitEvaluator.getClass().getName();
        return result + " --";
    }

    public String outputFileTipText() {
        return "Set the destination for saving raw output. If the rawOutput option is selected, then output from the splitEvaluator for individual train-test splits is saved. If the destination is a directory, then each output is saved to an individual gzip file; if the destination is a file, then each output is saved as an entry in a zip file.";
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File value) {
        this.m_OutputFile = value;
    }

    public String randomizeDataTipText() {
        return "Do not randomize dataset and do not perform probabilistic rounding if true";
    }

    public boolean getRandomizeData() {
        return this.m_randomize;
    }

    public void setRandomizeData(boolean value) {
        this.m_randomize = value;
    }

    public String rawOutputTipText() {
        return "Save raw output (useful for debugging). If set, then output is sent to the destination specified by outputFile";
    }

    public boolean getRawOutput() {
        return this.m_debugOutput;
    }

    public void setRawOutput(boolean value) {
        this.m_debugOutput = value;
    }

    public String splitEvaluatorTipText() {
        return "The evaluator to apply to the test data. This may be a classifier, regression scheme etc.";
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.m_SplitEvaluator;
    }

    public void setSplitEvaluator(SplitEvaluator value) {
        this.m_SplitEvaluator = value;
        this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
    }

    public String testsetDirTipText() {
        return "The directory containing the test sets.";
    }

    public File getTestsetDir() {
        return this.m_TestsetDir;
    }

    public void setTestsetDir(File value) {
        this.m_TestsetDir = value;
    }

    public String testsetPrefixTipText() {
        return "The prefix to use for the filename of the test sets.";
    }

    public String getTestsetPrefix() {
        return this.m_TestsetPrefix;
    }

    public void setTestsetPrefix(String value) {
        this.m_TestsetPrefix = value;
    }

    public String testsetSuffixTipText() {
        return "The suffix to use for the filename of the test sets - must contain the file extension.";
    }

    public String getTestsetSuffix() {
        return this.m_TestsetSuffix;
    }

    public void setTestsetSuffix(String value) {
        if (value == null || value.length() == 0) {
            value = DEFAULT_SUFFIX;
        }
        this.m_TestsetSuffix = value;
    }

    public String relationFindTipText() {
        return "The regular expression to use for removing parts of the relation name, ignored if empty.";
    }

    public String getRelationFind() {
        return this.m_RelationFind;
    }

    public void setRelationFind(String value) {
        this.m_RelationFind = value;
    }

    public String relationReplaceTipText() {
        return "The string to replace all matches of the regular expression with.";
    }

    public String getRelationReplace() {
        return this.m_RelationReplace;
    }

    public void setRelationReplace(String value) {
        this.m_RelationReplace = value;
    }

    public String toString() {
        String result = "ExplicitTestsetResultProducer: ";
        result = result + this.getCompatibilityState();
        result = this.m_Instances == null ? result + ": <null Instances>" : result + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9540 $");
    }
}

