/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;

public class ResultMatrixPlainText
extends ResultMatrix {
    private static final long serialVersionUID = 1502934525382357937L;

    public ResultMatrixPlainText() {
        this(1, 1);
    }

    public ResultMatrixPlainText(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixPlainText(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the output as plain text (for fixed width fonts).";
    }

    @Override
    public String getDisplayName() {
        return "Plain Text";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 25;
    }

    @Override
    public int getDefaultCountWidth() {
        return 5;
    }

    @Override
    public String toStringHeader() {
        int i;
        String result = "";
        String[][] data = new String[this.m_HeaderKeys.size()][2];
        for (i = 0; i < this.m_HeaderKeys.size(); ++i) {
            data[i][0] = this.m_HeaderKeys.get(i).toString() + ":";
            data[i][1] = this.m_HeaderValues.get(i).toString();
        }
        int size = this.getColSize(data, 0);
        for (i = 0; i < data.length; ++i) {
            data[i][0] = this.padString(data[i][0], size);
        }
        for (i = 0; i < data.length; ++i) {
            result = result + data[i][0] + " " + data[i][1] + "\n";
        }
        return result;
    }

    @Override
    public String toStringMatrix() {
        String line;
        int i;
        int n;
        StringBuffer result = new StringBuffer();
        StringBuffer head = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer foot = new StringBuffer();
        String[][] cells = this.toArray();
        int[] startMeans = new int[this.getColCount()];
        int[] startSigs = new int[this.getColCount() - 1];
        int maxLength = 0;
        for (n = 1; n < cells[0].length; ++n) {
            int size = this.getColSize(cells, n, true, true);
            for (i = 1; i < cells.length - 1; ++i) {
                cells[i][n] = this.padString(cells[i][n], size, true);
            }
        }
        int indexBase = 1;
        if (this.getShowStdDev()) {
            ++indexBase;
        }
        int indexSecond = indexBase + 1;
        if (this.getShowStdDev()) {
            ++indexSecond;
        }
        int j = 0;
        int k = 0;
        for (i = 1; i < cells.length - 1; ++i) {
            if (this.isAverage(i)) {
                body.append(this.padString("", maxLength).replaceAll(".", "-") + "\n");
            }
            line = "";
            for (n = 0; n < cells[0].length; ++n) {
                if (i == 1) {
                    if (this.isMean(n)) {
                        startMeans[j] = line.length();
                        ++j;
                    }
                    if (this.isSignificance(n)) {
                        startSigs[k] = line.length();
                        ++k;
                    }
                }
                if (n == 0) {
                    line = line + this.padString(cells[i][n], this.getRowNameWidth());
                    line = !this.isAverage(i) ? line + this.padString("(" + Utils.doubleToString(this.getCount(this.getDisplayRow(i - 1)), 0) + ")", this.getCountWidth(), true) : line + this.padString("", this.getCountWidth(), true);
                } else {
                    if (this.isMean(n)) {
                        line = line + "  ";
                    }
                    line = this.getShowStdDev() ? (this.isMean(n - 1) ? (!cells[i][n].trim().equals("") ? line + "(" + cells[i][n] + ")" : line + " " + cells[i][n] + " ") : line + " " + cells[i][n]) : line + " " + cells[i][n];
                }
                if (n != indexBase) continue;
                line = line + " |";
            }
            if (i == 1) {
                maxLength = line.length();
            }
            body.append(line + "\n");
        }
        line = this.padString(cells[0][0], startMeans[0]);
        i = -1;
        for (n = 1; n < cells[0].length; ++n) {
            if (!this.isMean(n)) continue;
            if (++i == 0) {
                line = this.padString(line, startMeans[i] - this.getCountWidth());
            } else if (i == 1) {
                line = this.padString(line, startMeans[i] - " |".length());
            } else if (i > 1) {
                line = this.padString(line, startMeans[i]);
            }
            if (i == 1) {
                line = line + " |";
            }
            line = line + " " + cells[0][n];
        }
        line = this.padString(line, maxLength);
        head.append(line + "\n");
        head.append(line.replaceAll(".", "-") + "\n");
        body.append(line.replaceAll(".", "-") + "\n");
        if (this.getColCount() > 1) {
            line = this.padString(cells[cells.length - 1][0], startMeans[1] - 2, true) + " |";
            i = 0;
            for (n = 1; n < cells[cells.length - 1].length; ++n) {
                if (!this.isSignificance(n)) continue;
                line = this.padString(line, startSigs[i] + 1 - cells[cells.length - 1][n].length());
                line = line + " " + cells[cells.length - 1][n];
                ++i;
            }
            line = this.padString(line, maxLength);
        } else {
            line = this.padString(cells[cells.length - 1][0], line.length() - 2) + " |";
        }
        foot.append(line + "\n");
        result.append(head.toString());
        result.append(body.toString());
        result.append(foot.toString());
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "Key:\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            result = result + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + " " + this.removeFilterName(this.m_ColNames[i]) + "\n";
        }
        return result;
    }

    @Override
    public String toStringSummary() {
        int i;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "";
        String titles = "";
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            titles = titles + " " + Utils.padLeft("" + this.getSummaryTitle(i), resultsetLength * 2 + 3);
        }
        result = result + titles + "  (No. of datasets where [col] >> [row])\n";
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                result = result + " ";
                result = j == i ? result + Utils.padLeft("-", resultsetLength * 2 + 3) : result + Utils.padLeft("" + this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")", resultsetLength * 2 + 3);
            }
            result = result + " | " + this.getSummaryTitle(i) + " = " + this.getColName(i) + '\n';
        }
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = Utils.padLeft(">-<", width) + ' ' + Utils.padLeft(">", width) + ' ' + Utils.padLeft("<", width) + " Resultset\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int curr = ranking[i];
            if (this.getColHidden(curr)) continue;
            result = result + Utils.padLeft("" + this.m_RankingDiff[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingWins[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingLosses[curr], width) + ' ' + this.removeFilterName(this.m_ColNames[curr]) + '\n';
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        ResultMatrixPlainText matrix = new ResultMatrixPlainText(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i != n) continue;
                if (i % 2 == 1) {
                    matrix.setSignificance(n, i, 1);
                    continue;
                }
                matrix.setSignificance(n, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

