/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.cda;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.cda.Messages;

public class ParameterMappingTableModel
extends AbstractTableModel {
    private ArrayList<ParameterMapping> backend = new ArrayList();

    public ParameterMapping[] getMappings() {
        ArrayList<ParameterMapping> list = new ArrayList<ParameterMapping>(this.backend.size());
        for (int i = 0; i < this.backend.size(); ++i) {
            ParameterMapping mapping = this.backend.get(i);
            String sourceColumn = mapping.getName();
            String alias = mapping.getAlias();
            if (StringUtils.isEmpty((String)sourceColumn)) continue;
            if (StringUtils.isEmpty((String)alias)) {
                list.add(new ParameterMapping(sourceColumn, sourceColumn));
                continue;
            }
            list.add(new ParameterMapping(sourceColumn, alias));
        }
        return list.toArray(new ParameterMapping[list.size()]);
    }

    public void setMappings(ParameterMapping[] mappings) {
        this.backend.clear();
        this.backend.addAll(Arrays.asList(mappings));
        this.fireTableDataChanged();
    }

    public void addRow() {
        this.backend.add(new ParameterMapping("", ""));
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.backend.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Messages.getString("ParameterMappingTableModel.DataRowColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("ParameterMappingTableModel.TranformationParameter", new Object[0]);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.backend.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ParameterMapping mapping = this.backend.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mapping.getName();
            }
            case 1: {
                return mapping.getAlias();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ParameterMapping mapping = this.backend.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                String name = aValue == null ? "" : (String)aValue;
                String alias = mapping.getAlias();
                this.backend.set(rowIndex, new ParameterMapping(name, alias));
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 1: {
                String name = mapping.getName();
                String alias = aValue == null ? "" : (String)aValue;
                this.backend.set(rowIndex, new ParameterMapping(name, alias));
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }
}

