/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckerException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AllSameExpressionVisitor;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class TypeCheckingExpVisitor
extends LogicalExpressionVisitor {
    private CompilationMessageCollector msgCollector;
    private LogicalRelationalOperator currentRelOp;
    private static final int INF = -1;
    static final HashMap<Byte, List<Byte>> castLookup = new HashMap();

    public TypeCheckingExpVisitor(OperatorPlan expPlan, CompilationMessageCollector msgCollector, LogicalRelationalOperator relOp) throws FrontendException {
        super(expPlan, new ReverseDependencyOrderWalker(expPlan));
        this.msgCollector = msgCollector;
        this.currentRelOp = relOp;
        FieldSchemaResetter sr = new FieldSchemaResetter(expPlan);
        sr.visit();
    }

    @Override
    public void visit(AddExpression binOp) throws FrontendException {
        this.addCastsToNumericBinExpression(binOp);
    }

    @Override
    public void visit(SubtractExpression binOp) throws FrontendException {
        this.addCastsToNumericBinExpression(binOp);
    }

    @Override
    public void visit(MultiplyExpression binOp) throws FrontendException {
        this.addCastsToNumericBinExpression(binOp);
    }

    @Override
    public void visit(DivideExpression binOp) throws FrontendException {
        this.addCastsToNumericBinExpression(binOp);
    }

    private void addCastsToNumericBinExpression(BinaryExpression binOp) throws FrontendException {
        LogicalExpression lhs = binOp.getLhs();
        LogicalExpression rhs = binOp.getRhs();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertCast((LogicalExpression)binOp, biggerType, binOp.getLhs());
            } else if (rhsType != biggerType) {
                this.insertCast((LogicalExpression)binOp, biggerType, binOp.getRhs());
            }
        } else if (lhsType == 50 && DataType.isNumberType(rhsType)) {
            this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
        } else if (rhsType == 50 && DataType.isNumberType(lhsType)) {
            this.insertCast((LogicalExpression)binOp, lhsType, binOp.getRhs());
        } else if (lhsType == 50 && rhsType == 50) {
            this.insertCast((LogicalExpression)binOp, (byte)25, binOp.getLhs());
            this.insertCast((LogicalExpression)binOp, (byte)25, binOp.getRhs());
        } else {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)binOp, msg, errCode, 2);
        }
    }

    @Override
    public void visit(ModExpression binOp) throws FrontendException {
        LogicalExpression lhs = binOp.getLhs();
        LogicalExpression rhs = binOp.getRhs();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        boolean error = false;
        if (lhsType == 10) {
            if (rhsType != 10) {
                if (rhsType == 15 || rhsType == 65) {
                    this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
                } else {
                    error = true;
                }
            }
        } else if (lhsType == 15) {
            if (rhsType == 10) {
                this.insertCast((LogicalExpression)binOp, lhsType, binOp.getRhs());
            } else if (rhsType == 65) {
                this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
            } else if (rhsType != 15) {
                error = true;
            }
        } else if (lhsType == 65) {
            if (rhsType == 10 || rhsType == 15) {
                this.insertCast((LogicalExpression)binOp, lhsType, binOp.getRhs());
            } else if (rhsType != 65) {
                error = true;
            }
        } else if (lhsType == 50) {
            if (rhsType == 10 || rhsType == 15 || rhsType == 65) {
                this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
            } else {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            int errCode = 1039;
            String msg = this.generateIncompatibleTypesMessage(binOp);
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)binOp, msg, errCode, 2);
        }
    }

    private String generateIncompatibleTypesMessage(BinaryExpression binOp) throws FrontendException {
        String msg = binOp.toString();
        if (this.currentRelOp.getAlias() != null) {
            msg = "In alias " + this.currentRelOp.getAlias() + ", ";
        }
        LogicalSchema.LogicalFieldSchema lhsFs = binOp.getLhs().getFieldSchema();
        LogicalSchema.LogicalFieldSchema rhsFs = binOp.getRhs().getFieldSchema();
        msg = msg + "incompatible types in " + binOp.getName() + " Operator" + " left hand side:" + DataType.findTypeName(lhsFs.type) + (lhsFs.schema == null ? "" : " " + lhsFs.schema.toString(false) + " ") + " right hand side:" + DataType.findTypeName(rhsFs.type) + (rhsFs.schema == null ? "" : " " + rhsFs.schema.toString(false) + " ");
        return msg;
    }

    @Override
    public void visit(NegativeExpression negExp) throws FrontendException {
        byte type = negExp.getExpression().getType();
        if (!DataType.isNumberType(type)) {
            if (type == 50) {
                this.insertCast((LogicalExpression)negExp, (byte)25, negExp.getExpression());
            } else {
                int errCode = 1041;
                String msg = "NEG can be used with numbers or Bytearray only";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException((Operator)negExp, msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(NotExpression notExp) throws FrontendException {
        byte type;
        if (notExp.getExpression() instanceof ConstantExpression && ((ConstantExpression)notExp.getExpression()).getValue() == null) {
            this.insertCast((LogicalExpression)notExp, (byte)5, notExp.getExpression());
        }
        if ((type = notExp.getExpression().getType()) != 5) {
            int errCode = 1042;
            String msg = "NOT can be used with boolean only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)notExp, msg, errCode, 2);
        }
    }

    @Override
    public void visit(OrExpression orExp) throws FrontendException {
        this.visitBooleanBinary(orExp);
    }

    @Override
    public void visit(AndExpression andExp) throws FrontendException {
        this.visitBooleanBinary(andExp);
    }

    private void visitBooleanBinary(BinaryExpression boolExp) throws FrontendException {
        this.insertCastsForNullToBoolean(boolExp);
        LogicalExpression lhs = boolExp.getLhs();
        LogicalExpression rhs = boolExp.getRhs();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (lhsType != 5 || rhsType != 5) {
            int errCode = 1038;
            String msg = "Operands of AND/OR can be boolean only";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)boolExp, msg, errCode, 2);
        }
    }

    @Override
    public void visit(LessThanExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, false);
    }

    @Override
    public void visit(LessThanEqualExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, false);
    }

    @Override
    public void visit(GreaterThanExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, false);
    }

    @Override
    public void visit(GreaterThanEqualExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, false);
    }

    @Override
    public void visit(EqualExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, true);
    }

    @Override
    public void visit(NotEqualExpression binOp) throws FrontendException {
        this.addCastsToCompareBinaryExp(binOp, true);
    }

    private void addCastsToCompareBinaryExp(BinaryExpression binOp, boolean isEquality) throws FrontendException {
        LogicalExpression lhs = binOp.getLhs();
        LogicalExpression rhs = binOp.getRhs();
        byte lhsType = lhs.getType();
        byte rhsType = rhs.getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (lhsType != biggerType) {
                this.insertCast((LogicalExpression)binOp, biggerType, binOp.getLhs());
            } else if (rhsType != biggerType) {
                this.insertCast((LogicalExpression)binOp, biggerType, binOp.getRhs());
            }
        } else if (!(lhsType == 30 && rhsType == 30 || lhsType == 55 && rhsType == 55 || lhsType == 50 && rhsType == 50)) {
            if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType) || rhsType == 5 || rhsType == 30)) {
                this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
            } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType) || lhsType == 5 || lhsType == 30)) {
                this.insertCast((LogicalExpression)binOp, lhsType, binOp.getRhs());
            } else if (isEquality) {
                if (!(lhsType == 5 && rhsType == 5 || lhsType == 110 && rhsType == 110 || lhsType == 100 && rhsType == 100)) {
                    if (lhsType == 50 && (rhsType == 100 || rhsType == 110)) {
                        this.insertCast((LogicalExpression)binOp, rhsType, binOp.getLhs());
                    } else if (rhsType == 50 && (lhsType == 100 || lhsType == 110)) {
                        this.insertCast((LogicalExpression)binOp, lhsType, binOp.getRhs());
                    } else {
                        this.throwIncompatibleTypeError(binOp);
                    }
                }
            } else {
                this.throwIncompatibleTypeError(binOp);
            }
        }
    }

    private void throwIncompatibleTypeError(BinaryExpression binOp) throws FrontendException {
        int errCode = 1039;
        String msg = this.generateIncompatibleTypesMessage(binOp);
        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
        throw new TypeCheckerException((Operator)binOp, msg, errCode, 2);
    }

    private void insertCastsForNullToBoolean(BinaryExpression binOp) throws FrontendException {
        if (binOp.getLhs() instanceof ConstantExpression && ((ConstantExpression)binOp.getLhs()).getValue() == null) {
            this.insertCast((LogicalExpression)binOp, (byte)5, binOp.getLhs());
        }
        if (binOp.getRhs() instanceof ConstantExpression && ((ConstantExpression)binOp.getRhs()).getValue() == null) {
            this.insertCast((LogicalExpression)binOp, (byte)5, binOp.getRhs());
        }
    }

    private void insertCast(LogicalExpression exp, byte toType, LogicalExpression arg) throws FrontendException {
        LogicalSchema.LogicalFieldSchema toFs = new LogicalSchema.LogicalFieldSchema(null, null, toType);
        this.insertCast(exp, toFs, arg);
    }

    private void insertCast(LogicalExpression node, LogicalSchema.LogicalFieldSchema toFs, LogicalExpression arg) throws FrontendException {
        TypeCheckingExpVisitor.collectCastWarning(node, arg.getType(), toFs.type, this.msgCollector);
        CastExpression cast = new CastExpression(this.plan, arg, toFs);
        try {
            this.plan.disconnect(cast, arg);
            this.plan.insertBetween(node, cast, arg);
        }
        catch (PlanException pe) {
            int errCode = 2059;
            String msg = "Problem with inserting cast operator for " + node + " in plan.";
            throw new TypeCheckerException(arg, msg, errCode, 4, pe);
        }
        this.visit(cast);
    }

    @Override
    public void visit(CastExpression cast) throws FrontendException {
        boolean castable;
        byte inType = cast.getExpression().getType();
        byte outType = cast.getType();
        if (outType == 50) {
            int errCode = 1051;
            String msg = "Cannot cast to bytearray";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)cast, msg, errCode, 2);
        }
        LogicalSchema.LogicalFieldSchema inFs = cast.getExpression().getFieldSchema();
        LogicalSchema.LogicalFieldSchema outFs = cast.getFieldSchema();
        if (inFs == null) {
            inFs = new LogicalSchema.LogicalFieldSchema(null, null, 50);
        }
        if (!(castable = LogicalSchema.LogicalFieldSchema.castable(inFs, outFs))) {
            int errCode = 1052;
            String msg = "Cannot cast " + DataType.findTypeName(inType) + (DataType.isSchemaType(inType) ? " with schema " + inFs.toString(false) : "") + " to " + DataType.findTypeName(outType) + (DataType.isSchemaType(outType) ? " with schema " + outFs.toString(false) : "");
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)cast, msg, errCode, 2);
        }
    }

    @Override
    public void visit(RegexExpression rg) throws FrontendException {
        if (rg.getLhs().getType() == 50) {
            this.insertCast((LogicalExpression)rg, (byte)55, rg.getLhs());
        }
        if (rg.getRhs().getType() == 50) {
            this.insertCast((LogicalExpression)rg, (byte)55, rg.getRhs());
        }
        if (rg.getLhs().getType() != 55 || rg.getRhs().getType() != 55) {
            int errCode = 1037;
            String msg = "Operands of Regex can be CharArray only :" + rg;
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)rg, msg, errCode, 2);
        }
    }

    @Override
    public void visit(BinCondExpression binCond) throws FrontendException {
        if (binCond.getCondition().getType() != 5) {
            int errCode = 1047;
            String msg = "Condition in BinCond must be boolean";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)binCond, msg, errCode, 2);
        }
        byte lhsType = binCond.getLhs().getType();
        byte rhsType = binCond.getRhs().getType();
        if (DataType.isNumberType(lhsType) && DataType.isNumberType(rhsType)) {
            byte biggerType;
            byte by = biggerType = lhsType > rhsType ? lhsType : rhsType;
            if (biggerType > lhsType) {
                this.insertCast((LogicalExpression)binCond, biggerType, binCond.getLhs());
            } else if (biggerType > rhsType) {
                this.insertCast((LogicalExpression)binCond, biggerType, binCond.getRhs());
            }
        } else if (lhsType == 50 && (rhsType == 55 || DataType.isNumberType(rhsType)) || rhsType == 30) {
            this.insertCast((LogicalExpression)binCond, rhsType, binCond.getLhs());
        } else if (rhsType == 50 && (lhsType == 55 || DataType.isNumberType(lhsType) || rhsType == 30)) {
            this.insertCast((LogicalExpression)binCond, lhsType, binCond.getRhs());
        } else {
            if (binCond.getLhs() instanceof ConstantExpression && ((ConstantExpression)binCond.getLhs()).getValue() == null) {
                try {
                    this.insertCast((LogicalExpression)binCond, binCond.getRhs().getFieldSchema(), binCond.getLhs());
                }
                catch (FrontendException e) {
                    int errCode = 2216;
                    String msg = "Problem getting fieldSchema for " + binCond.getRhs();
                    throw new TypeCheckerException(binCond, msg, errCode, 4, e);
                }
            }
            if (binCond.getRhs() instanceof ConstantExpression && ((ConstantExpression)binCond.getRhs()).getValue() == null) {
                try {
                    this.insertCast((LogicalExpression)binCond, binCond.getLhs().getFieldSchema(), binCond.getRhs());
                }
                catch (FrontendException e) {
                    int errCode = 2216;
                    String msg = "Problem getting fieldSchema for " + binCond.getRhs();
                    throw new TypeCheckerException(binCond, msg, errCode, 4, e);
                }
            }
            if (lhsType == rhsType) {
                if (DataType.isSchemaType(lhsType)) {
                    try {
                        if (!binCond.getLhs().getFieldSchema().isEqual(binCond.getRhs().getFieldSchema())) {
                            int errCode = 1048;
                            String msg = "Two inputs of BinCond must have compatible schemas. left hand side: " + binCond.getLhs().getFieldSchema() + " right hand side: " + binCond.getRhs().getFieldSchema();
                            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                            throw new TypeCheckerException((Operator)binCond, msg, errCode, 2);
                        }
                    }
                    catch (FrontendException fe) {
                        int errCode = 1049;
                        String msg = "Problem during evaluaton of BinCond output type";
                        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException(binCond, msg, errCode, 2, fe);
                    }
                }
            } else {
                int errCode = 1050;
                String msg = "Unsupported input type for BinCond: left hand side: " + DataType.findTypeName(lhsType) + "; right hand side: " + DataType.findTypeName(rhsType);
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException((Operator)binCond, msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(MapLookupExpression map) throws FrontendException {
        if (map.getMap().getType() != 100) {
            this.insertCast((LogicalExpression)map, (byte)100, map.getMap());
        }
    }

    @Override
    public void visit(DereferenceExpression deref) throws FrontendException {
        byte inputType = deref.getReferredExpression().getType();
        switch (inputType) {
            case 50: 
            case 110: 
            case 120: {
                break;
            }
            default: {
                int errCode = 1129;
                String msg = "Referring to column(s) within a column of type " + DataType.findTypeName(inputType) + " is not allowed";
                throw new TypeCheckerException((Operator)deref, msg, errCode, 2);
            }
        }
    }

    @Override
    public void visit(UserFuncExpression func) throws FrontendException {
        List<LogicalExpression> list = func.getArguments();
        Schema currentArgSchema = new Schema();
        for (LogicalExpression op : list) {
            if (!DataType.isUsableType(op.getType())) {
                int errCode = 1014;
                String msg = "Problem with input " + op + " of User-defined function: " + func;
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException((Operator)func, msg, errCode, 2);
            }
            try {
                currentArgSchema.add(Util.translateFieldSchema(op.getFieldSchema()));
            }
            catch (FrontendException e) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(func, msg, errCode, 2, e);
            }
        }
        EvalFunc ef = (EvalFunc)PigContext.instantiateFuncFromSpec(func.getFuncSpec());
        List<FuncSpec> funcSpecs = null;
        try {
            funcSpecs = ef.getArgToFuncMapping();
            if (funcSpecs != null) {
                for (FuncSpec funcSpec : funcSpecs) {
                    Schema s = funcSpec.getInputArgsSchema();
                    LogicalSchema ls = Util.translateSchema(s);
                    ls.normalize();
                    funcSpec.setInputArgsSchema(Util.translateSchema(ls));
                }
            }
        }
        catch (Exception e) {
            int errCode = 1044;
            String msg = "Unable to get list of overloaded methods.";
            throw new TypeCheckerException(func, msg, errCode, 2, e);
        }
        FuncSpec matchingSpec = null;
        boolean notExactMatch = false;
        if (funcSpecs != null && funcSpecs.size() != 0 && (matchingSpec = this.exactMatch(funcSpecs, currentArgSchema, func)) == null) {
            String msg;
            notExactMatch = true;
            if (this.byteArrayFound(func, currentArgSchema)) {
                matchingSpec = this.exactMatchWithByteArrays(funcSpecs, currentArgSchema, func);
                if (matchingSpec == null && (matchingSpec = this.bestFitMatchWithByteArrays(funcSpecs, currentArgSchema, func)) == null) {
                    int errCode = 1045;
                    msg = "Could not infer the matching function for " + func.getFuncSpec() + " as multiple or none of them fit. Please use an explicit cast.";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException((Operator)func, msg, errCode, 2);
                }
            } else {
                matchingSpec = this.bestFitMatch(funcSpecs, currentArgSchema);
                if (matchingSpec == null) {
                    int errCode = 1045;
                    msg = "Could not infer the matching function for " + func.getFuncSpec() + " as multiple or none of them fit. Please use an explicit cast.";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                    throw new TypeCheckerException((Operator)func, msg, errCode, 2);
                }
            }
        }
        if (matchingSpec != null) {
            if (notExactMatch) {
                String msg = "Function " + func.getFuncSpec().getClassName() + "()" + " will be called with following argument types: " + matchingSpec.getInputArgsSchema() + ". If you want to use " + "different input argument types, please use explicit casts.";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Warning, PigWarning.USING_OVERLOADED_FUNCTION);
            }
            if (func.isViaDefine()) {
                matchingSpec.setCtorArgs(func.getFuncSpec().getCtorArgs());
            }
            func.setFuncSpec(matchingSpec);
            this.insertCastsForUDF(func, currentArgSchema, matchingSpec.getInputArgsSchema());
        }
    }

    private FuncSpec bestFitMatchWithByteArrays(List<FuncSpec> funcSpecs, Schema s, UserFuncExpression func) throws VisitorException {
        ArrayList<Pair<Long, FuncSpec>> scoreFuncSpecList = new ArrayList<Pair<Long, FuncSpec>>();
        for (FuncSpec fs : funcSpecs) {
            long score = this.fitPossible(s, fs.getInputArgsSchema());
            if (score == -1L) continue;
            scoreFuncSpecList.add(new Pair<Long, FuncSpec>(score, fs));
        }
        if (scoreFuncSpecList.size() == 0) {
            return null;
        }
        if (scoreFuncSpecList.size() > 1) {
            Collections.sort(scoreFuncSpecList, new ScoreFuncSpecListComparator());
            if (((Pair)scoreFuncSpecList.get((int)0)).first == ((Pair)scoreFuncSpecList.get((int)1)).first) {
                int errCode = 1046;
                String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schemas: " + "(" + ((FuncSpec)((Pair)scoreFuncSpecList.get((int)0)).second).getInputArgsSchema() + ", " + ((FuncSpec)((Pair)scoreFuncSpecList.get((int)1)).second).getInputArgsSchema() + "). Please use an explicit cast.";
                this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                throw new TypeCheckerException((Operator)func, msg, errCode, 2);
            }
            List<Integer> byteArrayPositions = this.getByteArrayPositions(func, s);
            HashMap<Integer, Pair<FuncSpec, Byte>> castToMap = new HashMap<Integer, Pair<FuncSpec, Byte>>();
            Iterator it = scoreFuncSpecList.iterator();
            while (it.hasNext()) {
                FuncSpec funcSpec = (FuncSpec)((Pair)it.next()).second;
                Schema sch = funcSpec.getInputArgsSchema();
                for (Integer i : byteArrayPositions) {
                    try {
                        if (!castToMap.containsKey(i)) {
                            castToMap.put(i, new Pair<FuncSpec, Byte>(funcSpec, sch.getField((int)i.intValue()).type));
                            continue;
                        }
                        Pair existingPair = (Pair)castToMap.get(i);
                        if (sch.getField((int)i.intValue()).type == (Byte)existingPair.second) continue;
                        int errCode = 1046;
                        String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schema: " + "(" + ((FuncSpec)existingPair.first).getInputArgsSchema() + ", " + funcSpec.getInputArgsSchema() + "). Please use an explicit cast.";
                        this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
                        throw new TypeCheckerException((Operator)func, msg, errCode, 2);
                    }
                    catch (FrontendException fee) {
                        int errCode = 1043;
                        String msg = "Unalbe to retrieve field schema.";
                        throw new TypeCheckerException(func, msg, errCode, 2, fee);
                    }
                }
            }
        }
        return (FuncSpec)((Pair)scoreFuncSpecList.get((int)0)).second;
    }

    private FuncSpec exactMatchWithByteArrays(List<FuncSpec> funcSpecs, Schema s, UserFuncExpression func) throws FrontendException {
        return this.exactMatchHelper(funcSpecs, s, func, true);
    }

    private FuncSpec exactMatch(List<FuncSpec> funcSpecs, Schema s, UserFuncExpression func) throws FrontendException {
        return this.exactMatchHelper(funcSpecs, s, func, false);
    }

    private FuncSpec bestFitMatch(List<FuncSpec> funcSpecs, Schema s) {
        FuncSpec matchingSpec = null;
        long score = -1L;
        long prevBestScore = Long.MAX_VALUE;
        long bestScore = Long.MAX_VALUE;
        for (FuncSpec fs : funcSpecs) {
            score = this.fitPossible(s, fs.getInputArgsSchema());
            if (score == -1L || score > bestScore) continue;
            matchingSpec = fs;
            prevBestScore = bestScore;
            bestScore = score;
        }
        if (matchingSpec != null && bestScore != prevBestScore) {
            return matchingSpec;
        }
        return null;
    }

    private boolean byteArrayFound(UserFuncExpression func, Schema s) throws VisitorException {
        for (int i = 0; i < s.size(); ++i) {
            try {
                Schema.FieldSchema fs = s.getField(i);
                if (fs == null) {
                    return false;
                }
                if (fs.type != 50) continue;
                return true;
            }
            catch (FrontendException fee) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(func, msg, errCode, 2, fee);
            }
        }
        return false;
    }

    private List<Integer> getByteArrayPositions(UserFuncExpression func, Schema s) throws VisitorException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < s.size(); ++i) {
            try {
                Schema.FieldSchema fs = s.getField(i);
                if (fs.type != 50) continue;
                result.add(i);
                continue;
            }
            catch (FrontendException fee) {
                int errCode = 1043;
                String msg = "Unable to retrieve field schema.";
                throw new TypeCheckerException(func, msg, errCode, 2, fee);
            }
        }
        return result;
    }

    private FuncSpec exactMatchHelper(List<FuncSpec> funcSpecs, Schema s, UserFuncExpression func, boolean ignoreByteArrays) throws FrontendException {
        ArrayList<FuncSpec> matchingSpecs = new ArrayList<FuncSpec>();
        for (FuncSpec fs : funcSpecs) {
            if (!TypeCheckingExpVisitor.schemaEqualsForMatching(s, fs.getInputArgsSchema(), ignoreByteArrays)) continue;
            matchingSpecs.add(fs);
        }
        if (matchingSpecs.size() == 0) {
            return null;
        }
        if (matchingSpecs.size() > 1) {
            int errCode = 1046;
            String msg = "Multiple matching functions for " + func.getFuncSpec() + " with input schema: " + "(" + ((FuncSpec)matchingSpecs.get(0)).getInputArgsSchema() + ", " + ((FuncSpec)matchingSpecs.get(1)).getInputArgsSchema() + "). Please use an explicit cast.";
            this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Error);
            throw new TypeCheckerException((Operator)func, msg, errCode, 2);
        }
        return (FuncSpec)matchingSpecs.get(0);
    }

    public static boolean schemaEqualsForMatching(Schema inputSchema, Schema udfSchema, boolean ignoreByteArrays) throws FrontendException {
        if (inputSchema == null && udfSchema == null) {
            return true;
        }
        if (inputSchema == null) {
            return false;
        }
        if (udfSchema == null) {
            return false;
        }
        udfSchema = Util.fixSchemaAddTupleInBag(udfSchema);
        if (inputSchema.size() != udfSchema.size()) {
            return false;
        }
        Iterator<Schema.FieldSchema> i = inputSchema.getFields().iterator();
        Iterator<Schema.FieldSchema> j = udfSchema.getFields().iterator();
        while (i.hasNext()) {
            Schema.FieldSchema inputFieldSchema = i.next();
            Schema.FieldSchema udfFieldSchema = j.next();
            if (inputFieldSchema == null) {
                return false;
            }
            if (ignoreByteArrays && inputFieldSchema.type == 50) continue;
            if (inputFieldSchema.type != udfFieldSchema.type) {
                return false;
            }
            if (!DataType.isSchemaType(udfFieldSchema.type) || udfFieldSchema.schema == null || !TypeCheckingExpVisitor.isNotBagWithEmptyTuple(udfFieldSchema) || Schema.FieldSchema.equals(inputFieldSchema, udfFieldSchema, false, true)) continue;
            Schema.FieldSchema inputFSWithBytearrayinTuple = new Schema.FieldSchema(inputFieldSchema);
            TypeCheckingExpVisitor.convertEmptyTupleToBytearrayTuple(inputFSWithBytearrayinTuple);
            if (Schema.FieldSchema.equals(inputFSWithBytearrayinTuple, udfFieldSchema, false, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotBagWithEmptyTuple(Schema.FieldSchema fieldSch) throws FrontendException {
        boolean isBagWithEmptyTuple = false;
        if (fieldSch.type == 120 && fieldSch.schema != null && fieldSch.schema.getField(0) != null && fieldSch.schema.getField((int)0).type == 110 && fieldSch.schema.getField((int)0).schema == null) {
            isBagWithEmptyTuple = true;
        }
        return !isBagWithEmptyTuple;
    }

    private static void convertEmptyTupleToBytearrayTuple(Schema.FieldSchema fs) {
        if (fs.type == 110 && fs.schema != null && fs.schema.size() == 0) {
            fs.schema.add(new Schema.FieldSchema(null, 50));
            return;
        }
        if (fs.schema != null) {
            for (Schema.FieldSchema inFs : fs.schema.getFields()) {
                TypeCheckingExpVisitor.convertEmptyTupleToBytearrayTuple(inFs);
            }
        }
    }

    private long fitPossible(Schema s1, Schema s2) {
        if (s1 == null || s2 == null) {
            return -1L;
        }
        List<Schema.FieldSchema> sFields = s1.getFields();
        List<Schema.FieldSchema> fsFields = s2.getFields();
        if (sFields.size() != fsFields.size()) {
            return -1L;
        }
        long score = 0L;
        int castCnt = 0;
        for (int i = 0; i < sFields.size(); ++i) {
            Schema.FieldSchema sFS = sFields.get(i);
            if (sFS == null) {
                return -1L;
            }
            if (sFS.type == 50) continue;
            Schema.FieldSchema fsFS = fsFields.get(i);
            if (DataType.isSchemaType(sFS.type) && !Schema.FieldSchema.equals(sFS, fsFS, false, true)) {
                return -1L;
            }
            if (Schema.FieldSchema.equals(sFS, fsFS, true, true)) continue;
            if (!castLookup.containsKey(sFS.type)) {
                return -1L;
            }
            if (!castLookup.get(sFS.type).contains(fsFS.type)) {
                return -1L;
            }
            score += (long)(castLookup.get(sFS.type).indexOf(fsFS.type) + 1);
            ++castCnt;
        }
        return score * (long)castCnt;
    }

    private void insertCastsForUDF(UserFuncExpression func, Schema fromSch, Schema toSch) throws FrontendException {
        List<Schema.FieldSchema> fsLst = fromSch.getFields();
        List<Schema.FieldSchema> tsLst = toSch.getFields();
        List<LogicalExpression> args = func.getArguments();
        int i = -1;
        for (Schema.FieldSchema fFSch : fsLst) {
            Schema.FieldSchema tFSch = tsLst.get(++i);
            if (fFSch.type == tFSch.type) continue;
            this.insertCast((LogicalExpression)func, Util.translateFieldSchema(tFSch), args.get(i));
        }
    }

    static void collectCastWarning(Operator node, byte originalType, byte toType, CompilationMessageCollector msgCollector) {
        String originalTypeName = DataType.findTypeName(originalType);
        String toTypeName = DataType.findTypeName(toType);
        String opName = node.getClass().getSimpleName();
        PigWarning kind = null;
        switch (toType) {
            case 120: {
                kind = PigWarning.IMPLICIT_CAST_TO_BAG;
                break;
            }
            case 55: {
                kind = PigWarning.IMPLICIT_CAST_TO_CHARARRAY;
                break;
            }
            case 25: {
                kind = PigWarning.IMPLICIT_CAST_TO_DOUBLE;
                break;
            }
            case 20: {
                kind = PigWarning.IMPLICIT_CAST_TO_FLOAT;
                break;
            }
            case 10: {
                kind = PigWarning.IMPLICIT_CAST_TO_INT;
                break;
            }
            case 15: {
                kind = PigWarning.IMPLICIT_CAST_TO_LONG;
                break;
            }
            case 5: {
                kind = PigWarning.IMPLICIT_CAST_TO_BOOLEAN;
                break;
            }
            case 30: {
                kind = PigWarning.IMPLICIT_CAST_TO_DATETIME;
                break;
            }
            case 100: {
                kind = PigWarning.IMPLICIT_CAST_TO_MAP;
                break;
            }
            case 110: {
                kind = PigWarning.IMPLICIT_CAST_TO_TUPLE;
                break;
            }
            case 65: {
                kind = PigWarning.IMPLICIT_CAST_TO_BIGINTEGER;
                break;
            }
            case 70: {
                kind = PigWarning.IMPLICIT_CAST_TO_BIGDECIMAL;
            }
        }
        msgCollector.collect(originalTypeName + " is implicitly cast to " + toTypeName + " under " + opName + " Operator", CompilationMessageCollector.MessageType.Warning, kind);
    }

    static {
        List<Byte> boolToTypes = Arrays.asList((byte)10, (byte)15, (byte)20, (byte)25, (byte)65, (byte)70);
        castLookup.put((byte)5, boolToTypes);
        List<Byte> intToTypes = Arrays.asList((byte)15, (byte)20, (byte)25, (byte)65, (byte)70);
        castLookup.put((byte)10, intToTypes);
        List<Byte> longToTypes = Arrays.asList((byte)20, (byte)25, (byte)65, (byte)70);
        castLookup.put((byte)15, longToTypes);
        List<Byte> floatToTypes = Arrays.asList((byte)25, (byte)65, (byte)70);
        castLookup.put((byte)20, floatToTypes);
        List<Byte> doubleToTypes = Arrays.asList((byte)65, (byte)70);
        castLookup.put((byte)25, doubleToTypes);
        List<Byte> bigIntegerToTypes = Arrays.asList((byte)70);
        castLookup.put((byte)65, bigIntegerToTypes);
        List<Byte> byteArrayToTypes = Arrays.asList((byte)5, (byte)10, (byte)15, (byte)20, (byte)25, (byte)30, (byte)55, (byte)65, (byte)70, (byte)110, (byte)120, (byte)100);
        castLookup.put((byte)50, byteArrayToTypes);
    }

    static class FieldSchemaResetter
    extends AllSameExpressionVisitor {
        protected FieldSchemaResetter(OperatorPlan p) throws FrontendException {
            super(p, new ReverseDependencyOrderWalker(p));
        }

        @Override
        protected void execute(LogicalExpression op) throws FrontendException {
            op.resetFieldSchema();
        }
    }

    private static class ScoreFuncSpecListComparator
    implements Comparator<Pair<Long, FuncSpec>> {
        private ScoreFuncSpecListComparator() {
        }

        @Override
        public int compare(Pair<Long, FuncSpec> o1, Pair<Long, FuncSpec> o2) {
            if ((Long)o1.first < (Long)o2.first) {
                return -1;
            }
            if ((Long)o1.first > (Long)o2.first) {
                return 1;
            }
            return 0;
        }
    }
}

