/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.legacycharts;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.extensions.legacycharts.LegacyChartsUtil;
import org.pentaho.reporting.designer.extensions.legacycharts.Messages;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.extensions.legacy.charts.LegacyChartType;

public class EditLegacyChartAction
extends AbstractElementSelectionAction {
    private ReportModelEventFilter eventFilter;

    public EditLegacyChartAction() {
        this.putValue("Name", Messages.getInstance().getString("EditLegacyChartAction.Text"));
        this.putValue("ShortDescription", Messages.getInstance().getString("EditLegacyChartAction.Description"));
        this.putValue("MnemonicKey", Messages.getInstance().getOptionalMnemonic("EditLegacyChartAction.Mnemonic"));
        this.putValue("AcceleratorKey", Messages.getInstance().getOptionalKeyStroke("EditLegacyChartAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createAttributeFilter("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
    }

    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (selectedElement instanceof Section) {
            this.setEnabled(false);
            return;
        }
        if (selectedElement instanceof Element) {
            Element element = (Element)selectedElement;
            this.setEnabled(element.getElementType() instanceof LegacyChartType);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        if (selectionModel.getSelectionCount() != 1) {
            return;
        }
        Object selectedElement = selectionModel.getSelectedElement(0);
        if (!(selectedElement instanceof Element) || selectedElement instanceof Section) {
            return;
        }
        Element chartElement = (Element)selectedElement;
        if (!LegacyChartsUtil.isLegacyChartElement(chartElement)) {
            return;
        }
        LegacyChartsUtil.performEdit(chartElement, this.getReportDesignerContext());
    }
}

