/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.util.XLog;

public class MaprJobClient
extends JobClient {
    private static ExecutorService threadExecutor = Executors.newFixedThreadPool(20);
    private final int timeOut = 60000;

    public MaprJobClient() {
    }

    public MaprJobClient(JobConf conf) throws IOException {
        super(conf);
    }

    public void init(JobConf conf) throws IOException {
        super.init(conf);
    }

    public static void shutdown() {
        threadExecutor.shutdown();
    }

    public RunningJob getJob(final JobID jobid) throws IOException {
        RunningJob runJob;
        block5: {
            Callable<RunningJob> callTask = new Callable<RunningJob>(){

                @Override
                public RunningJob call() throws Exception {
                    return MaprJobClient.super.getJob(jobid);
                }
            };
            ArrayList<1> callableList = new ArrayList<1>();
            callableList.add(callTask);
            runJob = null;
            try {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("Making jobClient call");
                runJob = (RunningJob)threadExecutor.invokeAny(callableList, 60000L, TimeUnit.MILLISECONDS);
                XLog.getLog(((Object)((Object)this)).getClass()).debug("jobClient call is successful");
            }
            catch (InterruptedException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got InterruptedExeption");
            }
            catch (ExecutionException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got ExecutionException");
            }
            catch (TimeoutException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got TimeoutException");
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block5;
                throw (IOException)e;
            }
        }
        return runJob;
    }

    public void close() throws IOException {
        block5: {
            Callable<Void> callTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MaprJobClient.super.close();
                    return null;
                }
            };
            ArrayList<2> callableList = new ArrayList<2>();
            callableList.add(callTask);
            try {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("Making jobClient call");
                threadExecutor.invokeAny(callableList, 60000L, TimeUnit.MILLISECONDS);
                XLog.getLog(((Object)((Object)this)).getClass()).debug("jobClient call is successful");
            }
            catch (InterruptedException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got InterruptedExeption");
            }
            catch (ExecutionException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got ExecutionException");
            }
            catch (TimeoutException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got TimeoutException");
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block5;
                throw (IOException)e;
            }
        }
    }

    String getSubmitjobClasspath() {
        File dir = new File(System.getProperty("oozie.home.dir") + "/oozie-server/webapps/oozie/WEB-INF/lib/");
        if (!dir.isDirectory()) {
            return null;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("jar");
            }
        };
        String[] files = dir.list(filter);
        String cp = "";
        for (int i = 0; i < files.length; ++i) {
            cp = cp + ":" + dir.getAbsolutePath() + "/" + files[i];
        }
        return cp;
    }

    RunningJob submitJobDirectly(final JobConf job) throws FileNotFoundException, IOException {
        RunningJob runJob;
        block6: {
            Callable<RunningJob> callTask = new Callable<RunningJob>(){

                @Override
                public RunningJob call() throws Exception {
                    return MaprJobClient.super.submitJob(job);
                }
            };
            ArrayList<4> callableList = new ArrayList<4>();
            callableList.add(callTask);
            runJob = null;
            try {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("Making direct jobSubmit call");
                runJob = (RunningJob)threadExecutor.invokeAny(callableList, 60000L, TimeUnit.MILLISECONDS);
                XLog.getLog(((Object)((Object)this)).getClass()).debug("jobClient call is successful");
            }
            catch (InterruptedException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got InterruptedExeption");
            }
            catch (ExecutionException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got ExecutionException");
            }
            catch (TimeoutException e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got TimeoutException");
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    throw (FileNotFoundException)e;
                }
                if (!(e instanceof IOException)) break block6;
                throw (IOException)e;
            }
        }
        return runJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningJob submitJob(JobConf job) throws FileNotFoundException, IOException {
        JobID newJobId;
        if (System.getProperty("user.name").compareTo(job.getUser()) == 0) {
            return this.submitJobDirectly(job);
        }
        String oozieTmpDir = System.getProperty("oozie.data.dir");
        if (oozieTmpDir == null || oozieTmpDir.equalsIgnoreCase("")) {
            XLog.getLog(((Object)((Object)this)).getClass()).error("oozie.data.dir property not set, set oozie.data.dir to valid directory");
            throw new IOException("Unable to create JobIdFile because oozie.data.dir is not set");
        }
        File jobConfFile = new File(oozieTmpDir + "/" + job.get("oozie.job.id") + "-jobconf.dat");
        File jobIdFile = new File(oozieTmpDir + "/" + job.get("oozie.job.id") + "-jobid.dat");
        try {
            Shell.ShellCommandExecutor shExec;
            block17: {
                String suexecExe = System.getProperty("oozie.home.dir") + "/../../server/oozieexecute";
                File suexecFile = new File(suexecExe);
                if (!suexecFile.exists()) {
                    XLog.getLog(((Object)((Object)this)).getClass()).warn("Missing file: " + suexecExe);
                    throw new IOException("Can not impersonate different user");
                }
                jobIdFile.createNewFile();
                jobIdFile.setWritable(true, false);
                DataOutputStream outputFile = new DataOutputStream(new FileOutputStream(jobConfFile));
                job.write((DataOutput)outputFile);
                outputFile.flush();
                outputFile.close();
                ArrayList<String> command = new ArrayList<String>();
                command.add(suexecExe);
                command.add(job.getUser());
                command.add(job.get("oozie.action.dir.path"));
                command.add(jobConfFile.toString());
                command.add(jobIdFile.toString());
                command.add("-classpath");
                command.add(this.getSubmitjobClasspath());
                String libraryPath = System.getProperty("java.library.path");
                command.add("-Djava.library.path=" + libraryPath);
                String[] commandArray = command.toArray(new String[0]);
                XLog.getLog(((Object)((Object)this)).getClass()).debug("sudo cmd: " + ((Object)command).toString());
                shExec = new Shell.ShellCommandExecutor(commandArray, null, null);
                Callable<Void> callTask = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        shExec.execute();
                        return null;
                    }
                };
                ArrayList<5> callableList = new ArrayList<5>();
                callableList.add(callTask);
                try {
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("Making jobClient call");
                    threadExecutor.invokeAny(callableList, 60000L, TimeUnit.MILLISECONDS);
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("jobClient call is successful");
                }
                catch (InterruptedException e) {
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got InterruptedExeption");
                }
                catch (ExecutionException e) {
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got ExecutionException");
                }
                catch (TimeoutException e) {
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("JobClient call got TimeoutException");
                }
                catch (Exception e) {
                    int exitCode;
                    if (e instanceof FileNotFoundException) {
                        throw (FileNotFoundException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (!(e instanceof Shell.ExitCodeException) || (exitCode = shExec.getExitCode()) == 1) break block17;
                    XLog.getLog(((Object)((Object)this)).getClass()).debug("Exit code from taskcontroller : " + exitCode);
                    XLog.getLog(((Object)((Object)this)).getClass()).debug(shExec.getOutput());
                    throw new IOException("Task controller setup failed because of invalid permissions/ownership with exit code " + exitCode, e);
                }
            }
            XLog.getLog(((Object)((Object)this)).getClass()).debug("MaprSubmitJob output: " + shExec.getOutput());
            DataInputStream inputFile = new DataInputStream(new FileInputStream(jobIdFile));
            newJobId = new JobID();
            newJobId.readFields((DataInput)inputFile);
        }
        finally {
            try {
                jobConfFile.delete();
                jobIdFile.delete();
            }
            catch (Exception e) {
                XLog.getLog(((Object)((Object)this)).getClass()).debug("MaprSubmitJob cleanup got exception: " + e);
            }
        }
        return this.getJob(newJobId);
    }
}

