/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.servlet.BaseJobServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class BaseJobsServlet
extends JsonRestServlet {
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public BaseJobsServlet(String instrumentationName) {
        super(instrumentationName, RESOURCES_INFO);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.validateContentType(request, "application/xml");
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
        this.stopCron();
        conf = conf.trim();
        conf = conf.resolve();
        BaseJobsServlet.validateJobConfiguration(conf);
        String requestUser = this.getUser(request);
        if (!requestUser.equals("?")) {
            conf.set("user.name", requestUser);
        }
        BaseJobServlet.checkAuthorizationForApp(conf);
        JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
        JSONObject json = this.submitJob(request, conf);
        this.startCron();
        this.sendJsonResponse(response, 201, (JSONStreamAware)json);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String externalId = request.getParameter("external-id");
        if (externalId != null) {
            this.stopCron();
            JSONObject json = this.getJobIdForExternalId(request, externalId);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else {
            this.stopCron();
            JSONObject json = this.getJobs(request);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        }
    }

    abstract JSONObject submitJob(HttpServletRequest var1, Configuration var2) throws XServletException, IOException;

    abstract JSONObject getJobIdForExternalId(HttpServletRequest var1, String var2) throws XServletException, IOException;

    abstract JSONObject getJobs(HttpServletRequest var1) throws XServletException, IOException;

    static void validateJobConfiguration(Configuration conf) throws XServletException {
        if (conf.get("user.name") == null) {
            throw new XServletException(400, ErrorCode.E0401, "user.name");
        }
    }

    static {
        BaseJobsServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("POST", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, false, Arrays.asList("POST")), new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("jobtype", String.class, false, Arrays.asList("GET", "POST")), new JsonRestServlet.ParameterInfo("offset", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("len", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("bulk", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("external-id", String.class, false, Arrays.asList("GET"))));
    }
}

