/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.controllers;

import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ConditionsController
extends AbstractXulEventHandler {
    private Workspace workspace;
    private XulTree conditionsTree;
    private BindingFactory bf;
    private XulTree conditionTree;

    @Bindable
    public void init() {
        this.conditionsTree = (XulTree)this.document.getElementById("conditionsTree");
        this.bf.createBinding((Object)this.workspace, "conditions", (Object)this.conditionsTree, "elements", new BindingConvertor[0]);
        this.conditionTree = (XulTree)this.document.getElementById("conditionsTree");
        BindingConvertor<int[], Boolean> buttonConvertor = new BindingConvertor<int[], Boolean>(){

            public Boolean sourceToTarget(int[] value) {
                return value == null || value.length == 0;
            }

            public int[] targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.conditionTree, "selectedRows", "conditionUp", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.conditionTree, "selectedRows", "conditionDown", "disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)this.conditionTree, "selectedRows", "conditionRemove", "disabled", new BindingConvertor[]{buttonConvertor});
    }

    public int getSelectedIndex() {
        int[] rows = this.conditionTree.getAbsoluteSelectedRows();
        return rows != null && rows.length == 0 ? -1 : rows[0];
    }

    @Bindable
    public void moveUp() {
        try {
            int prevIndex = this.getSelectedIndex();
            this.workspace.getConditions().moveChildUp(this.getSelectedIndex());
            this.conditionTree.clearSelection();
            this.conditionTree.setSelectedRows(new int[]{prevIndex - 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void moveDown() {
        int prevIndex = this.getSelectedIndex();
        try {
            this.workspace.getConditions().moveChildDown(this.getSelectedIndex());
            this.conditionTree.clearSelection();
            this.conditionTree.setSelectedRows(new int[]{prevIndex + 1});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Bindable
    public void remove() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        this.workspace.getConditions().remove(this.getSelectedIndex());
        this.conditionTree.clearSelection();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "conditionsController";
    }
}

