/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class SystemActionsXml {
    Document document;
    private static final String ROOT_ELEMENT = "beans";

    public SystemActionsXml(File pentahoXmlFile) throws IOException, DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromFile((File)pentahoXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public SystemActionsXml(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public SystemActionsXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(Messages.getInstance().getErrorString("PentahoXml.ERROR_0001_INVALID_ROOT_ELEMENT"));
        }
        this.document = doc;
    }

    public SystemActionsXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    private void setValue(String xPath, String value) {
        this.setValue(xPath, value, false);
    }

    private void setValue(String xPath, String value, boolean useCData) {
        Element element = (Element)this.document.selectSingleNode(xPath);
        if (element == null) {
            element = DocumentHelper.makeElement((Branch)this.document, (String)xPath);
        }
        if (useCData) {
            element.clearContent();
            element.addCDATA(value);
        } else {
            element.setText(value);
        }
    }

    private String getValue(String xpath) {
        Element element = (Element)this.document.selectSingleNode(xpath);
        return element != null ? element.getText() : null;
    }

    public Document getDocument() {
        return this.document;
    }
}

