/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.catalog;

import java.io.Serializable;
import mondrian.olap.Util;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogComplementInfo;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;

public class MondrianCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String dataSourceInfo;
    private String definition;
    private MondrianSchema schema;
    private MondrianCatalogComplementInfo mondrianCatalogComplementInfo;

    public MondrianCatalog(String name, String dataSourceInfo, String definition, MondrianSchema schema) {
        this(name, dataSourceInfo, definition, schema, new MondrianCatalogComplementInfo());
    }

    public MondrianCatalog(String name, String dataSourceInfo, String definition, MondrianSchema schema, MondrianCatalogComplementInfo mondrianCatalogComplementInfo) {
        this.name = name;
        this.dataSourceInfo = dataSourceInfo;
        this.definition = definition;
        this.schema = schema;
        this.mondrianCatalogComplementInfo = mondrianCatalogComplementInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public boolean isJndi() {
        return this.getJndi() != null;
    }

    public String getJndi() {
        return Util.parseConnectString((String)this.dataSourceInfo).get("DataSource");
    }

    public MondrianSchema getSchema() {
        return this.schema;
    }

    public MondrianCatalogComplementInfo getMondrianCatalogComplementInfo() {
        return this.mondrianCatalogComplementInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("dataSourceInfo", (Object)this.dataSourceInfo).append("definition", (Object)this.definition).append("schema", (Object)this.schema).toString();
    }
}

