/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.mapper;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;
import org.pentaho.platform.plugin.action.olap.IOlapService;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.Assert;

public abstract class MondrianAbstractPlatformUserRoleMapper
implements IConnectionUserRoleMapper {
    private static final Log log = LogFactory.getLog(MondrianAbstractPlatformUserRoleMapper.class);

    protected abstract String[] mapRoles(String[] var1, String[] var2) throws PentahoAccessControlException;

    protected String[] getMondrianRolesFromCatalog(IPentahoSession userSession, String context) {
        Object[] roleNames;
        MondrianSchema schema;
        MondrianCatalog catalog;
        String[] rtn = null;
        IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class);
        if (catalogService != null && (catalog = catalogService.getCatalog(context, userSession)) != null && (schema = catalog.getSchema()) != null && (roleNames = schema.getRoleNames()) != null && roleNames.length > 0) {
            Arrays.sort(roleNames);
            return roleNames;
        }
        IOlapService olapService = (IOlapService)PentahoSystem.get(IOlapService.class);
        if (olapService != null) {
            MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            String serverName = null;
            for (String name : helper.getOlap4jServers()) {
                Util.PropertyList props = Util.parseConnectString((String)helper.getOlap4jServerInfo((String)name).URL);
                if (!props.get(RolapConnectionProperties.Catalog.name(), "").equals(context)) continue;
                serverName = name;
            }
            if (serverName != null) {
                OlapConnection conn = null;
                try {
                    conn = olapService.getConnection(serverName, null);
                    List roleList = conn.getAvailableRoleNames();
                    Object[] roleArray = roleList.toArray(new String[roleList.size()]);
                    Arrays.sort(roleArray);
                    Object[] objectArray = roleArray;
                    return objectArray;
                }
                catch (OlapException e) {
                    log.error((Object)("Failed to get a list of roles from olap connection " + context), (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            log.error((Object)("Failed to get a list of roles from olap connection " + context), (Throwable)e);
                        }
                    }
                }
            }
        }
        return rtn;
    }

    protected String[] getPlatformRolesFromSession(IPentahoSession session) {
        GrantedAuthority[] gAuths = (GrantedAuthority[])session.getAttribute("roles");
        if (gAuths == null) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            gAuths = authentication.getAuthorities();
            Assert.state((authentication != null ? 1 : 0) != 0);
        }
        Object[] rtn = null;
        if (gAuths != null && gAuths.length > 0) {
            rtn = new String[gAuths.length];
            for (int i = 0; i < gAuths.length; ++i) {
                rtn[i] = gAuths[i].getAuthority();
            }
            Arrays.sort(rtn);
        }
        return rtn;
    }

    public String[] mapConnectionRoles(IPentahoSession userSession, String connectionContext) throws PentahoAccessControlException {
        String[] mondrianRoleNames = this.getMondrianRolesFromCatalog(userSession, connectionContext);
        String[] platformRoleNames = this.getPlatformRolesFromSession(userSession);
        String[] mappedResult = null;
        if (mondrianRoleNames != null && platformRoleNames != null && mondrianRoleNames.length > 0 && platformRoleNames.length > 0) {
            mappedResult = this.mapRoles(mondrianRoleNames, platformRoleNames);
        }
        return mappedResult;
    }

    public Object mapConnectionUser(IPentahoSession userSession, String context) throws PentahoAccessControlException {
        throw new UnsupportedOperationException();
    }
}

