/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.olap.impl;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mondrian.olap.MondrianServer;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.server.DynamicContentFinder;
import mondrian.server.MondrianServerRegistry;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.util.LockBox;
import mondrian.xmla.XmlaHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Schema;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.olap.IOlapConnectionFilter;
import org.pentaho.platform.plugin.action.olap.IOlapService;
import org.pentaho.platform.plugin.action.olap.IOlapServiceException;
import org.pentaho.platform.plugin.action.olap.PlatformXmlaExtra;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.repository.solution.filebased.MondrianVfs;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.springframework.security.userdetails.UserDetailsService;

public class OlapServiceImpl
implements IOlapService {
    public static String CATALOG_CACHE_REGION = "iolapservice-catalog-cache";
    static final String MONDRIAN_DATASOURCE_FOLDER = "mondrian";
    final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    static final String DATASOURCE_NAME = "Pentaho";
    private static final Log LOG = OlapServiceImpl.getLogger();
    private IUnifiedRepository repository;
    private MondrianCatalogRepositoryHelper helper;
    private MondrianServer server = null;
    private final List<IOlapConnectionFilter> filters;
    private Role role;
    private Boolean isSec = null;

    private static Log getLogger() {
        return LogFactory.getLog(IOlapService.class);
    }

    public OlapServiceImpl() {
        this(null, null);
    }

    public OlapServiceImpl(IUnifiedRepository repo, MondrianServer server) {
        this.repository = repo;
        this.filters = new CopyOnWriteArrayList<IOlapConnectionFilter>();
        this.server = server;
        try {
            DefaultFileSystemManager dfsm = (DefaultFileSystemManager)VFS.getManager();
            if (!dfsm.hasProvider(MONDRIAN_DATASOURCE_FOLDER)) {
                dfsm.addProvider(MONDRIAN_DATASOURCE_FOLDER, (FileProvider)new MondrianVfs());
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSecurityEnabled() {
        if (this.isSec != null) {
            return this.isSec;
        }
        try {
            UserDetailsService uds = (UserDetailsService)PentahoSystem.get(UserDetailsService.class);
            this.isSec = uds != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e) {
            this.isSec = false;
        }
        return this.isSec;
    }

    synchronized IUnifiedRepository getRepository() {
        if (this.repository == null) {
            this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        }
        return this.repository;
    }

    synchronized MondrianCatalogRepositoryHelper getHelper() {
        if (this.helper == null) {
            this.helper = new MondrianCatalogRepositoryHelper(this.getRepository());
        }
        return this.helper;
    }

    public synchronized void setHelper(MondrianCatalogRepositoryHelper helper) {
        this.helper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<IOlapService.Catalog> getCache(IPentahoSession session) {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)session);
        Object cacheKey = this.makeCacheSubRegionKey(OlapServiceImpl.getLocale());
        Lock writeLock = this.cacheLock.writeLock();
        try {
            writeLock.lock();
            if (!cacheMgr.cacheEnabled(CATALOG_CACHE_REGION)) {
                cacheMgr.addCacheRegion(CATALOG_CACHE_REGION);
            }
            if (cacheMgr.getFromRegionCache(CATALOG_CACHE_REGION, cacheKey) == null) {
                cacheMgr.putInRegionCache(CATALOG_CACHE_REGION, cacheKey, new ArrayList());
            }
            List list = (List)cacheMgr.getFromRegionCache(CATALOG_CACHE_REGION, cacheKey);
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCache(IPentahoSession session) {
        Lock writeLock = this.cacheLock.writeLock();
        try {
            writeLock.lock();
            ICacheManager cacheMgr = PentahoSystem.getCacheManager((IPentahoSession)session);
            cacheMgr.clearRegionCache(CATALOG_CACHE_REGION);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected Object makeCacheSubRegionKey(Locale locale) {
        return locale.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCache(IPentahoSession session) {
        boolean needUpdate;
        List<IOlapService.Catalog> cache = this.getCache(session);
        Lock readLock = this.cacheLock.readLock();
        try {
            readLock.lock();
            needUpdate = cache.size() == 0;
        }
        finally {
            readLock.unlock();
        }
        if (needUpdate) {
            Lock writeLock = this.cacheLock.writeLock();
            try {
                writeLock.lock();
                cache.clear();
                Callable<Void> call = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (String name : OlapServiceImpl.this.getHelper().getHostedCatalogs()) {
                            try {
                                OlapServiceImpl.this.addCatalogToCache(PentahoSessionHolder.getSession(), name);
                            }
                            catch (Throwable t) {
                                LOG.error((Object)("Failed to initialize the cache for OLAP connection " + name), t);
                            }
                        }
                        for (String name : OlapServiceImpl.this.getHelper().getOlap4jServers()) {
                            try {
                                OlapServiceImpl.this.addCatalogToCache(PentahoSessionHolder.getSession(), name);
                            }
                            catch (Throwable t) {
                                LOG.error((Object)("Failed to initialize the cache for OLAP connection " + name), t);
                            }
                        }
                        return null;
                    }
                };
                if (this.isSecurityEnabled()) {
                    SecurityHelper.getInstance().runAsSystem((Callable)call);
                } else {
                    call.call();
                }
                Collections.sort(cache, new Comparator<IOlapService.Catalog>(){

                    @Override
                    public int compare(IOlapService.Catalog o1, IOlapService.Catalog o2) {
                        return o1.name.compareTo(o2.name);
                    }
                });
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to initialize the connection cache", t);
                throw new IOlapServiceException(t);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCatalogToCache(IPentahoSession session, String catalogName) {
        IOlapService.Catalog catalog = new IOlapService.Catalog(catalogName, new ArrayList<IOlapService.Schema>());
        OlapConnection connection = null;
        try {
            connection = this.getConnection(catalogName, session);
            for (Schema schema4j : connection.getOlapSchemas()) {
                connection.setSchema(schema4j.getName());
                IOlapService.Schema schema = new IOlapService.Schema(schema4j.getName(), catalog, new ArrayList<IOlapService.Cube>(), new ArrayList<String>(connection.getAvailableRoleNames()));
                for (Cube cube4j : schema4j.getCubes()) {
                    schema.cubes.add(new IOlapService.Cube(cube4j.getName(), cube4j.getCaption(), schema));
                }
                catalog.schemas.add(schema);
            }
            this.getCache(session).add(catalog);
        }
        catch (OlapException e) {
            LOG.warn((Object)("Failed to initialize the olap connection cache for catalog " + catalogName), (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to gracefully close an olap connection to catalog " + catalogName), (Throwable)e);
            }
        }
    }

    @Override
    public void addHostedCatalog(String name, String dataSourceInfo, InputStream inputStream, boolean overwrite, IPentahoSession session) {
        if (!this.hasAccess(name, EnumSet.of(RepositoryFilePermission.WRITE), session)) {
            LOG.debug((Object)"user does not have access; throwing exception");
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0003_INSUFFICIENT_PERMISSION"), IOlapServiceException.Reason.ACCESS_DENIED);
        }
        if (this.getCatalogNames(session).contains(name) && !overwrite) {
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0004_ALREADY_EXISTS"), IOlapServiceException.Reason.ALREADY_EXISTS);
        }
        try {
            MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper(this.getRepository());
            helper.addHostedCatalog(inputStream, name, dataSourceInfo);
        }
        catch (Exception e) {
            throw new IOlapServiceException(e, IOlapServiceException.Reason.convert(e));
        }
    }

    protected boolean hasAccess(String catalogName, EnumSet<RepositoryFilePermission> perms, IPentahoSession session) {
        return this.getHelper().hasAccess(catalogName, perms, session);
    }

    @Override
    public void addOlap4jCatalog(String name, String className, String URL2, String user, String password, Properties props, boolean overwrite, IPentahoSession session) {
        if (!this.hasAccess(name, EnumSet.of(RepositoryFilePermission.WRITE), session)) {
            LOG.debug((Object)"user does not have access; throwing exception");
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0003_INSUFFICIENT_PERMISSION"), IOlapServiceException.Reason.ACCESS_DENIED);
        }
        if (this.getCatalogNames(session).contains(name) && !overwrite) {
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0004_ALREADY_EXISTS"), IOlapServiceException.Reason.ALREADY_EXISTS);
        }
        MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper(this.getRepository());
        helper.addOlap4jServer(name, className, URL2, user, password, props);
    }

    @Override
    public void removeCatalog(String name, IPentahoSession session) {
        if (!this.hasAccess(name, EnumSet.of(RepositoryFilePermission.DELETE), session)) {
            LOG.debug((Object)"user does not have access; throwing exception");
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0003_INSUFFICIENT_PERMISSION"), IOlapServiceException.Reason.ACCESS_DENIED);
        }
        if (!this.getCatalogNames(session).contains(name)) {
            throw new IOlapServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0015_CATALOG_NOT_FOUND", new Object[]{name}));
        }
        this.getHelper().deleteCatalog(name);
    }

    @Override
    public void flushAll(IPentahoSession session) {
        Lock writeLock = this.cacheLock.writeLock();
        try {
            writeLock.lock();
            this.resetCache(session);
            this.flushHostedAndRemote(session);
        }
        catch (Exception e) {
            throw new IOlapServiceException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushHostedAndRemote(IPentahoSession session) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (String name : this.getCatalogNames(session)) {
            OlapConnection connection = null;
            try {
                connection = this.getConnection(name, session);
                XmlaHandler.XmlaExtra xmlaExtra = this.getXmlaExtra(connection);
                if (xmlaExtra == null) continue;
                xmlaExtra.flushSchemaCache(connection);
            }
            catch (Exception e) {
                LOG.warn((Object)Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0019_FAILED_TO_FLUSH", new Object[]{name}), (Throwable)e);
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    protected XmlaHandler.XmlaExtra getXmlaExtra(OlapConnection connection) throws SQLException {
        return PlatformXmlaExtra.unwrapXmlaExtra(connection);
    }

    @Override
    public List<String> getCatalogNames(IPentahoSession pentahoSession) throws IOlapServiceException {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.getHelper().getHostedCatalogs()) {
            if (!this.hasAccess(name, EnumSet.of(RepositoryFilePermission.READ), pentahoSession)) continue;
            names.add(name);
        }
        for (String name : this.getHelper().getOlap4jServers()) {
            if (!this.hasAccess(name, EnumSet.of(RepositoryFilePermission.READ), pentahoSession)) continue;
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IOlapService.Catalog> getCatalogs(IPentahoSession session) throws IOlapServiceException {
        this.initCache(session);
        List<IOlapService.Catalog> cache = this.getCache(session);
        Lock readLock = this.cacheLock.readLock();
        try {
            readLock.lock();
            ArrayList<IOlapService.Catalog> catalogs = new ArrayList<IOlapService.Catalog>();
            for (IOlapService.Catalog catalog : cache) {
                if (!this.hasAccess(catalog.name, EnumSet.of(RepositoryFilePermission.READ), session)) continue;
                catalogs.add(catalog);
            }
            List<IOlapService.Catalog> list = Collections.unmodifiableList(new ArrayList<IOlapService.Catalog>(cache));
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public List<IOlapService.Schema> getSchemas(String parentCatalog, IPentahoSession session) {
        ArrayList<IOlapService.Schema> schemas = new ArrayList<IOlapService.Schema>();
        for (IOlapService.Catalog catalog : this.getCatalogs(session)) {
            if (parentCatalog != null && !catalog.name.equals(parentCatalog)) continue;
            schemas.addAll(catalog.schemas);
        }
        return schemas;
    }

    @Override
    public List<IOlapService.Cube> getCubes(String parentCatalog, String parentSchema, IPentahoSession pentahoSession) {
        ArrayList<IOlapService.Cube> cubes = new ArrayList<IOlapService.Cube>();
        for (IOlapService.Schema schema : this.getSchemas(parentCatalog, pentahoSession)) {
            if (parentSchema != null && !schema.name.equals(parentSchema)) continue;
            cubes.addAll(schema.cubes);
        }
        return cubes;
    }

    @Override
    public OlapConnection getConnection(String catalogName, IPentahoSession session) throws IOlapServiceException {
        String[] effectiveRoles;
        if (catalogName == null) {
            try {
                return this.getServer().getConnection(DATASOURCE_NAME, null, null, new Properties());
            }
            catch (Exception e) {
                throw new IOlapServiceException(e);
            }
        }
        if (!this.hasAccess(catalogName, EnumSet.of(RepositoryFilePermission.READ), session)) {
            LOG.debug((Object)"user does not have access; throwing exception");
            throw new IOlapServiceException(Messages.getInstance().getErrorString("OlapServiceImpl.ERROR_0003_INSUFFICIENT_PERMISSION"), IOlapServiceException.Reason.ACCESS_DENIED);
        }
        if (!this.getCatalogNames(session).contains(catalogName)) {
            throw new IOlapServiceException(Messages.getInstance().getErrorString("MondrianCatalogHelper.ERROR_0015_CATALOG_NOT_FOUND", new Object[]{catalogName}));
        }
        if (this.getHelper().getOlap4jServers().contains(catalogName)) {
            return this.makeOlap4jConnection(catalogName);
        }
        StringBuilder roleName = new StringBuilder();
        LockBox.Entry roleMonikor = null;
        if (this.role != null) {
            roleMonikor = this.getServer().getLockBox().register((Object)this.role);
            roleName.append(roleMonikor.getMoniker());
        } else {
            IConnectionUserRoleMapper mapper = (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)"Mondrian-UserRoleMapper", null);
            effectiveRoles = new OlapConnection[]{};
            if (session != null && mapper != null) {
                try {
                    effectiveRoles = mapper.mapConnectionRoles(session, catalogName);
                    if (effectiveRoles == null) {
                        effectiveRoles = new String[]{};
                    }
                }
                catch (PentahoAccessControlException e) {
                    throw new IOlapServiceException(e);
                }
            }
            boolean addComma = false;
            for (String role : effectiveRoles) {
                if (addComma) {
                    roleName.append(",");
                }
                roleName.append(role);
                addComma = true;
            }
        }
        Properties properties = new Properties();
        properties.put(RolapConnectionProperties.Locale.name(), OlapServiceImpl.getLocale().toString());
        try {
            effectiveRoles = this.getServer().getConnection(DATASOURCE_NAME, catalogName, Util.isEmpty((String)roleName.toString()) ? null : roleName.toString(), properties);
            return effectiveRoles;
        }
        catch (Exception e) {
            throw new IOlapServiceException(e);
        }
        finally {
            if (roleMonikor != null) {
                this.getServer().getLockBox().deregister(roleMonikor);
            }
        }
    }

    private OlapConnection makeOlap4jConnection(String name) {
        MondrianCatalogRepositoryHelper.Olap4jServerInfo olapServerInfo = this.getHelper().getOlap4jServerInfo(name);
        assert (olapServerInfo != null);
        try {
            Class.forName(olapServerInfo.className);
        }
        catch (ClassNotFoundException e) {
            throw new IOlapServiceException(e);
        }
        Properties newProps = new Properties(olapServerInfo.properties);
        for (IOlapConnectionFilter filter : this.filters) {
            filter.filterProperties(newProps);
        }
        if (olapServerInfo.user != null) {
            newProps.put("user", olapServerInfo.user);
        }
        if (olapServerInfo.password != null) {
            newProps.put("password", olapServerInfo.password);
        }
        try {
            Connection conn = DriverManager.getConnection(olapServerInfo.URL, newProps);
            return conn.unwrap(OlapConnection.class);
        }
        catch (SQLException e) {
            throw new IOlapServiceException(e);
        }
    }

    private synchronized MondrianServer getServer() {
        if (this.server == null) {
            this.server = MondrianServerRegistry.INSTANCE.createWithRepository((RepositoryContentFinder)new DynamicContentFinder("http://not-needed.com"){

                public String getContent() {
                    return OlapServiceImpl.this.getDatasourcesXml();
                }
            }, new CatalogLocator(){

                public String locate(String URL2) {
                    return URL2;
                }
            });
        }
        return this.server;
    }

    private String getDatasourcesXml() {
        Callable<String> call = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return OlapServiceImpl.this.generateInMemoryDatasourcesXml();
            }
        };
        try {
            if (this.isSecurityEnabled()) {
                return (String)SecurityHelper.getInstance().runAsSystem((Callable)call);
            }
            return (String)call.call();
        }
        catch (Exception e) {
            throw new IOlapServiceException(e);
        }
    }

    private String generateInMemoryDatasourcesXml() {
        StringBuffer datasourcesXML = new StringBuffer();
        datasourcesXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        datasourcesXML.append("<DataSources>\n");
        datasourcesXML.append("<DataSource>\n");
        datasourcesXML.append("<DataSourceName>Pentaho</DataSourceName>\n");
        datasourcesXML.append("<DataSourceDescription>Pentaho BI Platform Datasources</DataSourceDescription>\n");
        datasourcesXML.append("<URL>Xmla</URL>\n");
        datasourcesXML.append("<DataSourceInfo>Provider=mondrian</DataSourceInfo>\n");
        datasourcesXML.append("<ProviderName>PentahoXMLA</ProviderName>\n");
        datasourcesXML.append("<ProviderType>MDP</ProviderType>\n");
        datasourcesXML.append("<AuthenticationMode>Unauthenticated</AuthenticationMode>\n");
        datasourcesXML.append("<Catalogs>\n");
        for (String name : this.getHelper().getHostedCatalogs()) {
            MondrianCatalogRepositoryHelper.HostedCatalogInfo hostedServerInfo = this.getHelper().getHostedCatalogInfo(name);
            this.addCatalogXml(datasourcesXML, hostedServerInfo.name, hostedServerInfo.dataSourceInfo, hostedServerInfo.definition);
        }
        datasourcesXML.append("</Catalogs>\n");
        datasourcesXML.append("</DataSource>\n");
        datasourcesXML.append("</DataSources>\n");
        return datasourcesXML.toString();
    }

    private void addCatalogXml(StringBuffer str, String catalogName, String dsInfo, String definition) {
        assert (definition != null);
        str.append("<Catalog name=\"" + catalogName + "\">\n");
        if (dsInfo != null) {
            str.append("<DataSourceInfo>" + dsInfo + "</DataSourceInfo>\n");
        }
        str.append("<Definition>" + definition + "</Definition>\n");
        str.append("</Catalog>\n");
    }

    public void setConnectionFilters(Collection<IOlapConnectionFilter> filters) {
        this.filters.addAll(filters);
    }

    public void setMondrianRole(Role role) {
        this.role = role;
    }

    private static Locale getLocale() {
        Locale locale = LocaleHelper.getLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }
}

