/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportMimeResolver;
import org.pentaho.platform.plugin.services.importer.mimeType.MimeType;

public class NameBaseMimeResolver
implements IPlatformImportMimeResolver {
    private Map<String, MimeType> extensionToMimeMap = new HashMap<String, MimeType>();

    @Override
    public String resolveMimeForFileName(String fileName) {
        MimeType mimeType = this.extensionToMimeMap.get(this.extractExtension(fileName));
        if (mimeType == null) {
            return null;
        }
        return mimeType.getName();
    }

    @Override
    public String resolveMimeForBundle(IPlatformImportBundle bundle) {
        if (bundle.getMimeType() != null) {
            return bundle.getMimeType();
        }
        MimeType mimeType = this.extensionToMimeMap.get(this.extractExtension(bundle.getName()));
        if (mimeType == null) {
            return null;
        }
        return mimeType.getName();
    }

    @Override
    public MimeType resolveMimeTypeForFileName(String fileName) {
        return this.extensionToMimeMap.get(this.extractExtension(fileName));
    }

    private String extractExtension(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(".");
        if (idx == -1 || idx == name.length()) {
            return name;
        }
        return name.substring(idx + 1);
    }

    @Override
    public void addMimeType(MimeType mimeType) {
        for (String extension : mimeType.getExtensions()) {
            this.extensionToMimeMap.put(extension, mimeType);
        }
    }
}

