/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class NestedLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator
implements InitializingBean {
    private Map extraRolesMapping;

    public NestedLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, groupSearchBase);
    }

    public Set getGroupMembershipRoles(String userDn, String username) {
        Set roles = super.getGroupMembershipRoles(userDn, username);
        Set newRolesFromPreviousPass = new HashSet(roles);
        HashSet allNewRoles = new HashSet();
        while (!newRolesFromPreviousPass.isEmpty()) {
            newRolesFromPreviousPass = this.getParentRoles(newRolesFromPreviousPass);
            allNewRoles.addAll(newRolesFromPreviousPass);
        }
        roles.addAll(this.toGrantedAuthorities(allNewRoles));
        return roles;
    }

    protected Set getParentRoles(Set children) {
        HashSet parents = new HashSet();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object parent = this.extraRolesMapping.get(iter.next());
            if (null == parent) continue;
            parents.add(parent);
        }
        return parents;
    }

    protected Set toGrantedAuthorities(Set rolesAsStringsSet) {
        HashSet<GrantedAuthorityImpl> grantedAuthorities = new HashSet<GrantedAuthorityImpl>();
        for (String auth : rolesAsStringsSet) {
            grantedAuthorities.add(new GrantedAuthorityImpl(auth));
        }
        return grantedAuthorities;
    }

    public Map getExtraRolesMapping() {
        return this.extraRolesMapping;
    }

    public void setExtraRolesMapping(Map extraRolesMapping) {
        this.extraRolesMapping = extraRolesMapping;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.extraRolesMapping);
    }
}

