/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.springframework.security.GrantedAuthorityImpl;

public class StringToGrantedAuthority
implements Transformer {
    private static final Log logger = LogFactory.getLog(StringToGrantedAuthority.class);
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;

    public Object transform(Object obj) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("StringToGrantedAuthority.DEBUG_INPUT_TO_TRANSFORM", new Object[]{null != obj ? obj.toString() : "null"}));
        }
        Object[] transformed = obj;
        if (obj instanceof String) {
            transformed = this.transformItem(obj);
        } else if (obj instanceof Collection) {
            transformed = new HashSet();
            Set authSet = (Set)transformed;
            Iterator iter = ((Collection)obj).iterator();
            while (iter.hasNext()) {
                authSet.add(this.transformItem(iter.next()));
            }
        } else if (obj instanceof Object[]) {
            Object[] objArray;
            transformed = new HashSet();
            Set authSet = (Set)transformed;
            for (Object element : objArray = (Object[])obj) {
                authSet.add(this.transformItem(element));
            }
            transformed = authSet.toArray();
        }
        return transformed;
    }

    protected Object transformItem(Object obj) {
        Object transformed = obj;
        if (obj instanceof String) {
            String converted = this.rolePrefix + (this.convertToUpperCase ? ((String)obj).toUpperCase() : obj.toString());
            transformed = new GrantedAuthorityImpl(converted);
        }
        return transformed;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }
}

