/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.vfs.KettleVFS;

public class FileLoggingEventListener
implements KettleLoggingEventListener {
    private String filename;
    private FileObject file;
    private OutputStream outputStream;
    private KettleLogLayout layout;
    private KettleException exception;
    private String logChannelId;

    public FileObject getFile() {
        return this.file;
    }

    public FileLoggingEventListener(String filename, boolean append) throws KettleException {
        this(null, filename, append);
    }

    public FileLoggingEventListener(String logChannelId, String filename, boolean append) throws KettleException {
        this.logChannelId = logChannelId;
        this.filename = filename;
        this.layout = new KettleLogLayout(true);
        this.exception = null;
        this.file = KettleVFS.getFileObject(filename);
        this.outputStream = null;
        try {
            this.outputStream = KettleVFS.getOutputStream(this.file, append);
        }
        catch (Exception e) {
            throw new KettleException("Unable to create a logging event listener to write to file '" + filename + "'", e);
        }
    }

    @Override
    public void eventAdded(KettleLoggingEvent event) {
        try {
            Object messageObject = event.getMessage();
            if (messageObject instanceof LogMessage) {
                boolean logToFile = false;
                if (this.logChannelId == null) {
                    logToFile = true;
                } else {
                    LogMessage message = (LogMessage)messageObject;
                    List<String> logChannelChildren = LoggingRegistry.getInstance().getLogChannelChildren(this.logChannelId);
                    boolean bl = logToFile = Const.indexOfString(message.getLogChannelId(), logChannelChildren) >= 0;
                }
                if (logToFile) {
                    String logText = this.layout.format(event);
                    this.outputStream.write(logText.getBytes());
                    this.outputStream.write(Const.CR.getBytes());
                }
            }
        }
        catch (Exception e) {
            this.exception = new KettleException("Unable to write to logging event to file '" + this.filename + "'", e);
        }
    }

    public void close() throws KettleException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to close output of file '" + this.filename + "'", e);
        }
    }

    public KettleException getException() {
        return this.exception;
    }

    public void setException(KettleException exception) {
        this.exception = exception;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

