/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionStates {
    private static final Log LOG = LogFactory.getLog(RegionStates.class);
    final HashMap<String, RegionState> regionsInTransition;
    private final Map<String, RegionState> regionStates = new HashMap<String, RegionState>();
    private final Map<ServerName, Set<HRegionInfo>> serverHoldings;
    private final Map<HRegionInfo, Set<HRegionInfo>> defaultReplicaToOtherReplicas;
    private final TreeMap<HRegionInfo, ServerName> regionAssignments;
    private final HashMap<String, ServerName> lastAssignments;
    private final HashMap<String, Long> deadServers;
    private final HashMap<ServerName, Long> processedServers;
    private long lastProcessedServerCleanTime;
    private final ServerManager serverManager;
    private final Server server;
    static final String LOG_SPLIT_TIME = "hbase.master.maximum.logsplit.keeptime";
    static final long DEFAULT_LOG_SPLIT_TIME = 0x6DDD00L;

    RegionStates(Server master, ServerManager serverManager) {
        this.regionsInTransition = new HashMap();
        this.serverHoldings = new HashMap<ServerName, Set<HRegionInfo>>();
        this.defaultReplicaToOtherReplicas = new HashMap<HRegionInfo, Set<HRegionInfo>>();
        this.regionAssignments = new TreeMap();
        this.lastAssignments = new HashMap();
        this.processedServers = new HashMap();
        this.deadServers = new HashMap();
        this.serverManager = serverManager;
        this.server = master;
    }

    public synchronized Map<HRegionInfo, ServerName> getRegionAssignments() {
        return (Map)this.regionAssignments.clone();
    }

    synchronized Map<ServerName, List<HRegionInfo>> getRegionAssignments(Collection<HRegionInfo> regions) {
        HashMap<ServerName, List<HRegionInfo>> map = new HashMap<ServerName, List<HRegionInfo>>();
        for (HRegionInfo region : regions) {
            HRegionInfo defaultReplica = RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)region);
            Set<HRegionInfo> allReplicas = this.defaultReplicaToOtherReplicas.get(defaultReplica);
            if (allReplicas == null) continue;
            for (HRegionInfo hri : allReplicas) {
                ServerName server = this.regionAssignments.get(hri);
                if (server == null) continue;
                ArrayList<HRegionInfo> regionsOnServer = (ArrayList<HRegionInfo>)map.get(server);
                if (regionsOnServer == null) {
                    regionsOnServer = new ArrayList<HRegionInfo>(1);
                    map.put(server, regionsOnServer);
                }
                regionsOnServer.add(hri);
            }
        }
        return map;
    }

    public synchronized ServerName getRegionServerOfRegion(HRegionInfo hri) {
        return this.regionAssignments.get(hri);
    }

    public synchronized Map<String, RegionState> getRegionsInTransition() {
        return (Map)this.regionsInTransition.clone();
    }

    public synchronized boolean isRegionInTransition(HRegionInfo hri) {
        return this.regionsInTransition.containsKey(hri.getEncodedName());
    }

    public synchronized boolean isRegionInTransition(String encodedName) {
        return this.regionsInTransition.containsKey(encodedName);
    }

    public synchronized boolean isRegionsInTransition() {
        return !this.regionsInTransition.isEmpty();
    }

    public synchronized boolean isRegionOnline(HRegionInfo hri) {
        return !this.isRegionInTransition(hri) && this.regionAssignments.containsKey(hri);
    }

    public synchronized boolean isRegionOffline(HRegionInfo hri) {
        return this.getRegionState(hri) == null || !this.isRegionInTransition(hri) && this.isRegionInState(hri, RegionState.State.OFFLINE, RegionState.State.CLOSED);
    }

    public synchronized boolean isRegionInState(HRegionInfo hri, RegionState.State ... states) {
        return this.isRegionInState(hri.getEncodedName(), states);
    }

    public synchronized boolean isRegionInState(String encodedName, RegionState.State ... states) {
        RegionState regionState = this.getRegionState(encodedName);
        RegionState.State s = regionState != null ? regionState.getState() : null;
        for (RegionState.State state : states) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public synchronized void waitForUpdate(long timeout) throws InterruptedException {
        this.wait(timeout);
    }

    public synchronized RegionState getRegionTransitionState(HRegionInfo hri) {
        return this.regionsInTransition.get(hri.getEncodedName());
    }

    public synchronized RegionState getRegionTransitionState(String encodedName) {
        return this.regionsInTransition.get(encodedName);
    }

    public synchronized void createRegionStates(List<HRegionInfo> hris) {
        for (HRegionInfo hri : hris) {
            this.createRegionState(hri);
        }
    }

    public synchronized RegionState createRegionState(HRegionInfo hri) {
        RegionState.State newState = hri.isOffline() && hri.isSplit() ? RegionState.State.SPLIT : RegionState.State.OFFLINE;
        String encodedName = hri.getEncodedName();
        RegionState regionState = this.regionStates.get(encodedName);
        if (regionState != null) {
            LOG.warn((Object)("Tried to create a state for a region already in RegionStates, used existing: " + regionState + ", ignored new: " + newState));
        } else {
            regionState = new RegionState(hri, newState);
            this.regionStates.put(encodedName, regionState);
        }
        return regionState;
    }

    public synchronized RegionState updateRegionState(HRegionInfo hri, RegionState.State state) {
        RegionState regionState = this.regionStates.get(hri.getEncodedName());
        return this.updateRegionState(hri, state, regionState == null ? null : regionState.getServerName());
    }

    public synchronized RegionState updateRegionState(RegionTransition transition, RegionState.State state) {
        byte[] regionName = transition.getRegionName();
        HRegionInfo regionInfo = this.getRegionInfo(regionName);
        if (regionInfo == null) {
            String prettyRegionName = HRegionInfo.prettyPrint((String)HRegionInfo.encodeRegionName((byte[])regionName));
            LOG.warn((Object)("Failed to find region " + prettyRegionName + " in updating its state to " + state + " based on region transition " + transition));
            return null;
        }
        return this.updateRegionState(regionInfo, state, transition.getServerName());
    }

    public synchronized RegionState updateRegionState(HRegionInfo hri, RegionState.State state, ServerName serverName) {
        ServerName last;
        ServerName oldServerName;
        if (state == RegionState.State.FAILED_CLOSE || state == RegionState.State.FAILED_OPEN) {
            LOG.warn((Object)("Failed to open/close " + hri.getShortNameToLog() + " on " + serverName + ", set to " + state));
        }
        String encodedName = hri.getEncodedName();
        RegionState regionState = new RegionState(hri, state, System.currentTimeMillis(), serverName);
        this.regionsInTransition.put(encodedName, regionState);
        RegionState oldState = this.regionStates.put(encodedName, regionState);
        ServerName serverName2 = oldServerName = oldState == null ? null : oldState.getServerName();
        if (oldState == null || oldState.getState() != regionState.getState() || oldServerName == null && serverName != null || oldServerName != null && !oldServerName.equals((Object)serverName)) {
            LOG.info((Object)("Transitioned " + oldState + " to " + regionState));
        }
        if ((state == RegionState.State.CLOSED || state == RegionState.State.MERGED || state == RegionState.State.SPLIT) && this.lastAssignments.containsKey(encodedName)) {
            last = this.lastAssignments.get(encodedName);
            if (last.equals((Object)serverName)) {
                this.lastAssignments.remove(encodedName);
            } else {
                LOG.warn((Object)(encodedName + " moved to " + state + " on " + serverName + ", expected " + last));
            }
        }
        if (serverName != null && state == RegionState.State.OPEN && !serverName.equals((Object)(last = this.lastAssignments.get(encodedName)))) {
            this.lastAssignments.put(encodedName, serverName);
            if (last != null && this.isServerDeadAndNotProcessed(last)) {
                LOG.warn((Object)(encodedName + " moved to " + serverName + ", while it's previous host " + last + " is dead but not processed yet"));
            }
        }
        this.notifyAll();
        return regionState;
    }

    public synchronized void regionOnline(HRegionInfo hri, ServerName serverName) {
        if (!this.serverManager.isServerOnline(serverName)) {
            LOG.warn((Object)("Ignored, " + hri.getEncodedName() + " was opened on a dead server: " + serverName));
            return;
        }
        String encodedName = hri.getEncodedName();
        RegionState oldState = this.regionStates.get(encodedName);
        if (oldState == null) {
            LOG.warn((Object)("Online region not in RegionStates: " + hri.getShortNameToLog()));
        }
        this.updateRegionState(hri, RegionState.State.OPEN, serverName);
        this.regionsInTransition.remove(encodedName);
        ServerName oldServerName = this.regionAssignments.put(hri, serverName);
        if (!serverName.equals((Object)oldServerName)) {
            LOG.info((Object)("Onlined " + hri.getShortNameToLog() + " on " + serverName));
            this.addToServerHoldings(serverName, hri);
            this.addToReplicaMapping(hri);
            if (oldServerName != null) {
                LOG.info((Object)("Offlined " + hri.getShortNameToLog() + " from " + oldServerName));
                this.removeFromServerHoldings(oldServerName, hri);
            }
        }
    }

    private void addToServerHoldings(ServerName serverName, HRegionInfo hri) {
        Set<HRegionInfo> regions = this.serverHoldings.get(serverName);
        if (regions == null) {
            regions = new HashSet<HRegionInfo>();
            this.serverHoldings.put(serverName, regions);
        }
        regions.add(hri);
    }

    private void addToReplicaMapping(HRegionInfo hri) {
        HRegionInfo defaultReplica = RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)hri);
        Set<HRegionInfo> replicas = this.defaultReplicaToOtherReplicas.get(defaultReplica);
        if (replicas == null) {
            replicas = new HashSet<HRegionInfo>();
            this.defaultReplicaToOtherReplicas.put(defaultReplica, replicas);
        }
        replicas.add(hri);
    }

    private void removeFromServerHoldings(ServerName serverName, HRegionInfo hri) {
        Set<HRegionInfo> oldRegions = this.serverHoldings.get(serverName);
        oldRegions.remove(hri);
        if (oldRegions.isEmpty()) {
            this.serverHoldings.remove(serverName);
        }
    }

    private void removeFromReplicaMapping(HRegionInfo hri) {
        HRegionInfo defaultReplica = RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)hri);
        Set<HRegionInfo> replicas = this.defaultReplicaToOtherReplicas.get(defaultReplica);
        if (replicas != null) {
            replicas.remove(hri);
            if (replicas.isEmpty()) {
                this.defaultReplicaToOtherReplicas.remove(defaultReplica);
            }
        }
    }

    public synchronized void logSplit(ServerName serverName) {
        Iterator<Map.Entry<String, ServerName>> it = this.lastAssignments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ServerName> e = it.next();
            if (!e.getValue().equals((Object)serverName)) continue;
            it.remove();
        }
        long now = System.currentTimeMillis();
        this.processedServers.put(serverName, now);
        Configuration conf = this.server.getConfiguration();
        long obsoleteTime = conf.getLong(LOG_SPLIT_TIME, 0x6DDD00L);
        if (now > this.lastProcessedServerCleanTime + obsoleteTime) {
            this.lastProcessedServerCleanTime = now;
            long cutoff = now - obsoleteTime;
            Iterator<Map.Entry<ServerName, Long>> it2 = this.processedServers.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<ServerName, Long> e = it2.next();
                if (e.getValue() >= cutoff) continue;
                it2.remove();
            }
        }
    }

    public synchronized void logSplit(HRegionInfo region) {
        this.clearLastAssignment(region);
    }

    public synchronized void clearLastAssignment(HRegionInfo region) {
        this.lastAssignments.remove(region.getEncodedName());
    }

    public void regionOffline(HRegionInfo hri) {
        this.regionOffline(hri, null);
    }

    public synchronized void regionOffline(HRegionInfo hri, RegionState.State expectedState) {
        Preconditions.checkArgument((expectedState == null || RegionState.isUnassignable((RegionState.State)expectedState) ? 1 : 0) != 0, (Object)("Offlined region should not be " + expectedState));
        String encodedName = hri.getEncodedName();
        RegionState.State newState = expectedState == null ? RegionState.State.OFFLINE : expectedState;
        this.updateRegionState(hri, newState);
        this.regionsInTransition.remove(encodedName);
        ServerName oldServerName = this.regionAssignments.remove(hri);
        if (oldServerName != null) {
            LOG.info((Object)("Offlined " + hri.getShortNameToLog() + " from " + oldServerName));
            this.removeFromServerHoldings(oldServerName, hri);
            this.removeFromReplicaMapping(hri);
        }
    }

    public synchronized List<HRegionInfo> serverOffline(ZooKeeperWatcher watcher, ServerName sn) {
        ArrayList<HRegionInfo> rits = new ArrayList<HRegionInfo>();
        Set<HRegionInfo> assignedRegions = this.serverHoldings.get(sn);
        if (assignedRegions == null) {
            assignedRegions = new HashSet<HRegionInfo>();
        }
        HashSet<HRegionInfo> regionsToOffline = new HashSet<HRegionInfo>();
        for (HRegionInfo region : assignedRegions) {
            if (this.isRegionOnline(region)) {
                regionsToOffline.add(region);
                continue;
            }
            if (!this.isRegionInState(region, RegionState.State.SPLITTING, RegionState.State.MERGING)) continue;
            LOG.debug((Object)("Offline splitting/merging region " + this.getRegionState(region)));
            try {
                ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)watcher, (HRegionInfo)region);
                regionsToOffline.add(region);
            }
            catch (KeeperException ke) {
                this.server.abort("Unexpected ZK exception deleting node " + region, (Throwable)ke);
            }
        }
        for (HRegionInfo hri : regionsToOffline) {
            this.regionOffline(hri);
        }
        for (RegionState state : this.regionsInTransition.values()) {
            HRegionInfo hri = state.getRegion();
            if (assignedRegions.contains(hri)) {
                LOG.info((Object)("Transitioning " + state + " will be handled by SSH for " + sn));
                continue;
            }
            if (!sn.equals((Object)state.getServerName())) continue;
            if (state.isPendingOpenOrOpening() || state.isFailedClose() || state.isOffline()) {
                LOG.info((Object)("Found region in " + state + " to be reassigned by SSH for " + sn));
                rits.add(hri);
                continue;
            }
            LOG.warn((Object)("THIS SHOULD NOT HAPPEN: unexpected " + state));
        }
        this.notifyAll();
        return rits;
    }

    public synchronized List<HRegionInfo> getRegionsOfTable(TableName tableName) {
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        HRegionInfo boundary = new HRegionInfo(tableName, null, null, false, 0L);
        for (HRegionInfo hri : this.regionAssignments.tailMap(boundary).keySet()) {
            if (!hri.getTable().equals((Object)tableName)) break;
            tableRegions.add(hri);
        }
        return tableRegions;
    }

    public synchronized void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws InterruptedException {
        if (!this.isRegionInTransition(hri)) {
            return;
        }
        while (!this.server.isStopped() && this.isRegionInTransition(hri)) {
            RegionState rs = this.getRegionState(hri);
            LOG.info((Object)("Waiting on " + rs + " to clear regions-in-transition"));
            this.waitForUpdate(100L);
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on region in transition because stoppable.isStopped is set");
        }
    }

    public synchronized void tableDeleted(TableName tableName) {
        HashSet<HRegionInfo> regionsToDelete = new HashSet<HRegionInfo>();
        for (RegionState state : this.regionStates.values()) {
            HRegionInfo region = state.getRegion();
            if (!region.getTable().equals((Object)tableName)) continue;
            regionsToDelete.add(region);
        }
        for (HRegionInfo region : regionsToDelete) {
            this.deleteRegion(region);
        }
    }

    synchronized boolean wasRegionOnDeadServer(String encodedName) {
        ServerName server = this.lastAssignments.get(encodedName);
        return this.isServerDeadAndNotProcessed(server);
    }

    synchronized boolean isServerDeadAndNotProcessed(ServerName server) {
        if (server == null) {
            return false;
        }
        if (this.serverManager.isServerOnline(server)) {
            String hostAndPort = server.getHostAndPort();
            long startCode = server.getStartcode();
            Long deadCode = this.deadServers.get(hostAndPort);
            if (deadCode == null || startCode > deadCode) {
                if (this.serverManager.isServerReachable(server)) {
                    return false;
                }
                this.deadServers.put(hostAndPort, startCode);
            }
            LOG.warn((Object)("Couldn't reach online server " + server));
        }
        return !this.processedServers.containsKey(server);
    }

    synchronized ServerName getLastRegionServerOfRegion(String encodedName) {
        return this.lastAssignments.get(encodedName);
    }

    synchronized void setLastRegionServerOfRegions(ServerName serverName, List<HRegionInfo> regionInfos) {
        for (HRegionInfo hri : regionInfos) {
            this.setLastRegionServerOfRegion(serverName, hri.getEncodedName());
        }
    }

    synchronized void setLastRegionServerOfRegion(ServerName serverName, String encodedName) {
        this.lastAssignments.put(encodedName, serverName);
    }

    protected synchronized double getAverageLoad() {
        int numServers = 0;
        int totalLoad = 0;
        for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
            Set<HRegionInfo> regions = e.getValue();
            ServerName serverName = e.getKey();
            int regionCount = regions.size();
            if (regionCount <= 0 && !this.serverManager.isServerOnline(serverName)) continue;
            totalLoad += regionCount;
            ++numServers;
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<TableName, Map<ServerName, List<HRegionInfo>>> getAssignmentsByTable() {
        HashMap<TableName, Map<ServerName, List<HRegionInfo>>> result = new HashMap<TableName, Map<ServerName, List<HRegionInfo>>>();
        RegionStates regionStates = this;
        synchronized (regionStates) {
            if (!this.server.getConfiguration().getBoolean("hbase.master.loadbalance.bytable", false)) {
                HashMap svrToRegions = new HashMap(this.serverHoldings.size());
                for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
                    svrToRegions.put(e.getKey(), new ArrayList(e.getValue()));
                }
                result.put(TableName.valueOf((String)"ensemble"), svrToRegions);
            } else {
                for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
                    for (HRegionInfo hri : e.getValue()) {
                        ArrayList<HRegionInfo> regions;
                        if (hri.isMetaRegion()) continue;
                        TableName tablename = hri.getTable();
                        HashMap<ServerName, ArrayList<HRegionInfo>> svrToRegions = (HashMap<ServerName, ArrayList<HRegionInfo>>)result.get(tablename);
                        if (svrToRegions == null) {
                            svrToRegions = new HashMap<ServerName, ArrayList<HRegionInfo>>(this.serverHoldings.size());
                            result.put(tablename, svrToRegions);
                        }
                        if ((regions = (ArrayList<HRegionInfo>)svrToRegions.get(e.getKey())) == null) {
                            regions = new ArrayList<HRegionInfo>();
                            svrToRegions.put(e.getKey(), regions);
                        }
                        regions.add(hri);
                    }
                }
            }
        }
        Map<ServerName, ServerLoad> onlineSvrs = this.serverManager.getOnlineServers();
        for (Map map : result.values()) {
            for (ServerName svr : onlineSvrs.keySet()) {
                if (map.containsKey(svr)) continue;
                map.put(svr, new ArrayList());
            }
        }
        return result;
    }

    protected synchronized Map<ServerName, List<HRegionInfo>> getRegionAssignmentsByServer() {
        HashMap<ServerName, List<HRegionInfo>> regionsByServer = new HashMap<ServerName, List<HRegionInfo>>(this.serverHoldings.size());
        for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
            regionsByServer.put(e.getKey(), new ArrayList(e.getValue()));
        }
        return regionsByServer;
    }

    protected synchronized RegionState getRegionState(HRegionInfo hri) {
        return this.regionStates.get(hri.getEncodedName());
    }

    protected synchronized RegionState getRegionState(String encodedName) {
        return this.regionStates.get(encodedName);
    }

    protected HRegionInfo getRegionInfo(byte[] regionName) {
        String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        RegionState regionState = this.regionStates.get(encodedName);
        if (regionState != null) {
            return regionState.getRegion();
        }
        try {
            HRegionInfo hri;
            Pair p = MetaReader.getRegion((CatalogTracker)this.server.getCatalogTracker(), (byte[])regionName);
            HRegionInfo hRegionInfo = hri = p == null ? null : (HRegionInfo)p.getFirst();
            if (hri != null) {
                this.createRegionState(hri);
            }
            return hri;
        }
        catch (IOException e) {
            this.server.abort("Aborting because error occoured while reading " + Bytes.toStringBinary((byte[])regionName) + " from hbase:meta", (Throwable)e);
            return null;
        }
    }

    private void deleteRegion(HRegionInfo hri) {
        String encodedName = hri.getEncodedName();
        this.regionsInTransition.remove(encodedName);
        this.regionStates.remove(encodedName);
        this.lastAssignments.remove(encodedName);
        ServerName sn = this.regionAssignments.remove(hri);
        if (sn != null) {
            Set<HRegionInfo> regions = this.serverHoldings.get(sn);
            regions.remove(hri);
        }
    }
}

