/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.locale.Locales;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.RequiredProperties;
import org.pentaho.pms.schema.concept.Concept;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.concept.DefaultPropertyID;
import org.pentaho.pms.schema.concept.types.alignment.AlignmentSettings;
import org.pentaho.pms.schema.concept.types.alignment.ConceptPropertyAlignment;
import org.pentaho.pms.schema.concept.types.color.ColorSettings;
import org.pentaho.pms.schema.concept.types.color.ConceptPropertyColor;
import org.pentaho.pms.schema.concept.types.font.ConceptPropertyFont;
import org.pentaho.pms.schema.concept.types.font.FontSettings;
import org.pentaho.pms.schema.security.SecurityReference;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;
import org.pentaho.pms.util.UniqueArrayList;
import org.pentaho.pms.util.UniqueList;

public class SchemaMeta {
    private String name;
    public String domainName;
    public UniqueList<DatabaseMeta> databases;
    private UniqueList<PhysicalTable> tables;
    private UniqueList<BusinessModel> businessModels;
    private UniqueList<ConceptInterface> concepts;
    private Locales locales;
    private SecurityReference securityReference;
    private RequiredProperties requiredProperties;
    private BusinessModel activeModel;
    private boolean changed;
    private boolean changedDatabases;
    private boolean changedTables;
    private boolean changedBusinessModels;
    private boolean changedConcepts;

    public SchemaMeta() {
        this.clear();
    }

    public void clear() {
        this.databases = new UniqueArrayList<DatabaseMeta>();
        this.tables = new UniqueArrayList<PhysicalTable>();
        this.businessModels = new UniqueArrayList<BusinessModel>();
        this.concepts = new UniqueArrayList<ConceptInterface>();
        this.locales = new Locales();
        this.securityReference = new SecurityReference();
        this.requiredProperties = new RequiredProperties();
        this.activeModel = null;
        this.clearChanged();
    }

    public void addDefaults() {
        Concept baseConcept = new Concept(Settings.getConceptNameBase());
        baseConcept.addProperty(new ConceptPropertyFont(DefaultPropertyID.FONT.getId(), new FontSettings("Arial", 10, false, false)));
        baseConcept.addProperty(new ConceptPropertyAlignment(DefaultPropertyID.ALIGNMENT.getId(), AlignmentSettings.LEFT));
        baseConcept.addProperty(new ConceptPropertyColor(DefaultPropertyID.COLOR_FG.getId(), ColorSettings.BLACK));
        try {
            this.addConcept(baseConcept);
        }
        catch (ObjectAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void addDatabase(DatabaseMeta databaseMeta) throws ObjectAlreadyExistsException {
        this.databases.add(databaseMeta);
        this.changedDatabases = true;
    }

    public void addTable(PhysicalTable ti) throws ObjectAlreadyExistsException {
        this.tables.add(ti);
        this.changedTables = true;
    }

    public void addModel(BusinessModel businessModel) throws ObjectAlreadyExistsException {
        this.businessModels.add(businessModel);
        this.changedBusinessModels = true;
    }

    public void addDatabase(int p, DatabaseMeta databaseMeta) throws ObjectAlreadyExistsException {
        this.databases.add(p, databaseMeta);
        this.changedDatabases = true;
    }

    public void addTable(int p, PhysicalTable ti) throws ObjectAlreadyExistsException {
        this.tables.add(p, ti);
        this.changedTables = true;
    }

    public void addModel(int p, BusinessModel businessModel) throws ObjectAlreadyExistsException {
        this.businessModels.add(p, businessModel);
        this.changedBusinessModels = true;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public PhysicalTable getTable(int i) {
        return this.tables.get(i);
    }

    public BusinessModel getModel(int i) {
        return this.businessModels.get(i);
    }

    public void removeDatabaseMeta(DatabaseMeta databaseMeta) {
        int i = this.databases.indexOf(databaseMeta);
        this.removeDatabaseMeta(i);
    }

    public void removeDatabaseMeta(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.changedDatabases = true;
    }

    public void removeTable(int i) {
        if (i < 0 || i >= this.tables.size()) {
            return;
        }
        this.tables.remove(i);
        this.changedTables = true;
    }

    public void removeBusinessModel(BusinessModel businessModel) {
        int i = this.businessModels.indexOf(businessModel);
        this.removeBusinessModel(i);
    }

    public void removeBusinessModel(int i) {
        if (i < 0 || i >= this.businessModels.size()) {
            return;
        }
        this.businessModels.remove(i);
        this.changedBusinessModels = true;
    }

    public int nrDatabases() {
        return this.databases.size();
    }

    public int nrTables() {
        return this.tables.size();
    }

    public int nrBusinessModels() {
        return this.businessModels.size();
    }

    public boolean haveDatabasesChanged() {
        if (this.changedDatabases) {
            return true;
        }
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveTablesChanged() {
        if (this.changedTables) {
            return true;
        }
        for (int i = 0; i < this.nrTables(); ++i) {
            PhysicalTable ti = this.getTable(i);
            if (ti.hasChanged()) {
                return true;
            }
            for (int ix = 0; ix < ti.nrPhysicalColumns(); ++ix) {
                PhysicalColumn tc = ti.getPhysicalColumn(ix);
                if (!tc.hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean haveBusinessModelsChanged() {
        for (int i = 0; i < this.nrBusinessModels(); ++i) {
            BusinessModel businessModel = this.getModel(i);
            if (!businessModel.hasChanged()) continue;
            return true;
        }
        return this.changedBusinessModels;
    }

    public boolean haveConceptsChanged() {
        if (this.changedConcepts) {
            return true;
        }
        for (int i = 0; i < this.nrConcepts(); ++i) {
            ConceptInterface concept = this.getConcept(i);
            if (!concept.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanged() {
        if (this.haveDatabasesChanged()) {
            return true;
        }
        if (this.haveTablesChanged()) {
            return true;
        }
        if (this.haveBusinessModelsChanged()) {
            return true;
        }
        if (this.haveConceptsChanged()) {
            return true;
        }
        if (this.locales.hasChanged()) {
            return true;
        }
        if (this.securityReference.getSecurityService().hasChanged()) {
            return true;
        }
        return this.changed;
    }

    public void clearChanged() {
        int i;
        this.changed = false;
        this.changedDatabases = false;
        this.changedTables = false;
        this.changedBusinessModels = false;
        this.changedConcepts = false;
        for (i = 0; i < this.nrDatabases(); ++i) {
            this.getDatabase(i).setChanged(false);
        }
        for (i = 0; i < this.nrTables(); ++i) {
            this.getTable(i).clearChanged();
        }
        for (i = 0; i < this.nrBusinessModels(); ++i) {
            this.getModel(i).clearChanged();
        }
        for (i = 0; i < this.nrConcepts(); ++i) {
            this.getConcept(i).clearChanged();
        }
        this.locales.clearChanged();
        this.securityReference.getSecurityService().setChanged(false);
    }

    public DatabaseMeta findDatabase(String dbName) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.getName().equalsIgnoreCase(dbName)) continue;
            return ci;
        }
        return null;
    }

    public PhysicalTable findPhysicalTable(String id) {
        return this.findPhysicalTable(id, (PhysicalTable)null);
    }

    public PhysicalTable findPhysicalTable(String id, PhysicalTable exclude) {
        int excl = -1;
        if (exclude != null) {
            excl = this.indexOfTable(exclude);
        }
        for (int i = 0; i < this.nrTables(); ++i) {
            PhysicalTable ti = this.getTable(i);
            if (i == excl || !ti.getId().equalsIgnoreCase(id)) continue;
            return ti;
        }
        return null;
    }

    public PhysicalTable findPhysicalTable(String locale, String nameToFind) {
        for (int i = 0; i < this.nrTables(); ++i) {
            PhysicalTable physicalTable = this.getTable(i);
            if (!nameToFind.equalsIgnoreCase(physicalTable.getConcept().getName(locale))) continue;
            return physicalTable;
        }
        return this.findPhysicalTable(nameToFind);
    }

    public int indexOfDatabase(DatabaseMeta ci) {
        return this.databases.indexOf(ci);
    }

    public int indexOfTable(PhysicalTable ti) {
        return this.tables.indexOf(ti);
    }

    public int indexOfBusinessModel(BusinessModel model) {
        return this.businessModels.indexOf(model);
    }

    public BusinessModel findModel(String id) {
        for (int i = 0; i < this.nrBusinessModels(); ++i) {
            BusinessModel businessModel = this.getModel(i);
            if (!businessModel.getId().equals(id)) continue;
            return businessModel;
        }
        return null;
    }

    public BusinessModel findModel(String locale, String nameToFind) {
        for (int i = 0; i < this.nrBusinessModels(); ++i) {
            BusinessModel businessModel = this.getModel(i);
            String locName = businessModel.getConcept().getName(locale);
            if ((locName == null || !locName.equals(nameToFind)) && !businessModel.getId().equals(nameToFind)) continue;
            return businessModel;
        }
        return null;
    }

    public PhysicalColumn findPhysicalColumn(String tableId, String columnId) {
        PhysicalTable ti = this.findPhysicalTable(tableId);
        if (ti != null) {
            return ti.findPhysicalColumn(columnId);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public UniqueList<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    public UniqueList<PhysicalTable> getTables() {
        return this.tables;
    }

    public PhysicalTable[] getTablesOnDatabase(DatabaseMeta databaseMeta) {
        ArrayList<PhysicalTable> allTables = new ArrayList<PhysicalTable>();
        for (int i = 0; i < this.nrTables(); ++i) {
            PhysicalTable table = this.getTable(i);
            if (table.getDatabaseMeta() == null || !table.getDatabaseMeta().equals((Object)databaseMeta)) continue;
            allTables.add(table);
        }
        return allTables.toArray(new PhysicalTable[allTables.size()]);
    }

    public BusinessModel getActiveModel() {
        return this.activeModel;
    }

    public void setActiveModel(BusinessModel activeModel) {
        this.activeModel = activeModel;
    }

    public UniqueList<BusinessModel> getBusinessModels() {
        return this.businessModels;
    }

    public String[] getBusinessModelIDs() {
        String[] ids = new String[this.businessModels.size()];
        for (int i = 0; i < this.businessModels.size(); ++i) {
            ids[i] = this.businessModels.get(i).getId();
        }
        return ids;
    }

    public String[] getBusinessModelNames(String locale) {
        String[] names = new String[this.businessModels.size()];
        for (int i = 0; i < this.businessModels.size(); ++i) {
            names[i] = this.businessModels.get(i).getDisplayName(locale);
        }
        return names;
    }

    public UniqueList getConcepts() {
        return this.concepts;
    }

    public int nrConcepts() {
        return this.concepts.size();
    }

    public ConceptInterface getConcept(int i) {
        return this.concepts.get(i);
    }

    public void removeConcept(int i) {
        this.concepts.remove(i);
        this.changedConcepts = true;
    }

    public void addConcept(ConceptInterface concept) throws ObjectAlreadyExistsException {
        this.concepts.add(concept);
        this.changedConcepts = true;
    }

    public void addConcept(int index, ConceptInterface concept) throws ObjectAlreadyExistsException {
        this.concepts.add(index, concept);
        this.changedConcepts = true;
    }

    public int indexOfConcept(ConceptInterface concept) {
        return this.concepts.indexOf(concept);
    }

    public void setConcept(int idx, ConceptInterface concept) throws ObjectAlreadyExistsException {
        this.concepts.set(idx, concept);
        this.changedConcepts = true;
    }

    public ConceptInterface findConcept(String[] path) {
        for (int i = 0; i < this.nrConcepts(); ++i) {
            ConceptInterface concept = this.getConcept(i);
            if (!concept.matches(path)) continue;
            return concept;
        }
        return null;
    }

    public String[] getUsedLocale() {
        Hashtable<String, String> allLocales = new Hashtable<String, String>();
        for (int i = 0; i < this.nrBusinessModels(); ++i) {
            String[] usedLocale = this.getModel(i).getConcept().getUsedLocale();
            for (int j = 0; j < usedLocale.length; ++j) {
                allLocales.put(usedLocale[i], "");
            }
        }
        Set keySet = allLocales.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public ConceptInterface findConcept(String conceptName) {
        for (int i = 0; i < this.nrConcepts(); ++i) {
            ConceptInterface concept = this.getConcept(i);
            if (!concept.getName().equals(conceptName)) continue;
            return concept;
        }
        return null;
    }

    public RequiredProperties getDefaultProperties() {
        return this.requiredProperties;
    }

    public void setDefaultProperties(RequiredProperties requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    public String[] getTableNames(String locale) {
        String[] names = new String[this.nrTables()];
        for (int i = 0; i < this.nrTables(); ++i) {
            names[i] = this.getTable(i).getDisplayName(locale);
        }
        return names;
    }

    public String getActiveLocale() {
        return this.locales.getActiveLocale();
    }

    public void setActiveLocale(String selectedLocale) {
        this.locales.setActiveLocale(selectedLocale);
    }

    public Locales getLocales() {
        return this.locales;
    }

    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public SecurityReference getSecurityReference() {
        return this.securityReference;
    }

    public void setSecurityReference(SecurityReference securityReference) {
        this.securityReference = securityReference;
    }

    public List<ConceptUtilityInterface> getConceptUtilityInterfaces() {
        ArrayList<ConceptUtilityInterface> list = new ArrayList<ConceptUtilityInterface>();
        for (int i = 0; i < this.nrTables(); ++i) {
            list.add(this.getTable(i));
        }
        for (int v = 0; v < this.nrBusinessModels(); ++v) {
            BusinessModel businessModel = this.getModel(v);
            list.add(businessModel);
            for (int t = 0; t < businessModel.nrBusinessTables(); ++t) {
                BusinessTable table = businessModel.getBusinessTable(t);
                list.add(table);
                for (int c = 0; c < table.nrBusinessColumns(); ++c) {
                    BusinessColumn column = table.getBusinessColumn(c);
                    list.add(column);
                }
            }
            for (int c = 0; c < businessModel.getRootCategory().nrBusinessCategories(); ++c) {
                list.add(businessModel.getRootCategory().getBusinessCategory(c));
            }
        }
        return list;
    }

    public String[] getConceptNames() {
        String[] conceptNames = new String[this.nrConcepts()];
        for (int i = 0; i < conceptNames.length; ++i) {
            conceptNames[i] = this.getConcept(i).getName();
        }
        Const.sortStrings(conceptNames);
        return conceptNames;
    }
}

