/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.test;

import java.util.Collection;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.pms.core.CWM;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.CwmDescription;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmExpression;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmModelElement;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmPackage;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmColumn;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmTable;

public class TestCWM {
    public static final String DOMAIN = "SomeDomain";
    private static final String TEST_TABLE_NAME = "PentahoTable1";
    private static CWM cwm = CWM.getInstance("SomeDomain");

    public static void main(String[] args) throws Exception {
        TestCWM testCWM = new TestCWM();
        testCWM.storeTable();
        testCWM.readBack();
        String[] domainNames = CWM.getDomainNames();
        for (int i = 0; i < domainNames.length; ++i) {
            System.out.println("Package #" + (i + 1) + " found : " + domainNames[i]);
            cwm.removePackage(domainNames[i]);
        }
        CWM.quitAndSync();
    }

    public void storeTable() {
        CwmTable table = cwm.getTable(TEST_TABLE_NAME);
        if (table == null) {
            System.out.println("Table [PentahoTable1] not found: creating...");
        } else {
            System.out.println("Table [PentahoTable1] found: overwriting...");
        }
        cwm.beginTransaction();
        RowMeta fields = new RowMeta();
        ValueMeta field1 = new ValueMeta("field1", 2);
        field1.setLength(35);
        field1.setOrigin("field1 description");
        fields.addValueMeta((ValueMetaInterface)field1);
        ValueMeta field2 = new ValueMeta("field2", 1);
        field2.setLength(7, 2);
        field2.setOrigin("field2 description");
        fields.addValueMeta((ValueMetaInterface)field2);
        ValueMeta field3 = new ValueMeta("field3", 5);
        field3.setLength(5);
        field3.setOrigin("field3 description");
        fields.addValueMeta((ValueMetaInterface)field3);
        ValueMeta field4 = new ValueMeta("field4", 3);
        field4.setOrigin("field4 description");
        fields.addValueMeta((ValueMetaInterface)field4);
        ValueMeta field5 = new ValueMeta("field5", 6);
        field5.setLength(52, 16);
        field5.setOrigin("field5 description");
        fields.addValueMeta((ValueMetaInterface)field5);
        ValueMeta field6 = new ValueMeta("field6", 4);
        field6.setOrigin("field6 description");
        fields.addValueMeta((ValueMetaInterface)field6);
        table = cwm.createTable(TEST_TABLE_NAME, (RowMetaInterface)fields);
        CwmDescription description = cwm.createDescription("This is a table description");
        cwm.setDescription((CwmModelElement)table, description);
        Collection collection = table.getOwnedElement();
        CwmColumn[] columns = collection.toArray(new CwmColumn[collection.size()]);
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface field = fields.getValueMeta(i);
            CwmColumn column = columns[i];
            description = cwm.createDescription(field.getOrigin());
            cwm.setDescription((CwmModelElement)column, description);
        }
        CwmPackage p = cwm.createPackage("SomeDomain package");
        Collection ca = p.getImportedElement();
        ca.add(table);
        cwm.setDescription((CwmModelElement)p, cwm.createDescription("This is a package description for [SomeDomain]"));
        cwm.endTransaction();
        System.out.println("Finished writing to table [PentahoTable1].");
    }

    public void readBack() {
        CwmTable table = cwm.getTable(TEST_TABLE_NAME);
        if (table != null) {
            System.out.println("Readback found table : " + table.getName());
            CwmDescription[] tableDescription = cwm.getDescription((CwmModelElement)table);
            for (int i = 0; i < tableDescription.length; ++i) {
                System.out.println("Table description #" + (i + 1) + " : " + tableDescription[i].getBody());
            }
            Collection collection = table.getOwnedElement();
            for (CwmColumn column : collection) {
                System.out.print("Column: " + column.getName() + ", type=" + column.getType().getName() + ", length=" + column.getLength() + ", precision=" + column.getPrecision());
                CwmExpression expression = column.getInitialValue();
                if (expression != null) {
                    System.out.print(" Formula: " + expression.getBody() + " (" + expression.getLanguage() + ")");
                }
                CwmDescription[] columnDescription = cwm.getDescription((CwmModelElement)column);
                for (int i = 0; i < columnDescription.length; ++i) {
                    System.out.print(" [" + columnDescription[i].getBody() + "]");
                }
                System.out.println();
            }
            CwmPackage p = cwm.getPackage(DOMAIN);
            if (p != null) {
                System.out.println("Package found ! --> " + p.getName());
                CwmDescription[] description = cwm.getDescription((CwmModelElement)p);
                for (int i = 0; i < description.length; ++i) {
                    System.out.println("Package description #" + (i + 1) + " --> " + description[i].getBody());
                }
            }
        } else {
            System.out.println("Couldn't find table PentahoTable1");
        }
    }

    public void removeTable() {
        cwm.removeTable(TEST_TABLE_NAME);
    }
}

