/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.utils.ServiceUtils;

public class AWSCredentials
implements Serializable {
    private static final long serialVersionUID = 4856782158657135551L;
    protected static final Log log = LogFactory.getLog((Class)AWSCredentials.class);
    public static final int CREDENTIALS_STORAGE_VERSION = 3;
    protected static final String V2_KEYS_DELIMITER = "AWSKEYS";
    protected static final String V3_KEYS_DELIMITER = "\n";
    protected static final String VERSION_PREFIX = "jets3t AWS Credentials, version: ";
    protected static final String REGULAR_TYPE_NAME = "regular";
    protected static final String DEVPAY_TYPE_NAME = "devpay";
    protected String awsAccessKey = null;
    protected String awsSecretAccessKey = null;
    protected String friendlyName = null;

    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey, String friendlyName) {
        this(awsAccessKey, awsSecretAccessKey);
        this.friendlyName = friendlyName;
    }

    public String getAccessKey() {
        return this.awsAccessKey;
    }

    public String getSecretKey() {
        return this.awsSecretAccessKey;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean hasFriendlyName() {
        return this.friendlyName != null && this.friendlyName.trim().length() > 0;
    }

    public String getLogString() {
        return this.getAccessKey() + " : " + this.getSecretKey();
    }

    protected String getTypeName() {
        return REGULAR_TYPE_NAME;
    }

    protected String getDataToEncrypt() {
        return this.getAccessKey() + V3_KEYS_DELIMITER + this.getSecretKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String password, File file, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.save(password, fos, algorithm);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void save(String password, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, file, "PBEWithMD5AndDES");
    }

    public void save(String password, OutputStream outputStream, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        BufferedOutputStream bufferedOS = null;
        EncryptionUtil encryptionUtil = new EncryptionUtil(password, algorithm, "2");
        bufferedOS = new BufferedOutputStream(outputStream);
        byte[] encryptedData = encryptionUtil.encrypt(this.getDataToEncrypt());
        bufferedOS.write("jets3t AWS Credentials, version: 3\n".getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((encryptionUtil.getAlgorithm() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(((this.friendlyName == null ? "" : this.friendlyName) + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((this.getTypeName() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(encryptedData);
        bufferedOS.flush();
    }

    public void save(String password, OutputStream outputStream) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, outputStream, "PBEWithMD5AndDES");
    }

    public static AWSCredentials load(String password, File file) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading credentials from file: " + file.getAbsolutePath()));
        }
        BufferedInputStream fileIS = null;
        try {
            fileIS = new BufferedInputStream(new FileInputStream(file));
            AWSCredentials aWSCredentials = AWSCredentials.load(password, fileIS);
            return aWSCredentials;
        }
        catch (Throwable t) {
            throw new S3ServiceException("Failed to load AWS credentials", t);
        }
        finally {
            if (fileIS != null) {
                try {
                    fileIS.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AWSCredentials load(String password, BufferedInputStream inputStream) throws S3ServiceException {
        boolean partialReadOnly;
        boolean bl = partialReadOnly = password == null;
        if (partialReadOnly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading partial information about AWS Credentials from input stream");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Loading AWS Credentials from input stream");
        }
        try {
            int expectedParts;
            Object credentialsType;
            EncryptionUtil encryptionUtil = null;
            byte[] encryptedKeys = new byte[2048];
            int encryptedDataIndex = 0;
            String version = null;
            int versionNum = 0;
            String algorithm = "";
            String friendlyName = "";
            boolean usingDevPay = false;
            version = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            versionNum = Integer.parseInt(version.substring(VERSION_PREFIX.length()));
            algorithm = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            friendlyName = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
            if (!partialReadOnly) {
                encryptionUtil = new EncryptionUtil(password, algorithm, "2");
            }
            if (3 <= versionNum) {
                credentialsType = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                usingDevPay = DEVPAY_TYPE_NAME.equals(credentialsType);
            }
            if (partialReadOnly) {
                if (usingDevPay) {
                    credentialsType = new AWSDevPayCredentials(null, null, friendlyName);
                    return credentialsType;
                }
                credentialsType = new AWSCredentials(null, null, friendlyName);
                return credentialsType;
            }
            encryptedDataIndex = inputStream.read(encryptedKeys);
            String keys = encryptionUtil.decryptString(encryptedKeys, 0, encryptedDataIndex);
            String[] parts = keys.split(3 <= versionNum ? V3_KEYS_DELIMITER : V2_KEYS_DELIMITER);
            int n = expectedParts = usingDevPay ? 4 : 2;
            if (parts.length != expectedParts) {
                throw new Exception("Number of parts (" + parts.length + ") did not match the expected number of parts (" + expectedParts + ") for this version (" + versionNum + ")");
            }
            if (usingDevPay) {
                AWSDevPayCredentials aWSDevPayCredentials = new AWSDevPayCredentials(parts[0], parts[1], parts[2], parts[3], friendlyName);
                return aWSDevPayCredentials;
            }
            AWSCredentials aWSCredentials = new AWSCredentials(parts[0], parts[1], friendlyName);
            return aWSCredentials;
        }
        catch (BadPaddingException bpe) {
            throw new S3ServiceException("Unable to decrypt AWS credentials. Is your password correct?", bpe);
        }
        catch (Throwable t) {
            throw new S3ServiceException("Failed to load AWS credentials", t);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            AWSCredentials.printHelp();
            System.exit(1);
        }
        String userName = args[0];
        File encryptedFile = new File(args[1]);
        String algorithm = "PBEWithMD5AndDES";
        if (args.length == 3) {
            algorithm = args[2];
        }
        try {
            FileOutputStream testFOS = new FileOutputStream(encryptedFile);
            testFOS.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write to file: " + encryptedFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please enter your AWS Credentials");
        System.out.print("Access Key: ");
        String awsAccessKey = reader.readLine();
        System.out.print("Secret Key: ");
        String awsSecretKey = reader.readLine();
        System.out.println("Please enter a password to protect your credentials file (may be empty)");
        System.out.print("Password: ");
        String password = reader.readLine();
        AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey, userName);
        awsCredentials.save(password, encryptedFile, algorithm);
        System.out.println("Successfully saved AWS Credentials to " + encryptedFile);
    }

    private static void printHelp() {
        System.out.println("AWSCredentials <User Name> <File Path> [algorithm]");
        System.out.println();
        System.out.println("User Name: A human-friendly name for the owner of the credentials, e.g. Horace.");
        System.out.println("File Path: Path and name for the encrypted file. Will be replaced if it already exists.");
        System.out.println("Algorithm: PBE encryption algorithm. Defaults to PBEWithMD5AndDES");
    }
}

