/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.db.SQLFailureHandler;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerRecordReader;

public class SQLServerDBRecordReader<T extends SqoopRecord>
extends SqlServerRecordReader<T> {
    private static final Log LOG = LogFactory.getLog(SQLServerDBRecordReader.class);
    protected SQLFailureHandler failureHandler = null;
    protected static final int RETRY_MAX = 3;
    private String splitColumn;
    private String lastRecordKey;

    public SQLServerDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table, String dbProduct) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
    }

    @Override
    public T getCurrentValue() {
        SqoopRecord val = (SqoopRecord)super.getCurrentValue();
        Object lastRecordSplitCol = val.getFieldMap().get(this.splitColumn);
        this.lastRecordKey = lastRecordSplitCol == null ? null : lastRecordSplitCol.toString();
        return (T)val;
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Class connHandlerClass;
        Configuration conf = this.getConf();
        if (conf == null) {
            LOG.error((Object)"Configuration cannot be NULL");
        }
        try {
            String className = conf.get("sqoop.import.failure.handler.class");
            connHandlerClass = conf.getClassByName(className);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Failed to find class: sqoop.import.failure.handler.class");
            throw new IOException(ex);
        }
        if (!SQLFailureHandler.class.isAssignableFrom(connHandlerClass)) {
            String error = "A subclass of " + SQLFailureHandler.class.getName() + " is expected. Actual class set is: " + connHandlerClass.getName();
            LOG.error((Object)error);
            throw new IOException(error);
        }
        LOG.trace((Object)("Using connection handler class: " + connHandlerClass));
        this.failureHandler = (SQLFailureHandler)ReflectionUtils.newInstance((Class)connHandlerClass, (Configuration)conf);
        this.failureHandler.initialize(conf);
        this.splitColumn = this.getDBConf().getInputOrderBy();
        if (this.splitColumn == null || this.splitColumn.length() == 0) {
            throw new IOException("Split column must be set");
        }
        int splitColLen = this.splitColumn.length();
        if (splitColLen > 2 && this.splitColumn.charAt(0) == '[' && this.splitColumn.charAt(splitColLen - 1) == ']') {
            this.splitColumn = this.splitColumn.substring(1, splitColLen - 1);
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        boolean valueReceived = false;
        int retryCount = 3;
        boolean doRetry = true;
        do {
            try {
                valueReceived = super.nextKeyValue();
                doRetry = false;
            }
            catch (IOException ioEx) {
                LOG.warn((Object)"Trying to recover from DB read failure: ", (Throwable)ioEx);
                Throwable cause = ioEx.getCause();
                if (this.failureHandler.canHandleFailure(cause)) {
                    Connection conn = this.failureHandler.recover();
                    this.configureConnection(conn);
                    this.setConnection(conn);
                    doRetry = --retryCount >= 0;
                    continue;
                }
                throw new IOException("Cannection handler cannot recover failure: ", ioEx);
            }
        } while (doRetry);
        if (retryCount < 0) {
            throw new IOException("Failed to read from database after 3 retries.");
        }
        return valueReceived;
    }

    protected void configureConnection(Connection conn) throws IOException {
        try {
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            LOG.error((Object)"Failed to configure SQL Connection");
            throw new IOException(sqlEx);
        }
    }

    @Override
    protected String getSelectQuery() {
        String selectQuery;
        if (this.lastRecordKey == null) {
            selectQuery = super.getSelectQuery();
        } else {
            DataDrivenDBInputFormat.DataDrivenDBInputSplit dataSplit = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)this.getSplit();
            StringBuilder lowerClause = new StringBuilder();
            lowerClause.append(this.getDBConf().getInputOrderBy());
            lowerClause.append(" > ");
            lowerClause.append(this.lastRecordKey.toString());
            selectQuery = this.getSelectQuery(lowerClause.toString(), dataSplit.getUpperClause());
        }
        return selectQuery;
    }
}

