/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.HasOverwritePrompter;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.CanLimitDirs;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExportSaxParser;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class RepositoryImporter
implements IRepositoryImporter,
CanLimitDirs {
    public static final String IMPORT_ASK_ABOUT_REPLACE_DB = "IMPORT_ASK_ABOUT_REPLACE_DB";
    public static final String IMPORT_ASK_ABOUT_REPLACE_SS = "IMPORT_ASK_ABOUT_REPLACE_SS";
    public static final String IMPORT_ASK_ABOUT_REPLACE_CS = "IMPORT_ASK_ABOUT_REPLACE_CS";
    public static final String IMPORT_ASK_ABOUT_REPLACE_PS = "IMPORT_ASK_ABOUT_REPLACE_PS";
    private static final Class<?> PKG = RepositoryImporter.class;
    private Repository rep;
    private LogChannelInterface log;
    private SharedObjects sharedObjects;
    private RepositoryDirectoryInterface baseDirectory;
    private RepositoryDirectoryInterface root;
    private boolean overwrite;
    private boolean askOverwrite = true;
    private String versionComment;
    private boolean needToCheckPathForVariables;
    private boolean continueOnError;
    private String transDirOverride = null;
    private String jobDirOverride = null;
    private ImportRules importRules;
    private List<String> limitDirs;
    private List<RepositoryObject> referencingObjects;
    private List<Exception> exceptions;
    private OverwritePrompter overwritePrompter;
    private final Set<String> rememberPropertyNamesToOverwrite = new HashSet<String>();
    private int transformationNumber = 1;
    private DocumentBuilder documentBuilder;
    private int jobNumber = 1;

    public RepositoryImporter(Repository repository) {
        this(repository, new ImportRules(), new ArrayList<String>());
    }

    public RepositoryImporter(Repository repository, LogChannelInterface log) {
        this(repository, new ImportRules(), Collections.emptyList(), log);
    }

    public RepositoryImporter(Repository repository, ImportRules importRules, List<String> limitDirs) {
        this(repository, importRules, limitDirs, (LogChannelInterface)new LogChannel((Object)"Repository import"));
    }

    public RepositoryImporter(Repository repository, ImportRules importRules, List<String> limitDirs, LogChannelInterface log) {
        this.log = log;
        this.rep = repository;
        this.importRules = importRules;
        this.limitDirs = limitDirs;
        this.exceptions = new ArrayList<Exception>();
    }

    private boolean isRemembered(String rememberPropertyName) {
        return !"Y".equalsIgnoreCase(Props.getInstance().getProperty(rememberPropertyName));
    }

    private boolean getPromptResult(String message, String rememberText, String rememberPropertyName) {
        if (this.isRemembered(rememberPropertyName)) {
            return this.rememberPropertyNamesToOverwrite.contains(rememberPropertyName);
        }
        boolean result = this.overwritePrompter.overwritePrompt(message, rememberText, rememberPropertyName);
        if (result) {
            this.rememberPropertyNamesToOverwrite.add(rememberPropertyName);
        } else {
            this.rememberPropertyNamesToOverwrite.remove(rememberPropertyName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void importAll(RepositoryImportFeedbackInterface feedback, String fileDirectory, String[] filenames, RepositoryDirectoryInterface baseDirectory, boolean overwrite, boolean continueOnError, String versionComment) {
        this.baseDirectory = baseDirectory;
        this.overwrite = overwrite;
        this.continueOnError = continueOnError;
        this.versionComment = versionComment;
        String importPathCompatibility = System.getProperty("KETTLE_COMPATIBILITY_IMPORT_PATH_ADDITION_ON_VARIABLES", "N");
        this.needToCheckPathForVariables = "N".equalsIgnoreCase(importPathCompatibility);
        boolean askReplace = Props.getInstance().askAboutReplacingDatabaseConnections();
        if (askReplace) {
            if (feedback instanceof HasOverwritePrompter) {
                Props.getInstance().setProperty(IMPORT_ASK_ABOUT_REPLACE_CS, "Y");
                Props.getInstance().setProperty(IMPORT_ASK_ABOUT_REPLACE_DB, "Y");
                Props.getInstance().setProperty(IMPORT_ASK_ABOUT_REPLACE_PS, "Y");
                Props.getInstance().setProperty(IMPORT_ASK_ABOUT_REPLACE_SS, "Y");
                this.overwritePrompter = ((HasOverwritePrompter)feedback).getOverwritePrompter();
            } else {
                this.overwritePrompter = new OverwritePrompter(){

                    public boolean overwritePrompt(String arg0, String arg1, String arg2) {
                        throw new RuntimeException(BaseMessages.getString((Class)PKG, (String)"RepositoryImporter.CannotPrompt.Label", (String[])new String[0]));
                    }
                };
            }
        } else {
            final boolean replaceExisting = Props.getInstance().replaceExistingDatabaseConnections();
            this.overwritePrompter = new OverwritePrompter(){

                public boolean overwritePrompt(String arg0, String arg1, String arg2) {
                    return replaceExisting;
                }
            };
        }
        this.referencingObjects = new ArrayList<RepositoryObject>();
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportXML.Label", (String[])new String[0]));
        try {
            this.loadSharedObjects();
            RepositoryImportLocation.setRepositoryImportLocation(baseDirectory);
            for (int ii = 0; ii < filenames.length; ++ii) {
                String filename;
                String string = filename = !Const.isEmpty((String)fileDirectory) ? fileDirectory + Const.FILE_SEPARATOR + filenames[ii] : filenames[ii];
                if (this.log.isBasic()) {
                    this.log.logBasic("Import objects from XML file [" + filename + "]");
                }
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.WhichFile.Log", (String[])new String[]{filename}));
                feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.WhichDir.Label", (String[])new String[0]));
                try {
                    RepositoryExportSaxParser parser = new RepositoryExportSaxParser(filename, feedback);
                    parser.parse(this);
                    continue;
                }
                catch (Exception e) {
                    this.addException(e);
                    feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Message", (String[])new String[0]), e);
                }
            }
            for (RepositoryObject ro : this.referencingObjects) {
                if (ro.getObjectType() == RepositoryObjectType.TRANSFORMATION) {
                    TransMeta transMeta = this.rep.loadTransformation(ro.getObjectId(), null);
                    try {
                        transMeta.lookupRepositoryReferences(this.rep);
                    }
                    catch (KettleException e) {
                        feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.LookupRepoRefsError.Log", (String[])new String[]{transMeta.getName()}));
                    }
                    this.rep.save(transMeta, "import object reference specification", null);
                    continue;
                }
                if (ro.getObjectType() != RepositoryObjectType.JOB) continue;
                JobMeta jobMeta = this.rep.loadJob(ro.getObjectId(), null);
                try {
                    jobMeta.lookupRepositoryReferences(this.rep);
                }
                catch (KettleException e) {
                    feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.LookupRepoRefsError.Log", (String[])new String[]{jobMeta.getName()}));
                }
                this.rep.save(jobMeta, "import object reference specification", null);
            }
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportFinished.Log", (String[])new String[0]));
        }
        catch (Exception e) {
            this.addException(e);
            feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorGeneral.Message", (String[])new String[0]), e);
        }
        finally {
            RepositoryImportLocation.setRepositoryImportLocation(null);
        }
    }

    protected void loadSharedObjects() throws KettleException {
        this.sharedObjects = new SharedObjects();
        for (ObjectId id : this.rep.getDatabaseIDs(false)) {
            DatabaseMeta databaseMeta = this.rep.loadDatabaseMeta(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, databaseMeta);
            this.sharedObjects.storeObject((SharedObjectInterface)databaseMeta);
        }
        ObjectId[] slaveIDs = this.rep.getSlaveIDs(false);
        ArrayList<SlaveServer> slaveServers = new ArrayList<SlaveServer>(slaveIDs.length);
        for (ObjectId id : slaveIDs) {
            SlaveServer slaveServer = this.rep.loadSlaveServer(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, slaveServer);
            this.sharedObjects.storeObject(slaveServer);
            slaveServers.add(slaveServer);
        }
        for (ObjectId id : this.rep.getClusterIDs(false)) {
            ClusterSchema clusterSchema = this.rep.loadClusterSchema(id, slaveServers, null);
            RepositoryImporter.validateImportedElement(this.importRules, clusterSchema);
            this.sharedObjects.storeObject(clusterSchema);
        }
        for (ObjectId id : this.rep.getPartitionSchemaIDs(false)) {
            PartitionSchema partitionSchema = this.rep.loadPartitionSchema(id, null);
            RepositoryImporter.validateImportedElement(this.importRules, partitionSchema);
            this.sharedObjects.storeObject(partitionSchema);
        }
    }

    public static void validateImportedElement(ImportRules importRules, Object subject) throws KettleException {
        List<ImportValidationFeedback> feedback = importRules.verifyRules(subject);
        List<ImportValidationFeedback> errors = ImportValidationFeedback.getErrors(feedback);
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder(BaseMessages.getString(PKG, (String)"RepositoryImporter.ValidationFailed.Message", (String[])new String[]{subject.toString()}));
            message.append(Const.CR);
            for (ImportValidationFeedback error : errors) {
                message.append(" - ");
                message.append(error.toString());
                message.append(Const.CR);
            }
            throw new KettleException(message.toString());
        }
    }

    @Override
    public void addLog(String line) {
        this.log.logBasic(line);
    }

    @Override
    public void setLabel(String labelText) {
        this.log.logBasic(labelText);
    }

    @Override
    public boolean transOverwritePrompt(TransMeta transMeta) {
        return this.overwrite;
    }

    @Override
    public boolean jobOverwritePrompt(JobMeta jobMeta) {
        return this.overwrite;
    }

    @Override
    public void updateDisplay() {
    }

    @Override
    public void showError(String title, String message, Exception e) {
        this.log.logError(message, (Throwable)e);
    }

    protected <T extends SharedObjectInterface> List<T> getSharedObjects(Class<T> clazz) {
        ArrayList<SharedObjectInterface> result = new ArrayList<SharedObjectInterface>();
        for (SharedObjectInterface sharedObject : this.sharedObjects.getObjectsMap().values()) {
            if (!clazz.isInstance(sharedObject)) continue;
            result.add(sharedObject);
        }
        return result;
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    protected boolean equals(DatabaseMeta databaseMeta, DatabaseMeta databaseMeta2) {
        if (!this.equals(databaseMeta.getName(), databaseMeta2.getName())) {
            return false;
        }
        if (!this.equals(databaseMeta.getPluginId(), databaseMeta2.getPluginId())) {
            return false;
        }
        if (!this.equals(databaseMeta.getAccessType(), databaseMeta2.getAccessType())) {
            return false;
        }
        if (!this.equals(databaseMeta.getHostname(), databaseMeta2.getHostname())) {
            return false;
        }
        if (!this.equals(databaseMeta.getDatabaseName(), databaseMeta2.getDatabaseName())) {
            return false;
        }
        if (!this.equals(databaseMeta.getDatabasePortNumberString(), databaseMeta2.getDatabasePortNumberString())) {
            return false;
        }
        if (!this.equals(databaseMeta.getUsername(), databaseMeta2.getUsername())) {
            return false;
        }
        if (!this.equals(databaseMeta.getPassword(), databaseMeta2.getPassword())) {
            return false;
        }
        if (!this.equals(databaseMeta.getServername(), databaseMeta2.getServername())) {
            return false;
        }
        if (!this.equals(databaseMeta.getDataTablespace(), databaseMeta2.getDataTablespace())) {
            return false;
        }
        if (!this.equals(databaseMeta.getIndexTablespace(), databaseMeta2.getIndexTablespace())) {
            return false;
        }
        HashMap<Object, Object> databaseMeta2Attributes = new HashMap<Object, Object>(databaseMeta2.getAttributes());
        for (Map.Entry<Object, Object> databaseMetaEntry : new HashMap<Object, Object>(databaseMeta.getAttributes()).entrySet()) {
            Object value = databaseMeta2Attributes.remove(databaseMetaEntry.getKey());
            if (this.equals(value, databaseMetaEntry.getValue())) continue;
            return false;
        }
        return databaseMeta2Attributes.size() <= 0;
    }

    protected boolean equals(SlaveServer slaveServer, SlaveServer slaveServer2) {
        if (!this.equals(slaveServer.getName(), slaveServer2.getName())) {
            return false;
        }
        if (!this.equals(slaveServer.getHostname(), slaveServer2.getHostname())) {
            return false;
        }
        if (!this.equals(slaveServer.getPort(), slaveServer2.getPort())) {
            return false;
        }
        if (!this.equals(slaveServer.getWebAppName(), slaveServer2.getWebAppName())) {
            return false;
        }
        if (!this.equals(slaveServer.getUsername(), slaveServer2.getUsername())) {
            return false;
        }
        if (!this.equals(slaveServer.getPassword(), slaveServer2.getPassword())) {
            return false;
        }
        if (!this.equals(slaveServer.getProxyHostname(), slaveServer2.getProxyHostname())) {
            return false;
        }
        if (!this.equals(slaveServer.getProxyPort(), slaveServer2.getProxyPort())) {
            return false;
        }
        if (!this.equals(slaveServer.getNonProxyHosts(), slaveServer2.getNonProxyHosts())) {
            return false;
        }
        return this.equals(slaveServer.isMaster(), slaveServer2.isMaster());
    }

    protected boolean equals(PartitionSchema partitionSchema, PartitionSchema partitionSchema2) {
        if (!this.equals(partitionSchema.getName(), partitionSchema2.getName())) {
            return false;
        }
        if (!this.equals(partitionSchema.getPartitionIDs(), partitionSchema2.getPartitionIDs())) {
            return false;
        }
        if (!this.equals(partitionSchema.isDynamicallyDefined(), partitionSchema2.isDynamicallyDefined())) {
            return false;
        }
        return this.equals(partitionSchema.getNumberOfPartitionsPerSlave(), partitionSchema2.getNumberOfPartitionsPerSlave());
    }

    protected boolean equals(ClusterSchema clusterSchema, ClusterSchema clusterSchema2) {
        if (!this.equals(clusterSchema.getName(), clusterSchema2.getName())) {
            return false;
        }
        if (!this.equals(clusterSchema.getBasePort(), clusterSchema2.getBasePort())) {
            return false;
        }
        if (!this.equals(clusterSchema.getSocketsBufferSize(), clusterSchema2.getSocketsBufferSize())) {
            return false;
        }
        if (!this.equals(clusterSchema.getSocketsFlushInterval(), clusterSchema2.getSocketsFlushInterval())) {
            return false;
        }
        if (!this.equals(clusterSchema.isSocketsCompressed(), clusterSchema2.isSocketsCompressed())) {
            return false;
        }
        if (!this.equals(clusterSchema.isDynamic(), clusterSchema2.isDynamic())) {
            return false;
        }
        return this.equals(clusterSchema.getSlaveServers(), clusterSchema2.getSlaveServers());
    }

    private void replaceSharedObjects(AbstractMeta abstractMeta) {
        Object imported;
        int index;
        for (DatabaseMeta databaseMeta : this.getSharedObjects(DatabaseMeta.class)) {
            index = abstractMeta.indexOfDatabase(databaseMeta);
            if (index < 0) {
                abstractMeta.addDatabase(databaseMeta);
                continue;
            }
            imported = abstractMeta.getDatabase(index);
            imported.setObjectId(databaseMeta.getObjectId());
            if (this.equals(databaseMeta, (DatabaseMeta)imported) || !this.getPromptResult(BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ConnectionExistsOverWrite.Message", (String[])new String[]{imported.getName()}), BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]), IMPORT_ASK_ABOUT_REPLACE_DB)) {
                imported.replaceMeta(databaseMeta);
                imported.clearChanged();
                continue;
            }
            imported.setChanged();
        }
        for (SlaveServer slaveServer : this.getSharedObjects(SlaveServer.class)) {
            index = abstractMeta.getSlaveServers().indexOf(slaveServer);
            if (index < 0) {
                abstractMeta.getSlaveServers().add(slaveServer);
                continue;
            }
            imported = abstractMeta.getSlaveServers().get(index);
            ((SlaveServer)imported).setObjectId(slaveServer.getObjectId());
            if (this.equals(slaveServer, (SlaveServer)imported) || !this.getPromptResult(BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.SlaveServerExistsOverWrite.Message", (String[])new String[]{((SlaveServer)imported).getName()}), BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]), IMPORT_ASK_ABOUT_REPLACE_SS)) {
                ((SlaveServer)imported).replaceMeta(slaveServer);
                ((ChangedFlag)imported).clearChanged();
                continue;
            }
            ((ChangedFlag)imported).setChanged();
        }
    }

    protected void replaceSharedObjects(TransMeta transMeta) throws KettleException {
        ChangedFlag imported;
        int index;
        this.replaceSharedObjects((AbstractMeta)transMeta);
        for (ClusterSchema clusterSchema : this.getSharedObjects(ClusterSchema.class)) {
            index = transMeta.getClusterSchemas().indexOf(clusterSchema);
            if (index < 0) {
                transMeta.getClusterSchemas().add(clusterSchema);
                continue;
            }
            imported = transMeta.getClusterSchemas().get(index);
            ((ClusterSchema)imported).setObjectId(clusterSchema.getObjectId());
            if (this.equals(clusterSchema, (ClusterSchema)imported) || !this.getPromptResult(BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ClusterSchemaExistsOverWrite.Message", (String[])new String[]{((ClusterSchema)imported).getName()}), BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]), IMPORT_ASK_ABOUT_REPLACE_CS)) {
                ((ClusterSchema)imported).replaceMeta(clusterSchema);
                imported.clearChanged();
                continue;
            }
            imported.setChanged();
        }
        for (PartitionSchema partitionSchema : this.getSharedObjects(PartitionSchema.class)) {
            index = transMeta.getPartitionSchemas().indexOf(partitionSchema);
            if (index < 0) {
                transMeta.getPartitionSchemas().add(partitionSchema);
                continue;
            }
            imported = transMeta.getPartitionSchemas().get(index);
            ((PartitionSchema)imported).setObjectId(partitionSchema.getObjectId());
            if (this.equals(partitionSchema, (PartitionSchema)imported) || !this.getPromptResult(BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.PartitionSchemaExistsOverWrite.Message", (String[])new String[]{((PartitionSchema)imported).getName()}), BaseMessages.getString(PKG, (String)"RepositoryImporter.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage", (String[])new String[0]), IMPORT_ASK_ABOUT_REPLACE_PS)) {
                ((PartitionSchema)imported).replaceMeta(partitionSchema);
                imported.clearChanged();
                continue;
            }
            imported.setChanged();
        }
    }

    protected void replaceSharedObjects(JobMeta transMeta) throws KettleException {
        this.replaceSharedObjects((AbstractMeta)transMeta);
    }

    private void patchMappingSteps(TransMeta transMeta) {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            MappingMeta mappingMeta;
            if (!stepMeta.isMapping() || (mappingMeta = (MappingMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() != ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) continue;
            if (this.transDirOverride != null) {
                mappingMeta.setDirectoryPath(this.transDirOverride);
                continue;
            }
            String mappingMetaPath = this.resolvePath(this.baseDirectory.getPath(), mappingMeta.getDirectoryPath());
            mappingMeta.setDirectoryPath(mappingMetaPath);
        }
    }

    private void patchJobEntries(JobMeta jobMeta) {
        for (JobEntryCopy copy : jobMeta.getJobCopies()) {
            String entryPath;
            JobEntryBase entry;
            if (copy.isTransformation() && ((JobEntryTrans)(entry = (JobEntryTrans)copy.getEntry())).getSpecificationMethod() == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) {
                if (this.transDirOverride != null) {
                    ((JobEntryTrans)entry).setDirectory(this.transDirOverride);
                    continue;
                }
                entryPath = this.resolvePath(this.baseDirectory.getPath(), ((JobEntryTrans)entry).getDirectory());
                ((JobEntryTrans)entry).setDirectory(entryPath);
            }
            if (!copy.isJob() || ((JobEntryJob)(entry = (JobEntryJob)copy.getEntry())).getSpecificationMethod() != ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) continue;
            if (this.jobDirOverride != null) {
                ((JobEntryJob)entry).setDirectory(this.jobDirOverride);
                continue;
            }
            entryPath = this.resolvePath(this.baseDirectory.getPath(), ((JobEntryJob)entry).getDirectory());
            ((JobEntryJob)entry).setDirectory(entryPath);
        }
    }

    private String resolvePath(String rootPath, String entryPath) {
        String extraPath = Const.NVL((String)entryPath, (String)"/");
        if (this.needToCheckPathForVariables() && RepositoryImporter.containsVariables(entryPath)) {
            return extraPath;
        }
        String newPath = Const.NVL((String)rootPath, (String)"/");
        if (newPath.endsWith("/") && extraPath.startsWith("/")) {
            newPath = newPath.substring(0, newPath.length() - 1);
        } else if (!newPath.endsWith("/") && !extraPath.startsWith("/")) {
            newPath = newPath + "/";
        } else if (extraPath.equals("/")) {
            extraPath = "";
        }
        return newPath + extraPath;
    }

    private static boolean containsVariables(String entryPath) {
        ArrayList variablesList = new ArrayList();
        StringUtil.getUsedVariables((String)entryPath, variablesList, (boolean)true);
        return !variablesList.isEmpty();
    }

    boolean needToCheckPathForVariables() {
        return this.needToCheckPathForVariables;
    }

    protected void saveTransMeta(TransMeta transMeta) throws KettleException {
        this.rep.save(transMeta, this.versionComment, this, this.overwrite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean importTransformation(Node transnode, RepositoryImportFeedbackInterface feedback) throws KettleException {
        TransMeta transMeta = this.createTransMetaForNode(transnode);
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportTrans.Label", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName()}));
        RepositoryImporter.validateImportedElement(this.importRules, transMeta);
        String directoryPath = Const.NVL((String)XMLHandler.getTagValue((Node)transnode, (String)"info", (String)"directory"), (String)Const.FILE_SEPARATOR);
        if (this.transDirOverride != null) {
            directoryPath = this.transDirOverride;
        }
        if (directoryPath.startsWith("/")) {
            directoryPath = directoryPath.substring(1);
        }
        if (this.limitDirs.size() > 0 && Const.indexOfString((String)directoryPath, this.limitDirs) < 0) {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedTransformationNotPartOfLimitingDirectories.Log", (String[])new String[]{transMeta.getName()}));
            return true;
        }
        RepositoryDirectoryInterface targetDirectory = this.getTargetDirectory(directoryPath, this.transDirOverride, feedback);
        ObjectId existingId = this.rep.getTransformationID(transMeta.getName(), targetDirectory);
        if (existingId != null && this.askOverwrite) {
            this.overwrite = feedback.transOverwritePrompt(transMeta);
            this.askOverwrite = feedback.isAskingOverwriteConfirmation();
        } else {
            this.updateDisplay();
        }
        if (existingId == null || this.overwrite) {
            this.replaceSharedObjects(transMeta);
            transMeta.setObjectId(existingId);
            transMeta.setRepositoryDirectory(targetDirectory);
            this.patchMappingSteps(transMeta);
            try {
                if (transMeta.getCreatedUser() == null || transMeta.getCreatedUser().equals("-")) {
                    transMeta.setCreatedDate(new Date());
                    if (this.rep.getUserInfo() != null) {
                        transMeta.setCreatedUser(this.rep.getUserInfo().getLogin());
                    } else {
                        transMeta.setCreatedUser(null);
                    }
                }
                this.saveTransMeta(transMeta);
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.TransSaved.Log", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName()}));
                if (!transMeta.hasRepositoryReferences()) return true;
                this.referencingObjects.add(new RepositoryObject(transMeta.getObjectId(), transMeta.getName(), transMeta.getRepositoryDirectory(), null, null, RepositoryObjectType.TRANSFORMATION, null, false));
                return true;
            }
            catch (Exception e) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorSavingTrans.Log", (String[])new String[]{Integer.toString(this.transformationNumber), transMeta.getName(), Const.getStackTracker((Throwable)e)}));
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) return true;
                return false;
            }
        } else {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedExistingTransformation.Log", (String[])new String[]{transMeta.getName()}));
        }
        return true;
    }

    TransMeta createTransMetaForNode(Node transnode) throws KettleMissingPluginsException, KettleXMLException {
        return new TransMeta(transnode, null);
    }

    protected void saveJobMeta(JobMeta jobMeta) throws KettleException {
        if (jobMeta.getCreatedUser() == null || jobMeta.getCreatedUser().equals("-")) {
            jobMeta.setCreatedDate(new Date());
            if (this.rep.getUserInfo() != null) {
                jobMeta.setCreatedUser(this.rep.getUserInfo().getLogin());
            } else {
                jobMeta.setCreatedUser(null);
            }
        }
        this.rep.save(jobMeta, this.versionComment, null, this.overwrite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean importJob(Node jobnode, RepositoryImportFeedbackInterface feedback) throws KettleException {
        JobMeta jobMeta = this.createJobMetaForNode(jobnode);
        feedback.setLabel(BaseMessages.getString(PKG, (String)"RepositoryImporter.ImportJob.Label", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName()}));
        RepositoryImporter.validateImportedElement(this.importRules, jobMeta);
        String directoryPath = Const.NVL((String)XMLHandler.getTagValue((Node)jobnode, (String)"directory"), (String)Const.FILE_SEPARATOR);
        if (this.jobDirOverride != null) {
            directoryPath = this.jobDirOverride;
        }
        if (directoryPath.startsWith("/")) {
            directoryPath = directoryPath.substring(1);
        }
        if (this.limitDirs.size() > 0 && Const.indexOfString((String)directoryPath, this.limitDirs) < 0) {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedJobNotPartOfLimitingDirectories.Log", (String[])new String[]{jobMeta.getName()}));
            return true;
        }
        RepositoryDirectoryInterface targetDirectory = this.getTargetDirectory(directoryPath, this.jobDirOverride, feedback);
        ObjectId existintId = this.rep.getJobId(jobMeta.getName(), targetDirectory);
        if (existintId != null && this.askOverwrite) {
            this.overwrite = feedback.jobOverwritePrompt(jobMeta);
            this.askOverwrite = feedback.isAskingOverwriteConfirmation();
        } else {
            this.updateDisplay();
        }
        if (existintId == null || this.overwrite) {
            this.replaceSharedObjects(jobMeta);
            jobMeta.setRepositoryDirectory(targetDirectory);
            jobMeta.setObjectId(existintId);
            this.patchJobEntries(jobMeta);
            try {
                this.saveJobMeta(jobMeta);
                if (jobMeta.hasRepositoryReferences()) {
                    this.referencingObjects.add(new RepositoryObject(jobMeta.getObjectId(), jobMeta.getName(), jobMeta.getRepositoryDirectory(), null, null, RepositoryObjectType.JOB, null, false));
                }
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.JobSaved.Log", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName()}));
                return true;
            }
            catch (Exception e) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorSavingJob.Log", (String[])new String[]{Integer.toString(this.jobNumber), jobMeta.getName(), Const.getStackTracker((Throwable)e)}));
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) return true;
                return false;
            }
        } else {
            feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.SkippedExistingJob.Log", (String[])new String[]{jobMeta.getName()}));
        }
        return true;
    }

    JobMeta createJobMetaForNode(Node jobnode) throws KettleXMLException {
        return new JobMeta(jobnode, null, false, (OverwritePrompter)SpoonFactory.getInstance());
    }

    private DocumentBuilder getOrCreateDb() throws KettleXMLException {
        if (this.documentBuilder == null) {
            this.documentBuilder = XMLHandler.createDocumentBuilder((boolean)false, (boolean)true);
        }
        return this.documentBuilder;
    }

    @Override
    public boolean transformationElementRead(String xml, RepositoryImportFeedbackInterface feedback) {
        block3: {
            try {
                Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.getOrCreateDb(), (String)xml);
                Node transformationNode = XMLHandler.getSubNode((Node)doc, (String)"transformation");
                if (!this.importTransformation(transformationNode, feedback)) {
                    return false;
                }
                ++this.transformationNumber;
            }
            catch (Exception e) {
                feedback.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringTransformationImport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringTransformationImport.Message", (String[])new String[0]), e);
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) break block3;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean jobElementRead(String xml, RepositoryImportFeedbackInterface feedback) {
        block3: {
            try {
                Document doc = XMLHandler.loadXMLString((DocumentBuilder)this.getOrCreateDb(), (String)xml);
                Node jobNode = XMLHandler.getSubNode((Node)doc, (String)"job");
                if (!this.importJob(jobNode, feedback)) {
                    return false;
                }
                ++this.jobNumber;
            }
            catch (Exception e) {
                this.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringJobImport.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.UnexpectedErrorDuringJobImport.Message", (String[])new String[0]), e);
                if (feedback.askContinueOnErrorQuestion(BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.DoYouWantToContinue.Message", (String[])new String[0]))) break block3;
                return false;
            }
        }
        return true;
    }

    private RepositoryDirectoryInterface getTargetDirectory(String directoryPath, String dirOverride, RepositoryImportFeedbackInterface feedback) throws KettleException {
        RepositoryDirectoryInterface targetDirectory = null;
        if (dirOverride != null) {
            targetDirectory = this.rep.findDirectory(directoryPath);
            if (targetDirectory == null) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.CreateDir.Log", (String[])new String[]{directoryPath, this.getRepositoryRoot().toString()}));
                targetDirectory = this.rep.createRepositoryDirectory(this.getRepositoryRoot(), directoryPath);
            }
        } else {
            targetDirectory = this.baseDirectory.findDirectory(directoryPath);
            if (targetDirectory == null) {
                feedback.addLog(BaseMessages.getString(PKG, (String)"RepositoryImporter.CreateDir.Log", (String[])new String[]{directoryPath, this.baseDirectory.toString()}));
                targetDirectory = this.rep.createRepositoryDirectory(this.baseDirectory, directoryPath);
            }
        }
        return targetDirectory;
    }

    private RepositoryDirectoryInterface getRepositoryRoot() throws KettleException {
        if (this.root == null) {
            this.root = this.rep.loadRepositoryDirectoryTree();
        }
        return this.root;
    }

    @Override
    public void fatalXmlErrorEncountered(SAXParseException e) {
        this.showError(BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorInvalidXML.Message", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryImporter.ErrorInvalidXML.Title", (String[])new String[0]), e);
    }

    @Override
    public boolean askContinueOnErrorQuestion(String title, String message) {
        return this.continueOnError;
    }

    public void beginTask(String message, int nrWorks) {
        this.addLog(message);
    }

    public void done() {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setTaskName(String taskName) {
        this.addLog(taskName);
    }

    public void subTask(String message) {
        this.addLog(message);
    }

    public void worked(int nrWorks) {
    }

    public String getTransDirOverride() {
        return this.transDirOverride;
    }

    @Override
    public void setTransDirOverride(String transDirOverride) {
        this.transDirOverride = transDirOverride;
    }

    public String getJobDirOverride() {
        return this.jobDirOverride;
    }

    @Override
    public void setJobDirOverride(String jobDirOverride) {
        this.jobDirOverride = jobDirOverride;
    }

    @Override
    public void setImportRules(ImportRules importRules) {
        this.importRules = importRules;
    }

    public ImportRules getImportRules() {
        return this.importRules;
    }

    @Override
    public boolean isAskingOverwriteConfirmation() {
        return this.askOverwrite;
    }

    private void addException(Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(exception);
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void setLimitDirs(List<String> limitDirs) {
        this.limitDirs = new ArrayList<String>(limitDirs);
    }

    protected void setBaseDirectory(RepositoryDirectoryInterface baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getVersionComment() {
        return this.versionComment;
    }
}

