/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryValueDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryValueDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getValue(ObjectId id_value) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_VALUE"), this.quote("ID_VALUE"), id_value);
    }

    public ValueMetaAndData loadValueMetaAndData(ObjectId id_value) throws KettleException {
        ValueMetaAndData valueMetaAndData = new ValueMetaAndData();
        try {
            RowMetaAndData r = this.getValue(id_value);
            if (r != null) {
                String name = r.getString("NAME", null);
                int valtype = ValueMeta.getType((String)r.getString("VALUE_TYPE", null));
                boolean isNull = r.getBoolean("IS_NULL", false);
                valueMetaAndData.setValueMeta((ValueMetaInterface)new ValueMeta(name, valtype));
                if (isNull) {
                    valueMetaAndData.setValueData(null);
                } else {
                    ValueMeta stringValueMeta = new ValueMeta(name, 2);
                    ValueMetaInterface valueMeta = valueMetaAndData.getValueMeta();
                    stringValueMeta.setConversionMetadata(valueMeta);
                    valueMeta.setDecimalSymbol(".");
                    valueMeta.setGroupingSymbol(",");
                    switch (valueMeta.getType()) {
                        case 1: {
                            valueMeta.setConversionMask("#.#");
                            break;
                        }
                        case 5: {
                            valueMeta.setConversionMask("#");
                            break;
                        }
                    }
                    String string = r.getString("VALUE_STR", null);
                    valueMetaAndData.setValueData(stringValueMeta.convertDataUsingConversionMetaData((Object)string));
                    valueMeta = new ValueMeta(name, valueMeta.getType());
                }
            }
            return valueMetaAndData;
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load Value from repository with id_value=" + id_value, (Throwable)dbe);
        }
    }
}

