/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessinput;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessinput.AccessInput;
import org.pentaho.di.trans.steps.accessinput.AccessInputData;
import org.pentaho.di.trans.steps.accessinput.AccessInputField;
import org.pentaho.di.trans.steps.accessinput.AccessInputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class AccessInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AccessInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private boolean includeFilename;
    private boolean includeTablename;
    private boolean resetRowNumber;
    private String tablenameField;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String TableName;
    private long rowLimit;
    private AccessInputField[] inputFields;
    private boolean filefield;
    private boolean isaddresult;
    private String dynamicFilenameField;
    private static final String YES = "Y";
    public static final String[] type_trim_code = new String[]{"none", "left", "right", "both"};
    public static final String PREFIX_SYSTEM = "MSys";
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public AccessInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(AccessInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public boolean includeTablename() {
        return this.includeTablename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public void setIncludeTablename(boolean includeTablename) {
        this.includeTablename = includeTablename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean resetRowNumber() {
        return this.resetRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public void setResetRowNumber(boolean resetRowNumber) {
        this.resetRowNumber = resetRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public String gettablenameField() {
        return this.tablenameField;
    }

    public String getTableName() {
        return this.TableName;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public void setTablenameField(String tablenameField) {
        this.tablenameField = tablenameField;
    }

    public void setTableName(String TableName) {
        this.TableName = TableName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        AccessInputMeta retval = (AccessInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (AccessInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"tablename", (boolean)this.includeTablename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_Field", (String)this.dynamicFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"tablename_field", (String)this.tablenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"resetrownumber", (boolean)this.resetRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table_name", (String)this.TableName));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attribut", (String)this.inputFields[i].getColumn()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeTablename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"tablename"));
            this.tablenameField = XMLHandler.getTagValue((Node)stepnode, (String)"tablename_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            String addresult = XMLHandler.getTagValue((Node)stepnode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : YES.equalsIgnoreCase(addresult);
            this.filefield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.TableName = XMLHandler.getTagValue((Node)stepnode, (String)"table_name");
            this.dynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_Field");
            this.resetRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"resetrownumber"));
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = new AccessInputField();
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setColumn(XMLHandler.getTagValue((Node)fnode, (String)"attribut"));
                this.inputFields[i].setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XMLHandler.getTagValue((Node)fnode, (String)"repeat");
                this.inputFields[i].setTrimType(AccessInputMeta.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.allocateFiles(nrfiles);
        this.allocateFields(nrfields);
    }

    public void allocateFiles(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    public void allocateFields(int nrfields) {
        this.inputFields = new AccessInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.isaddresult = true;
        this.filefield = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeTablename = false;
        this.tablenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.TableName = "";
        this.dynamicFilenameField = "";
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new AccessInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v;
        int nr = this.inputFields == null ? 0 : this.inputFields.length;
        for (int i = 0; i < nr; ++i) {
            AccessInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v2 = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v2.setLength(field.getLength());
            v2.setPrecision(field.getPrecision());
            v2.setOrigin(name);
            v2.setConversionMask(field.getFormat());
            v2.setDecimalSymbol(field.getDecimalSymbol());
            v2.setGroupingSymbol(field.getGroupSymbol());
            v2.setCurrencySymbol(field.getCurrencySymbol());
            v2.setTrimType(field.getTrimType());
            r.addValueMeta((ValueMetaInterface)v2);
        }
        if (this.includeFilename) {
            v = new ValueMeta(space.environmentSubstitute(this.filenameField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeTablename) {
            v = new ValueMeta(space.environmentSubstitute(this.tablenameField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getShortFileNameField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getExtensionField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getPathField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getSizeField()), 5);
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.isHiddenField()), 4);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getLastModificationDateField()), 3);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getRootUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trim_code.length; ++i) {
                if (!type_trim_code[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.TableName = rep.getStepAttributeString(id_step, "table_name");
            this.includeTablename = rep.getStepAttributeBoolean(id_step, "tablename");
            this.dynamicFilenameField = rep.getStepAttributeString(id_step, "filename_Field");
            this.tablenameField = rep.getStepAttributeString(id_step, "tablename_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            String addresult = rep.getStepAttributeString(id_step, "isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : rep.getStepAttributeBoolean(id_step, "isaddresult");
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.resetRowNumber = rep.getStepAttributeBoolean(id_step, "reset_rownumber");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = RequiredFilesCode[0];
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = RequiredFilesCode[0];
            }
            for (i = 0; i < nrFields; ++i) {
                AccessInputField field = new AccessInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setColumn(rep.getStepAttributeString(id_step, i, "field_attribut"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(AccessInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename", this.includeTablename);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_field", this.tablenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "isaddresult", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "filename_Field", this.dynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "table_name", this.TableName);
            rep.saveStepAttribute(id_transformation, id_step, "reset_rownumber", this.resetRowNumber);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                AccessInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", field.getColumn());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.getTableName())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AccessInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public static String getFilename(FileObject fileObject) {
        FileName fileName = fileObject.getName();
        String root = fileName.getRootURI();
        if (!root.startsWith("file:")) {
            return fileName.getURI();
        }
        root = root.endsWith(":/") ? root.substring(8, 10) : root.substring(7, root.length() - 1);
        String fileString = root + fileName.getPath();
        if (!"/".equals(Const.FILE_SEPARATOR)) {
            fileString = Const.replace((String)fileString, (String)"/", (String)Const.FILE_SEPARATOR);
        }
        return fileString;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new AccessInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AccessInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            for (int i = 0; i < this.fileName.length; ++i) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public static ValueMetaInterface getValueMeta(Column c) {
        ValueMetaAndData vmd = AccessInputMeta.getValueMetaAndData(c, null, null);
        if (vmd != null) {
            return vmd.getValueMeta();
        }
        return null;
    }

    public static ValueMetaAndData getValueMetaAndData(Column c, String name, Object data) {
        ValueMetaAndData valueMetaData = new ValueMetaAndData();
        Object o = data;
        DataType type = c.getType();
        int sourceValueType = 2;
        switch (type) {
            case BINARY: {
                sourceValueType = 8;
                break;
            }
            case BOOLEAN: {
                sourceValueType = 4;
                if (o == null) break;
                o = Boolean.valueOf(o.toString());
                break;
            }
            case DOUBLE: {
                sourceValueType = 1;
                break;
            }
            case FLOAT: {
                sourceValueType = 6;
                if (o == null) break;
                o = new BigDecimal(Float.toString(((Float)o).floatValue()));
                break;
            }
            case INT: {
                sourceValueType = 1;
                if (o == null) break;
                o = Double.parseDouble(o.toString());
                break;
            }
            case BYTE: {
                sourceValueType = 1;
                if (o == null) break;
                o = Double.parseDouble(o.toString());
                break;
            }
            case LONG: {
                sourceValueType = 5;
                if (o == null) break;
                Integer i = (Integer)o;
                o = i.longValue();
                break;
            }
            case MEMO: {
                break;
            }
            case MONEY: {
                sourceValueType = 6;
                break;
            }
            case NUMERIC: {
                sourceValueType = 6;
                break;
            }
            case SHORT_DATE_TIME: {
                sourceValueType = 3;
                break;
            }
            default: {
                if (o == null) break;
                o = o.toString();
            }
        }
        ValueMeta sourceValueMeta = new ValueMeta(name == null ? c.getName() : name, sourceValueType);
        sourceValueMeta.setLength((int)c.getLength(), (int)c.getPrecision());
        valueMetaData.setValueMeta((ValueMetaInterface)sourceValueMeta);
        if (o != null) {
            valueMetaData.setValueData(o);
        }
        return valueMetaData;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new AccessInputMetaInjection(this);
    }
}

