/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.changefileencoding;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.changefileencoding.ChangeFileEncodingData;
import org.pentaho.di.trans.steps.changefileencoding.ChangeFileEncodingMeta;

public class ChangeFileEncoding
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ChangeFileEncoding.class;
    private ChangeFileEncodingMeta meta;
    private ChangeFileEncodingData data;

    public ChangeFileEncoding(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (ChangeFileEncodingMeta)smi;
            this.data = (ChangeFileEncodingData)sdi;
            Object[] outputRow = this.getRow();
            if (outputRow == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta().clone();
                if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                if (Const.isEmpty((String)this.meta.getTargetFilenameField())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.TargetFilenameFieldMissing", (String[])new String[0]));
                }
                this.data.indexOfFileename = this.data.inputRowMeta.indexOfValue(this.meta.getDynamicFilenameField());
                if (this.data.indexOfFileename < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                }
                this.data.indexOfTargetFileename = this.data.inputRowMeta.indexOfValue(this.meta.getTargetFilenameField());
                if (this.data.indexOfTargetFileename < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getTargetFilenameField() + "]");
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.CouldnotFindField", (String[])new String[]{this.meta.getTargetFilenameField()}));
                }
                this.data.sourceEncoding = this.environmentSubstitute(this.meta.getSourceEncoding());
                this.data.targetEncoding = this.environmentSubstitute(this.meta.getTargetEncoding());
                if (Const.isEmpty((String)this.data.targetEncoding)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Exception.TargetEncodingEmpty", (String[])new String[0]));
                }
            }
            try {
                String sourceFilename = this.data.inputRowMeta.getString(outputRow, this.data.indexOfFileename);
                if (Const.isEmpty((String)sourceFilename)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileIsEmpty", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                }
                String targetFilename = this.data.inputRowMeta.getString(outputRow, this.data.indexOfTargetFileename);
                if (Const.isEmpty((String)targetFilename)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.TargetFileIsEmpty", (String[])new String[]{this.meta.getTargetFilenameField()}));
                }
                this.data.sourceFile = KettleVFS.getFileObject((String)sourceFilename);
                if (!this.data.sourceFile.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileNotExists", (String[])new String[]{sourceFilename}));
                }
                if (this.data.sourceFile.getType() != FileType.FILE) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.SourceFileNotAFile", (String[])new String[]{sourceFilename}));
                }
                if (!this.data.sourceFile.getParent().exists()) {
                    if (this.meta.isCreateParentFolder()) {
                        this.data.sourceFile.getParent().createFolder();
                    } else {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.ParentFolderNotExist", (String[])new String[]{this.data.sourceFile.getParent().toString()}));
                    }
                }
                this.changeEncoding(sourceFilename, targetFilename);
                this.putRow(this.data.inputRowMeta, outputRow);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(outputRow)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), outputRow, 1L, errorMessage, this.meta.getDynamicFilenameField(), "ChangeFileEncoding001");
            }
        }
        return true;
    }

    private void changeEncoding(String sourceFilename, String targetFilename) throws KettleException {
        BufferedWriter buffWriter = null;
        BufferedReader buffReader = null;
        try {
            ResultFile resultFile;
            buffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFilename, false), this.data.targetEncoding));
            buffReader = Const.isEmpty((String)this.data.sourceEncoding) ? new BufferedReader(new InputStreamReader(new FileInputStream(sourceFilename))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFilename), this.data.sourceEncoding));
            char[] cBuf = new char[8192];
            int readSize = 0;
            while ((readSize = buffReader.read(cBuf)) != -1) {
                buffWriter.write(cBuf, 0, readSize);
            }
            if (this.meta.addSourceResultFilenames()) {
                resultFile = new ResultFile(0, this.data.sourceFile, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FilenameAddResult", (String[])new String[]{this.data.sourceFile.toString()}));
                }
            }
            if (this.meta.addTargetResultFilenames()) {
                resultFile = new ResultFile(0, KettleVFS.getFileObject((String)targetFilename), this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Log.FilenameAddResult", (String[])new String[]{targetFilename}));
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncoding.Error.CreatingFile", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (buffWriter != null) {
                    buffWriter.flush();
                    buffWriter.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ChangeFileEncodingMeta)smi;
        this.data = (ChangeFileEncodingData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ChangeFileEncodingMeta)smi;
        this.data = (ChangeFileEncodingData)sdi;
        if (this.data.sourceFile != null) {
            try {
                this.data.sourceFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

